<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Arts extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_FINE_ART = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FINE_ART_EDITIONED = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Arts';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        // Overriding Barcode as not required.
        $this->attributes['StandardProductID_Value'] = [
            'sequence' => '20\20',
            'name' => 'Barcode',
            'dataType' => "Barcode",
            'minOccurs' => '0',
            "length" => "8:16"
        ];

        switch ($this->subCategory) {
            case "FineArt":
                $this->attributes = array_merge($this->attributes, $this->getFineArt());
                break;
            case "FineArtEditioned":
                $this->attributes = array_merge($this->attributes, $this->getFineArtEditioned());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Arts => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Arts_";

        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child"
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "SizeName",
                        1 => "FrameMaterial",
                        2 => "Size-Material"
                    ],
                ],
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getFineArt()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Arts => 10
         * ProductType => 10
         * FineArt => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Arts_ProductType_FineArt_";

        $attributes = [
            "ProductData_Arts_ProductType_FineArt" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "FineArt",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ArtworkType" => [
                "sequence" => "{$s}10",
                "name" => "ArtworkType",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}Artist" => [
                "sequence" => "{$s}20",
                "name" => "Artist",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}ArtistBiography" => [
                "sequence" => "{$s}30",
                "name" => "ArtistBiography",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ArtworkMedium" => [
                "sequence" => "{$s}40",
                "name" => "ArtworkMedium",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}Date" => [
                "sequence" => "{$s}50",
                "name" => "Date",
                "dataType" => "dateTime",
                "minOccurs" => "1",
            ],
            "{$i}Framed" => [
                "sequence" => "{$s}160",
                "name" => "Framed",
                "dataType" => "boolean",
                "minOccurs" => "1",
            ],
            "{$i}SaleType" => [
                "sequence" => "{$s}370",
                "name" => "SaleType",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
        ];
        return $attributes;
    }

    public function getFineArtEditioned()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Arts => 10
         * ProductType => 10
         * FineArtEditioned => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Arts_ProductType_FineArtEditioned_";

        $attributes = [
            "ProductData_Arts_ProductType_FineArtEditioned" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FineArtEditioned",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ArtworkType" => [
                "sequence" => "{$s}10",
                "name" => "ArtworkType",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}Artist" => [
                "sequence" => "{$s}20",
                "name" => "Artist",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}ArtistBiography" => [
                "sequence" => "{$s}30",
                "name" => "ArtistBiography",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ArtworkMedium" => [
                "sequence" => "{$s}40",
                "name" => "ArtworkMedium",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}Date" => [
                "sequence" => "{$s}50",
                "name" => "Date",
                "dataType" => "dateTime",
                "minOccurs" => "1",
            ],
            "{$i}Framed" => [
                "sequence" => "{$s}160",
                "name" => "Framed",
                "dataType" => "boolean",
                "minOccurs" => "1",
            ],
            "{$i}LimitedEditionSize" => [
                "sequence" => "{$s}310",
                "name" => "LimitedEditionSize",
                "dataType" => "positiveInteger",
                "minOccurs" => "1",
            ],
            "{$i}SaleType" => [
                "sequence" => "{$s}430",
                "name" => "SaleType",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
            ],
        ];
        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Arts_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
