<?php

namespace Amazon\Sdk\Order;

/**
 * Class Fulfillment
 * @package Amazon\Sdk\Order
 * @refer amazon-sdk/xsd/xsd_in/OrderFulfillment.xsd
 */
class Fulfillment extends \Amazon\Sdk\Base
{
    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_ORDER_FULFILLMENT;
    }

    /**
     * @param null $orderId
     * @param array $data
     * @throws \Exception
     */
    public function setData($orderId = null, array $data = [])
    {
        if (isset($orderId) && !empty($orderId)) {
            $this->data[0]['AmazonOrderID'] = (string)$orderId;  // required, choice
        } elseif (isset($data['MerchantOrderID']) && !empty($data['MerchantOrderID'])) {
            $this->data[0]['MerchantOrderID'] = (string)$data['MerchantOrderID']; // required, choice
        } else {
            throw new \Exception("'AmazonOrderID' and 'MerchantOrderID' both are invalid.");
        }

        if (isset($data['MerchantFulfillmentID']) && !empty($data['MerchantFulfillmentID'])) {
            $this->data[0]['MerchantFulfillmentID'] = (string)$data['MerchantFulfillmentID']; // optional
        }

        // Format: YYYY-MM-DDThh:mm:ss  // 2009-02-10T09:22:33+00:00
        if (isset($data['FulfillmentDate']) && !empty($data['FulfillmentDate']) and
            $this->validateDate($data['FulfillmentDate'])
        ) {
            // required
            $this->data[0]['FulfillmentDate'] = (string)$this->generateDate($data['FulfillmentDate']);
        } else {
            throw new \Exception("'FulfillmentDate' is invalid.");
        }

        $codes = \Amazon\Sdk\Order\Fulfillment\CarrierCode::getCarrierCodes();
        if (isset($data['FulfillmentData']['CarrierCode']) and
            !empty($data['FulfillmentData']['CarrierCode']) and
            in_array($data['FulfillmentData']['CarrierCode'], $codes)
        ) {
            // required, choice
            $this->data[0]['FulfillmentData']['CarrierCode'] = (string)$data['FulfillmentData']['CarrierCode'];
        } elseif (isset($data['FulfillmentData']['CarrierName']) && !empty($data['FulfillmentData']['CarrierName'])) {
            // required, choice
            $this->data[0]['FulfillmentData']['CarrierName'] = (string)$data['FulfillmentData']['CarrierName'];
        } else {
            throw new \Exception("'CarrierCode/CarrierName' is invalid. Use " . implode('|', $codes));
        }

        if (isset($data['FulfillmentData']['ShippingMethod']) && !empty($data['FulfillmentData']['ShippingMethod'])) {
            $this->data[0]['FulfillmentData']['ShippingMethod'] = (string)$data['FulfillmentData']['ShippingMethod']; // optional
        }

        if (isset($data['FulfillmentData']['ShipperTrackingNumber']) &&
            !empty($data['FulfillmentData']['ShipperTrackingNumber'])) {
            $this->data[0]['FulfillmentData']['ShipperTrackingNumber'] =
                trim((string)$data['FulfillmentData']['ShipperTrackingNumber']); // optional
        }
    }

    /**
     * @param array $items ,
     * [
     *  [AmazonOrderItemCode] => 68828574383266  // required, choice
     *  [MerchantOrderItemID] => 68828574383266  // required, choice
     *  [MerchantFulfillmentItemID] => 68828574383266  // optional
     *  [Quantity] => 1 // required
     * ]
     * @throws \Exception
     */
    public function setItems(array $items = [])
    {
        foreach ($items as $item) {
            if (isset($item['Quantity']) && $item['Quantity'] > 0) {
                $value = [];
                if (isset($item['AmazonOrderItemCode']) && !empty($item['AmazonOrderItemCode'])) {
                    $value['AmazonOrderItemCode'] = (string)$item['AmazonOrderItemCode'];  // required, choice
                } elseif (isset($item['MerchantOrderItemID']) && !empty($item['MerchantOrderItemID'])) {
                    $value['MerchantOrderItemID'] = (string)$item['MerchantOrderItemID']; // required, choice
                } else {
                    throw new \Exception("'AmazonOrderItemCode' && 'MerchantOrderItemID' both are invalid.");
                }

                if (isset($item['MerchantFulfillmentItemID']) && !empty($item['MerchantFulfillmentItemID'])) {
                    $value['MerchantFulfillmentItemID'] = (string)$item['MerchantFulfillmentItemID']; // optional
                }

                if (isset($item['Quantity']) && !empty($item['Quantity'])) {
                    $value['Quantity'] = (string)$item['Quantity']; // required
                } else {
                    throw new \Exception("'Quantity' is invalid.");
                }

                $this->data[]['Item'] = $value;
            }
        }
    }
}
