<?php

namespace Amazon\Sdk\Order;

/**
 * Class Acknowledgement
 * @package Amazon\Sdk\Order
 * @refer amazon-sdk/xsd/xsd_in/OrderAcknowledgement.xsd
 */
class Acknowledgement extends \Amazon\Sdk\Base
{
    const STATUS_CODE_SUCCESS = 'Success';

    const STATUS_CODE_FAILURE = 'Failure';


    const CANCEL_REASON_NO_INVENTORY = 'NoInventory';

    const CANCEL_REASON_UNDELIVERABLE = 'ShippingAddressUndeliverable';

    const CANCEL_REASON_CUSTOMER_EXCHANGE = 'CustomerExchange';

    const CANCEL_REASON_BUYER_CANCELED = 'BuyerCanceled';

    const CANCEL_REASON_GENERAL_ADJUSTMENT = 'GeneralAdjustment';

    const CANCEL_REASON_CARRIER_CREDIT_DECISION = 'CarrierCreditDecision';

    const CANCEL_REASON_RAI_NOT_VALID = 'RiskAssessmentInformationNotValid';

    const CANCEL_REASON_CARRIER_COVERAGE_FAILURE = 'CarrierCoverageFailure';

    const CANCEL_REASON_CUSTOMER_RETURN = 'CustomerReturn';

    const CANCEL_REASON_MERCHANDISE_NOT_RECEIVED = 'MerchandiseNotReceived';

    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_ORDER_ACKNOWLEDGEMENT;
    }

    /**
     * Set Acknowledgement data
     * @param $orderId
     * @param string $status
     * @param null $merchantOrderId
     */
    public function setData($orderId, $status = self::STATUS_CODE_SUCCESS, $merchantOrderId = null)
    {
        $this->data[0]['AmazonOrderID'] = (string)$orderId; // required
        if (isset($merchantOrderId)) {
            $this->data[0]['MerchantOrderID'] = (string)$merchantOrderId; // optional
        }
        $this->data[0]['StatusCode'] = (string)$status; // required
    }

    /**
     * @FIXME: invalid
     * @param array $item , ['AmazonOrderItemCode' => '', 'MerchantOrderItemID' => '', 'CancelReason' => '']
     */
    public function setItems(array $item = [])
    {
        $this->data[]['Item'] = $item;
    }
}