<?php
/**
 * Copyright 2013 CPI Group, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Amazon\Sdk\Api;

/**
 * Core class for Amazon Outbound Shipment API.
 *
 * This is the core class for all objects in the Amazon Outbound section.
 * It contains no methods in itself other than the constructor.
 */
abstract class OutboundCore extends \Amazon\Sdk\Api\Core
{
    /**
     * AmazonOutboundCore constructor sets up key information used in all Amazon Outbound Core requests
     *
     * This constructor is called when initializing all objects in the Amazon Outbound Core.
     * The parameters are passed by the child objects' constructors, which are
     * in turn passed to the AmazonCore constructor. See it for more information
     * on these parameters and common methods.
     * @param \Amazon\Sdk\Api\ConfigInterface|null $config ,
     * @param \Psr\Log\LoggerInterface|null $logger ,
     * @param boolean $mockMode [optional] <p>This is a flag for enabling Mock Mode.
     * This defaults to <b>FALSE</b>.</p>
     * @param array|string $mockFiles [optional] <p>The files (or file) to use in Mock Mode.</p>
     */
    public function __construct(
        \Amazon\Sdk\Api\ConfigInterface $config = null,
        \Psr\Log\LoggerInterface $logger = null,
        $mockMode = false,
        $mockFiles = null
    )
    {
        parent::__construct($config, $logger, $mockMode, $mockFiles);

        $this->urlbranch = 'FulfillmentOutboundShipment/' . \Amazon\Sdk\Api\Environment::AMAZON_VERSION_OUTBOUND;
        $this->options['Version'] = \Amazon\Sdk\Api\Environment::AMAZON_VERSION_OUTBOUND;
        $this->throttleLimit = \Amazon\Sdk\Api\Environment::THROTTLE_LIMIT_INVENTORY;
        $this->throttleTime = \Amazon\Sdk\Api\Environment::THROTTLE_TIME_INVENTORY;
        $this->throttleGroup = 'Inventory';
    }
}
