<?php

namespace Amazon\Sdk\Api\Order;

/**
 * Copyright 2013 CPI Group, LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 *
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Core class for Amazon Orders API.
 *
 * This is the core class for all objects in the Amazon Orders section.
 * It contains no methods in itself other than the constructor.
 */
abstract class Core extends \Amazon\Sdk\Api\Core
{
    const ORDER_STATUS_PENDING = 'Pending';
    const ORDER_STATUS_UNSHIPPED = 'Unshipped';
    const ORDER_STATUS_PARTIALLY_SHIPPED = 'PartiallyShipped';
    const ORDER_STATUS_SHIPPED = 'Shipped';
    const ORDER_STATUS_CANCELED = 'Canceled';
    const ORDER_STATUS_UNFULFILLABLE = 'Unfulfillable';
    //The PendingAvailability status is available only for pre-orders in Japan.
    const ORDER_STATUS_PENDING_AVAILABILITY = 'PendingAvailability';

    const ORDER_STATUS = [
        self::ORDER_STATUS_PENDING,
        self::ORDER_STATUS_UNSHIPPED,
        self::ORDER_STATUS_PARTIALLY_SHIPPED,
        self::ORDER_STATUS_SHIPPED,
        self::ORDER_STATUS_CANCELED,
        self::ORDER_STATUS_UNFULFILLABLE,
        self::ORDER_STATUS_PENDING_AVAILABILITY,
    ];

    /**
     * AmazonOrdersCore constructor sets up key information used in all Amazon Orders Core requests
     *
     * This constructor is called when initializing all objects in the Amazon Orders Core.
     * The parameters are passed by the child objects' constructors, which are
     * in turn passed to the AmazonCore constructor. See it for more information
     * on these parameters and common methods.
     * @param \Amazon\Sdk\Api\ConfigInterface|null $config ,
     * @param \Psr\Log\LoggerInterface|null $logger ,
     * @param boolean $mockMode [optional] <p>This is a flag for enabling Mock Mode.
     * This defaults to <b>FALSE</b>.</p>
     * @param array|null $mockFiles [optional] <p>The files (or file) to use in Mock Mode.</p>
     * @throws \Amazon\Sdk\Api\Exception\InvalidConfigValue
     */
    public function __construct(
        \Amazon\Sdk\Api\ConfigInterface $config = null,
        \Psr\Log\LoggerInterface $logger = null,
        $mockMode = false,
        $mockFiles = null
    ) {
        parent::__construct($config, $logger, $mockMode, $mockFiles);

        $this->urlbranch = 'Orders/' . \Amazon\Sdk\Api\Environment::AMAZON_VERSION_ORDERS;
        $this->options['Version'] = \Amazon\Sdk\Api\Environment::AMAZON_VERSION_ORDERS;
    }
}
