<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2019 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Api\Data;

use DateTimeInterface;

class PingResult extends Data implements PingResultInterface
{
    /**
     * Get Timestamp
     * @return DateTimeInterface
     */
    public function getTimestamp()
    {
        return $this->getData(self::FIELD_TIMESTAMP);
    }

    /**
     * Set Timestamp
     * @param DateTimeInterface $value
     * @return $this
     */
    public function setTimestamp($value)
    {
        return $this->setData(self::FIELD_TIMESTAMP, $value);
    }

    /**
     * Get API status
     * @return boolean
     */
    public function getStatus()
    {
        return $this->getData(self::FIELD_STATUS);
    }

    /**
     * Set API Status
     * @param $value
     * @return $this
     */
    public function setStatus($value)
    {
        return $this->setData(self::FIELD_STATUS, $value);
    }
}
