<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Amazon-Sdk
 * @package     Ced_Amazon_Sdk
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CedCommerce (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Api;

class Config implements ConfigInterface
{
    /**
     * Amazon Seller Id or Merchant Id
     * @var string $sellerId
     */
    protected $sellerId;

    /**
     * Amazon Marketplace Id
     * @var string $marketplaceId
     * @refer var $marketplaceIds
     */
    protected $marketplaceId;

    /**
     * AWSAccessKeyId
     * @var string $accessKeyId
     */
    protected $accessKeyId;

    /**
     * Amazon Secret Key
     * @var string $secretKey
     */
    protected $secretKey;

    /**
     * Amazon Service Url
     * @var string $serviceUrl
     * @refer var $marketplaceIds
     */
    protected $serviceUrl = \Amazon\Sdk\Marketplace::URL_NORTH_AMERICA;

    /**
     * Mute Logging
     * @var boolean $muteLog
     */
    protected $muteLog;

    /**
     * MWS auth token
     * @var string $token
     */
    protected $token;

    /** @var \Amazon\Sdk\Marketplace */
    protected $marketplace;

    /**
     * API Mode
     * @var $mode
     */
    protected $mode = self::API_MODE_SELLER;

    /**
     * [
     * 'sellerId' => 'AU5LJQPL530RI',
     * 'marketplaceId' => 'A21TJRUUN4KGV',
     * 'accessKeyId' => 'AKIAIGWDV4YWY53QGLMQ',
     * 'secretKey' => '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',
     * 'token' => 'amzn.mws.4ea38b7b-f563-7709-4bae-87aea',
     * 'serviceUrl' => 'https://mws.amazonservices.in/',
     * 'mode' => 'merchant',
     * 'muteLog' => false
     * ]
     * @inheritdoc
     */
    public function __construct($params = [])
    {
        foreach ($params as $key => $value) {
            if (property_exists($this, $key)) {
                $this->{$key} = $value;
            }
        }

        $this->marketplace = new \Amazon\Sdk\Marketplace();
    }

    /**
     * @inheritdoc
     */
    public function getSellerId()
    {
        return $this->sellerId;
    }

    /**
     * @inheritdoc
     */
    public function setMode($mode)
    {
        $this->mode = $mode;
    }

    /**
     * @inheritdoc
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * @inheritdoc
     */
    public function setSellerId($sellerId)
    {
        $this->sellerId = $sellerId;
    }

    /**
     * @inheritdoc
     */
    public function getAccessKeyId()
    {
        return $this->accessKeyId;
    }

    /**
     * @inheritdoc
     */
    public function setAccessKeyId($accessKeyId)
    {
        $this->accessKeyId = $accessKeyId;
    }

    /**
     * @inheritdoc
     */
    public function getMarketplaceId()
    {
        return $this->marketplaceId;
    }

    /**
     * @inheritdoc
     */
    public function setMarketplaceId($marketplaceId)
    {
        $this->marketplaceId = $marketplaceId;
    }

    /**
     * @inheritdoc
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }

    /**
     * @inheritdoc
     */
    public function setSecretKey($secretKey)
    {
        $this->secretKey = $secretKey;
    }

    /**
     * @inheritdoc
     */
    public function getServiceUrl()
    {
        if (isset($this->marketplaceId) && !empty($this->marketplaceId)) {
            if (is_string($this->marketplaceId) && $this->marketplace->has($this->marketplaceId)) {
                $this->serviceUrl = $this->marketplace->url($this->marketplaceId);
            } elseif (is_array($this->marketplaceId) && $marketplaceId = reset($this->marketplaceId)) {
                if ($this->marketplace->has($marketplaceId)) {
                    $this->serviceUrl = $this->marketplace->url($marketplaceId);
                }
            }
        }

        return $this->serviceUrl;
    }

    /**
     * @inheritdoc
     */
    public function setServiceUrl($serviceUrl)
    {
        if (!in_array($serviceUrl, \Amazon\Sdk\Marketplace::URLS)) {
            $serviceUrls = implode('|', \Amazon\Sdk\Marketplace::URLS);
            throw new \Amazon\Sdk\Api\Exception\InvalidConfigValue(
                "Invalid service url - '{$serviceUrl}'. Available urls are: {$serviceUrls}"
            );
        }

        $this->serviceUrl = $serviceUrl;
    }

    /**
     * @inheritdoc
     */
    public function getMuteLog()
    {
        return $this->muteLog;
    }

    /**
     * @inheritdoc
     */
    public function setMuteLog($muteLog = false)
    {
        $this->muteLog = $muteLog;
    }

    /**
     * Set Amazon MWSAuthToken
     * @param string $token
     */
    public function setAuthToken($token)
    {
        $this->token = $token;
    }

    /**
     * Get Amazon MWSAuthToken
     * @return string
     */
    public function getAuthToken()
    {
        return $this->token;
    }
}
