<?php
namespace App\Webapi\Components;
use App\Core\Models\Resource;

class Helper extends \App\Core\Components\Base
{
    public function loadAreaConfigurations() {
        $helper = $this->di->getObjectManager()->get('App\Core\Components\Helper');
        $config = $this->di->getCache()->get('config');
        foreach ($helper->getAllModules() as $module => $active) {
            if ($active) {
                $filePath = CODE . DS . $module . DS . 'etc' . DS . 'rest'.DS.'config.php';
                if (file_exists($filePath)) {
                    $array = new \Phalcon\Config\Adapter\Php($filePath);
                    $config->merge($array);
                }
                $systemConfigfilePath = CODE . DS . $module . DS . 'etc'  . DS . 'rest'.DS. 'webapi.php';
                if (file_exists($systemConfigfilePath)) {
                    $array = new \Phalcon\Config\Adapter\Php($systemConfigfilePath);
                    $config->merge($array);
                }
            }
        }
        $this->di->set('config', $config);
    }

    public function updateAfter(\Phalcon\Events\Event $event,$object){
        $data = $event->getData();
        $this->di->getObjectManager()->get('\App\Webapi\Components\Helper')
                ->loadAreaConfigurations();
        $module = 'webapi';

        foreach($this->di->getConfig()->get('restapi')->get('v1')->toArray() as $method=>$routes){
            $method = strtolower($method);
            foreach($routes['routes'] as $apis){
                $resource = $apis['resource'] ?? $apis['url'];
                $data['final_resources'][$module . '_' . $resource . '_' . $method] = 1;
                $resources = ['module' => $module, 'controller' => $resource, 'action' => $method];
                if (!Resource::findFirst([
                    "module = :module: AND controller = :controller: AND action = :action:",
                    'bind' => $resources])
                ) {
                    $resource = new Resource($resources);
                    $resource->save();
                }
            }

        }

    }
}
