<?php

namespace App\Apiconnect\Controllers;

use Phalcon\Http\Response;

/**
 * Class RequestController
 * @package App\Shopifywebapi\Controllers
 */
class RequestController extends \App\Core\Controllers\BaseController
{

    public $_postData;

    public $_targetMarketplace;

    public $_errorMsg;

    public $_appConfig;

    public function initialize()
    {
        $this->_postData = $shop = $this->request->get();
        $this->di->getLog()->logContent('post data : ' . json_encode($this->_postData), 'info', 'postData.log');
        if (empty($this->_postData)) $this->_errorMsg = 'App missing. Please contact support.';
        $this->_appConfig = $this->di->getRegistry()->getAppConfig();

        $this->di->getLog()->logContent('_appConfig : ' . print_r($this->_appConfig, true), 'info', 'postData.log');

        if (empty($this->_appConfig) || !isset($this->_appConfig['marketplace'])) $this->_errorMsg = 'Sorry !! Requested App does not exist. Please contact support.';
        $targetMarketplace = $this->di->getConfig()->get('marketplace-modules')->get($this->_appConfig['marketplace']) ?: ucfirst($this->_appConfig['marketplace']);
        $this->di->getLog()->logContent('_target marketplace : ' . json_encode($targetMarketplace), 'info', 'postData.log');
        $this->_targetMarketplace = $targetMarketplace;
    }

    public function authAction()
    {

        try {
            $this->di->getLog()->logContent('auth post data : ' . json_encode($this->_postData), 'info', 'postData.log');

            if (!empty($this->_errorMsg)) return $this->prepareResponse(['success' => false, 'message'=> $this->_errorMsg]);
            $authData = $this->di->getObjectManager()->get('\App\\'.$this->_targetMarketplace.'\\Components\Route\Handler')->requestRedirectAuthUrl($this->_postData);
            $this->di->getLog()->logContent('$authData : ' . json_encode($authData), 'info', 'postData.log');
            $this->di->getLog()->logContent('STEP 1 : ', 'info', 'postData.log');

            if(!($authData['success']) && isset($authData['force_redirect'])) return $this->response->redirect($this->di->getConfig()->get('frontend_force_app_url').'?'.http_build_query($authData));
            $this->di->getLog()->logContent('STEP 2 : ', 'info', 'postData.log');
            if(isset($this->_appConfig['sub_app_id'])){
                $this->session->set("sub_app_id",$this->_appConfig['sub_app_id']);
            }else{
                $this->session->set("sub_app_id",false);
            }
            if(isset($this->_postData['state'])){
                $this->session->set("requested_state",$this->_postData['state']);
            }
            else{
                $this->session->set("requested_state",false);
            }
            $this->di->getLog()->logContent('STEP 3 : ', 'info', 'postData.log');

            if (!($authData['success'])) return $this->prepareResponse($authData);
            return $this->response->redirect($authData['authUrl'], true);
        } catch (\Exception $e) {
            print_r($e->getMessage());
            print_r($e->getTraceAsString());die;
        }

    }

    public function commenceAuthAction()
    {
        // if (!empty($this->_errorMsg)) return $this->prepareResponse(['errorFlag' => true, 'msg'=> $this->_errorMsg]);
        if (!empty($this->_errorMsg)) return $this->prepareResponse(['success' => true, 'msg'=> $this->_errorMsg]);
        $handler = $this->di->getObjectManager()->get('\App\\'.$this->_targetMarketplace.'\\Components\Route\Handler');
        $result = $handler->processAuth();

        $this->di->getLog()->logContent('result = '.json_encode($result),'critical','shopify_home_auth.log');


        if ($result['success']) {
            $helper = $this->di->getObjectManager()->get('\App\Core\Components\Helper');
            $date1 = new \DateTime('+360 second');
            if(!isset($result['data']['state'])){
                $result['data']['marketplace'] = $this->_appConfig['marketplace'];
                $token = [
                    "data" => $result['data'],
                    "exp" => $date1->getTimestamp()
                ];

                $token = $helper->getJwtToken($token, 'RS256', false, $this->_appConfig['private_key'] ?? false);
                $result = ['data'=>$token];
               
            }
            $result['marketplace'] = $this->_appConfig['marketplace'];
            if($state = $this->session->get("requested_state")){
                $result['state'] = $state;
            }

           
            return $this->response->redirect($handler->getUrl($this->_appConfig['url'], '', $result), true);
        } elseif (isset($result['message'])) {
            if($state = $this->session->get("requested_state")){
                
                $result['state'] = $state;
            }
            $result['msg'] = $result['message'];
            return $this->response->redirect($handler->getUrl($this->_appConfig['url'], '', $result), true);
        }
    }

    public function saveSellerInfoAction(){

        if(isset($this->_postData['test'])){
            $path = 'shopifywebapi' . DS . 'view' . DS . 'email' . DS . 'review.volt';
            $data['email'] = 'shuklaswati881@gmail.com';
            $data['path'] = $path;
            $data['name'] = "Pankaj Aswal";
            $data['subject'] = 'Account Pending for Facebook Approval';
            $data['aksb'] = $this->di->getConfig()->backend_base_url .'front/shopify/email/aksb.js';
            $data['logo'] = $this->di->getConfig()->backend_base_url .'front/shopify/email/logo.png';
            $data['fb_banner'] = $this->di->getConfig()->backend_base_url .'front/shopify/email/fb_banner.jpg';

            $response = $this->di->getObjectManager()->get('App\Core\Components\SendMail')->send($data);

            print_r($response);die('test 00');
        }

        if(!isset($this->_postData['sAppId']) || !isset($this->_postData['shop_url'])){
            return $this->prepareResponse([
                'success' => false,
                'message' => 'Field Missing. Kindly provide all data.'
            ]);
        }

        $shopData = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->getShop(false , false, ["shop_url" => $this->_postData['shop_url']], ['shop_url']);

        if(isset($shopData['data']['datos']['info'])){
            if(isset($this->_postData['status'])){
                $info = $shopData['data']['datos']['info'];

                $info['status'] = isset($this->_postData['status']) ? $this->_postData['status'] : $info['status'];
                $info['name'] = isset($this->_postData['name']) ? $this->_postData['name'] : $info['name'];
                $info['email'] = isset($this->_postData['email']) ? $this->_postData['email'] : $info['email'];
                $info['category'] = isset($this->_postData['category']) ? $this->_postData['category'] : $info['category'];
                $info['facebook_id'] = isset($this->_postData['facebook_id']) ? $this->_postData['facebook_id']: $info['facebook_id'];

                $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(false, false, [
                    'shop_url' => $this->_postData['shop_url'],
                    'info' => $info
                ],
                    ['shop_url']
                );
                return $this->prepareResponse($shop);
            } else {
                return $this->prepareResponse([
                    'success' => false,
                    'message' => 'Invalid Request Type'
                ]);
            }
        } else {
            $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->addShop(false, false, [
                'shop_url' => $this->_postData['shop_url'],
                'info' => [
                    'name' => $this->_postData['name'],
                    'email' => $this->_postData['email'],
                    'category' => $this->_postData['category'],
                    'facebook_id' => $this->_postData['facebook_id'],
                    'status' => isset($this->_postData['status']) ? $this->_postData['status'] : 'UNDER_REVIEW'
                ]
            ],
                ['shop_url']
            );

            $path = 'shopifywebapi' . DS . 'view' . DS . 'email' . DS . 'review.volt';
            $data['email'] = $this->_postData['email'];
            $data['path'] = $path;
            $data['name'] = $this->_postData['name'];
            $data['subject'] = 'Account Pending for Facebook Approval';
            $data['aksb'] = $this->di->getConfig()->backend_base_url .'front/shopify/email/aksb.js';
            $data['logo'] = $this->di->getConfig()->backend_base_url .'front/shopify/email/logo.png';
            $data['fb_banner'] = $this->di->getConfig()->backend_base_url .'front/shopify/email/fb_banner.jpg';

            $response = $this->di->getObjectManager()->get('App\Core\Components\SendMail')->send($data);

            return $this->prepareResponse([
                'success' => true,
                'message' => 'Your Application has been successfully Submitted.'
            ]);
        }

    }

}