<?php
namespace App\Apiconnect\Models;

use App\Core\Models\Base;

class Apps extends \App\Core\Models\BaseMongo
{
    protected $table = 'apps';

    protected $isGlobal = true;

    /**
     * Set user config data by key
     *
     * @param int $apps_id
     * @param string $key
     * @param mixed $value
     * @return array with success true/false and message
     */
    public function setConfigByKey($apps_id, $key, $value){
        if (!$apps_id) {
            return false;
        }
        $result = $collection->UpdateOne(
            ['_id' => $apps_id],
            ['$set' => ["{$key}" => $value]]
        );
        if ($result->getMatchedCount()) {
            return ['success' => true, 'message' => 'Shop Updated Successfuly'];
        } else {
            return ['success' => false, 'message' => 'No Record Matched', 'code' => 'no_record_found'];
        }

    }

    /**
     * Get apps data by key
     *
     * @param string $key
     * @param int $apps_id
     * @return mixed
     */
    public function getAppsDataByKey($key, $apps_id = false){
        if (!$apps_id) {
            return false;
        }
        $result = $collection->findOne(
            ['_id' => $apps_id],
            [
                "typeMap" => ['root' => 'array', 'document' => 'array'],
                "projection" => ["{$key}" => 1]
            ]
        );
        if (!empty($result) && isset($result[$key])) {
            return $result[$key];
        }
        return false;
    }

    /**
     * Get apps data
     *
     * @param int $apps_id
     * @return array
     */
    public function getConfig($apps_id = false){
        if (!$apps_id) {
            return false;
        }
        $collection = $this->getCollection();
        return $collection->findOne(
                    ['_id' => (int)$apps_id],
                    ["typeMap" => ['root' => 'array', 'document' => 'array']]
                );
    }

    /*
     * get sub app object
     * */
    public function getSubApp($sAppId){
        $subUserWithApp = $this->getSubUserWithApp([['apps._id'=>(int)$sAppId]]);
        return isset($subUserWithApp[0]) ? $subUserWithApp[0]->apps : false;
    }

    public function getSubConfig($sAppId){
        $subApp = $this->getSubApp($sAppId);
        $appConfig = $this->getConfig($subApp->app_id);

        $appConfig['url'] = $subApp->auth_url;
        $appConfig['sub_app_id'] = $subApp->_id;
        $appConfig['domain'] = $subApp->domain;
        $appConfig['public_key'] = isset($subApp->public_key)?$subApp->public_key:'';
        $appConfig['private_key'] = isset($subApp->private_key)?$subApp->private_key:'';
        
        return $appConfig;
    }

    public function getSubUserWithApp($filter = []){
        $subUser = $this->di->getObjectManager()->create('App\Core\Models\User\SubUser');
        $aggregation = [];
        $aggregation[] = ['$unwind'=>'$apps'];
        $aggregation[] = ['$match' =>
            [
                '$and'=> $filter
            ]
        ];
        return $subUser->getCollection()->aggregate($aggregation)->toArray();
    }

}