<?php

namespace App\Apiconnect\Components\Authenticate;

/**
 * A marketplace module needs to implement HandlerInterface for authentication
 *
 * Interface HandlerInterface
 * @package App\Apiconnect\Components\Authenticate
 */
interface HandlerInterface
{
    /**
     * Step 2: Generate Marketplace authentication url and redirect to it
     * @param $params
     * @return array
     */
    public function requestRedirectAuthUrl($params);

    /**
     * Step 3: Receive Marketplace Token, Verify Token and Create/Update a Shop
     *
     * @return array
     */
    public function processAuth();
}
