<?php

namespace App\Apiconnect\Api;

class AppShop extends \App\Apiconnect\Api\Base
{
    protected $_component = 'AppShop';

    /**
     * get one product/ get product list.
     *
     * @param array $requestData
     * @return array/json with success true/false and message
     */
    public function get($requestData)
    {
        if (isset($requestData['shop_data']) && $requestData['unique_keys']) {
            return $this->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                    ->getShop(false, false, $requestData['shop_data'], $requestData['unique_keys'], true);
        } else {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insufficient_data'];
        }
    }

    public function set($requestData)
    {
        if (isset($requestData['shop_id'])) {
            return $this->di->getObjectManager()->get('\App\Apiconnect\Models\Apps\Shop')
                    ->addShop(false, false, ['_id'=>$requestData['shop_id']], ['_id']);
        } else {
            return ['success' => false, 'message' => 'Shop details not provided', 'code' => 'insufficient_data'];
        }
    }

    public function delete($requestData)
    {
        try {
            if($shop = $this->di->getRegistry()->getCurrentShop())
            {
                // if(is_array($requestData['shop_ids']))
                // {
                //     $response = [];

                //     foreach ($$requestData['shop_ids'] as $id) {
                //         $resp = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->deleteShop($id);
                //         if($resp['success']) {
                //             $response['success'][$id] = $id;
                //         }
                //         else {
                //             $response['error'][$id] = $resp['message'];
                //         }

                //         if(isset($response['success'])) {
                //             return [
                //                 'success'   => true,
                //                 'data'      => $response
                //             ];
                //         }
                //         else {
                //             return [
                //                 'success'   => false,
                //                 'msg'       => $response['error']
                //             ];
                //         }
                //     }
                // }
                // else
                // {
                    $shop = $this->di->getobjectManager()->create('\App\Apiconnect\Models\Apps\Shop')->deleteShop($requestData['shop_id']);

                    if(isset($shop['success'])) {
                        return [
                            'success' => true,
                            'data' => $requestData['shop_id']
                        ];
                    }
                    else {
                        return [
                            'success' => false,
                            'msg' => $shop['message']
                        ];
                    }
                // }
            }
            else
            {
                die('shop_id not found.');
            }
        } catch (\Exception $exception) {
            return $exception->getMessage();
        }
    }
}
