<?php

namespace Onyx;


class Client
{

    public $client_id;
    public $client_secret;

    private $base_url = 'https://uczikt95ne.execute-api.us-east-2.amazonaws.com/prod';

    public function __construct($client_id, $client_secret, $base_url = null)
    {
        $this->client_id = $client_id;
        $this->client_secret = $client_secret;
        if ($base_url) {
            $this->base_url = $base_url;
        }
    }

    public function getTokenFromAuthorizationCode($authCode)
    {
        $request_uri = 'oauth/token';

        $postData = [
            'client_id' => $this->client_id,
            'client_secret' => $this->client_secret,
            'grant_type' => 'authorization_code',
            'code' => $authCode
        ];

        $params = http_build_query($postData);

        $headers = [
            'Content-Type: application/x-www-form-urlencoded'
        ];

        $response = $this->call($request_uri, $headers, $params, 'POST');

        return $response;
    }

    public function getTokenFromRefreshToken($clientId, $clientSecret, $refreshToken)
    {
        $request_uri = 'oauth/token';

        $postData = [
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'grant_type' => 'refresh_token',
            'refresh_token' => $refreshToken
        ];

        $params = http_build_query($postData);

        $headers = [
            'Content-Type: application/x-www-form-urlencoded'
        ];

        $response = $this->call($request_uri, $headers, $params, 'POST');

        return $response;
    }

    public function call($uri, $headers, $params = [], $method = 'GET')
    {
        $url = trim($this->base_url, '/') . "/{$uri}";

        if ($method === 'GET' || strtolower($method) === 'get') {
            $url .= empty($params) ? '' : '?' . http_build_query($params);
        }

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        if (strtolower($method) !== 'get') {
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $curlResponse = curl_exec($ch);

        if ($curlResponse === false || curl_error($ch)) {
            $curlError = curl_error($ch);

            curl_close($ch);

            return ['success' => false, 'message' => $curlError];
        } else {
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            curl_close($ch);

            return ['success' => true, 'http_code' => $httpCode, 'data' => json_decode($curlResponse, true)];
        }
    }
}