# Store API

## Get all sites information


```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getSites();
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    die;

//    Sample Response : {"success":true,"data":[{"icon":"icon-url","updateTime":"2021-04-30T13:53:23.003424Z","status":"DRAFT","createTime":"2021-04-28T02:43:52.053588Z","logo":"logo-url","id":"site456","name":"My Site 2"},{"icon":"icon-url","updateTime":"2021-04-30T13:53:23.003424Z","status":"DRAFT","createTime":"2021-04-28T02:43:52.053588Z","logo":"logo-url","id":"site789","name":"My Site 3"},{"icon":"icon-url","updateTime":"2021-04-30T13:53:23.003424Z","status":"LIVE","createTime":"2021-04-28T02:43:52.053588Z","logo":"logo-url","id":"site123","name":"My Site"}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get a site information


```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getSite(
        [
            'params'=>[
                'siteId'=>'site123'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    die;

//    Sample Response : {"success":true,"data":{"icon":"icon-url","updateTime":"2021-04-30T13:53:23.003424Z","status":"LIVE","createTime":"2021-04-28T02:43:52.053588Z","logo":"logo-url","id":"site123","name":"My Site"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?> 
```