# Promotion API


## Create a promotion

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createPromotion(
        [
            'data' => [
                "promotionType" => "PER_PRODUCT_DISCOUNT",
                "redemptionMethod" => "AUTOMATIC",
                "status" => "Active",
                "updatedBy" => "ShivamVerma",
                "scheduleEnd" => "2022-01-28T00:00:00-08:00",
                "name" => "Shivam End Of Reason Sale",
                "discount" => [
                    "discountType" => "PERCENT_OFF",
                    "discountPercent" => "5"
                ],
                "enabled" => true,
                "eligibleCustomers" => [
                    "customerSegmentIds" => [
                        "NewCustomers"
                    ],
                    "customerReferenceType" => "CUSTOMER_SEGMENT_IDS"
                ],
                "discountProducts" => [
                    "productReferenceType" => "PRODUCT_COLLECTION_IDS",
                    "productCollectionIds" => [
                        "FOOD"
                    ]
                ],
                "scheduleStart" => "2022-01-01T00:00:00-08:00"
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    //Sample Response : {"success":true,"data":{"promotionType":"PER_PRODUCT_DISCOUNT","redemptionMethod":"AUTOMATIC","status":"Active","updatedBy":"ShivamVerma","scheduleEnd":"2021-12-28T00:00:00-08:00","name":"Shivam End Of Reason Sale","discount":{"discountType":"PERCENT_OFF","discountPercent":"5"},"enabled":1,"eligibleCustomers":{"customerSegmentIds":["NewCustomers"],"customerReferenceType":"CUSTOMER_SEGMENT_IDS"},"discountProducts":{"productReferenceType":"PRODUCT_COLLECTION_IDS","productCollectionIds":["FOOD"]},"scheduleStart":"2022-01-01T00:00:00-08:00","id":"I0a5E9BkXy","redemptionCountUpdateTime":"2021-12-30T11:42:27.963816Z","createTime":"2021-12-30T11:42:27.963816Z","updateTime":"2021-12-30T11:42:27.963816Z","version":1}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```
## Update a promotion

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->updatePromotion(
        [
            'params' => [
                "promotion_id" => 'zSdtpE78'
            ],
            'data' => [
                "id" => 'zSdtpE78',
                "name" => 'Winter Sale 25% OFF'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    //Sample Response : {"success":true,"data":{"message":"Promotion updated successfully"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Delete a promotion

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->deletePromotion(
        [
            'params' => [
                'promotion_id' => 'I0a5E9BkXy'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":null}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get all promotions

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getPromotions();
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":[{"version":"3","redemptionMethod":"COUPON_CODE","minimumBuyValue":{"type":"AMOUNT","amount":{"currencyCode":"USD","amount":"100.00"}},"createTime":"2021-06-01T02:43:52.053588Z","name":"Toy Sale ($15 off $100)","items":{"type":"PRODUCTS","products":[{"id":"toy123"},{"id":"toy456"}]},"coupon":{"code":"TOY_SALE"},"discount":{"type":"AMOUNT","amount":{"currencyCode":"USD","amount":"15.00"}},"enabled":true,"startTime":"2021-06-20T00:00:00Z","endTime":"2021-09-20T12:30:00Z","updateTime":"2021-06-05T13:53:23.003424Z","redemptionCount":"5","redemptionLimit":"5000","redemptionCountUpdateTime":"2021-10-05T02:20:00.123456Z","id":"1GNN2W1I","type":"PRODUCT_DISCOUNT"},{"version":"1","redemptionMethod":"COUPON_CODE","minimumBuyValue":{"type":"QUANTITY","quantity":"5"},"createTime":"2021-02-01T02:43:52.053588Z","name":"Winter Sale","coupon":{"code":"WINTER_SALE"},"discount":{"type":"PERCENTAGE","percentage":"25"},"enabled":false,"startTime":"2021-06-20T00:00:00Z","endTime":"2021-09-20T12:30:00Z","updateTime":"2021-02-01T02:43:52.053588Z","redemptionCount":"12","redemptionLimit":"1525","redemptionCountUpdateTime":"2021-10-05T02:20:00.053588Z","id":"zSdtpE78","type":"ORDER_DISCOUNT"},{"version":"1","redemptionMethod":"COUPON_CODE","minimumBuyValue":{"type":"AMOUNT","amount":{"currencyCode":"USD","amount":"100.00"}},"createTime":"2020-01-01T04:32:23.034234Z","name":"Free Shipping (up to $10 discount) on orders over $100","coupon":{"code":"FREE_SHIP_100"},"enabled":true,"startTime":"2020-02-20T08:00:00Z","updateTime":"2020-01-01T04:32:23.034234Z","maximumDiscountAmount":{"currencyCode":"USD","amount":"10.00"},"redemptionCount":"0","id":"U5ynjjt9","type":"FREE_SHIPPING"}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get a promotion

```php 

<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getPromotion(
        [
            'params' => [
                'promotion_id' => 'U5ynjjt9'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"version":"1","redemptionMethod":"COUPON_CODE","minimumBuyValue":{"type":"AMOUNT","amount":{"currencyCode":"USD","amount":"100.00"}},"createTime":"2020-01-01T04:32:23.034234Z","name":"Free Shipping (up to $10 discount) on orders over $100","coupon":{"code":"FREE_SHIP_100"},"enabled":true,"startTime":"2020-02-20T08:00:00Z","updateTime":"2020-01-01T04:32:23.034234Z","maximumDiscountAmount":{"currencyCode":"USD","amount":"10.00"},"redemptionCount":"0","id":"U5ynjjt9","type":"FREE_SHIPPING"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>

```

## Get all Coupons

```php 

<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getCoupons();
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":[{"code":"GJDKJSHAK","redemptionCount":"2","redemptionCountUpdateTime":"2021-12-15T05:50:00.654321Z","promotion":{"id":"XJDKJDKH"}},{"code":"ASKDJIFJH","redemptionCount":"5","redemptionCountUpdateTime":"2021-10-05T02:20:00.123456Z","promotion":{"id":"XJDKJDKH"}}]}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>

```

## Get a coupons

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getCoupon(
        [
            'params' => [
                'code' => 'GJDKJSHAK'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"code":"GJDKJSHAK","redemptionCount":"2","redemptionCountUpdateTime":"2021-12-15T05:50:00.654321Z","promotion":{"id":"XJDKJDKH"}}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>

```