# Contact API

## Create Contact on Onyx

```php
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createContact(
        [
            'data' => [
                "emailDataList" => [
                    [
                        "name" => "Shivam",
                        "email" => "shivam@domain.com",
                        "verificationStatus" => "VERIFIED"
                    ]
                ]
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":{"contactBookReference":{"contactBookId":"49b02250-6959-11ec-bb96-2bb444240c68","contactBookVersionId":"1"}}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get a contact from Onyx

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getContact(
        [
            'params' => [
                "contactBookId" => '49b02250-6959-11ec-bb96-2bb444240c68',
                "contactBookVersionId" => '1'
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    die;

//    Sample Response : {"success":true,"data":{"contactBookInformation":{"contactBookReference":{"contactBookId":"49b02250-6959-11ec-bb96-2bb444240c68","contactBookVersionId":"1"},"creationTime":"1640859275093","emailContactList":[{"creationTime":"1640859275093","contactId":"shivam@domain.com","emailData":{"name":"Shivam","verificationStatus":"VERIFIED","email":"shivam@domain.com"}}]}}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```