# Catalog API

## Get a Catalog by Catalog Id
   
```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getCatalog(
        [
            'params' => [
                'catalog_id' => $catalogId
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"catalogName":"demo catalog","catalogId":"YEzFjXRG3G"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>

```

## Create a Catalog 

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createCatalog(
        [
            'data' => [
                'catalogName' => "Test Catalog SDKs"
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"message":"catalog created successfully"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get all product using catalog_id

```php  
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';

    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getProducts(
        [
            'params' => [
                'catalog_id' => $catalogId
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    Sample Response : {"success":true,"data":[{"attributes":[{"attributeId":"it:santos\/product:title","attributeValue":{"string":"demo product 2"}},{"attributeId":"it:santos\/product:price","attributeValue":"20"},{"attributeId":"it:santos\/product:currency_code","attributeValue":"USD"},{"attributeId":"open-content:demo_open_content","attributeValue":{"string":"demo variant attribute"}}],"catalogId":"YEzFjXRG3G","productId":"EIx8rufklq"},{"relationships":[{"relationshipId":"fhA243adi6","type":"variant","attributeDiscriminators":[{"variantAttributeValue":{"string":"demo variant attribute"},"variantAttributeId":"open-content:demo_open_content"}],"connectedEntity":{"catalog":{"productId":"EIx8rufklq"}}}],"attributes":[{"attributeId":"it:santos\/product:title","attributeValue":{"string":"demo product"}},{"attributeId":"it:santos\/product:price","attributeValue":"10"},{"attributeId":"it:santos\/product:currency_code","attributeValue":"USD"},{"attributeId":"open-content:demo_open_content","attributeValue":{"string":"open-content value"}}],"catalogId":"YEzFjXRG3G","productId":"1RUH7nbpLY"}]}
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get a single product using catalog_id & product_id

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $product_id = 'EIx8rufklq';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getProduct(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $product_id
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Create a product on Onyx

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createProduct(
        [
            'params' => [
                'catalog_id' => $catalogId,
            ],
            'data' => [
                'attributes' => [
                    [
                        'attributeId' => 'open-content:demo_open_content-sdk',
                        'attributeValue' => 'demo sdk data new test'
                    ],
                    [
                        'attributeId' => 'it:santos/product:title',
                        'attributeValue' => 'Test Simple Product'
                    ],
                    [
                        'attributeId' => 'it:santos/product:price',
                        'attributeValue' => 10
                    ],
                    [
                        'attributeId' => 'it:santos/product:currency_code',
                        'attributeValue' => 'USD'
                    ]
                ]
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    Sample Resonse : {"success":true,"data":{"message":"product created successfully","Location":"https:\/\/q9yzuvr05h.execute-api.us-east-1.amazonaws.com\/prod\/catalogs\/YEzFjXRG3G\/YEzFjXRG3G\/products\/KpC1WIaU6o"}}
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Delete a product from Onyx

```php  

<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $productId = 'KpC1WIaU6o';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->deleteProduct(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":null}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Update a product on Onyx

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $productId = '0t3Ft0o6ao';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->deleteProduct(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId,
                'attribute_name' => 'price'
            ],
            'data' => [
                "attributeValue" => 36
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Success Response : {"success":true,"data":{"message":"product updated successfully"}}
    Sample Error Response : {"success":false,"message":{"error":"product not found"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Create a product attribute on product 

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $productId = 'FAT4HDyt0F';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createProductAttribute(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ],
            'data' => [
                'attributeId' => 'myattribute',
                'attributeValue' => '98745897858478',
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

//    Sample Response : {"success":true,"data":{"message":"CREATED"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Delete a product attribute from product

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $productId = '0t3Ft0o6ao';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->deleteProductAttribute(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId,
                'attribute_id' => 'currency_code',
            ],
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));

    Sample Response : {"success":true,"data":null}
} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Create a product relation

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $productId = '0t3Ft0o6ao';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->createProductRelation(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ],
            'data' => [
                "type" => "variants",
                "attributeDiscriminators" => [
                    "variantAttributeId" => "open-content:wood_material",
                    "variantAttributeValue" => "WALNUT_GOLD_PLATED"
                ],
                "connectedEntity" => [
                    "catalog" => [
                        "productId" => $productId
                    ]
                ]
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"message":"OK relationship"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>

```

## Get a product relationship

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $productId = 'U938Pk9c9x';
    $relationShipId = 'fhA243adi6';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getProductRelation(
        [
            'params' => [
                'relationship_id' => $relationShipId,
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Reponse : {"success":false,"message":{"error":"product not found"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Get an inventory

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $product_id = 'EIx8rufklq';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->getInventory(
        [
            'params' => [
                'catalog_id' => $catalogId,
            ],
            'data' => [
                "productIds" => [
                    $product_id,
                    'KpC1WIaU6o',
                    '9QIQF0pDDb'
                ]
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"responses":[{"catalogId":"YEzFjXRG3G","availableQuantity":"60","reservedQuantity":"10","productId":"EIx8rufklq","totalQuantity":"70"}],"failedItems":[{"catalogId":"YEzFjXRG3G","productId":"KpC1WIaU6o","reason":"RESOURCE_NOT_FOUND"},{"catalogId":"YEzFjXRG3G","productId":"9QIQF0pDDb","reason":"RESOURCE_NOT_FOUND"}]}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```

## Update a Inventory of product

```php 
<?php

include 'autoload.php';

try {

    $token = 'L3aD>L2PjxtU';
    $catalogId = 'YEzFjXRG3G';
    $product_id = 'EIx8rufklq';
    $apiObj = new \Onyx\Api($token);
    $response = $apiObj->updateInventory(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $product_id
            ],
            'data' => [
                "availableQuantity" => 500
            ]
        ]
    );
    echo '<pre>';
    print_r($response);
    print_r(json_encode($response));
    
    Sample Response : {"success":true,"data":{"catalogId":"YEzFjXRG3G","availableQuantity":500,"reservedQuantity":"10","productId":"EIx8rufklq","totalQuantity":"510"}}

} catch (Exception $e) {
    echo 'Message: ' . $e->getMessage();
}

?>
```