# Onyx PHP SDK

## Catalog API


### Get a Product by Catalog Id and Product Id

```php 
<?php
    try{
     $token =  'L3aD>L2PjxtU',
     $apiObj = new \Onyx\Api($token);
     $response = $apiObj->getProduct(
        [
            'params' => [
                'catalog_id' => $catalogId
                'product_id'=> $productId
            ]
        ]
    );
    }
   catch(Exception $e) {
    echo 'Message: ' .$e->getMessage();
    }
    ?>

```

### Get Products by Catalog Id 

```php 
<?php
    try{
      $token =  'L3aD>L2PjxtU',
      $apiObj = new \Onyx\Api($token);
      $response = $apiObj->getProducts(
        [
            'params' => [
                'catalog_id' => $catalogId
            ]
        ]
    );
    }
    catch(Exception $e) {
    echo 'Message: ' .$e->getMessage();
    }
?>
   
```

### Create Product with Attributes


```php 
<?php
    try{
       $token =  'L3aD>L2PjxtU',
       $apiObj = new \Onyx\Api($token);
       $response = $apiObj->createProduct(
        [
            'params'=>[
                'catalog_id'=>$catalogId,
            ],
            'data' => [
                'attributes' =>  [
                    [
                        'attributeId'=>'open-content:demo_open_content-sdk',
                        'attributeValue'=> 'demo sdk data'
                    ],
                    [
                        'attributeId'=>'it:santos/product:title',
                        'attributeValue'=> 'demo sdk product title'
                    ],
                    [
                        'attributeId'=>'it:santos/product:price',
                        'attributeValue'=> 20
                    ],
                    [
                        'attributeId'=>'it:santos/product:currency_code',
                        'attributeValue'=> 'USD'
                    ]
                    
                    ]
            ]
        ]
    );
    }
    catch(Exception $e){
      echo 'Message: ' .$e->getMessage();
    }
    ?>


```

### Upadte a Product by Catalog Id , Product Id and Attribute Name

```php 
<?php
    try{
        $token =  'L3aD>L2PjxtU',
        $apiObj = new \Onyx\Api($token);
        $response = $apiObj->updateProduct(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId,
                'attribute_name'=>$attributeName,
            ],
            'data'=> [
                "attributeValue"=>1000
            ]
        ]
    );
    }
    catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
    
```

### Delete a Product by Catalog Id and Product Id

```php 
<?php
    try{
         $token =  'L3aD>L2PjxtU',
         $apiObj = new \Onyx\Api($token);
         $response = $apiObj->deleteProduct(
        [
            'params' => [
                'catalog_id' => $catalogId
                'product_id'=> $productId
            ]
        ]
    );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```

### Create a Product Attribute
```php 
<?php
    try{
        $token =  'L3aD>L2PjxtU',
        $apiObj = new \Onyx\Api($token);
        $response = $apiObj->createProductAttribute(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ],
            'data'=>[
                'attribute_id' => $attributeId,
                'attribute_value'=> $attributeValue,
            ]
        ]
    );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```

### Delete a Product Attribute

```php 
<?php
    try{
         $token =  'L3aD>L2PjxtU',
         $apiObj = new \Onyx\Api($token);
         $response = $apiObj->deleteProductAttribute(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId,
                'attribute_id' => $attributeId,
            ],
            
        ]
    );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```

### Get a Product Relation by Relation Id , Product Id and Catalog Id
```php 
<?php
    try{
         $token =  'L3aD>L2PjxtU',
         $apiObj = new \Onyx\Api($token);
         $response = $apiObj->getProductRelation(
        [
            'params' => [
                'relationship_id' => $relationShipId,
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ]
        ]
    );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```

### Create a Product Relation by Product Id and Catalog Id
```php 
<?php
    try{
         $token =  'L3aD>L2PjxtU',
         $apiObj = new \Onyx\Api($token);
         $response = $apiObj->createProductRelation(
        [
            'params' => [
                'catalog_id' => $catalogId,
                'product_id' => $productId
            ],
            'data'=>[
                "type"=>"variants",
                "attributeDiscriminators"=>[
                    "variantAttributeId"=>"open-content:wood_material",
                    "variantAttributeValue"=>"WALNUT_GOLD_PLATED"
                ],
                "connectedEntity"=>[
                    "catalog"=>[
                        "productId"=>$productId
                    ]
                ]
            ]
        ]
    );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```

### Get Inventory of product Ids
```php 
<?php
    try{
       $token =  'L3aD>L2PjxtU',
       $apiObj = new \Onyx\Api($token);
       $response = $apiObj->getInventory(
        [
            'params' => [
                'catalog_id' => $catalogId,
            ],
            'data'=>[
                "productIds" => [
                    $productId
                ]
            ]
        ]
    );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```

### Update Inventory of a product
```php 
<?php
    try{
        $token =  'L3aD>L2PjxtU',
        $apiObj = new \Onyx\Api($token);
        $response = $apiObj->updateInventory(
            [
                'params' => [
                    'catalog_id' => $catalogId,
                    'product_id' => $productId
                ],
                'data'=>[
                    "availableQuantity" => 1000
                ]
            ]
        );
    }
     catch(Exception $e){
        echo 'Message: ' .$e->getMessage();
    }
    ?>
```