<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CedCommerce (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk;

class Validator
{
    public $xsdDirectory = '';

    public $logger;

    public $object;

    public $errors = [];

    public function __construct(
        \Amazon\Sdk\Base $object,
        $directory = null,
        \Psr\Log\LoggerInterface $logger = null
    )
    {
        $this->object = $object;
        $this->logger = $logger;

        $this->xsdDirectory = $this->getXsdDirectory($directory);
    }

    /**
     * @TODO update for all operation type
     * Validate generated xml with xsd files
     * @return array|boolean
     */
    public function validate()
    {
        $status = false;
        try {
            $operationType = $this->object->getOperationType();
            $type = $this->object->getMessageType();
            if ($operationType == \Amazon\Sdk\Base::OPERATION_TYPE_DELETE) {
                $file = $this->xsdDirectory . $type . ".xsd";
                $status = true;
                //@TODO: create a delete xsd for product delete xml validation. Skipped for now.
            } else {
                $file = $this->xsdDirectory . $type . ".xsd";
                if (!file_exists($file)) {
                    throw new \Exception("Xsd file does not exists. {$file}");
                }

                $generator = new \Amazon\Sdk\Generator();
                $xml = $generator->arrayToXml(
                    [
                        $type => [
                            '_attribute' => [],
                            '_value' => $this->object->getData()
                        ],
                    ]
                )->__toString();

                libxml_use_internal_errors(true);
                $dom = new \DOMDocument();
                $dom->preserveWhitespace = false;
                $xmlLoaded = $dom->loadXML($xml);
                if ($xmlLoaded === true) {
                    if (($dom->schemaValidate($file))) {
                        $this->setErrors(null);
                        $status = true;
                    } else {
                        $e = libxml_get_errors();
                        $errors = [];
                        foreach ($e as $item) {
                            $errors[] = $item->message;
                        }
                        $this->setErrors($errors);
                        $status = false;
                    }
                }
            }
        } catch (\Exception $exception) {
            if (isset($this->logger)) {
                $this->logger->log('ERROR', $exception->getMessage(), ['path' => __METHOD__]);
            }
        }

        return $status;
    }

    public function getErrors()
    {
        return $this->errors;
    }

    public function setErrors($errors)
    {
        $this->errors = $errors;
    }

    private function getXsdDirectory($directory)
    {
        if (empty($directory) || !file_exists($directory)) {
            $directory =  __DIR__ . '/../xsd/US/';
        }

        return $directory;
    }
}
