<?php

namespace Amazon\Sdk\Product;

/**
 * Class Inventory
 * @package Amazon\Sdk\Product
 * @refer amazon-sdk/xsd/xsd_in/Inventory.xsd
 */
class Inventory extends \Amazon\Sdk\Base
{
    const TYPE_AFN = 'AFN';
    const TYPE_MFN = 'MFN';

    public $attributes = [
        "SKU" => [
            'id' => "SKU",
            'name' => 'SKU',
            'sequence' => '10',
            'dataType' => "StringNotNull",
            'minOccurs' => '1',
        ],
        "FulfillmentCenterID" => [
            'id' => "FulfillmentCenterID",
            'name' => 'Fulfillment Center ID',
            'sequence' => '20',
            'dataType' => "String",
            'minOccurs' => '0',
        ],
        "Available" => [
            'id' => "Available",
            'name' => 'Available',
            'sequence' => '30',
            'dataType' => "boolean",
            'minOccurs' => '0',
            'choice' => [
                "Quantity",
                "Lookup"
            ],
        ],
        "Lookup" => [
            'id' => 'Lookup',
            'name' => 'Lookup',
            'sequence' => '40',
            'dataType' => "string",
            'minOccurs' => '0',
            'choice' => [
                "Quantity",
                "Available"
            ],
            'restriction' => [
                'optionValues' => [
                    'FulfillmentNetwork'
                ]
            ]
        ],
        "Quantity" => [
            'id' => 'Quantity',
            'name' => 'Quantity',
            'sequence' => '50',
            'dataType' => "nonNegativeInteger",
            'minOccurs' => '0',
            'choice' => [
                "Available",
                "Lookup"
            ],
        ],

        "RestockDate" =>  [
            'id' => 'Restock Date',
            'name' => 'RestockDate',
            'sequence' => '60',
            'dataType' => "date",
            'minOccurs' => '0',
        ],
        "FulfillmentLatency"  =>  [
            'id' => 'FulfillmentLatency',
            'name' => 'Fulfillment Latency',
            'sequence' => '70',
            'dataType' => "positiveInteger",
            'minOccurs' => '0',
        ],
        "SwitchFulfillmentTo"  =>  [
            'id' => 'SwitchFulfillmentTo',
            'name' => 'Switch Fulfillment To',
            'sequence' => '80',
            'dataType' => "string",
            'minOccurs' => '0',
            'restriction' => [
                'optionValues' => [
                    self::TYPE_AFN,
                    self::TYPE_MFN
                ]
            ]
        ],
    ];

    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_INVENTORY;
    }

    /**
     * Set Inventory Data
     * @param $sku
     * @param $qty
     * @param $fulfillmentLatency
     */
    public function setData($sku, $qty, $fulfillmentLatency)
    {
        $this->setSku($sku);
        $this->setQuantity($qty);
        $this->setFulfillmentLatency($fulfillmentLatency);
    }

    public function setSku($value)
    {
        $this->data['SKU'] = (string)$value;
    }

    public function setQuantity($value)
    {
        if (empty($value)) {
            $value = "0";
        }

        $this->data['Quantity'] = (string)$value;
    }

    public function setFulfillmentCenterId($id)
    {
        $this->data['FulfillmentCenterID'] = (string)$id;
    }

    public function setRestockDate($value)
    {
        $this->data['RestockDate'] = (string)$value;
    }

    public function setFulfillmentLatency($value)
    {
        if (empty($value)) {
            $value = "1";
        }

        $this->data['FulfillmentLatency'] = (string)$value;
    }

    public function setChannel($value)
    {
        $this->data['SwitchFulfillmentTo'] = (string)$value;
    }

    public function getData()
    {
        $data = [];

        foreach ($this->getAttributes() as $attribute) {
            $attributeId = $attribute['id'];
            if (isset($this->data[$attributeId])) {
                $data[$attributeId] = $this->data[$attributeId];
            }
        }

        return $data;
    }

    public function getAttributes()
    {
        usort($this->attributes, function ($item1, $item2) {
            if ($item1['sequence'] == $item2['sequence']) {
                return 0;
            }

            return $item1['sequence'] < $item2['sequence'] ? -1 : 1;
        });

        return $this->attributes;
    }
}
