<?php

namespace Amazon\Sdk\Product;

class Image extends \Amazon\Sdk\Base
{
    /**
     * Image Types
     * @var array $imageTypes
     * @refer ProductImage.xsd
     */
    public $imageTypes = [
        'Main',
        'Swatch',
        'BKLB',
        'PT1',
        'PT2',
        'PT3',
        'PT4',
        'PT5',
        'PT6',
        'PT7',
        'PT8',
        'Search',
        'MainOfferImage',
        'OfferImage1',
        'OfferImage2',
        'OfferImage3',
        'OfferImage4',
        'OfferImage5',
        'PFEE',
        'PFUK',
        'PFDE',
        'PFFR',
        'PFIT',
        'PFES',
        'EEGL',
        'PT98',
        'PT99',
        'ELFL',
        'EGUS',
    ];

    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_IMAGE;
    }

    /**
     * Set Image Data
     * @param $sku
     * @param string $imageType
     * @param string $imageLocation
     */
    public function setData($sku, $imageType = 'Main', $imageLocation = '')
    {
        $this->data['SKU'] = (string)$sku;
        if (in_array($imageType, $this->imageTypes)) {
            $this->data['ImageType'] = (string)$imageType;
        } else {
            $imageTypes = implode('|', $this->imageTypes);
            throw new \InvalidArgumentException(
                "Invalid value for 'imageType'. Allowed values are: [{$imageTypes}]"
            );
        }
        $this->data['ImageLocation'] = (string)$imageLocation;
    }
}