<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Wireless
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/Wireless.xsd
 */
class Wireless extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_WIRELESS_ACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_WIRELESS_DOWNLOADS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Wireless';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "WirelessAccessories":
                $this->attributes = array_merge($this->attributes, $this->getWirelessAccessories());
                break;
            case "WirelessDownloads":
                $this->attributes = array_merge($this->attributes, $this->getWirelessDownloads());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Wireless => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Wireless_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getWirelessAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Wireless => 10
         * ProductType => 10
         * WirelessAccessories => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Wireless_ProductType_WirelessAccessories_";

        $this->attributes = [
            "ProductData_Wireless_ProductType_WirelessAccessories" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "WirelessAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Color" => [
                "sequence" => "{$s}10",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Solar" => [
                "sequence" => "{$s}30",
                "name" => "Solar",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}BatteryType" => [
                "sequence" => "{$s}100",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AntennaType" => [
                "sequence" => "{$s}120",
                "name" => "AntennaType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatiblePhoneModels" => [
                "sequence" => "{$s}130",
                "name" => "CompatiblePhoneModels",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ManufacturerName" => [
                "sequence" => "{$s}150",
                "name" => "ManufacturerName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getWirelessDownloads()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Wireless => 10
         * ProductType => 10
         * WirelessDownloads => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Wireless_ProductType_WirelessDownloads_";

        $this->attributes = [
            "ProductData_Wireless_ProductType_WirelessDownloads" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "WirelessDownloads",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}CompatiblePhoneModels" => [
                "sequence" => "{$s}10",
                "name" => "CompatiblePhoneModels",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ManufacturerName" => [
                "sequence" => "{$s}20",
                "name" => "ManufacturerName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ApplicationVersion" => [
                "sequence" => "{$s}50",
                "name" => "ApplicationVersion",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Wireless_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
