<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class WineAndAlcohol
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/WineAndAlcohol.xsd
 */
class WineAndAlcohol extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_WINE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SPIRITS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BEER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'WineAndAlcohol';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Wine":
                $this->attributes = array_merge($this->attributes, $this->getWine());
                break;
            case "Spirits":
                $this->attributes = array_merge($this->attributes, $this->getSpirits());
                break;
            case "Beer":
                $this->attributes = array_merge($this->attributes, $this->getBeer());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * WineAndAlcohol => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_WineAndAlcohol_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "Color",
                                "Color-ItemDisplayWeight",
                                "Color-PatternName",
                                "Color-Size",
                                "Flavor",
                                "Flavor-Size",
                                "ItemDisplayWeight",
                                "ItemDisplayWeight-Color",
                                "ItemDisplayWeight-ItemPackageQuantity",
                                "ItemDisplayWeight-Size",
                                "ItemPackageQuantity-ItemDisplayWeight",
                                "PatternName",
                                "PatternName-Flavor",
                                "PatternName-ItemDisplayWeight",
                                "PatternName-Size",
                                "Size",
                                "Size-Color",
                                "Size-ItemDisplayWeight",
                                "Size-PatternName",
                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}20\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}20\\40",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}20\\80",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PhValue" => [
                "sequence" => "{$s}50",
                "name" => "PhValue",
                "minOccurs" => "0",
                "dataType" => "decimal",
            ],
            "{$i}ItemVolume" => [
                "sequence" => "{$s}70",
                "name" => "ItemVolume",
                "minOccurs" => "1",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ItemVolume_unitOfMeasure_VolumeUnitOfMeasure"
            ],
            "{$i}PackageTypeName" => [
                "sequence" => "{$s}100",
                "name" => "PackageTypeName",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}CountryString" => [
                "sequence" => "{$s}200",
                "name" => "CountryString",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}AgeRangeDescription" => [
                "sequence" => "{$s}250",
                "name" => "AgeRangeDescription",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) && !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getWine()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * WineAndAlcohol => 10
         * ProductType => 10
         * Wine => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_WineAndAlcohol_ProductType_Wine_";

        $attributes = [
            "ProductData_WineAndAlcohol_ProductType_Wine" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Wine",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}HarvestDate" => [
                "sequence" => "{$s}20",
                "name" => "HarvestDate",
                "minOccurs" => "0",
                "dataType" => "dateTime",
            ],
            "{$i}Appellation" => [
                "sequence" => "{$s}30",
                "name" => "Appellation",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VineDescription" => [
                "sequence" => "{$s}35",
                "name" => "VineDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VineAge" => [
                "sequence" => "{$s}40",
                "name" => "VineAge",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}VarietalDesignation" => [
                "sequence" => "{$s}140",
                "name" => "VarietalDesignation",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}BottleColor" => [
                "sequence" => "{$s}270",
                "name" => "BottleColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WineRatingRater" => [
                "sequence" => "{$s}340",
                "name" => "WineRatingRater",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "RP",
                                "WE",
                                "WS",
                            ],
                    ],
            ],
            "{$i}WineRatingScore" => [
                "sequence" => "{$s}350",
                "name" => "WineRatingScore",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WineRatingReview" => [
                "sequence" => "{$s}360",
                "name" => "WineRatingReview",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSpirits()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * WineAndAlcohol => 10
         * ProductType => 10
         * Spirits => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_WineAndAlcohol_ProductType_Spirits_";

        $attributes = [
            "ProductData_WineAndAlcohol_ProductType_Spirits" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Spirits",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getBeer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * WineAndAlcohol => 10
         * ProductType => 10
         * Beer => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_WineAndAlcohol_ProductType_Beer_";

        $attributes = [
            "ProductData_WineAndAlcohol_ProductType_Beer" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Beer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_WineAndAlcohol_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributesArr = [
            "{$i}ItemVolume_unitOfMeasure_VolumeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "liters",
                                1 => "milliliters",
                                2 => "gallon",
                            ],
                    ],
                "default" => "liters"
            ],
        ];
        return array_merge($subAttributes, $subAttributesArr);
    }
}
