<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Video
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/Video.xsd
 */
class Video extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_VIDEO_DVD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEO_VHS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Video';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "VideoDVD":
                $this->attributes = array_merge($this->attributes, $this->getVideoDVD());
                break;
            case "VideoVHS":
                $this->attributes = array_merge($this->attributes, $this->getVideoVHS());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Video => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Video_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getVideoDVD()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Video => 10
         * ProductType => 10
         * VideoDVD => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Video_ProductType_VideoDVD_";

        $attributes = [
            "ProductData_Video_ProductType_VideoDVD" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "VideoDVD",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AspectRatio" => [
                "sequence" => "{$s}5",
                "name" => "AspectRatio",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "1.33:1",
                        "1.37:1",
                        "1.44:1",
                        "1.55:1",
                        "1.66:1",
                        "1.75:1",
                        "1.77:1",
                        "1.78:1",
                        "1.85:1",
                        "2.20:1",
                        "2.35:1",
                        "2.40:1",
                        "2.55:1",
                        "2:1",
                        "unknown_aspect_ratio",
                    ],
                ],
            ],
            "{$i}BBFCRating" => [
                "sequence" => "{$s}10",
                "name" => "BBFCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "ages_12_and_over",
                        "ages_15_and_over",
                        "ages_18_and_over",
                        "exempt",
                        "parental_guidance",
                        "to_be_announced",
                        "universal",
                        "universal_childrens",
                    ],
                ],
            ],
            "{$i}CNCRating" => [
                "sequence" => "{$s}20",
                "name" => "CNCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "universal",
                                "parental_guidance",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "ages_18_and_over_x_rated",
                            ],
                    ],
            ],
            "{$i}FSKRating" => [
                "sequence" => "{$s}30",
                "name" => "FSKRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ages_6_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "checked_by_legal_department",
                                "cannot_publicize",
                                "not_checked",
                                "unknown",
                                "without_age_limitation",
                            ],
                    ],
            ],
            "{$i}MPAARating" => [
                "sequence" => "{$s}40",
                "name" => "MPAARating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "g",
                                "nc-17",
                                "pg",
                                "pg-13",
                                "nr",
                                "unrated",
                                "r",
                                "x",
                            ],
                    ],
            ],
            "{$i}MediaType" => [
                "sequence" => "{$s}50",
                "name" => "MediaType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "dvd",
                                "hd_dvd",
                                "blu_ray",
                                "videodisc",
                                "dvd_i",
                                "dvd_r",
                                "umd",
                                "video_cd",
                                "mini_disc",
                                "laser_disc",
                            ],
                    ],
            ],
            "{$i}Format" => [
                "sequence" => "{$s}100",
                "name" => "Format",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ac-3",
                                "dolby",
                                "thx",
                                "pal",
                                "ntsc",
                                "bw",
                                "color",
                                "subtitled",
                                "dubbed",
                                "closed-captioned",
                                "import",
                                "remastered",
                                "widescreen",
                                "hi-fidelity",
                                "collectors_edition",
                                "silent",
                                "directors_cut",
                                "full_screen",
                                "anamorphic",
                                "surround",
                                "dts_stereo",
                                "dvd_video",
                                "vhs",
                                "vhs_c",
                                "hybrid_sacd",
                                "digital_sound",
                                "deluxe_edition",
                                "special_extended_version",
                                "special_limited_edition",
                                "mono",
                                "dual_disc",
                                "value_price",
                                "multisystem",
                                "hd_dvd",
                                "blu_ray",
                            ],
                    ],
            ],
            "{$i}Language" => [
                "sequence" => "{$s}200",
                "name" => "Language",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Abkhazian",
                                "Adygei",
                                "Afar",
                                "Afrikaans",
                                "Albanian",
                                "Alsatian",
                                "Amharic",
                                "Arabic",
                                "Aramaic",
                                "Armenian",
                                "Assamese",
                                "Aymara",
                                "Azerbaijani",
                                "Bambara",
                                "Bashkir",
                                "Basque",
                                "Bengali",
                                "Berber",
                                "Bhutani",
                                "Bihari",
                                "Bislama",
                                "Breton",
                                "Bulgarian",
                                "Burmese",
                                "Buryat",
                                "Byelorussian",
                                "CantoneseChinese",
                                "Castillian",
                                "Catalan",
                                "Cayuga",
                                "Cheyenne",
                                "Chinese",
                                "ClassicalNewari",
                                "Cornish",
                                "Corsican",
                                "Creole",
                                "CrimeanTatar",
                                "Croatian",
                                "Czech",
                                "Danish",
                                "Dargwa",
                                "Dutch",
                                "English",
                                "Esperanto",
                                "Estonian",
                                "Faroese",
                                "Farsi",
                                "Fiji",
                                "Filipino",
                                "Finnish",
                                "Flemish",
                                "French",
                                "FrenchCanadian",
                                "Frisian",
                                "Galician",
                                "Georgian",
                                "German",
                                "Gibberish",
                                "Greek",
                                "Greenlandic",
                                "Guarani",
                                "Gujarati",
                                "Gullah",
                                "Hausa",
                                "Hawaiian",
                                "Hebrew",
                                "Hindi",
                                "Hmong",
                                "Hungarian",
                                "Icelandic",
                                "IndoEuropean",
                                "Indonesian",
                                "Ingush",
                                "Interlingua",
                                "Interlingue",
                                "Inuktitun",
                                "Inuktitut",
                                "Inupiak",
                                "Inupiaq",
                                "Irish",
                                "Italian",
                                "Japanese",
                                "Javanese",
                                "Kalaallisut",
                                "Kalmyk",
                                "Kannada",
                                "KarachayBalkar",
                                "Kashmiri",
                                "Kashubian",
                                "Kazakh",
                                "Khmer",
                                "Kinyarwanda",
                                "Kirghiz",
                                "Kirundi",
                                "Klingon",
                                "Korean",
                                "Kurdish",
                                "Ladino",
                                "Lao",
                                "Lapp",
                                "Latin",
                                "Latvian",
                                "Lingala",
                                "Lithuanian",
                                "Lojban",
                                "LowerSorbian",
                                "Macedonian",
                                "Malagasy",
                                "Malay",
                                "Malayalam",
                                "Maltese",
                                "MandarinChinese",
                                "Maori",
                                "Marathi",
                                "Mende",
                                "MiddleEnglish",
                                "Mirandese",
                                "Moksha",
                                "Moldavian",
                                "Mongo",
                                "Mongolian",
                                "Multilingual",
                                "Nauru",
                                "Navaho",
                                "Nepali",
                                "Nogai",
                                "Norwegian",
                                "Occitan",
                                "OldEnglish",
                                "Oriya",
                                "Oromo",
                                "Pashto",
                                "Persian",
                                "PigLatin",
                                "Polish",
                                "Portuguese",
                                "Punjabi",
                                "Quechua",
                                "Romance",
                                "Romanian",
                                "Romany",
                                "Russian",
                                "Samaritan",
                                "Samoan",
                                "Sangho",
                                "Sanskrit",
                                "Serbian",
                                "Serbo-Croatian",
                                "Sesotho",
                                "Setswana",
                                "Shona",
                                "SichuanYi",
                                "Sicilian",
                                "SignLanguage",
                                "Sindhi",
                                "Sinhalese",
                                "Siswati",
                                "Slavic",
                                "Slovak",
                                "Slovakian",
                                "Slovene",
                                "Somali",
                                "Spanish",
                                "Sumerian",
                                "Sundanese",
                                "Swahili",
                                "Swedish",
                                "SwissGerman",
                                "Syriac",
                                "Tagalog",
                                "TaiwaneseChinese",
                                "Tajik",
                                "Tamil",
                                "Tatar",
                                "Telugu",
                                "Thai",
                                "Tibetan",
                                "Tigrinya",
                                "Tonga",
                                "Tsonga",
                                "Turkish",
                                "Turkmen",
                                "Twi",
                                "Udmurt",
                                "Uighur",
                                "Ukrainian",
                                "Ukranian",
                                "Unknown",
                                "Urdu",
                                "Uzbek",
                                "Vietnamese",
                                "Volapuk",
                                "Welsh",
                                "Wolof",
                                "Xhosa",
                                "Yiddish",
                                "Yoruba",
                                "Zhuang",
                                "Zulu",
                            ],
                    ],
            ],
            "{$i}SubtitleLanguage" => [
                "sequence" => "{$s}210",
                "name" => "SubtitleLanguage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Abkhazian",
                                "Adygei",
                                "Afar",
                                "Afrikaans",
                                "Albanian",
                                "Alsatian",
                                "Amharic",
                                "Arabic",
                                "Aramaic",
                                "Armenian",
                                "Assamese",
                                "Aymara",
                                "Azerbaijani",
                                "Bambara",
                                "Bashkir",
                                "Basque",
                                "Bengali",
                                "Berber",
                                "Bhutani",
                                "Bihari",
                                "Bislama",
                                "Breton",
                                "Bulgarian",
                                "Burmese",
                                "Buryat",
                                "Byelorussian",
                                "CantoneseChinese",
                                "Castillian",
                                "Catalan",
                                "Cayuga",
                                "Cheyenne",
                                "Chinese",
                                "ClassicalNewari",
                                "Cornish",
                                "Corsican",
                                "Creole",
                                "CrimeanTatar",
                                "Croatian",
                                "Czech",
                                "Danish",
                                "Dargwa",
                                "Dutch",
                                "English",
                                "Esperanto",
                                "Estonian",
                                "Faroese",
                                "Farsi",
                                "Fiji",
                                "Filipino",
                                "Finnish",
                                "Flemish",
                                "French",
                                "FrenchCanadian",
                                "Frisian",
                                "Galician",
                                "Georgian",
                                "German",
                                "Gibberish",
                                "Greek",
                                "Greenlandic",
                                "Guarani",
                                "Gujarati",
                                "Gullah",
                                "Hausa",
                                "Hawaiian",
                                "Hebrew",
                                "Hindi",
                                "Hmong",
                                "Hungarian",
                                "Icelandic",
                                "IndoEuropean",
                                "Indonesian",
                                "Ingush",
                                "Interlingua",
                                "Interlingue",
                                "Inuktitun",
                                "Inuktitut",
                                "Inupiak",
                                "Inupiaq",
                                "Irish",
                                "Italian",
                                "Japanese",
                                "Javanese",
                                "Kalaallisut",
                                "Kalmyk",
                                "Kannada",
                                "KarachayBalkar",
                                "Kashmiri",
                                "Kashubian",
                                "Kazakh",
                                "Khmer",
                                "Kinyarwanda",
                                "Kirghiz",
                                "Kirundi",
                                "Klingon",
                                "Korean",
                                "Kurdish",
                                "Ladino",
                                "Lao",
                                "Lapp",
                                "Latin",
                                "Latvian",
                                "Lingala",
                                "Lithuanian",
                                "Lojban",
                                "LowerSorbian",
                                "Macedonian",
                                "Malagasy",
                                "Malay",
                                "Malayalam",
                                "Maltese",
                                "MandarinChinese",
                                "Maori",
                                "Marathi",
                                "Mende",
                                "MiddleEnglish",
                                "Mirandese",
                                "Moksha",
                                "Moldavian",
                                "Mongo",
                                "Mongolian",
                                "Multilingual",
                                "Nauru",
                                "Navaho",
                                "Nepali",
                                "Nogai",
                                "Norwegian",
                                "Occitan",
                                "OldEnglish",
                                "Oriya",
                                "Oromo",
                                "Pashto",
                                "Persian",
                                "PigLatin",
                                "Polish",
                                "Portuguese",
                                "Punjabi",
                                "Quechua",
                                "Romance",
                                "Romanian",
                                "Romany",
                                "Russian",
                                "Samaritan",
                                "Samoan",
                                "Sangho",
                                "Sanskrit",
                                "Serbian",
                                "Serbo-Croatian",
                                "Sesotho",
                                "Setswana",
                                "Shona",
                                "SichuanYi",
                                "Sicilian",
                                "SignLanguage",
                                "Sindhi",
                                "Sinhalese",
                                "Siswati",
                                "Slavic",
                                "Slovak",
                                "Slovakian",
                                "Slovene",
                                "Somali",
                                "Spanish",
                                "Sumerian",
                                "Sundanese",
                                "Swahili",
                                "Swedish",
                                "SwissGerman",
                                "Syriac",
                                "Tagalog",
                                "TaiwaneseChinese",
                                "Tajik",
                                "Tamil",
                                "Tatar",
                                "Telugu",
                                "Thai",
                                "Tibetan",
                                "Tigrinya",
                                "Tonga",
                                "Tsonga",
                                "Turkish",
                                "Turkmen",
                                "Twi",
                                "Udmurt",
                                "Uighur",
                                "Ukrainian",
                                "Ukranian",
                                "Unknown",
                                "Urdu",
                                "Uzbek",
                                "Vietnamese",
                                "Volapuk",
                                "Welsh",
                                "Wolof",
                                "Xhosa",
                                "Yiddish",
                                "Yoruba",
                                "Zhuang",
                                "Zulu",
                            ],
                    ],
            ],
            "{$i}PrimaryContributor" => [
                "sequence" => "{$s}220",
                "name" => "PrimaryContributor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Genre" => [
                "sequence" => "{$s}250",
                "name" => "Genre",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getVideoVHS()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Video => 10
         * ProductType => 10
         * VideoVHS => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Video_ProductType_VideoVHS_";

        $this->attributes = [
            "ProductData_Video_ProductType_VideoVHS" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "VideoVHS",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BBFCRating" => [
                "sequence" => "{$s}10",
                "name" => "BBFCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ages_12_and_over",
                                "ages_15_and_over",
                                "ages_18_and_over",
                                "exempt",
                                "parental_guidance",
                                "to_be_announced",
                                "universal",
                                "universal_childrens",
                            ],
                    ],
            ],
            "{$i}CNCRating" => [
                "sequence" => "{$s}20",
                "name" => "CNCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "universal",
                                "parental_guidance",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "ages_18_and_over_x_rated",
                            ],
                    ],
            ],
            "{$i}FSKRating" => [
                "sequence" => "{$s}30",
                "name" => "FSKRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "without_age_limitation",
                                "ages_6_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                            ],
                    ],
            ],
            "{$i}MPAARating" => [
                "sequence" => "{$s}40",
                "name" => "MPAARating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "g",
                                "nc-17",
                                "pg",
                                "pg-13",
                                "nr",
                                "unrated",
                                "r",
                                "x",
                            ],
                    ],
            ],
            "{$i}MediaType" => [
                "sequence" => "{$s}50",
                "name" => "MediaType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "dvd",
                                "hd_dvd",
                                "blu_ray",
                                "videodisc",
                                "dvd_i",
                                "dvd_r",
                                "umd",
                                "video_cd",
                                "mini_disc",
                                "laser_disc",
                            ],
                    ],
            ],
            "{$i}Format" => [
                "sequence" => "{$s}100",
                "name" => "Format",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" =>
                        [
                            "ac-3",
                            "dolby",
                            "thx",
                            "pal",
                            "ntsc",
                            "bw",
                            "color",
                            "subtitled",
                            "dubbed",
                            "closed-captioned",
                            "import",
                            "remastered",
                            "widescreen",
                            "hi-fidelity",
                            "collectors_edition",
                            "silent",
                            "directors_cut",
                            "full_screen",
                            "anamorphic",
                            "surround",
                            "dts_stereo",
                            "dvd_video",
                            "vhs",
                            "vhs_c",
                            "hybrid_sacd",
                            "digital_sound",
                            "deluxe_edition",
                            "special_extended_version",
                            "special_limited_edition",
                            "mono",
                            "dual_disc",
                            "value_price",
                            "multisystem",
                            "hd_dvd",
                            "blu_ray",
                        ],
                ],
            ],
            "{$i}Language" => [
                "sequence" => "{$s}200",
                "name" => "Language",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Abkhazian",
                                "Adygei",
                                "Afar",
                                "Afrikaans",
                                "Albanian",
                                "Alsatian",
                                "Amharic",
                                "Arabic",
                                "Aramaic",
                                "Armenian",
                                "Assamese",
                                "Aymara",
                                "Azerbaijani",
                                "Bambara",
                                "Bashkir",
                                "Basque",
                                "Bengali",
                                "Berber",
                                "Bhutani",
                                "Bihari",
                                "Bislama",
                                "Breton",
                                "Bulgarian",
                                "Burmese",
                                "Buryat",
                                "Byelorussian",
                                "CantoneseChinese",
                                "Castillian",
                                "Catalan",
                                "Cayuga",
                                "Cheyenne",
                                "Chinese",
                                "ClassicalNewari",
                                "Cornish",
                                "Corsican",
                                "Creole",
                                "CrimeanTatar",
                                "Croatian",
                                "Czech",
                                "Danish",
                                "Dargwa",
                                "Dutch",
                                "English",
                                "Esperanto",
                                "Estonian",
                                "Faroese",
                                "Farsi",
                                "Fiji",
                                "Filipino",
                                "Finnish",
                                "Flemish",
                                "French",
                                "FrenchCanadian",
                                "Frisian",
                                "Galician",
                                "Georgian",
                                "German",
                                "Gibberish",
                                "Greek",
                                "Greenlandic",
                                "Guarani",
                                "Gujarati",
                                "Gullah",
                                "Hausa",
                                "Hawaiian",
                                "Hebrew",
                                "Hindi",
                                "Hmong",
                                "Hungarian",
                                "Icelandic",
                                "IndoEuropean",
                                "Indonesian",
                                "Ingush",
                                "Interlingua",
                                "Interlingue",
                                "Inuktitun",
                                "Inuktitut",
                                "Inupiak",
                                "Inupiaq",
                                "Irish",
                                "Italian",
                                "Japanese",
                                "Javanese",
                                "Kalaallisut",
                                "Kalmyk",
                                "Kannada",
                                "KarachayBalkar",
                                "Kashmiri",
                                "Kashubian",
                                "Kazakh",
                                "Khmer",
                                "Kinyarwanda",
                                "Kirghiz",
                                "Kirundi",
                                "Klingon",
                                "Korean",
                                "Kurdish",
                                "Ladino",
                                "Lao",
                                "Lapp",
                                "Latin",
                                "Latvian",
                                "Lingala",
                                "Lithuanian",
                                "Lojban",
                                "LowerSorbian",
                                "Macedonian",
                                "Malagasy",
                                "Malay",
                                "Malayalam",
                                "Maltese",
                                "MandarinChinese",
                                "Maori",
                                "Marathi",
                                "Mende",
                                "MiddleEnglish",
                                "Mirandese",
                                "Moksha",
                                "Moldavian",
                                "Mongo",
                                "Mongolian",
                                "Multilingual",
                                "Nauru",
                                "Navaho",
                                "Nepali",
                                "Nogai",
                                "Norwegian",
                                "Occitan",
                                "OldEnglish",
                                "Oriya",
                                "Oromo",
                                "Pashto",
                                "Persian",
                                "PigLatin",
                                "Polish",
                                "Portuguese",
                                "Punjabi",
                                "Quechua",
                                "Romance",
                                "Romanian",
                                "Romany",
                                "Russian",
                                "Samaritan",
                                "Samoan",
                                "Sangho",
                                "Sanskrit",
                                "Serbian",
                                "Serbo-Croatian",
                                "Sesotho",
                                "Setswana",
                                "Shona",
                                "SichuanYi",
                                "Sicilian",
                                "SignLanguage",
                                "Sindhi",
                                "Sinhalese",
                                "Siswati",
                                "Slavic",
                                "Slovak",
                                "Slovakian",
                                "Slovene",
                                "Somali",
                                "Spanish",
                                "Sumerian",
                                "Sundanese",
                                "Swahili",
                                "Swedish",
                                "SwissGerman",
                                "Syriac",
                                "Tagalog",
                                "TaiwaneseChinese",
                                "Tajik",
                                "Tamil",
                                "Tatar",
                                "Telugu",
                                "Thai",
                                "Tibetan",
                                "Tigrinya",
                                "Tonga",
                                "Tsonga",
                                "Turkish",
                                "Turkmen",
                                "Twi",
                                "Udmurt",
                                "Uighur",
                                "Ukrainian",
                                "Ukranian",
                                "Unknown",
                                "Urdu",
                                "Uzbek",
                                "Vietnamese",
                                "Volapuk",
                                "Welsh",
                                "Wolof",
                                "Xhosa",
                                "Yiddish",
                                "Yoruba",
                                "Zhuang",
                                "Zulu",
                            ],
                    ],
            ],
            "{$i}SubtitleLanguage" => [
                "sequence" => "{$s}210",
                "name" => "SubtitleLanguage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Abkhazian",
                                "Adygei",
                                "Afar",
                                "Afrikaans",
                                "Albanian",
                                "Alsatian",
                                "Amharic",
                                "Arabic",
                                "Aramaic",
                                "Armenian",
                                "Assamese",
                                "Aymara",
                                "Azerbaijani",
                                "Bambara",
                                "Bashkir",
                                "Basque",
                                "Bengali",
                                "Berber",
                                "Bhutani",
                                "Bihari",
                                "Bislama",
                                "Breton",
                                "Bulgarian",
                                "Burmese",
                                "Buryat",
                                "Byelorussian",
                                "CantoneseChinese",
                                "Castillian",
                                "Catalan",
                                "Cayuga",
                                "Cheyenne",
                                "Chinese",
                                "ClassicalNewari",
                                "Cornish",
                                "Corsican",
                                "Creole",
                                "CrimeanTatar",
                                "Croatian",
                                "Czech",
                                "Danish",
                                "Dargwa",
                                "Dutch",
                                "English",
                                "Esperanto",
                                "Estonian",
                                "Faroese",
                                "Farsi",
                                "Fiji",
                                "Filipino",
                                "Finnish",
                                "Flemish",
                                "French",
                                "FrenchCanadian",
                                "Frisian",
                                "Galician",
                                "Georgian",
                                "German",
                                "Gibberish",
                                "Greek",
                                "Greenlandic",
                                "Guarani",
                                "Gujarati",
                                "Gullah",
                                "Hausa",
                                "Hawaiian",
                                "Hebrew",
                                "Hindi",
                                "Hmong",
                                "Hungarian",
                                "Icelandic",
                                "IndoEuropean",
                                "Indonesian",
                                "Ingush",
                                "Interlingua",
                                "Interlingue",
                                "Inuktitun",
                                "Inuktitut",
                                "Inupiak",
                                "Inupiaq",
                                "Irish",
                                "Italian",
                                "Japanese",
                                "Javanese",
                                "Kalaallisut",
                                "Kalmyk",
                                "Kannada",
                                "KarachayBalkar",
                                "Kashmiri",
                                "Kashubian",
                                "Kazakh",
                                "Khmer",
                                "Kinyarwanda",
                                "Kirghiz",
                                "Kirundi",
                                "Klingon",
                                "Korean",
                                "Kurdish",
                                "Ladino",
                                "Lao",
                                "Lapp",
                                "Latin",
                                "Latvian",
                                "Lingala",
                                "Lithuanian",
                                "Lojban",
                                "LowerSorbian",
                                "Macedonian",
                                "Malagasy",
                                "Malay",
                                "Malayalam",
                                "Maltese",
                                "MandarinChinese",
                                "Maori",
                                "Marathi",
                                "Mende",
                                "MiddleEnglish",
                                "Mirandese",
                                "Moksha",
                                "Moldavian",
                                "Mongo",
                                "Mongolian",
                                "Multilingual",
                                "Nauru",
                                "Navaho",
                                "Nepali",
                                "Nogai",
                                "Norwegian",
                                "Occitan",
                                "OldEnglish",
                                "Oriya",
                                "Oromo",
                                "Pashto",
                                "Persian",
                                "PigLatin",
                                "Polish",
                                "Portuguese",
                                "Punjabi",
                                "Quechua",
                                "Romance",
                                "Romanian",
                                "Romany",
                                "Russian",
                                "Samaritan",
                                "Samoan",
                                "Sangho",
                                "Sanskrit",
                                "Serbian",
                                "Serbo-Croatian",
                                "Sesotho",
                                "Setswana",
                                "Shona",
                                "SichuanYi",
                                "Sicilian",
                                "SignLanguage",
                                "Sindhi",
                                "Sinhalese",
                                "Siswati",
                                "Slavic",
                                "Slovak",
                                "Slovakian",
                                "Slovene",
                                "Somali",
                                "Spanish",
                                "Sumerian",
                                "Sundanese",
                                "Swahili",
                                "Swedish",
                                "SwissGerman",
                                "Syriac",
                                "Tagalog",
                                "TaiwaneseChinese",
                                "Tajik",
                                "Tamil",
                                "Tatar",
                                "Telugu",
                                "Thai",
                                "Tibetan",
                                "Tigrinya",
                                "Tonga",
                                "Tsonga",
                                "Turkish",
                                "Turkmen",
                                "Twi",
                                "Udmurt",
                                "Uighur",
                                "Ukrainian",
                                "Ukranian",
                                "Unknown",
                                "Urdu",
                                "Uzbek",
                                "Vietnamese",
                                "Volapuk",
                                "Welsh",
                                "Wolof",
                                "Xhosa",
                                "Yiddish",
                                "Yoruba",
                                "Zhuang",
                                "Zulu",
                            ],
                    ],
            ],
            "{$i}PrimaryContributor" => [
                "sequence" => "{$s}220",
                "name" => "PrimaryContributor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Genre" => [
                "sequence" => "{$s}250",
                "name" => "Genre",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Binding" => [
                "sequence" => "{$s}260",
                "name" => "Binding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "dvd",
                        "blu_ray",
                        "hd_dvd",
                        "umd",
                        "VHStape",
                        "videotape",
                        "cassette",
                        "mp3_cd",
                        "cd_rom",
                        "audioCD",
                        "dvd_r",
                    ],
                ],
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Video_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
