<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Sports
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/Sports.xsd
 */
class Sports extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_SPORTING_GOODS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GOLF_CLUB_HYBRID = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GOLF_CLUB_IRON = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GOLF_CLUB_PUTTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GOLF_CLUB_WEDGE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GOLF_CLUB_WOOD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GOLF_CLUBS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Sports';
        $this->data["ProductData_{$this->category}_ProductType"] = $subCategory;
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";

        $common = [
            "{$i}ProductType" => [
                "sequence" => "{$s}10",
                "name" => "ProductType",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "AgeGenderCategory",
                                "CalfSize",
                                "Caliber",
                                "Color",
                                "Curvature",
                                "CurvatureHand",
                                "Design",
                                "Diameter",
                                "Flavor",
                                "FlavorSize",
                                "GolfFlex",
                                "GripType",
                                "HeadSize",
                                "HeadSizeShape",
                                "Height",
                                "Length",
                                "LengthLineCapacity",
                                "LengthLineWeight",
                                "LengthMaterial",
                                "LineWeightSize",
                                "Material",
                                "MaterialShape",
                                "MaterialSize",
                                "MaterialStyle",
                                "MaterialTensionLevel",
                                "MaterialWeight",
                                "MaterialWheelSize",
                                "MaterialWidth",
                                "RoundsSize",
                                "ShaftMaterial",
                                "ShaftMaterialShaftType",
                                "ShaftType",
                                "Shape",
                                "ShapeSize",
                                "Size",
                                "Style",
                                "Width",
                            ],
                    ],
            ],
            "{$i}VariationData_AgeGenderCategory" => [
                "sequence" => "{$s}20\\30",
                "name" => "AgeGenderCategory",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Bounce" => [
                "sequence" => "{$s}20\\60",
                "name" => "Bounce",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_CalfSize" => [
                "sequence" => "{$s}20\\70",
                "name" => "CalfSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Club" => [
                "sequence" => "{$s}20\\100",
                "name" => "Club",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}20\\110",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Curvature" => [
                "sequence" => "{$s}20\\120",
                "name" => "Curvature",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_CustomerPackageType" => [
                "sequence" => "{$s}20\\130",
                "name" => "CustomerPackageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Department" => [
                "sequence" => "{$s}20\\150",
                "name" => "Department",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Design" => [
                "sequence" => "{$s}20\\170",
                "name" => "Design",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}20\\200",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Shape" => [
                "sequence" => "{$s}20\\350",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}20\\360",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Style" => [
                "sequence" => "{$s}20\\370",
                "name" => "Style",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        switch ($this->subCategory) {
            case "SportingGoods":
                $this->attributes = array_merge($this->attributes, $this->getSportingGoods());
                break;
            case "GolfClubHybrid":
                $this->attributes = array_merge($this->attributes, $this->getGolfClubHybrid());
                break;
            case "GolfClubIron":
                $this->attributes = array_merge($this->attributes, $this->getGolfClubIron());
                break;
            case "GolfClubPutter":
                $this->attributes = array_merge($this->attributes, $this->getGolfClubPutter());
                break;
            case "GolfClubWedge":
                $this->attributes = array_merge($this->attributes, $this->getGolfClubWedge());
                break;
            case "GolfClubWood":
                $this->attributes = array_merge($this->attributes, $this->getGolfClubWood());
                break;
            case "GolfClubs":
                $this->attributes = array_merge($this->attributes, $this->getGolfClubs());
                break;
        }

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getSportingGoods()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getGolfClubHybrid()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getGolfClubIron()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getGolfClubPutter()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getGolfClubWedge()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getGolfClubWood()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getGolfClubs()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Sports => 10
         */
        $s = "100\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";
        $attributes = [];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Sports_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
