<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class SoftwareVideoGames
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/SWVG.xsd
 */
class SoftwareVideoGames extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_SOFTWARE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HAND_HELD_SOFTWARE_DOWNLOADS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SOFTWARE_GAMES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEO_GAMES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEO_GAMES_ACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEO_GAMES_HARDWARE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'SoftwareVideoGames';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Software":
                $this->attributes = array_merge($this->attributes, $this->getSoftware());
                break;
            case "HandheldSoftwareDownloads":
                $this->attributes = array_merge($this->attributes, $this->getHandheldSoftwareDownloads());
                break;
            case "SoftwareGames":
                $this->attributes = array_merge($this->attributes, $this->getSoftwareGames());
                break;
            case "VideoGames":
                $this->attributes = array_merge($this->attributes, $this->getVideoGames());
                break;
            case "VideoGamesAccessories":
                $this->attributes = array_merge($this->attributes, $this->getVideoGamesAccessories());
                break;
            case "VideoGamesHardware":
                $this->attributes = array_merge($this->attributes, $this->getVideoGamesHardware());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getSoftware()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         * ProductType => 10
         * Software => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_ProductType_Software_";

        $this->attributes = [
            "ProductData_SoftwareVideoGames_ProductType_Software" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Software",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}MediaFormat" => [
                "sequence" => "{$s}10",
                "name" => "MediaFormat",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}OperatingSystem" => [
                "sequence" => "{$s}20",
                "name" => "OperatingSystem",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Bundles" => [
                "sequence" => "{$s}30",
                "name" => "Bundles",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ChildrensSoftwareGenre" => [
                "sequence" => "{$s}40",
                "name" => "ChildrensSoftwareGenre",
                "minOccurs" => "0",
                "maxOccurs" => "5",
                "dataType" => "StringNotNull",
            ],
            "{$i}ESRBRating" => [
                "sequence" => "{$s}41",
                "name" => "ESRBRating",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
                "choice" => [
                    "{$i}ESRBRating",
                    "{$i}BBFCRating",
                    "{$i}PEGIRating",
                    "{$i}USKRating"
                ]
            ],
            "{$i}BBFCRating" => [
                "sequence" => "{$s}41",
                "name" => "BBFCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" =>
                            [
                                "ages_12_and_over",
                                "ages_15_and_over",
                                "ages_18_and_over",
                                "exempt",
                                "parental_guidance",
                                "to_be_announced",
                                "universal_childrens",
                            ],
                ],
                "choice" => [
                    "{$i}ESRBRating",
                    "{$i}BBFCRating",
                    "{$i}PEGIRating",
                    "{$i}USKRating"
                ]
            ],
            "{$i}PEGIRating" => [
                "sequence" => "{$s}43",
                "name" => "PEGIRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" =>
                            [
                                "ages_3_and_over",
                                "ages_7_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "unknown",
                            ],
                ],
                "choice" => [
                    "{$i}ESRBRating",
                    "{$i}BBFCRating",
                    "{$i}PEGIRating",
                    "{$i}USKRating"
                ]
            ],
            "{$i}USKRating" => [
                "sequence" => "{$s}44",
                "name" => "USKRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_6_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "cannot_publicize",
                                "checked_by_legal_department",
                                "not_checked",
                                "without_age_limitation",
                                "unknown",
                        ],
                ],
                "choice" => [
                    "{$i}ESRBRating",
                    "{$i}BBFCRating",
                    "{$i}PEGIRating",
                    "{$i}USKRating"
                ]
            ],
            "{$i}ESRBDescriptors" => [
                "sequence" => "{$s}60",
                "name" => "ESRBDescriptors",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SoftwarePlatform" => [
                "sequence" => "{$s}100",
                "name" => "SoftwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "linux",
                                "mac",
                                "windows",
                                "unix",
                            ],
                    ],
            ],
            "{$i}ApplicationVersion" => [
                "sequence" => "{$s}120",
                "name" => "ApplicationVersion",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getHandheldSoftwareDownloads()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         * ProductType => 10
         * HandheldSoftwareDownloads => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_ProductType_HandheldSoftwareDownloads_";

        $this->attributes = [
            "ProductData_SoftwareVideoGames_ProductType_HandheldSoftwareDownloads" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "HandheldSoftwareDownloads",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ApplicationVersion" => [
                "sequence" => "{$s}10",
                "name" => "ApplicationVersion",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}DownloadableFile_DownloadableFileFormat" => [
                "sequence" => "{$s}15\\10",
                "name" => "DownloadableFileFormat",
                "minOccurs" => "1",
                "dataType" => "FortyStringNotNull",
            ],
            "{$i}DownloadableFile_FileSize" => [
                "sequence" => "{$s}15\\20",
                "name" => "FileSize",
                "minOccurs" => "1",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}FileSize_unitOfMeasure_MemorySizeUnitOfMeasure"
            ],
            "{$i}OperatingSystem" => [
                "sequence" => "{$s}20",
                "name" => "OperatingSystem",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}SystemRequirements" => [
                "sequence" => "{$s}30",
                "name" => "SystemRequirements",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}NumberOfLicenses" => [
                "sequence" => "{$s}50",
                "name" => "NumberOfLicenses",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
        ];
        return $this->attributes;
    }

    public function getSoftwareGames()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         * ProductType => 10
         * SoftwareGames => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_ProductType_SoftwareGames_";

        $this->attributes = [
            "ProductData_SoftwareVideoGames_ProductType_SoftwareGames" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "SoftwareGames",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}SoftwareVideoGamesGenre_ESRBRating" => [
                "sequence" => "{$s}10\\10",
                "name" => "ESRBRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "choice" => [
                    "{$i}SoftwareVideoGamesGenre_ESRBRating",
                    "{$i}SoftwareVideoGamesGenre_BBFCRating",
                    "{$i}SoftwareVideoGamesGenre_PEGIRating",
                    "{$i}SoftwareVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}SoftwareVideoGamesGenre_BBFCRating" => [
                "sequence" => "{$s}10\\20",
                "name" => "BBFCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_12_and_over",
                                "ages_15_and_over",
                                "ages_18_and_over",
                                "exempt",
                                "parental_guidance",
                                "to_be_announced",
                                "universal_childrens",
                        ],
                ],
                "choice" => [
                    "{$i}SoftwareVideoGamesGenre_ESRBRating",
                    "{$i}SoftwareVideoGamesGenre_BBFCRating",
                    "{$i}SoftwareVideoGamesGenre_PEGIRating",
                    "{$i}SoftwareVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}SoftwareVideoGamesGenre_PEGIRating" => [
                "sequence" => "{$s}10\\30",
                "name" => "PEGIRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_3_and_over",
                                "ages_7_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "unknown",
                        ],
                ],
                "choice" => [
                    "{$i}SoftwareVideoGamesGenre_ESRBRating",
                    "{$i}SoftwareVideoGamesGenre_BBFCRating",
                    "{$i}SoftwareVideoGamesGenre_PEGIRating",
                    "{$i}SoftwareVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}SoftwareVideoGamesGenre_USKRating" => [
                "sequence" => "{$s}10\\40",
                "name" => "USKRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_6_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "cannot_publicize",
                                "checked_by_legal_department",
                                "not_checked",
                                "without_age_limitation",
                                "unknown",
                        ],
                ],
                "choice" => [
                    "{$i}SoftwareVideoGamesGenre_ESRBRating",
                    "{$i}SoftwareVideoGamesGenre_BBFCRating",
                    "{$i}SoftwareVideoGamesGenre_PEGIRating",
                    "{$i}SoftwareVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}MediaFormat" => [
                "sequence" => "{$s}30",
                "name" => "MediaFormat",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}OperatingSystem" => [
                "sequence" => "{$s}50",
                "name" => "OperatingSystem",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Bundles" => [
                "sequence" => "{$s}60",
                "name" => "Bundles",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SoftwarePlatform" => [
                "sequence" => "{$s}100",
                "name" => "SoftwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "linux",
                                "mac",
                                "windows",
                                "unix",
                            ],
                    ],
            ],
        ];
        return $this->attributes;
    }

    public function getVideoGames()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         * ProductType => 10
         * VideoGames => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_ProductType_VideoGames_";

        $this->attributes = [
            "ProductData_SoftwareVideoGames_ProductType_VideoGames" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "VideoGames",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ConsoleVideoGamesGenre" => [
                "sequence" => "{$s}29",
                "name" => "ConsoleVideoGamesGenre",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ESRBRating" => [
                "sequence" => "{$s}10\\10",
                "name" => "ESRBRating",
                "minOccurs" => "0",
                "dataType" => "FortyStringNotNull",
                "choice" => [
                    "{$i}ConsoleVideoGamesGenre_ESRBRating",
                    "{$i}ConsoleVideoGamesGenre_BBFCRating",
                    "{$i}ConsoleVideoGamesGenre_PEGIRating",
                    "{$i}ConsoleVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}BBFCRating" => [
                "sequence" => "{$s}10\\20",
                "name" => "BBFCRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_12_and_over",
                                "ages_15_and_over",
                                "ages_18_and_over",
                                "exempt",
                                "parental_guidance",
                                "to_be_announced",
                                "universal_childrens",
                        ],
                ],
                "choice" => [
                    "{$i}ConsoleVideoGamesGenre_ESRBRating",
                    "{$i}ConsoleVideoGamesGenre_BBFCRating",
                    "{$i}ConsoleVideoGamesGenre_PEGIRating",
                    "{$i}ConsoleVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}PEGIRating" => [
                "sequence" => "{$s}10\\30",
                "name" => "PEGIRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_3_and_over",
                                "ages_7_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "unknown",
                        ],
                ],
                "choice" => [
                    "{$i}ConsoleVideoGamesGenre_ESRBRating",
                    "{$i}ConsoleVideoGamesGenre_BBFCRating",
                    "{$i}ConsoleVideoGamesGenre_PEGIRating",
                    "{$i}ConsoleVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}USKRating" => [
                "sequence" => "{$s}10\\40",
                "name" => "USKRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                "ages_6_and_over",
                                "ages_12_and_over",
                                "ages_16_and_over",
                                "ages_18_and_over",
                                "cannot_publicize",
                                "checked_by_legal_department",
                                "not_checked",
                                "without_age_limitation",
                                "unknown",
                        ],
                ],
                "choice" => [
                    "{$i}ConsoleVideoGamesGenre_ESRBRating",
                    "{$i}ConsoleVideoGamesGenre_BBFCRating",
                    "{$i}ConsoleVideoGamesGenre_PEGIRating",
                    "{$i}ConsoleVideoGamesGenre_USKRating"
                ]
            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}30",
                "name" => "HardwarePlatform",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Bundles" => [
                "sequence" => "{$s}60",
                "name" => "Bundles",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SoftwarePlatform" => [
                "sequence" => "{$s}100",
                "name" => "SoftwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "linux",
                                "mac",
                                "windows",
                                "unix",
                            ],
                    ],
            ],
        ];

        return $this->attributes;
    }

    public function getVideoGamesAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         * ProductType => 10
         * VideoGamesAccessories => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_ProductType_VideoGamesAccessories_";

        $this->attributes = [
            "ProductData_SoftwareVideoGames_ProductType_VideoGamesAccessories" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "VideoGamesAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}30",
                "name" => "HardwarePlatform",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Bundles" => [
                "sequence" => "{$s}50",
                "name" => "Bundles",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}60",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getVideoGamesHardware()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * SoftwareVideoGames => 10
         * ProductType => 10
         * VideoGamesHardware => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_ProductType_VideoGamesHardware_";

        $this->attributes = [
            "ProductData_SoftwareVideoGames_ProductType_VideoGamesHardware" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "VideoGamesHardware",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}10",
                "name" => "HardwarePlatform",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Bundles" => [
                "sequence" => "{$s}20",
                "name" => "Bundles",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}60",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_SoftwareVideoGames_";

        $subAttributes = self::SUB_ATTRIBUTES;

        $subAttributes[$i . "ProductType_HandheldSoftwareDownloads_FileSize_unitOfMeasure_MemorySizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" => [
                        "TB",
                        "GB",
                        "MB",
                        "KB",
                        "KO",
                        "MO",
                        "GO",
                        "TO",
                        "bytes",
                    ],
                ],
            "default" => "KG"
        ];

        return $subAttributes;
    }
}
