<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class RawMaterials
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/RawMaterials.xsd
 */
class RawMaterials extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_CERAMIC_BALLS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CERAMIC_TUBING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CERAMICS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_METAL_BALLS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_METAL_MESH = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_METAL_TUBING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_METALS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PLASTIC_BALLS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PLASTIC_MESH = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PLASTIC_TUBING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PLASTICS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RAW_MATERIALS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_WIRE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'RawMaterials';
        $this->data["ProductData_{$this->category}_ProductType"] = $subCategory;
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "CeramicBalls":
                $this->attributes = array_merge($this->attributes, $this->getCeramicBalls());
                break;
            case "CeramicTubing":
                $this->attributes = array_merge($this->attributes, $this->getCeramicTubing());
                break;
            case "Ceramics":
                $this->attributes = array_merge($this->attributes, $this->getCeramics());
                break;
            case "MetalBalls":
                $this->attributes = array_merge($this->attributes, $this->getMetalBalls());
                break;
            case "MetalMesh":
                $this->attributes = array_merge($this->attributes, $this->getMetalMesh());
                break;
            case "MetalTubing":
                $this->attributes = array_merge($this->attributes, $this->getMetalTubing());
                break;
            case "Metals":
                $this->attributes = array_merge($this->attributes, $this->getMetals());
                break;
            case "PlasticBalls":
                $this->attributes = array_merge($this->attributes, $this->getPlasticBalls());
                break;
            case "PlasticMesh":
                $this->attributes = array_merge($this->attributes, $this->getPlasticMesh());
                break;
            case "PlasticTubing":
                $this->attributes = array_merge($this->attributes, $this->getPlasticTubing());
                break;
            case "Plastics":
                $this->attributes = array_merge($this->attributes, $this->getPlastics());
                break;
            case "RawMaterials":
                $this->attributes = array_merge($this->attributes, $this->getRawMaterials());
                break;
            case "Wire":
                $this->attributes = array_merge($this->attributes, $this->getWire());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * RawMaterials => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_RawMaterials_";
        $common = [
            "{$i}ProductType" => [
                "sequence" => "{$s}10",
                "name" => "ProductType",
                "minOccurs" => "1",
                "dataType" => "HundredString",
                "visible" => false,
                "restriction" => [
                    "optionValues" => [
                        "CeramicBalls",
                        "CeramicTubing",
                        "Ceramics",
                        "MetalBalls",
                        "MetalMesh",
                        "MetalTubing",
                        "Metals",
                        "PlasticBalls",
                        "PlasticMesh",
                        "PlasticTubing",
                        "Plastics",
                        "RawMaterials",
                        "Wire",
                    ],
                ],
            ],
            "{$i}CornerStyle" => [
                "sequence" => "{$s}50",
                "name" => "CornerStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ExteriorFinish" => [
                "sequence" => "{$s}100",
                "name" => "ExteriorFinish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemHardness" => [
                "sequence" => "{$s}200",
                "name" => "ItemHardness",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}300",
                "name" => "MaterialType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}MeasurementSystem" => [
                "sequence" => "{$s}310",
                "name" => "MeasurementSystem",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getCeramicBalls()
    {
        return [];
    }

    public function getCeramicTubing()
    {
        return [];
    }

    public function getCeramics()
    {
        return [];
    }

    public function getMetalBalls()
    {
        return [];
    }

    public function getMetalMesh()
    {
        return [];
    }

    public function getMetalTubing()
    {
        return [];
    }

    public function getMetals()
    {
        return [];
    }

    public function getPlasticBalls()
    {
        return [];
    }

    public function getPlasticMesh()
    {
        return [];
    }

    public function getPlasticTubing()
    {
        return [];
    }

    public function getPlastics()
    {
        return [];
    }

    public function getRawMaterials()
    {
        return [];
    }

    public function getWire()
    {
        return [];
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_RawMaterials_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
