<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class ProfessionalHealthCare extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_PROFESSIONAL_HEALTH_CARE = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'ProfessionalHealthCare';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "ProfessionalHealthCare":
                $this->attributes = array_merge($this->attributes, $this->getProfessionalHealthCare());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * ProfessionalHealthCare => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ProfessionalHealthCare_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ColorName",
                                "Material",
                                "SizeName",
                            ],
                    ],
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}30",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorName" => [
                "sequence" => "{$s}40",
                "name" => "ColorName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScentName" => [
                "sequence" => "{$s}60",
                "name" => "ScentName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}100",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}150",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getProfessionalHealthCare()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * ProfessionalHealthCare => 10
         * ProductType => 10
         * ProfessionalHealthCare => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ProfessionalHealthCare_ProductType_ProfessionalHealthCare_";

        $this->attributes = [
            "ProductData_ProfessionalHealthCare_ProductType_ProfessionalHealthCare" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "ProfessionalHealthCare",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ]
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Capacity",
                        2 => "Color",
                        3 => "Size-Color",
                        4 => "Scent",
                        5 => "Size-Scent",
                        6 => "PatternName",
                        7 => "Size-UnitCount",
                    ],
                ]
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_ColorMap" => [
                "sequence" => "{$s}10\\50",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\60",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_ProfessionalHealthCare_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
