<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Music extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_MUSIC_POPULAR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MUSIC_CLASSICAL = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Music';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            // Overriding Barcode as not required.
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        $this->attributes['DescriptionData_Manufacturer'] = [
            'sequence' => '30\150',
            'name' => 'Manufacturer',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1'
        ];

        switch ($this->subCategory) {
            case "MusicPopular":
                $this->attributes = array_merge($this->attributes, $this->getMusicPopular());
                break;
            case "MusicClassical":
                $this->attributes = array_merge($this->attributes, $this->getMusicClassical());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Music => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Music_";

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    public function getMusicPopular()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Music => 10
         * ProductType => 10
         * MusicPopular => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Music_ProductType_MusicPopular_";

        $attributes = [
            "ProductData_Music_ProductType_MusicPopular" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "MusicPopular",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}MediaType" => [
                "sequence" => "{$s}10",
                "name" => "MediaType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "audioCD",
                                "cassette",
                                "dvd_audio",
                            ],
                    ],
            ],
            "{$i}Format" => [
                "sequence" => "{$s}50",
                "name" => "Format",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "authorized_bootleg",
                                "bsides",
                                "best_of",
                                "box_set",
                                "original_recording",
                                "reissued",
                                "remastered",
                                "soundtrack",
                                "special_edition",
                                "special_limited_edition",
                                "cast_recording",
                                "compilation",
                                "deluxe_edition",
                                "digital_sound",
                                "double_lp",
                                "explicit_lyrics",
                                "hi-fidelity",
                                "import",
                                "limited_collectors_edition",
                                "limited_edition",
                                "remixes",
                                "live",
                                "extra_tracks",
                                "cutout",
                                "cd_and_dvd",
                                "dual_disc",
                                "hybrid_sacd",
                                "cd-single",
                                "maxi_single",
                                "sacd",
                                "minidisc",
                                "uk_import",
                                "us_import",
                                "jp_import",
                                "enhanced",
                                "clean",
                                "copy_protected_cd",
                                "double_lp",
                                "soundtrack",
                                "cd-single",
                                "remastered",
                                "box_set",
                                "double_cd",
                                "karaoke",
                                "limited_edition",
                                "maxi_single",
                                "mp3_audio",
                                "ringle",
                                "cd_and_dvd",
                                "shm_cd",
                            ],
                    ],
            ],
            "{$i}AudioEncoding" => [
                "sequence" => "{$s}60",
                "name" => "AudioEncoding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "5_1_disney_enhanced_home_theater_mix",
                                "7_1_disney_enhanced_home_theater_mix",
                                "analog",
                                "digital_atrac",
                                "dolby_digital_1.0",
                                "dolby_digital_2.0",
                                "dolby_digital_2.0_mono",
                                "dolby_digital_2.0_stereo",
                                "dolby_digital_2.0_surround",
                                "dolby_digital_2.1",
                                "dolby_digital_3.0",
                                "dolby_digital_4.0",
                                "dolby_digital_4.1",
                                "dolby_digital_5.0",
                                "dolby_digital_5.1",
                                "dolby_digital_5.1_es",
                                "dolby_digital_5.1_ex",
                                "dolby_digital_6.1_es",
                                "dolby_digital_6.1_ex",
                                "dolby_digital_ex",
                                "dolby_digital_live",
                                "dolby_digital_plus",
                                "dolby_digital_plus_2_0",
                                "dolby_digital_plus_5_1",
                                "dolby_stereo_analog",
                                "dolby_surround",
                                "dolby_truehd",
                                "dolby_truehd_5_1",
                                "dts_5.0",
                                "dts_5.1",
                                "dts_6.1",
                                "dts_6_1_es",
                                "dts_6.1_es",
                                "dts_es",
                                "dts_hd_high_res_audio",
                                "dts_interactive",
                                "hi_res_96_24_digital_surround",
                                "mlp_lossless",
                                "mono",
                                "mpeg_1_2.0",
                                "mpeg_2_5.1",
                                "pcm",
                                "pcm_24bit_96khz",
                                "pcm_mono",
                                "pcm_stereo",
                                "pcm_surround",
                                "quadraphonic",
                                "stereo",
                                "surround",
                                "thx_surround_ex",
                                "unknown_audio_encoding",
                            ],
                    ],
            ],
            "{$i}NumberOfDiscs" => [
                "sequence" => "{$s}70",
                "name" => "NumberOfDiscs",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}Artist" => [
                "sequence" => "{$s}80",
                "name" => "Artist",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Performer" => [
                "sequence" => "{$s}90",
                "name" => "Performer",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Composer" => [
                "sequence" => "{$s}100",
                "name" => "Composer",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getMusicClassical()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Music => 10
         * ProductType => 10
         * MusicClassical => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Music_ProductType_MusicClassical_";

        $attributes = [
            "ProductData_Music_ProductType_MusicClassical" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "MusicClassical",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}MediaType" => [
                "sequence" => "{$s}10",
                "name" => "MediaType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "audioCD",
                                "cassette",
                                "dvd_audio",
                            ],
                    ],
            ],
            "{$i}Format" => [
                "sequence" => "{$s}50",
                "name" => "Format",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "authorized_bootleg",
                                "bsides",
                                "best_of",
                                "box_set",
                                "original_recording",
                                "reissued",
                                "remastered",
                                "soundtrack",
                                "special_edition",
                                "special_limited_edition",
                                "cast_recording",
                                "compilation",
                                "deluxe_edition",
                                "digital_sound",
                                "double_lp",
                                "explicit_lyrics",
                                "hi-fidelity",
                                "import",
                                "limited_collectors_edition",
                                "limited_edition",
                                "remixes",
                                "live",
                                "extra_tracks",
                                "cutout",
                                "cd_and_dvd",
                                "dual_disc",
                                "hybrid_sacd",
                                "cd-single",
                                "maxi_single",
                                "sacd",
                                "minidisc",
                                "uk_import",
                                "us_import",
                                "jp_import",
                                "enhanced",
                                "clean",
                                "copy_protected_cd",
                                "double_lp",
                                "soundtrack",
                                "cd-single",
                                "remastered",
                                "box_set",
                                "double_cd",
                                "karaoke",
                                "limited_edition",
                                "maxi_single",
                                "mp3_audio",
                                "ringle",
                                "cd_and_dvd",
                                "shm_cd",
                            ],
                    ],
            ],
            "{$i}AudioEncoding" => [
                "sequence" => "{$s}60",
                "name" => "AudioEncoding",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "5_1_disney_enhanced_home_theater_mix",
                                "7_1_disney_enhanced_home_theater_mix",
                                "analog",
                                "digital_atrac",
                                "dolby_digital_1.0",
                                "dolby_digital_2.0",
                                "dolby_digital_2.0_mono",
                                "dolby_digital_2.0_stereo",
                                "dolby_digital_2.0_surround",
                                "dolby_digital_2.1",
                                "dolby_digital_3.0",
                                "dolby_digital_4.0",
                                "dolby_digital_4.1",
                                "dolby_digital_5.0",
                                "dolby_digital_5.1",
                                "dolby_digital_5.1_es",
                                "dolby_digital_5.1_ex",
                                "dolby_digital_6.1_es",
                                "dolby_digital_6.1_ex",
                                "dolby_digital_ex",
                                "dolby_digital_live",
                                "dolby_digital_plus",
                                "dolby_digital_plus_2_0",
                                "dolby_digital_plus_5_1",
                                "dolby_stereo_analog",
                                "dolby_surround",
                                "dolby_truehd",
                                "dolby_truehd_5_1",
                                "dts_5.0",
                                "dts_5.1",
                                "dts_6.1",
                                "dts_6_1_es",
                                "dts_6.1_es",
                                "dts_es",
                                "dts_hd_high_res_audio",
                                "dts_interactive",
                                "hi_res_96_24_digital_surround",
                                "mlp_lossless",
                                "mono",
                                "mpeg_1_2.0",
                                "mpeg_2_5.1",
                                "pcm",
                                "pcm_24bit_96khz",
                                "pcm_mono",
                                "pcm_stereo",
                                "pcm_surround",
                                "quadraphonic",
                                "stereo",
                                "surround",
                                "thx_surround_ex",
                                "unknown_audio_encoding",
                            ],
                    ],
            ],
            "{$i}NumberOfDiscs" => [
                "sequence" => "{$s}70",
                "name" => "NumberOfDiscs",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}Artist" => [
                "sequence" => "{$s}80",
                "name" => "Artist",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Performer" => [
                "sequence" => "{$s}90",
                "name" => "Performer",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Composer" => [
                "sequence" => "{$s}100",
                "name" => "Composer",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Music_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
