<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class LargeAppliances extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_AIR_CONDITIONER = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_APPLIANCE_ACCESSORY = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_COOKING_OVEN = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COOKTOP = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DISH_WASHER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LAUNDRY_APPLIANCE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MICROWAVE_OVEN = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RANGE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_REFRIGERATION_APPLIANCE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRASH_COMPACTOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VENT_HOOD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'LargeAppliances';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        $this->attributes['DescriptionData_Manufacturer'] = [
            'sequence' => '30\150',
            'name' => 'Manufacturer',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1'
        ];

        $this->attributes['DescriptionData_MfrPartNumber'] = [
            'sequence' => '30\160',
            'name' => 'MfrPartNumber',
            'dataType' => 'FortyStringNotNull',
            'minOccurs' => '1'
        ];

        $this->attributes['DescriptionData_RecommendedBrowseNode'] = [
            'sequence' => '30\170',
            'name' => 'RecommendedBrowseNode',
            'dataType' => 'positiveInteger',
            'minOccurs' => '1',
        ];

        $this->attributes['DescriptionData_ItemDimensions_Length']['minOccurs'] = "1";
        $this->attributes['DescriptionData_ItemDimensions_Width']['minOccurs'] = "1";
        $this->attributes['DescriptionData_ItemDimensions_Height']['minOccurs'] = "1";

        $this->attributes['DescriptionData_PackageDimensions_Length']['minOccurs'] = "1";
        $this->attributes['DescriptionData_PackageDimensions_Width']['minOccurs'] = "1";
        $this->attributes['DescriptionData_PackageDimensions_Height']['minOccurs'] = "1";

        switch ($this->subCategory) {
            case "AirConditioner":
                $this->attributes = array_merge($this->attributes, $this->getAirConditioner());
                break;
            case "ApplianceAccessory":
                $this->attributes = array_merge($this->attributes, $this->getApplianceAccessory());
                break;
            case "CookingOven":
                $this->attributes = array_merge($this->attributes, $this->getCookingOven());
                break;
            case "Cooktop":
                $this->attributes = array_merge($this->attributes, $this->getCooktop());
                break;
            case "Dishwasher":
                $this->attributes = array_merge($this->attributes, $this->getDishwasher());
                break;
            case "LaundryAppliance":
                $this->attributes = array_merge($this->attributes, $this->getLaundryAppliance());
                break;
            case "MicrowaveOven":
                $this->attributes = array_merge($this->attributes, $this->getMicrowaveOven());
                break;
            case "Range":
                $this->attributes = array_merge($this->attributes, $this->getRange());
                break;
            case "RefrigerationAppliance":
                $this->attributes = array_merge($this->attributes, $this->getRefrigerationAppliance());
                break;
            case "TrashCompactor":
                $this->attributes = array_merge($this->attributes, $this->getTrashCompactor());
                break;
            case "VentHood":
                $this->attributes = array_merge($this->attributes, $this->getVentHood());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}250\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}250\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Color",
                        "Size",
                        "SizeColor",
                    ],
                ],
            ],
            "{$i}ProductGrade" => [
                "sequence" => "{$s}251",
                "name" => "ProductGrade",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SidePanelColor" => [
                "sequence" => "{$s}255",
                "name" => "SidePanelColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}256",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getAirConditioner()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * AirConditioner => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_AirConditioner_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_AirConditioner" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "AirConditioner",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AirConditionCoverageCooling" => [
                "sequence" => "{$s}10",
                "name" => "AirConditionCoverageCooling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AirConditionCoverageHeating" => [
                "sequence" => "{$s}20",
                "name" => "AirConditionCoverageHeating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConnectorType" => [
                "sequence" => "{$s}30",
                "name" => "ConnectorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ControlsType" => [
                "sequence" => "{$s}40",
                "name" => "ControlsType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CoolingVents" => [
                "sequence" => "{$s}50",
                "name" => "CoolingVents",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}DryerPowerSource" => [
                "sequence" => "{$s}60",
                "name" => "DryerPowerSource",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}IceCapacity" => [
                "sequence" => "{$s}100",
                "name" => "IceCapacity",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ItemDimensionsIndoor" => [
                "sequence" => "{$s}110",
                "name" => "ItemDimensionsIndoor",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ItemDimensionsOutdoor" => [
                "sequence" => "{$s}120",
                "name" => "ItemDimensionsOutdoor",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
        ];
        return $attributes;
    }

    public function getApplianceAccessory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * CookingOven => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_CookingOven_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_CookingOven" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "CookingOven",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ConnectorType" => [
                "sequence" => "{$s}10",
                "name" => "ConnectorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ControlsType" => [
                "sequence" => "{$s}20",
                "name" => "ControlsType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CoolingVents" => [
                "sequence" => "{$s}30",
                "name" => "CoolingVents",
                "minOccurs" => "0",
                "dataType" => "integer",
            ],
            "{$i}DryerPowerSource" => [
                "sequence" => "{$s}40",
                "name" => "DryerPowerSource",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LightingMethod" => [
                "sequence" => "{$s}50",
                "name" => "LightingMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}RecommendedProductUses" => [
                "sequence" => "{$s}60",
                "name" => "RecommendedProductUses",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ShelfType" => [
                "sequence" => "{$s}70",
                "name" => "ShelfType",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TrayType" => [
                "sequence" => "{$s}80",
                "name" => "TrayType",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
        ];
        return $attributes;
    }

    public function getCookingOven()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * CookingOven => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_CookingOven_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_CookingOven" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "CookingOven",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BurnerType" => [
                "sequence" => "{$s}10",
                "name" => "BurnerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DrawerType" => [
                "sequence" => "{$s}20",
                "name" => "DrawerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FuelType" => [
                "sequence" => "{$s}30",
                "name" => "FuelType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HeatingMode" => [
                "sequence" => "{$s}40",
                "name" => "HeatingMode",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaxEnergyOutput" => [
                "sequence" => "{$s}50",
                "name" => "MaxEnergyOutput",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}MaxEnergyOutput_unitOfMeasure_MaxEnergyOutputUnitOfMeasure"
            ],
            "{$i}Racks" => [
                "sequence" => "{$s}60",
                "name" => "Racks",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ]
        ];
        return $attributes;
    }

    public function getCooktop()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * Cooktop => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_Cooktop_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_Cooktop" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "Cooktop",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BurnerType" => [
                "sequence" => "{$s}10",
                "name" => "BurnerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DrawerType" => [
                "sequence" => "{$s}20",
                "name" => "DrawerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FuelType" => [
                "sequence" => "{$s}30",
                "name" => "FuelType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HeatingElements" => [
                "sequence" => "{$s}40",
                "name" => "HeatingElements",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}MaxEnergyOutput" => [
                "sequence" => "{$s}50",
                "name" => "MaxEnergyOutput",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}MaxEnergyOutput_unitOfMeasure_MaxEnergyOutputUnitOfMeasure"
            ]
        ];
        return $attributes;
    }

    public function getDishwasher()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * Dishwasher => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_Dishwasher_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_Dishwasher" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "Dishwasher",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ControlsType" => [
                "sequence" => "{$s}10",
                "name" => "ControlsType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CounterDepth" => [
                "sequence" => "{$s}20",
                "name" => "CounterDepth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}CounterDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}IsPortable" => [
                "sequence" => "{$s}30",
                "name" => "IsPortable",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}OptionCycles" => [
                "sequence" => "{$s}40",
                "name" => "OptionCycles",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}StandardCycles" => [
                "sequence" => "{$s}50",
                "name" => "StandardCycles",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TrayType" => [
                "sequence" => "{$s}60",
                "name" => "TrayType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WasherArms" => [
                "sequence" => "{$s}70",
                "name" => "WasherArms",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ]
        ];
        return $attributes;
    }

    public function getLaundryAppliance()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * LaundryAppliance => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_LaundryAppliance_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_LaundryAppliance" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "LaundryAppliance",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AccessLocation" => [
                "sequence" => "{$s}10",
                "name" => "AccessLocation",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClothesCapacity" => [
                "sequence" => "{$s}20",
                "name" => "ClothesCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleDevice" => [
                "sequence" => "{$s}30",
                "name" => "CompatibleDevice",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CounterDepth" => [
                "sequence" => "{$s}40",
                "name" => "CounterDepth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}CounterDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}IsPortable" => [
                "sequence" => "{$s}50",
                "name" => "IsPortable",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
        ];
        return $attributes;
    }

    public function getMicrowaveOven()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * MicrowaveOven => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_MicrowaveOven_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_MicrowaveOven" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "MicrowaveOven",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Racks" => [
                "sequence" => "{$s}10",
                "name" => "Racks",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ]
        ];
        return $attributes;
    }

    public function getRange()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * Range => 80
         */
        $s = "100\\10\\10\\80\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_Range_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_Range" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "Range",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BurnerType" => [
                "sequence" => "{$s}10",
                "name" => "BurnerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DrawerType" => [
                "sequence" => "{$s}20",
                "name" => "DrawerType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FuelType" => [
                "sequence" => "{$s}30",
                "name" => "FuelType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HeatingElements" => [
                "sequence" => "{$s}40",
                "name" => "HeatingElements",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}HeatingMode" => [
                "sequence" => "{$s}50",
                "name" => "HeatingMode",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaxEnergyOutput" => [
                "sequence" => "{$s}60",
                "name" => "MaxEnergyOutput",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}MaxEnergyOutput_unitOfMeasure_MaxEnergyOutputUnitOfMeasure"
            ]
        ];
        return $attributes;
    }

    public function getRefrigerationAppliance()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * RefrigerationAppliance => 90
         */
        $s = "100\\10\\10\\90\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_RefrigerationAppliance_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_RefrigerationAppliance" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "RefrigerationAppliance",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}CompatibleDevice" => [
                "sequence" => "{$s}10",
                "name" => "CompatibleDevice",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConnectorType" => [
                "sequence" => "{$s}20",
                "name" => "ConnectorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CoolingVents" => [
                "sequence" => "{$s}30",
                "name" => "CoolingVents",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}DefrostSystemType" => [
                "sequence" => "{$s}40",
                "name" => "DefrostSystemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DoorMaterialType" => [
                "sequence" => "{$s}60",
                "name" => "DoorMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Drawers" => [
                "sequence" => "{$s}70",
                "name" => "Drawers",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}FreezerCapacity" => [
                "sequence" => "{$s}80",
                "name" => "FreezerCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}FreezerCapacity_unitOfMeasure_VolumeUnitOfMeasure"
            ],
            "{$i}LightingMethod" => [
                "sequence" => "{$s}100",
                "name" => "LightingMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}RecommendedProductUses" => [
                "sequence" => "{$s}110",
                "name" => "RecommendedProductUses",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ShelfType" => [
                "sequence" => "{$s}120",
                "name" => "ShelfType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ]
        ];
        return $attributes;
    }

    public function getTrashCompactor()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * TrashCompactor => 90
         */
        $s = "100\\10\\10\\90\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_TrashCompactor_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_TrashCompactor" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "TrashCompactor",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getVentHood()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LargeAppliances => 10
         * ProductType => 10
         * VentHood => 90
         */
        $s = "100\\10\\10\\90\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_ProductType_VentHood_";

        $attributes = [
            "ProductData_LargeAppliances_ProductType_VentHood" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "VentHood",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubCookingOven()
    {
        $i = "ProductData_LargeAppliances_ProductType_CookingOven_";
        $subAttributes = [
            "{$i}MaxEnergyOutput_unitOfMeasure_MaxEnergyOutputUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "btus",
                            ],
                    ],
                "default" => "btus"
            ],
        ];
        return $subAttributes;
    }

    public function getSubCooktop()
    {
        $i = "ProductData_LargeAppliances_ProductType_Cooktop_";
        $subAttributes = [
            "{$i}MaxEnergyOutput_unitOfMeasure_MaxEnergyOutputUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "btus",
                            ],
                    ],
                "default" => "btus"
            ],
        ];
        return $subAttributes;
    }

    public function getSubRange()
    {
        $i = "ProductData_LargeAppliances_ProductType_Range_";
        $subAttributes = [
            "{$i}MaxEnergyOutput_unitOfMeasure_MaxEnergyOutputUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "btus",
                            ],
                    ],
                "default" => "btus"
            ],
        ];
        return $subAttributes;
    }

    public function getSubDishwasher()
    {
        $i = "ProductData_LargeAppliances_ProductType_Dishwasher_";
        $subAttributes = [
            "{$i}CounterDepth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubLaundryAppliance()
    {
        $i = "ProductData_LargeAppliances_ProductType_LaundryAppliance_";
        $subAttributes = [
            "{$i}CounterDepth_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubRefrigerationAppliance()
    {
        $i = "ProductData_LargeAppliances_ProductType_RefrigerationAppliance_";
        $subAttributes = [
            "{$i}FreezerCapacity_unitOfMeasure_VolumeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "liters",
                                "gallon",
                            ],
                    ],
                "default" => "liters"
            ],
        ];
        return $subAttributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_LargeAppliances_";

        $subAttributes = self::SUB_ATTRIBUTES;

        switch ($this->subCategory) {
//            case "AirConditioner":
//                $subAttributes = array_merge($subAttributes, $this->getSubAirConditioner());
//                break;
//            case "ApplianceAccessory":
//                $subAttributes = array_merge($subAttributes, $this->getApplianceAccessory());
//                break;
            case "CookingOven":
                $subAttributes = array_merge($subAttributes, $this->getSubCookingOven());
                break;
            case "Cooktop":
                $subAttributes = array_merge($subAttributes, $this->getSubCooktop());
                break;
            case "Dishwasher":
                $subAttributes = array_merge($subAttributes, $this->getSubDishwasher());
                break;
            case "LaundryAppliance":
                $subAttributes = array_merge($subAttributes, $this->getSubLaundryAppliance());
                break;
//            case "MicrowaveOven":
//                $subAttributes = array_merge($subAttributes, $this->getMicrowaveOven());
//                break;
            case "Range":
                $subAttributes = array_merge($subAttributes, $this->getSubRange());
                break;
            case "RefrigerationAppliance":
                $subAttributes = array_merge($subAttributes, $this->getSubRefrigerationAppliance());
                break;
//            case "TrashCompactor":
//                $subAttributes = array_merge($subAttributes, $this->getTrashCompactor());
//                break;
//            case "VentHood":
//                $subAttributes = array_merge($subAttributes, $this->getVentHood());
//                break;
        }

        return $subAttributes;
    }
}
