<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class LabSupplies extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_LAB_SUPPLY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SAFETY_SUPPLY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'LabSupplies';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "LabSupply":
                $this->attributes = array_merge($this->attributes, $this->getLabSupply());
                break;
            case "SafetySupply":
                $this->attributes = array_merge($this->attributes, $this->getSafetySupply());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * LabSupplies => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LabSupplies_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getLabSupply()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LabSupplies => 10
         * ProductType => 10
         * LabSupply => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LabSupplies_ProductType_LabSupply_";

        $this->attributes = [
            "ProductData_LabSupplies_ProductType_LabSupply" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "LabSupply",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ColorName",
                                "ItemPackageQuantity",
                                "ItemWeight",
                                "Material",
                                "NumberOfItems",
                                "SizeName-ColorName",
                                "SizeName",
                                "Style",
                            ],
                    ],
            ],
            "{$i}AgeRangeDescription" => [
                "sequence" => "{$s}20",
                "name" => "AgeRangeDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSafetySupply()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * LabSupplies => 10
         * ProductType => 10
         * SafetySupply => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_LabSupplies_ProductType_SafetySupply_";

        $attributes = [
            "ProductData_LabSupplies_ProductType_SafetySupply" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "SafetySupply",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ColorName",
                                "ItemPackageQuantity",
                                "ItemWeight",
                                "Material",
                                "NumberOfItems",
                                "SizeName-ColorName",
                                "SizeName",
                                "Style",
                            ],
                    ],
            ],
            "{$i}Model" => [
                "sequence" => "{$s}20",
                "name" => "Model",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VolumeCapacityName" => [
                "sequence" => "{$s}30",
                "name" => "VolumeCapacityName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}40",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorName" => [
                "sequence" => "{$s}50",
                "name" => "ColorName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FrameMaterial" => [
                "sequence" => "{$s}60",
                "name" => "FrameMaterial",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_LabSupplies_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
