<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Industrial extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_ABRASIVES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ADHESIVES_AND_SEALANTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CUTTING_TOOLS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ELECTRONIC_COMPONENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GEARS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GROMMETS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_INDUSTRIAL_HOSE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_INDUSTRIAL_WHEELS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MECHANICAL_COMPONENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ORINGS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PRECISION_MEASURING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Industrial';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value']['minOccurs'] = '1';
        }

        $this->attributes['DescriptionData_Manufacturer']['minOccurs'] = '1';
        $this->attributes['DescriptionData_MfrPartNumber']['minOccurs'] = '1';

        $this->attributes['DescriptionData_ItemWeight']['minOccurs'] = '1';
        $this->attributes['DescriptionData_ItemVolume']['minOccurs'] = '1';
        $this->attributes['DescriptionData_Battery_AreBatteriesIncluded']['minOccurs'] = '1';
        $this->attributes['DescriptionData_Battery_AreBatteriesRequired']['minOccurs'] = '1';
        $this->attributes['DescriptionData_GHSClassificationClass']['minOccurs'] = '1';
        $this->attributes['DescriptionData_SupplierDeclaredDGHZRegulation']['minOccurs'] = '1';
        $this->attributes['DescriptionData_HazmatUnitedNationsRegulatoryID']['minOccurs'] = '1';
        $this->attributes['DescriptionData_SafetyDataSheetURL']['minOccurs'] = '1';

        switch ($this->subCategory) {
            case "Abrasives":
                $this->attributes = array_merge($this->attributes, $this->getAbrasives());
                break;
            case "AdhesivesAndSealants":
                $this->attributes = array_merge($this->attributes, $this->getAdhesivesAndSealants());
                break;
            case "CuttingTools":
                $this->attributes = array_merge($this->attributes, $this->getCuttingTools());
                break;
            case "ElectronicComponents":
                $this->attributes = array_merge($this->attributes, $this->getElectronicComponents());
                break;
            case "Gears":
                $this->attributes = array_merge($this->attributes, $this->getGears());
                break;
            case "Grommets":
                $this->attributes = array_merge($this->attributes, $this->getGrommets());
                break;
            case "IndustrialHose":
                $this->attributes = array_merge($this->attributes, $this->getIndustrialHose());
                break;
            case "IndustrialWheels":
                $this->attributes = array_merge($this->attributes, $this->getIndustrialWheels());
                break;
            case "MechanicalComponents":
                $this->attributes = array_merge($this->attributes, $this->getMechanicalComponents());
                break;
            case "ORings":
                $this->attributes = array_merge($this->attributes, $this->getORings());
                break;
            case "PrecisionMeasuring":
                $this->attributes = array_merge($this->attributes, $this->getPrecisionMeasuring());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_";
        $common = [
            "{$i}CrossSectionShape" => [
                "sequence" => "{$s}20",
                "name" => "CrossSectionShape",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}50",
                "name" => "CrossSectionShape",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}Model" => [
                "sequence" => "{$s}70",
                "name" => "Model",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getAbrasives()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * Abrasives => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_Abrasives_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_Abrasives" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Webcam",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ArborHoleDiameter" => [
                "sequence" => "{$s}10",
                "name" => "ArborHoleDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}ArborHoleDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}FasteningType" => [
                "sequence" => "{$s}80",
                "name" => "FasteningType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}FinishTypes" => [
                "sequence" => "{$s}90",
                "name" => "FinishTypes",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}GritMaterialType" => [
                "sequence" => "{$s}100",
                "name" => "GritMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}GritType" => [
                "sequence" => "{$s}110",
                "name" => "GritType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}HeadHeight" => [
                "sequence" => "{$s}120",
                "name" => "HeadHeight",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}HeadHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HubDiameter" => [
                "sequence" => "{$s}130",
                "name" => "HubDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}HubDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HubLength" => [
                "sequence" => "{$s}140",
                "name" => "HubLength",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}HubLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}IndustryStandardIdentifier" => [
                "sequence" => "{$s}150",
                "name" => "IndustryStandardIdentifier",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}ItemDiameter" => [
                "sequence" => "{$s}160",
                "name" => "ItemDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}ItemDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ItemPitch" => [
                "sequence" => "{$s}170",
                "name" => "ItemPitch",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}ItemPitch_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ItemShape" => [
                "sequence" => "{$s}180",
                "name" => "ItemShape",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "length" =>"1:50",
            ],
            "{$i}ItemTorque" => [
                "sequence" => "{$s}190",
                "name" => "ItemTorque",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ItemTorque_TorqueUnitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getAdhesivesAndSealants()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * AdhesivesAndSealants => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_AdhesivesAndSealants_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_AdhesivesAndSealants" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "AdhesivesAndSealants",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getCuttingTools()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * CuttingTools => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_CuttingTools_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_CuttingTools" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "CuttingTools",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ArborHoleDiameter" => [
                "sequence" => "{$s}10",
                "name" => "ArborHoleDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ArborHoleDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ExteriorFinish" => [
                "sequence" => "{$s}70",
                "name" => "ExteriorFinish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FasteningType" => [
                "sequence" => "{$s}80",
                "name" => "FasteningType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FinishTypes" => [
                "sequence" => "{$s}90",
                "name" => "FinishTypes",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GritMaterialType" => [
                "sequence" => "{$s}100",
                "name" => "GritMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GritType" => [
                "sequence" => "{$s}110",
                "name" => "GritType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HeadHeight" => [
                "sequence" => "{$s}120",
                "name" => "HeadHeight",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}HeadHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HubDiameter" => [
                "sequence" => "{$s}130",
                "name" => "HubDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}HubDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}HubLength" => [
                "sequence" => "{$s}140",
                "name" => "HubLength",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}HubLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}IndustryStandardIdentifier" => [
                "sequence" => "{$s}150",
                "name" => "IndustryStandardIdentifier",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemDiameter" => [
                "sequence" => "{$s}160",
                "name" => "ItemDiameter",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}ItemDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}ItemPitch" => [
                "sequence" => "{$s}170",
                "name" => "ItemPitch",
                "minOccurs" => "0",
                "dataType" => "Dimension",
                "attribute" => "{$i}ItemPitch_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getElectronicComponents()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * ElectronicComponents => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_ElectronicComponents_";

        $attributes = [
            "ProductData_Industrial_ProductType_ElectronicComponents" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "ElectronicComponents",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ]
                ]
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                    "optionValues" => [
                        "NumberOfItems",
                        "SizeName-NumberOfItems",
                        "Color",
                        "ColorSize",
                        "SizeStyle",
                        "SizeName-ColorName-NumberOfItems",
                        "Color-Material",
                        "Wattage",
                        "ItemPackageQuantity",
                        "Size",
                        "Material",
                        "ItemPackageQuantity-Size",
                        "StyleName",
                        "SizeName-StyleName",
                        "SizeName-ColorName",
                        "SizeName",
                    ]
                ]
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}29",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}70",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}80",
                "name" => "SpecialFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecificationMet1" => [
                "sequence" => "{$s}90",
                "name" => "SpecificationMet1",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecificationMet2" => [
                "sequence" => "{$s}100",
                "name" => "SpecificationMet2",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecificationMet3" => [
                "sequence" => "{$s}110",
                "name" => "SpecificationMet3",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecificationMet4" => [
                "sequence" => "{$s}120",
                "name" => "SpecificationMet4",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpecificationMet5" => [
                "sequence" => "{$s}130",
                "name" => "SpecificationMet5",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}StyleName" => [
                "sequence" => "{$s}140",
                "name" => "StyleName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $attributes;
    }

    public function getGears()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * Gears => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_Gears_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_Gears" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "Gears",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getGrommets()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * Grommets => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_Grommets_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_Grommets" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "Grommets",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getIndustrialHose()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * IndustrialHose => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_IndustrialHose_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_IndustrialHose" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "IndustrialHose",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getIndustrialWheels()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * IndustrialWheels => 80
         */
        $s = "100\\10\\10\\80\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_IndustrialWheels_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_IndustrialWheels" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "IndustrialWheels",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getMechanicalComponents()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * MechanicalComponents => 90
         */
        $s = "100\\10\\10\\90\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_MechanicalComponents_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_MechanicalComponents" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "MechanicalComponents",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getORings()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * ORings => 100
         */
        $s = "100\\10\\10\\100\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_ORings_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_ORings" => [
                "sequence" => "100\\10\\10\\100",
                "name" => "ORings",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getPrecisionMeasuring()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Industrial => 10
         * ProductType => 10
         * PrecisionMeasuring => 110
         */
        $s = "100\\10\\10\\110\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_ProductType_PrecisionMeasuring_";

        $this->attributes = [
            "ProductData_Industrial_ProductType_PrecisionMeasuring" => [
                "sequence" => "100\\10\\10\\110",
                "name" => "PrecisionMeasuring",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BackingType" => [
                "sequence" => "{$s}20",
                "name" => "BackingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CuttingDiameter" => [
                "sequence" => "{$s}50",
                "name" => "CuttingDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CutType" => [
                "sequence" => "{$s}60",
                "name" => "CutType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SizeName" => [
                "sequence" => "{$s}250",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WheelDiameter" => [
                "sequence" => "{$s}350",
                "name" => "WheelDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Industrial_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }

    public function getSubAbrasives()
    {
        $i = "ProductData_Industrial_ProductType_Abrasives_";
        $subAttributes = [
            "{$i}ArborHoleDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HeadHeight_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HubDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}HubLength_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}ItemDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}ItemPitch_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}ItemTorque_TorqueUnitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "foot-lbs",
                                "inch-lbs",
                                "centimeter_kilograms",
                                "foot_pounds",
                                "inch_ounces",
                                "inch_pounds",
                                "kilonewtons",
                                "kilograms_per_millimeter",
                                "newton_meters",
                                "newton_millimeters",
                                "newtons",
                            ],
                    ],
                "default" => "foot-lbs"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "MM",
                                "CM",
                                "M",
                                "IN",
                                "FT",
                                "inches",
                                "feet",
                                "meters",
                                "decimeters",
                                "centimeters",
                                "millimeters",
                                "micrometers",
                                "nanometers",
                                "picometers",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubAdhesivesAndSealants()
    {
        $i = "ProductData_Industrial_ProductType_AdhesivesAndSealants_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubCuttingTools()
    {
        $i = "ProductData_Industrial_ProductType_CuttingTools_";
        $subAttributes = [
            "{$i}ArborHoleDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubElectronicComponents()
    {
        $i = "ProductData_Industrial_ProductType_ElectronicComponents_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubGears()
    {
        $i = "ProductData_Industrial_ProductType_Gears_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubGrommets()
    {
        $i = "ProductData_Industrial_ProductType_Grommets_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubIndustrialHose()
    {
        $i = "ProductData_Industrial_ProductType_IndustrialHose_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubIndustrialWheels()
    {
        $i = "ProductData_Industrial_ProductType_IndustrialWheels_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubMechanicalComponents()
    {
        $i = "ProductData_Industrial_ProductType_MechanicalComponents_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubORings()
    {
        $i = "ProductData_Industrial_ProductType_ORings_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubPrecisionMeasuring()
    {
        $i = "ProductData_Industrial_ProductType_PrecisionMeasuring_";
        $subAttributes = [
            "{$i}CuttingDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}WheelDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }
}
