<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class HomeImprovement extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_BUILDING_MATERIALS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HARDWARE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ELECTRICAL = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_PLUMBING_FIXTURES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TOOLS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_ORGANIZERS_AND_STORAGE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MAJOR_HOME_APPLIANCES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SECURITY_ELECTRONICS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'HomeImprovement';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value']['minOccurs'] = '1';
        }

        $this->attributes['DescriptionData_Manufacturer']['minOccurs'] = '1';

        switch ($this->subCategory) {
            case "BuildingMaterials":
                $this->attributes = array_merge($this->attributes, $this->getBuildingMaterials());
                break;
            case "Hardware":
                $this->attributes = array_merge($this->attributes, $this->getHardware());
                break;
            case "Electrical":
                $this->attributes = array_merge($this->attributes, $this->getElectrical());
                break;
            case "PlumbingFixtures":
                $this->attributes = array_merge($this->attributes, $this->getPlumbingFixtures());
                break;
            case "OrganizersAndStorage":
                $this->attributes = array_merge($this->attributes, $this->getOrganizersAndStorage());
                break;
            case "MajorHomeAppliances":
                $this->attributes = array_merge($this->attributes, $this->getMajorHomeAppliances());
                break;
            case "Tools":
                $this->attributes = array_merge($this->attributes, $this->getTools());
                unset($this->attributes['ItemPackageQuantity']);
                break;
            case "SecurityElectronics":
                $this->attributes = array_merge($this->attributes, $this->getSecurityElectronics());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_";

        $common = [
            "{$i}HICommon_Finish" => [
                "sequence" => "{$s}10\\10",
                "name" => "Finish",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_IncludedComponent" => [
                "sequence" => "{$s}10\\20",
                "name" => "IncludedComponent",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_InstallationMethod" => [
                "sequence" => "{$s}10\\30",
                "name" => "InstallationMethod",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_IsAdultProduct" => [
                "sequence" => "{$s}10\\40",
                "name" => "IsAdultProduct",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_Pattern" => [
                "sequence" => "{$s}10\\100",
                "name" => "Pattern",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_Shape" => [
                "sequence" => "{$s}10\\200",
                "name" => "Shape",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_SizeMap" => [
                "sequence" => "{$s}10\\210",
                "name" => "SizeMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}HICommon_SpecialFeatures" => [
                "sequence" => "{$s}10\\220",
                "name" => "SpecialFeatures",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "maxOccurs" => "5",
            ],
            "{$i}HICommon_Style" => [
                "sequence" => "{$s}10\\300",
                "name" => "Style",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "maxOccurs" => "5",
            ],
            "{$i}HICommon_Usage" => [
                "sequence" => "{$s}10\\400",
                "name" => "Usage",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "maxOccurs" => "5",
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}20\\10",
                "name" => "AreBatteriesIncluded",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}20\\20",
                "name" => "AreBatteriesRequired",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}20\\30\\10",
                "name" => "BatteryType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                        "optionValues" => [
                                0 => "battery_type_2/3A",
                                1 => "battery_type_4/3A",
                                2 => "battery_type_4/5A",
                                3 => "battery_type_9v",
                                4 => "battery_type_12v",
                                5 => "battery_type_a",
                                6 => "battery_type_a76",
                                7 => "battery_type_aa",
                                8 => "battery_type_aaa",
                                9 => "battery_type_aaaa",
                                10 => "battery_type_c",
                                11 => "battery_type_cr123a",
                                12 => "battery_type_cr2",
                                13 => "battery_type_cr5",
                                14 => "battery_type_d",
                                15 => "battery_type_lithium_ion",
                                16 => "battery_type_lithium_metal",
                                17 => "battery_type_L-SC",
                                18 => "battery_type_p76",
                                19 => "battery_type_product_specific",
                                20 => "battery_type_SC",
                            ],
                    ],
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}20\\30\\20",
                "name" => "NumberOfBatteries",
                "dataType" => "positiveInteger",
                "minOccurs" => "0",
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getBuildingMaterials()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * BuildingMaterials => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_BuildingMaterials_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_BuildingMaterials" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "BuildingMaterials",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        "Size",
                        "Color",
                        "Material",
                        "ItemWeight",
                        "Size-Color",
                        "Style",
                        "Pattern",
                        "ItemPackageQuantity",
                        "CustomerPackageType",
                        "ColorName-CustomerPackageType",
                        "SizeName-CustomerPackageType",
                        "SizeName-ColorName-CustomerPackageType",
                        "StyleName-CustomerPackageType",
                        "SizeName-StyleName-CustomerPackageType",
                    ],
                ],
            ],
            "{$i}AccessoryConnectionType" => [
                "sequence" => "{$s}30",
                "name" => "AccessoryConnectionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DeviceType" => [
                "sequence" => "{$s}100",
                "name" => "DeviceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Size" => [
                "sequence" => "{$s}1000",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}1010",
                "name" => "Color",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}1020",
                "name" => "ColorMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}1030",
                "name" => "Material",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DisplayVolume" => [
                "sequence" => "{$s}1040",
                "name" => "DisplayVolume",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"
            ],
            "{$i}DisplayWeight" => [
                "sequence" => "{$s}1050",
                "name" => "DisplayWeight",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}1060",
                "name" => "DisplayLength",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}CustomerPackageType" => [
                "sequence" => "{$s}1100",
                "name" => "CustomerPackageType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    public function getHardware()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * Hardware => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_Hardware_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_Hardware" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Hardware",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Material",
                    ],
                ],
            ],
            "{$i}AccessoryConnectionType" => [
                "sequence" => "{$s}30",
                "name" => "AccessoryConnectionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DeviceType" => [
                "sequence" => "{$s}100",
                "name" => "DeviceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    public function getElectrical()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * Electrical => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_Electrical_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_Electrical" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "Electrical",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Material",
                    ],
                ],
            ],
            "{$i}AccessoryConnectionType" => [
                "sequence" => "{$s}30",
                "name" => "AccessoryConnectionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DeviceType" => [
                "sequence" => "{$s}100",
                "name" => "DeviceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    public function getPlumbingFixtures()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * PlumbingFixtures => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_PlumbingFixtures_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_PlumbingFixtures" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "PlumbingFixtures",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Material",
                    ],
                ],
            ],
            "{$i}AccessoryConnectionType" => [
                "sequence" => "{$s}30",
                "name" => "AccessoryConnectionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DeviceType" => [
                "sequence" => "{$s}100",
                "name" => "DeviceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    public function getOrganizersAndStorage()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * OrganizersAndStorage => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_OrganizersAndStorage_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_OrganizersAndStorage" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "OrganizersAndStorage",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Material",
                    ],
                ],
            ],
            "{$i}AccessoryConnectionType" => [
                "sequence" => "{$s}30",
                "name" => "AccessoryConnectionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DeviceType" => [
                "sequence" => "{$s}100",
                "name" => "DeviceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    public function getMajorHomeAppliances()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * MajorHomeAppliances => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_MajorHomeAppliances_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_MajorHomeAppliances" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "MajorHomeAppliances",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Style",
                    ],
                ],
            ],
            "{$i}Size" => [
                "sequence" => "{$s}30",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}40",
                "name" => "Color",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}60",
                "name" => "Material",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getTools()
    {
        unset($this->attributes['ItemPackageQuantity']);

        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * Tools => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_Tools_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_Tools" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "Electrical",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false,
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}20\\20",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull"
                ],

            "{$i}VariationData_SizeName" => [
                "sequence" => "{$s}20\\30",
                "name" => "SizeName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull"
            ],
            "{$i}VariationData_ItemPackageQuantity" => [
                "sequence" => "{$s}20\\40",
                "name" => "ItemPackageQuantity",
                "minOccurs" => "0",
                "dataType" => "positiveInteger"
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\50",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "ColorName",
                        1 => "Weight",
                        2 => "ItemPackageQuantity",
                        3 => "ItemPackageQuantityColor",
                        4 => "ItemPackageQuantitySize",
                        5 => "Material",
                        6 => "MaterialSize",
                        7 => "PatternName",
                        8 => "SizeName",
                        9 => "SizeName-ColorName",
                        10 => "Style",
                        11 => "Color",
                        12 => "Pattern"
                    ],
                ],
            ],
        ];

        return $this->attributes;
    }

    public function getSecurityElectronics()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * HomeImprovement => 10
         * ProductType => 10
         * SecurityElectronics => 80
         */
        $s = "100\\10\\10\\80\\";

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_ProductType_SecurityElectronics_";

        $this->attributes = [
            "ProductData_HomeImprovement_ProductType_SecurityElectronics" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "SecurityElectronics",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\20",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Style",
                    ],
                ],
            ],
            "{$i}AccessoryConnectionType" => [
                "sequence" => "{$s}30",
                "name" => "AccessoryConnectionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}DeviceType" => [
                "sequence" => "{$s}100",
                "name" => "DeviceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_HomeImprovement_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}SeatHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                        0 => "GR",
                        1 => "KG",
                        2 => "OZ",
                        3 => "LB",
                        4 => "MG",
                    ],
                ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Volume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}VolumeCapacity_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        switch ($this->category) {
            case "Electrical":
                $subAttributes = array_merge($subAttributes, $this->getSubElectrical());
                break;
            case "BuildingMaterials":
                $subAttributes = array_merge($subAttributes, $this->getSubBuildingMaterials());
                break;
        }

        return $subAttributes;
    }

    public function getSubElectrical()
    {
        $i = "ProductData_HomeImprovement_ProductType_Electrical_";
        $subAttributes = [
            "{$i}MaximumCoverageArea_unitOfMeasure_AreaUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "square-in",
                                1 => "square-ft",
                                2 => "square-cm",
                                3 => "square-m",
                            ],
                    ],
                "default" => "square-cm"
            ],
            "{$i}OutputCapacity_unitOfMeasure_VolumeRateUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "milliliters per second",
                                1 => "centiliters per second",
                                2 => "liters per second",
                                3 => "milliliters per minute",
                                4 => "liters per minute",
                                5 => "microliters per second",
                                6 => "nanoliters per second",
                                7 => "picoliters per second",
                                8 => "microliters per minute",
                                9 => "nanoliters per minute",
                                10 => "picoliters per minute",
                                11 => "gallons_per_day",
                                12 => "gallons_per_day",
                                13 => "liters_per_day",
                                14 => "liters",
                            ],
                    ],
                "default" => "milliliters per second"
            ],
            "{$i}TowelWeight_unitOfMeasure_WeightUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                            0 => "GR",
                            1 => "KG",
                            2 => "OZ",
                            3 => "LB",
                            4 => "MG",
                        ],
                    ],
                "default" => "KG"
            ],
            "{$i}Wattage_unitOfMeasure_WattageUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                            0 => "watts",
                            1 => "kilowatts",
                        ],
                    ],
                "default" => "watts"
            ],
        ];
        return $subAttributes;
    }

    public function getSubBuildingMaterials()
    {
        $i = "ProductData_HomeImprovement_ProductType_BuildingMaterials_";
        $subAttributes["{$i}DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                        0 => "GR",
                        1 => "KG",
                        2 => "OZ",
                        3 => "LB",
                        4 => "MG",
                    ],
                ],
            "default" => "KG"
        ];

        return $subAttributes;
    }
}
