<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Home extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    /**
     * Index prefix:
     * @var string
     */
    public $i = "ProductData_Home_";

    /**
     * Sequence prefix:
     * ProductData => 100
     * Home => 10
     * @var string
     */
    public $s = "100\\10\\";

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Home';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value']['minOccurs'] = '0';
        }

        // Overriding attributes
        $this->attributes['DescriptionData_Manufacturer']['minOccurs'] = '1';
        $this->attributes['DescriptionData_RecommendedBrowseNode']['minOccurs'] = '1';

        switch ($this->subCategory) {
            case "BedAndBath":
                $this->attributes = array_merge($this->attributes, $this->getBedAndBath());
                break;
            case "FurnitureAndDecor":
                $this->attributes = array_merge($this->attributes, $this->getFurnitureAndDecor());
                break;
            case "Kitchen":
                $this->attributes = array_merge($this->attributes, $this->getKitchen());
                break;
            case "OutdoorLiving":
                $this->attributes = array_merge($this->attributes, $this->getOutdoorLiving());
                break;
            case "SeedsAndPlants":
                $this->attributes = array_merge($this->attributes, $this->getSeedsAndPlants());
                break;
            case "Art":
                $this->attributes = array_merge($this->attributes, $this->getArt());
                break;
            case "Home":
                $this->attributes = array_merge($this->attributes, $this->getHome());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         */
        $s = $this->s;

        /**
         * Index prefix
         */
        $i = $this->i;

        $common = [
            "{$i}Parentage" => [
                "sequence" => "{$s}20",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "collection-parent",
                        1 => "variation-parent",
                        2 => "base-product",
                        3 => "parent",
                        4 => "child",
                    ],
                ],
            ],
//            "{$i}VariationData_Parentage" => [
//                "sequence" => "{$s}30\\10",
//                "name" => "Parentage",
//                "documentation" => "Use of this element is deprecated. Please use Home/Parentage instead. " .
//                    "This element is present for backward-compatibility reasons only.",
//                "minOccurs" => "0",
//                "dataType" => "StringNotNull",
//                "restriction" => [
//                    "optionValues" => [
//                        0 => "parent",
//                        1 => "child",
//                    ],
//                ],
//            ],
//            "{$i}VariationData_VariationTheme" => [
//                "sequence" => "{$s}30\\20",
//                "name" => "VariationTheme",
//                "dataType" => "StringNotNull",
//                "minOccurs" => "0",
//                "restriction" => [
//                    "optionValues" => [
//                        0 => "Size",
//                        1 => "Color",
//                        2 => "Scent",
//                        3 => "Size-Color",
//                        4 => "Size-Scent",
//                        5 => "DisplayLength-DisplayWidth",
//                        6 => "DisplayLength-Material",
//                        7 => "DisplayLength-Size",
//                        8 => "DisplayLength-Color",
//                        9 => "DisplayLength-DisplayHeight",
//                        10 => "DisplayWidth-Material",
//                        11 => "DisplayWidth-Size",
//                        12 => "DisplayWidth-Color",
//                        13 => "DisplayWidth-DisplayHeight",
//                        14 => "ItemPackageQuantity-Material",
//                        15 => "ItemPackageQuantity-Size",
//                        16 => "ItemPackageQuantity-Color",
//                        17 => "ItemPackageQuantity-DisplayHeight",
//                        18 => "DisplayWeight-ItemPackageQuantity",
//                        19 => "DisplayWeight-Material",
//                        20 => "DisplayWeight-Size",
//                        21 => "DisplayWeight-Color",
//                        22 => "DisplayWeight-DisplayHeight",
//                        23 => "Material-DisplayLength",
//                        24 => "Material-DisplayWidth",
//                        25 => "Material-Size",
//                        26 => "Material-Color",
//                        27 => "Material-DisplayHeight",
//                        28 => "Size-DisplayLength",
//                        29 => "Size-DisplayWidth",
//                        30 => "Size-DisplayWeight",
//                        31 => "Size-Material",
//                        32 => "Size-Color",
//                        33 => "Size-DisplayHeight",
//                        34 => "Color-DisplayLength",
//                        35 => "Color-DisplayWidth",
//                        36 => "Color-ItemPackageQuantity",
//                        37 => "Color-DisplayWeight",
//                        38 => "Color-Material",
//                        39 => "Color-Size",
//                        40 => "Color-DisplayHeight",
//                        41 => "DisplayHeight",
//                        42 => "Material",
//                        43 => "DisplayWeight",
//                        44 => "DisplayLength",
//                        45 => "ItemPackageQuantity",
//                        46 => "DisplayLength-PatternName",
//                        47 => "DisplayLength-StyleName",
//                        48 => "DisplayWidth-PatternName",
//                        49 => "DisplayWidth-StyleName",
//                        50 => "Occasion-PatternName",
//                        51 => "Occasion-ItemPackageQuantity",
//                        52 => "Occasion-Material",
//                        53 => "Occasion-StyleName",
//                        54 => "Occasion-Size",
//                        55 => "Occasion-Color",
//                        56 => "Occasion-DisplayHeight",
//                        57 => "PatternName-DisplayLength",
//                        58 => "PatternName-DisplayWidth",
//                        59 => "PatternName-Occasion",
//                        60 => "PatternName-Material",
//                        61 => "PatternName-StyleName",
//                        62 => "PatternName-Size",
//                        63 => "PatternName-Color",
//                        64 => "PatternName-DisplayHeight",
//                        65 => "MatteStyle-Material",
//                        66 => "MatteStyle-StyleName",
//                        67 => "MatteStyle-Size",
//                        68 => "MatteStyle-Color",
//                        69 => "ItemPackageQuantity-Occasion",
//                        70 => "ItemPackageQuantity-StyleName",
//                        71 => "DisplayWeight-StyleName",
//                        72 => "Material-PatternName",
//                        73 => "Material-MatteStyle",
//                        74 => "Material-StyleName",
//                        75 => "StyleName-DisplayLength",
//                        76 => "StyleName-DisplayWidth",
//                        77 => "StyleName-Occasion",
//                        78 => "StyleName-PatternName",
//                        79 => "StyleName-DisplayWeight",
//                        80 => "StyleName-Material",
//                        81 => "StyleName-Size",
//                        82 => "StyleName-Color",
//                        83 => "Size-Occasion",
//                        84 => "Size-PatternName",
//                        85 => "Size-MatteStyle",
//                        86 => "Size-StyleName",
//                        87 => "Color-Occasion",
//                        88 => "Color-PatternName",
//                        89 => "Color-MatteStyle",
//                        90 => "Color-StyleName",
//                        91 => "MatteStyle",
//                        92 => "PatternName",
//                        93 => "Occasion",
//                        94 => "StyleName",
//                        95 => "CustomerPackageType",
//                        96 => "ColorName-CustomerPackageType",
//                        97 => "SizeName-CustomerPackageType",
//                        98 => "SizeName-ColorName-CustomerPackageType",
//                        99 => "StyleName-CustomerPackageType",
//                        100 => "SizeName-StyleName-CustomerPackageType",
//                    ],
//                ],
//            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}30\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}30\\40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}40",
                "name" => "BatteryDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}45",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "beige",
                        "black",
                        "blue",
                        "brass",
                        "bronze",
                        "brown",
                        "burst",
                        "chrome",
                        "clear",
                        "gold",
                        "gray",
                        "green",
                        "metallic",
                        "multi-colored",
                        "natural",
                        "off-white",
                        "orange",
                        "pink",
                        "purple",
                        "red",
                        "silver",
                        "white",
                        "yellow",
                    ],
                ],
            ],
            "{$i}CanShipInOriginalContainer" => [
                "sequence" => "{$s}50",
                "name" => "CanShipInOriginalContainer",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}CountryAsLabeled" => [
                "sequence" => "{$s}60",
                "name" => "CountryAsLabeled",
                "minOccurs" => "0",
                "dataType" => "StringNotNull", // CountryOfOriginType
                "pattern" => "[a-zA-Z][a-zA-Z]|unknown"
            ],
            "{$i}CountryOfOrigin" => [
                "sequence" => "{$s}70",
                "name" => "CountryOfOrigin",
                "minOccurs" => "0",
                "dataType" => "String",
                "length" => "2:2"
            ],
            "{$i}CountryProducedIn" => [
                "sequence" => "{$s}80",
                "name" => "CountryProducedIn",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ImportDesignation" => [
                "sequence" => "{$s}90",
                "name" => "ImportDesignation",
                "minOccurs" => "0",
                "dataType" => "String",
            ],
            "{$i}FurDescription" => [
                "sequence" => "{$s}100",
                "name" => "FurDescription",
                "minOccurs" => "0",
                "dataType" => "LongString",
            ],
            "{$i}IdentityPackageType" => [
                "sequence" => "{$s}110",
                "name" => "IdentityPackageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                0 => "bulk",
                                1 => "frustration_free",
                                2 => "traditional",
                            ],
                    ],
            ],
            "{$i}IncludedComponents" => [
                "sequence" => "{$s}120",
                "name" => "IncludedComponents",
                "minOccurs" => "0",
                "maxOccurs" => "5",
                "dataType" => "StringNotNull",
            ],
            "{$i}FabricType" => [
                "sequence" => "{$s}130",
                "name" => "FabricType",
                "minOccurs" => "0",
                "maxOccurs" => "3",
                "dataType" => "HundredString",
            ],
            "{$i}PatternName" => [
                "sequence" => "{$s}140",
                "name" => "PatternName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SeatHeight" => [
                "sequence" => "{$s}150",
                "name" => "SeatHeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "SeatHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}SpecialFeatures" => [
                "sequence" => "{$s}160",
                "name" => "SpecialFeatures",
                "minOccurs" => "0",
                "maxOccurs" => "5",
                "dataType" => "StringNotNull",
            ],
            "{$i}StyleName" => [
                "sequence" => "{$s}170",
                "name" => "StyleName",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Occasion" => [
                "sequence" => "{$s}180",
                "name" => "Occasion",
                "minOccurs" => "0",
                "dataType" => "MediumStringNotNull",
            ],
            "{$i}MatteStyle" => [
                "sequence" => "{$s}190",
                "name" => "MatteStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DisplayLength" => [
                "sequence" => "{$s}200",
                "name" => "DisplayLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayWidth" => [
                "sequence" => "{$s}210",
                "name" => "DisplayWidth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayHeight" => [
                "sequence" => "{$s}220",
                "name" => "DisplayHeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayDiameter" => [
                "sequence" => "{$s}230",
                "name" => "DisplayDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayDepth" => [
                "sequence" => "{$s}235",
                "name" => "DisplayDepth",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}DisplayVolume" => [
                "sequence" => "{$s}240",
                "name" => "DisplayVolume",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"
            ],
            "{$i}DisplayWeight" => [
                "sequence" => "{$s}250",
                "name" => "DisplayWeight",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"
            ],
            "{$i}ItemPackageQuantity" => [
                "sequence" => "{$s}260",
                "name" => "ItemPackageQuantity",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
                "default" => "1",
            ],
            "{$i}ManufacturerWarrantyDescription" => [
                "sequence" => "{$s}270",
                "name" => "ManufacturerWarrantyDescription",
                "minOccurs" => "0",
                "dataType" => "normalizedString",
                "length" => "0:1500",
                "restriction" => [
                    "maxLength" => "1500"
                ]
            ],
            "{$i}Volume" => [
                "sequence" => "{$s}280",
                "name" => "Volume",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "Volume_unitOfMeasure_VolumeRateUnitOfMeasure"
            ],
            "{$i}VolumeCapacity" => [
                "sequence" => "{$s}290",
                "name" => "VolumeCapacity",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => $this->i . "VolumeCapacity_unitOfMeasure_VolumeUnitOfMeasure"
            ],
            "{$i}Material" => [
                "sequence" => "{$s}300",
                "name" => "Material",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ThreadCount" => [
                "sequence" => "{$s}310",
                "name" => "ThreadCount",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}NumberOfPieces" => [
                "sequence" => "{$s}320",
                "name" => "NumberOfPieces",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}SafetyWarning" => [
                "sequence" => "{$s}330",
                "name" => "SafetyWarning",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}SizeMap" => [
                "sequence" => "{$s}1000",
                "name" => "SizeMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Warnings" => [
                "sequence" => "{$s}1100",
                "name" => "Warnings",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}Wattage" => [
                "sequence" => "{$s}1200",
                "name" => "Wattage",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        if ($this->subCategory == 'Home') {
            unset($this->attributes['ProductData_Home_VariationData_Size']);
        }

        if (isset($params) && !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    public function getBedAndBath()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * BedAndBath => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_BedAndBath_";

        $attributes = [
            "ProductData_Home_ProductType_BedAndBath" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "BedAndBath",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getKitchen()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * Kitchen => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_Kitchen_";

        $this->attributes = [
            "ProductData_Home_ProductType_Kitchen" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Kitchen",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $this->attributes;
    }

    public function getOutdoorLiving()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * OutdoorLiving => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_OutdoorLiving_";

        $this->attributes = [
            "ProductData_Home_ProductType_OutdoorLiving" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "OutdoorLiving",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}UnitCount" => [
                "sequence" => "{$s}10\\10",
                "name" => "UnitCount",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "attribute" => "{$i}UnitCount_unitOfMeasure"
            ]
        ];

        $this->attributes['DescriptionData_RecommendedBrowseNode']['minOccurs'] = '0';
        return $this->attributes;
    }

    public function getSeedsAndPlants()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * SeedsAndPlants => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_SeedsAndPlants_";

        $this->attributes = [
            "ProductData_Home_ProductType_SeedsAndPlants" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "SeedsAndPlants",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $this->attributes;
    }

    public function getArt()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * Art => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_Art_";

        $this->attributes = [
            "ProductData_Home_ProductType_Art" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Art",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $this->attributes;
    }

    public function getHome()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * Home => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_Home_";

        $this->attributes = [
            "ProductData_Home_ProductType_Home" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Home",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\10",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Scent",
                        3 => "Size-Color",
                        4 => "Size-Scent",
                        5 => "DisplayLength-DisplayWidth",
                        6 => "DisplayLength-Material",
                        7 => "DisplayLength-Size",
                        8 => "DisplayLength-Color",
                        9 => "DisplayLength-DisplayHeight",
                        10 => "DisplayWidth-Material",
                        11 => "DisplayWidth-Size",
                        12 => "DisplayWidth-Color",
                        13 => "DisplayWidth-DisplayHeight",
                        14 => "ItemPackageQuantity-Material",
                        15 => "ItemPackageQuantity-Size",
                        16 => "ItemPackageQuantity-Color",
                        17 => "ItemPackageQuantity-DisplayHeight",
                        18 => "DisplayWeight-ItemPackageQuantity",
                        19 => "DisplayWeight-Material",
                        20 => "DisplayWeight-Size",
                        21 => "DisplayWeight-Color",
                        22 => "DisplayWeight-DisplayHeight",
                        23 => "Material-DisplayLength",
                        24 => "Material-DisplayWidth",
                        25 => "Material-Size",
                        26 => "Material-Color",
                        27 => "Material-DisplayHeight",
                        28 => "Size-DisplayLength",
                        29 => "Size-DisplayWidth",
                        30 => "Size-DisplayWeight",
                        31 => "Size-Material",
                        32 => "Size-Color",
                        33 => "Size-DisplayHeight",
                        34 => "Color-DisplayLength",
                        35 => "Color-DisplayWidth",
                        36 => "Color-ItemPackageQuantity",
                        37 => "Color-DisplayWeight",
                        38 => "Color-Material",
                        39 => "Color-Size",
                        40 => "Color-DisplayHeight",
                        41 => "DisplayHeight",
                        42 => "Material",
                        43 => "DisplayWeight",
                        44 => "DisplayLength",
                        45 => "ItemPackageQuantity",
                        46 => "DisplayLength-PatternName",
                        47 => "DisplayLength-StyleName",
                        48 => "DisplayWidth-PatternName",
                        49 => "DisplayWidth-StyleName",
                        50 => "Occasion-PatternName",
                        51 => "Occasion-ItemPackageQuantity",
                        52 => "Occasion-Material",
                        53 => "Occasion-StyleName",
                        54 => "Occasion-Size",
                        55 => "Occasion-Color",
                        56 => "Occasion-DisplayHeight",
                        57 => "PatternName-DisplayLength",
                        58 => "PatternName-DisplayWidth",
                        59 => "PatternName-Occasion",
                        60 => "PatternName-Material",
                        61 => "PatternName-StyleName",
                        62 => "PatternName-Size",
                        63 => "PatternName-Color",
                        64 => "PatternName-DisplayHeight",
                        65 => "MatteStyle-Material",
                        66 => "MatteStyle-StyleName",
                        67 => "MatteStyle-Size",
                        68 => "MatteStyle-Color",
                        69 => "ItemPackageQuantity-Occasion",
                        70 => "ItemPackageQuantity-StyleName",
                        71 => "DisplayWeight-StyleName",
                        72 => "Material-PatternName",
                        73 => "Material-MatteStyle",
                        74 => "Material-StyleName",
                        75 => "StyleName-DisplayLength",
                        76 => "StyleName-DisplayWidth",
                        77 => "StyleName-Occasion",
                        78 => "StyleName-PatternName",
                        79 => "StyleName-DisplayWeight",
                        80 => "StyleName-Material",
                        81 => "StyleName-Size",
                        82 => "StyleName-Color",
                        83 => "Size-Occasion",
                        84 => "Size-PatternName",
                        85 => "Size-MatteStyle",
                        86 => "Size-StyleName",
                        87 => "Color-Occasion",
                        88 => "Color-PatternName",
                        89 => "Color-MatteStyle",
                        90 => "Color-StyleName",
                        91 => "MatteStyle",
                        92 => "PatternName",
                        93 => "Occasion",
                        94 => "StyleName",
                        95 => "CustomerPackageType",
                        96 => "ColorName-CustomerPackageType",
                        97 => "SizeName-CustomerPackageType",
                        98 => "SizeName-ColorName-CustomerPackageType",
                        99 => "StyleName-CustomerPackageType",
                        100 => "SizeName-StyleName-CustomerPackageType",
                    ],
                ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\20",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];

        return $this->attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getFurnitureAndDecor()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Home => 10
         * ProductType => 10
         * FurnitureAndDecor => 20
         */
        $s = $this->s . "10\\20\\";

        /**
         * Index prefix
         */
        $i = $this->i . "ProductType_FurnitureAndDecor_";

        $attributes = [
            "ProductData_Home_ProductType_FurnitureAndDecor" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "FurnitureAndDecor",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Battery_AreBatteriesIncluded" => [
                "sequence" => "{$s}10\\10",
                "name" => "AreBatteriesIncluded",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_AreBatteriesRequired" => [
                "sequence" => "{$s}10\\20",
                "name" => "AreBatteriesRequired",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}Battery_BatterySubgroup_BatteryType" => [
                "sequence" => "{$s}10\\30\\10",
                "name" => "BatteryType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                        "optionValues" => [
                                0 => "battery_type_2/3A",
                                1 => "battery_type_4/3A",
                                2 => "battery_type_4/5A",
                                3 => "battery_type_9v",
                                4 => "battery_type_12v",
                                5 => "battery_type_a",
                                6 => "battery_type_a76",
                                7 => "battery_type_aa",
                                8 => "battery_type_aaa",
                                9 => "battery_type_aaaa",
                                10 => "battery_type_c",
                                11 => "battery_type_cr123a",
                                12 => "battery_type_cr2",
                                13 => "battery_type_cr5",
                                14 => "battery_type_d",
                                15 => "battery_type_lithium_ion",
                                16 => "battery_type_lithium_metal",
                                17 => "battery_type_L-SC",
                                18 => "battery_type_p76",
                                19 => "battery_type_product_specific",
                                20 => "battery_type_SC",
                            ],
                    ],
                /*"depends" => [
                    "{$i}Battery_BatterySubgroup_NumberOfBatteries" => "NumberOfBatteries"
                ]*/
            ],
            "{$i}Battery_BatterySubgroup_NumberOfBatteries" => [
                "sequence" => "{$s}10\\30\\20",
                "name" => "NumberOfBatteries",
                "dataType" => "positiveInteger",
                "minOccurs" => "0",
                /*"depends" => [
                    "{$i}Battery_BatterySubgroup_BatteryType" => "BatteryType"
                ]*/
            ],
            "{$i}CanShipInOriginalContainer" => [
                "sequence" => "{$s}20",
                "name" => "CanShipInOriginalContainer",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}30",
                "name" => "ColorMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Finish" => [
                "sequence" => "{$s}40",
                "name" => "Finish",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}IdentityPackageType" => [
                "sequence" => "{$s}50",
                "name" => "IdentityPackageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                        "optionValues" => [
                                0 => "bulk",
                                1 => "frustration_free",
                                2 => "traditional",
                            ],
                    ],
            ],
            "{$i}IsStainResistant" => [
                "sequence" => "{$s}60",
                "name" => "IsStainResistant",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}LightSourceType" => [
                "sequence" => "{$s}70",
                "name" => "LightSourceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Material" => [
                "sequence" => "{$s}80",
                "name" => "Material",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}MaximumCoverageArea" => [
                "sequence" => "{$s}90",
                "name" => "MaximumCoverageArea",
                "dataType" => "PositiveDimension", //"AreaDimensionOptionalUnit",
                "minOccurs" => "0",
                "attribute" => "{$i}MaximumCoverageArea_unitOfMeasure_AreaUnitOfMeasure"
            ],
            "{$i}NumberOfSets" => [
                "sequence" => "{$s}100",
                "name" => "NumberOfSets",
                "dataType" => "TenDigitInteger",
                "minOccurs" => "0",
            ],
            "{$i}OutputCapacity" => [
                "sequence" => "{$s}110",
                "name" => "OutputCapacity",
                "dataType" => "PositiveDimension", //"VolumeRateDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}OutputCapacity_unitOfMeasure_VolumeRateUnitOfMeasure"
            ],
            "{$i}PieceCount" => [
                "sequence" => "{$s}120",
                "name" => "PieceCount",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}Shape" => [
                "sequence" => "{$s}130",
                "name" => "Shape",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ThreadCount" => [
                "sequence" => "{$s}140",
                "name" => "ThreadCount",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}TowelWeight" => [
                "sequence" => "{$s}150",
                "name" => "TowelWeight",
                "dataType" => "PositiveDimension", //"WeightDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}TowelWeight_unitOfMeasure_WeightUnitOfMeasure"
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}160",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "Scent",
                        3 => "Size-Color",
                        4 => "Size-Scent",
                        5 => "DisplayLength-DisplayWidth",
                        6 => "DisplayLength-Material",
                        7 => "DisplayLength-Size",
                        8 => "DisplayLength-Color",
                        9 => "DisplayLength-DisplayHeight",
                        10 => "DisplayWidth-Material",
                        11 => "DisplayWidth-Size",
                        12 => "DisplayWidth-Color",
                        13 => "DisplayWidth-DisplayHeight",
                        14 => "ItemPackageQuantity-Material",
                        15 => "ItemPackageQuantity-Size",
                        16 => "ItemPackageQuantity-Color",
                        17 => "ItemPackageQuantity-DisplayHeight",
                        18 => "DisplayWeight-ItemPackageQuantity",
                        19 => "DisplayWeight-Material",
                        20 => "DisplayWeight-Size",
                        21 => "DisplayWeight-Color",
                        22 => "DisplayWeight-DisplayHeight",
                        23 => "Material-DisplayLength",
                        24 => "Material-DisplayWidth",
                        25 => "Material-Size",
                        26 => "Material-Color",
                        27 => "Material-DisplayHeight",
                        28 => "Size-DisplayLength",
                        29 => "Size-DisplayWidth",
                        30 => "Size-DisplayWeight",
                        31 => "Size-Material",
                        32 => "Size-Color",
                        33 => "Size-DisplayHeight",
                        34 => "Color-DisplayLength",
                        35 => "Color-DisplayWidth",
                        36 => "Color-ItemPackageQuantity",
                        37 => "Color-DisplayWeight",
                        38 => "Color-Material",
                        39 => "Color-Size",
                        40 => "Color-DisplayHeight",
                        41 => "DisplayHeight",
                        42 => "Material",
                        43 => "DisplayWeight",
                        44 => "DisplayLength",
                        45 => "ItemPackageQuantity",
                        46 => "DisplayLength-PatternName",
                        47 => "DisplayLength-StyleName",
                        48 => "DisplayWidth-PatternName",
                        49 => "DisplayWidth-StyleName",
                        50 => "Occasion-PatternName",
                        51 => "Occasion-ItemPackageQuantity",
                        52 => "Occasion-Material",
                        53 => "Occasion-StyleName",
                        54 => "Occasion-Size",
                        55 => "Occasion-Color",
                        56 => "Occasion-DisplayHeight",
                        57 => "PatternName-DisplayLength",
                        58 => "PatternName-DisplayWidth",
                        59 => "PatternName-Occasion",
                        60 => "PatternName-Material",
                        61 => "PatternName-StyleName",
                        62 => "PatternName-Size",
                        63 => "PatternName-Color",
                        64 => "PatternName-DisplayHeight",
                        65 => "MatteStyle-Material",
                        66 => "MatteStyle-StyleName",
                        67 => "MatteStyle-Size",
                        68 => "MatteStyle-Color",
                        69 => "ItemPackageQuantity-Occasion",
                        70 => "ItemPackageQuantity-StyleName",
                        71 => "DisplayWeight-StyleName",
                        72 => "Material-PatternName",
                        73 => "Material-MatteStyle",
                        74 => "Material-StyleName",
                        75 => "StyleName-DisplayLength",
                        76 => "StyleName-DisplayWidth",
                        77 => "StyleName-Occasion",
                        78 => "StyleName-PatternName",
                        79 => "StyleName-DisplayWeight",
                        80 => "StyleName-Material",
                        81 => "StyleName-Size",
                        82 => "StyleName-Color",
                        83 => "Size-Occasion",
                        84 => "Size-PatternName",
                        85 => "Size-MatteStyle",
                        86 => "Size-StyleName",
                        87 => "Color-Occasion",
                        88 => "Color-PatternName",
                        89 => "Color-MatteStyle",
                        90 => "Color-StyleName",
                        91 => "MatteStyle",
                        92 => "PatternName",
                        93 => "Occasion",
                        94 => "StyleName",
                        95 => "CustomerPackageType",
                        96 => "ColorName-CustomerPackageType",
                        97 => "SizeName-CustomerPackageType",
                        98 => "SizeName-ColorName-CustomerPackageType",
                        99 => "StyleName-CustomerPackageType",
                        100 => "SizeName-StyleName-CustomerPackageType",
                    ],
                ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}170",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}180",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}190",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_StyleName" => [
                "sequence" => "{$s}200",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_CustomerPackageType" => [
                "sequence" => "{$s}210",
                "name" => "CustomerPackageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Wattage" => [
                "sequence" => "{$s}220",
                "name" => "Wattage",
                "dataType" => "PositiveDimension", //"WattageDimensionOptionalUnit",
                "minOccurs" => "0",
                "attribute" => "{$i}Wattage_unitOfMeasure_WattageUnitOfMeasure"
            ],
            "{$i}AdjustmentType" => [
                "sequence" => "{$s}230",
                "name" => "AdjustmentType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}FormFactor" => [
                "sequence" => "{$s}240",
                "name" => "FormFactor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}FrameType" => [
                "sequence" => "{$s}250",
                "name" => "FrameType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}InstallationType" => [
                "sequence" => "{$s}260",
                "name" => "InstallationType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemHardness" => [
                "sequence" => "{$s}270",
                "name" => "ItemHardness",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}280",
                "name" => "ItemStyling",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}LineWeight" => [
                "sequence" => "{$s}290",
                "name" => "LineWeight",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}NumberOfDoors" => [
                "sequence" => "{$s}300",
                "name" => "NumberOfDoors",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}OccasionType" => [
                "sequence" => "{$s}310",
                "name" => "OccasionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}PaintType" => [
                "sequence" => "{$s}320",
                "name" => "PaintType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}PaperSize" => [
                "sequence" => "{$s}330",
                "name" => "PaperSize",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}SeatingCapacity" => [
                "sequence" => "{$s}340",
                "name" => "SeatingCapacity",
                "dataType" => "PositiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}SpecificUsesForProduct" => [
                "sequence" => "{$s}350",
                "name" => "SpecificUsesForProduct",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Theme" => [
                "sequence" => "{$s}360",
                "name" => "Theme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}MaterialComposition" => [
                "sequence" => "{$s}370",
                "name" => "MaterialComposition",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ItemTypeName" => [
                "sequence" => "{$s}380",
                "name" => "ItemTypeName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}PowerSourceType" => [
                "sequence" => "{$s}390",
                "name" => "PowerSourceType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}BatteryCellComposition" => [
                "sequence" => "{$s}400",
                "name" => "BatteryCellComposition",
                "dataType" => "StringNotNull", //"BatteryCellTypeValues",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        0 => "NiCAD",
                        1 => "NiMh",
                        2 => "alkaline",
                        3 => "aluminum_oxygen",
                        4 => "lead_acid",
                        5 => "lead_calcium",
                        6 => "lithium",
                        7 => "lithium_ion",
                        8 => "lithium_manganese_dioxide",
                        9 => "lithium_metal",
                        10 => "lithium_polymer",
                        11 => "manganese",
                        12 => "polymer",
                        13 => "silver_oxide",
                        14 => "zinc",
                    ],
                ],
            ],
            "{$i}BatteryDescription" => [
                "sequence" => "{$s}410",
                "name" => "BatteryDescription",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}BatteryFormFactor" => [
                "sequence" => "{$s}420",
                "name" => "BatteryFormFactor",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}LithiumBatteryWeight" => [
                "sequence" => "{$s}430",
                "name" => "LithiumBatteryWeight",
                "dataType" => "decimal",
                "minOccurs" => "0",
            ],
            "{$i}BatteryAverageLife" => [
                "sequence" => "{$s}440",
                "name" => "BatteryAverageLife",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
            ],
            "{$i}BatteryAverageLifeStandby" => [
                "sequence" => "{$s}450",
                "name" => "BatteryAverageLifeStandby",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
            ],
            "{$i}BatteryChargeTime" => [
                "sequence" => "{$s}460",
                "name" => "BatteryChargeTime",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
            ],
            "{$i}LithiumBatteryEnergyContent" => [
                "sequence" => "{$s}470",
                "name" => "LithiumBatteryEnergyContent",
                "dataType" => "decimal",
                "minOccurs" => "0",
            ],
            "{$i}LithiumBatteryPackaging" => [
                "sequence" => "{$s}480",
                "name" => "LithiumBatteryPackaging",
                "minOccurs" => "0",
                "dataType" => "string",
                "restriction" => [
                        "optionValues" => [
                                0 => "batteries_contained_in_equipment",
                                1 => "batteries_only",
                                2 => "batteries_packed_with_equipment",
                            ],
                    ],
            ],
            "{$i}LithiumBatteryVoltage" => [
                "sequence" => "{$s}490",
                "name" => "LithiumBatteryVoltage",
                "dataType" => "decimal",
                "minOccurs" => "0",
            ],
            "{$i}NumberOfLithiumIonCells" => [
                "sequence" => "{$s}500",
                "name" => "NumberOfLithiumIonCells",
                "dataType" => "positiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}NumberOfLithiumMetalCells" => [
                "sequence" => "{$s}510",
                "name" => "NumberOfLithiumMetalCells",
                "dataType" => "positiveInteger",
                "minOccurs" => "0",
            ],
            "{$i}SellerWarrantyDescription" => [
                "sequence" => "{$s}520",
                "name" => "SellerWarrantyDescription",
                "dataType" => "SuperLongStringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}SizeMap" => [
                "sequence" => "{$s}530",
                "name" => "SizeMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}CustomerRestrictionType" => [
                "sequence" => "{$s}540",
                "name" => "CustomerRestrictionType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}Efficiency" => [
                "sequence" => "{$s}550",
                "name" => "Efficiency",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = $this->i;

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}SeatHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayLength_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayHeight_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayWidth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDepth_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayDiameter_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];

        $subAttributes["{$i}DisplayVolume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}DisplayWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                        0 => "GR",
                        1 => "KG",
                        2 => "OZ",
                        3 => "LB",
                        4 => "MG",
                    ],
                ],
            "default" => "KG"
        ];

        $subAttributes["{$i}Volume_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        $subAttributes["{$i}VolumeCapacity_unitOfMeasure_VolumeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "cubic-cm",
                            1 => "cubic-ft",
                            2 => "cubic-in",
                            3 => "cubic-m",
                            4 => "cubic-yd",
                            5 => "cup",
                            6 => "fluid-oz",
                            7 => "gallon",
                            8 => "liter",
                            9 => "milliliter",
                            10 => "ounce",
                            11 => "pint",
                            12 => "quart",
                            13 => "liters",
                            14 => "deciliters",
                            15 => "centiliters",
                            16 => "milliliters",
                            17 => "microliters",
                            18 => "nanoliters",
                            19 => "picoliters",
                        ],
                ],
            "default" => "cubic-cm"
        ];

        switch ($this->subCategory) {
            case "FurnitureAndDecor":
                $subAttributes = array_merge($subAttributes, $this->getSubFurnitureAndDecor());
                break;
                case "OutdoorLiving":
                $subAttributes = array_merge($subAttributes, $this->getSubOutdoorLiving());
                break;
        }

        return $subAttributes;
    }

    public function getSubFurnitureAndDecor()
    {
        $i = "ProductData_Home_ProductType_FurnitureAndDecor_";
        $subAttributes = [
            "{$i}MaximumCoverageArea_unitOfMeasure_AreaUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "square-in",
                                1 => "square-ft",
                                2 => "square-cm",
                                3 => "square-m",
                            ],
                    ],
                "default" => "square-cm"
            ],
            "{$i}OutputCapacity_unitOfMeasure_VolumeRateUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                                0 => "milliliters per second",
                                1 => "centiliters per second",
                                2 => "liters per second",
                                3 => "milliliters per minute",
                                4 => "liters per minute",
                                5 => "microliters per second",
                                6 => "nanoliters per second",
                                7 => "picoliters per second",
                                8 => "microliters per minute",
                                9 => "nanoliters per minute",
                                10 => "picoliters per minute",
                                11 => "gallons_per_day",
                                12 => "gallons_per_day",
                                13 => "liters_per_day",
                                14 => "liters",
                            ],
                    ],
                "default" => "milliliters per second"
            ],
            "{$i}TowelWeight_unitOfMeasure_WeightUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                            0 => "GR",
                            1 => "KG",
                            2 => "OZ",
                            3 => "LB",
                            4 => "MG",
                        ],
                    ],
                "default" => "KG"
            ],
            "{$i}Wattage_unitOfMeasure_WattageUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" => [
                        "optionValues" => [
                            0 => "watts",
                            1 => "kilowatts",
                        ],
                    ],
                "default" => "watts"
            ],
        ];
        return $subAttributes;
    }

    public function getSubOutdoorLiving()
    {
        $i = $this->i . "ProductType_OutdoorLiving_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}UnitCount_unitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "default" => "Count"
        ];
        return $subAttributes;
    }
}
