<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Health extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_HEALTH_MISC = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PERSONAL_CARE_APPLIANCES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PRESCRIPTION_DRUG = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DIETARY_SUPPLEMENTS = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_OTCMEDICATION = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_PRESCRIPTION_EYE_WEAR = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];
    const ALLOWED_MARKETPLACE_SEXUAL_WELLNESS = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA
    ];

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Health';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "HealthMisc":
                $this->attributes = array_merge($this->attributes, $this->getHealthMisc());
                break;
            case "PersonalCareAppliances":
                $this->attributes = array_merge($this->attributes, $this->getPersonalCareAppliances());
                break;
            case "PrescriptionDrug":
                $this->attributes = array_merge($this->attributes, $this->getPrescriptionDrug());
                break;
            case "DietarySupplements":
                $this->attributes = array_merge($this->attributes, $this->getDietarySupplements());
                break;
            case "OTCMedication":
                $this->attributes = array_merge($this->attributes, $this->getOTCMedication());
                break;
            case "PrescriptionEyewear":
                $this->attributes = array_merge($this->attributes, $this->getPrescriptionEyewear());
                break;
            case "SexualWellness":
                $this->attributes = array_merge($this->attributes, $this->getSexualWellness());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_";
        $common = [
            "{$i}MedicineClassification" => [
                "sequence" => "{$s}300",
                "name" => "MedicineClassification",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getHealthMisc()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         * ProductType => 10
         * HealthMisc => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_ProductType_HealthMisc_";

        $this->attributes = [
            "ProductData_Health_ProductType_HealthMisc" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "HealthMisc",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Size",
                                "Color",
                                "Count",
                                "Scent",
                                "Flavor",
                                "Size-Color",
                                "Flavor-Count",
                                "Flavor-Size",
                                "Size-Scent",
                                "Size-UnitCount",
                                "CustomerPackageType",
                                "ColorName-CustomerPackageType",
                                "SizeName-CustomerPackageType",
                                "SizeName-ColorName-CustomerPackageType",
                                "StyleName-CustomerPackageType",
                                "SizeName-StyleName-CustomerPackageType",
                                "Opticalpower-Basecurveradius-Itemdiameterstring-Cylindercorrection-Cylinderaxis-unitcount",
                                "Opticalpower-Basecurveradius-Itemdiameterstring-Lensadditionpower-Unitcount",
                                "Opticalpower-Basecurveradius-Itemdiameterstring-Unitcount",
                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\50",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\100",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\110",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}150",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}160",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],

        ];
        return $this->attributes;
    }

    public function getPersonalCareAppliances()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         * ProductType => 10
         * PersonalCareAppliances => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_ProductType_PersonalCareAppliances_";

        $this->attributes = [
            "ProductData_Health_ProductType_PersonalCareAppliances" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "PersonalCareAppliances",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Size",
                                "Color",
                                "Count",
                                "Size-Color",
                                "Size-UnitCount",
                                "Scent",

                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\60",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\110",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}160",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}350",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}UnitCount" => [
                "sequence" => "{$s}20",
                "name" => "UnitCount",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}UnitCount_unitOfMeasure"
            ],
        ];
        return $this->attributes;
    }

    public function getPrescriptionDrug()
    {
        return [];
    }

    public function getDietarySupplements()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         * ProductType => 10
         * DietarySupplements => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_ProductType_DietarySupplements_";

        $this->attributes = [
            "ProductData_Health_ProductType_DietarySupplements" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "DietarySupplements",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Flavor",
                                "SizeName-CustomerPackageType",
                                "Size-UnitCount",
                                "Scent",

                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\60",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\80",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\110",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}300",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}350",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],

        ];
        return $this->attributes;
    }

    public function getOTCMedication()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         * ProductType => 10
         * OTCMedication => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_ProductType_OTCMedication_";

        $this->attributes = [
            "ProductData_Health_ProductType_OTCMedication" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "OTCMedication",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Flavor",
                                "SizeName-CustomerPackageType",
                                "Size-UnitCount",
                                "Scent",

                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\60",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\80",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\110",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}300",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}350",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],

        ];
        return $this->attributes;
    }

    public function getPrescriptionEyewear()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         * ProductType => 10
         * PrescriptionEyewear => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_ProductType_PrescriptionEyewear_";

        $this->attributes = [
            "ProductData_Health_ProductType_PrescriptionEyewear" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "PrescriptionEyewear",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Flavor",
                                "SizeName-CustomerPackageType",
                                "Size-UnitCount",
                                "Scent",

                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\60",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\80",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\110",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}300",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}350",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],

        ];
        return $this->attributes;
    }

    public function getSexualWellness()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Health => 10
         * ProductType => 10
         * SexualWellness => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Health_ProductType_SexualWellness_";

        $this->attributes = [
            "ProductData_Health_ProductType_SexualWellness" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "SexualWellness",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Color",
                                "Flavor",
                                "SizeName-CustomerPackageType",
                                "Size-UnitCount",
                                "Scent",

                            ],
                    ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\30",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\60",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Flavor" => [
                "sequence" => "{$s}10\\80",
                "name" => "Flavor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Scent" => [
                "sequence" => "{$s}10\\110",
                "name" => "Scent",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}UnitCount" => [
                "sequence" => "{$s}20",
                "name" => "UnitCount",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}UnitCount_unitOfMeasure"
            ],
            "{$i}Ingredients" => [
                "sequence" => "{$s}300",
                "name" => "Ingredients",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}350",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "LongStringNotNull",
            ],

        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Health_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}UnitCount_unitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "default" => "CM"
        ];

        switch ($this->subCategory) {
            case "PersonalCareAppliances":
                $subAttributes = array_merge($subAttributes, $this->getSubPersonalCareAppliances());
                break;
            case "HealthMisc":
                $subAttributes = array_merge($subAttributes, $this->getSubHealthMisc());
                break;

        }
        return $subAttributes;
    }

    public function getSubHealthMisc()
    {
        $i = "ProductData_Health_ProductType_HealthMisc_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}UnitCount_unitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "default" => "Count"
        ];
        return $subAttributes;
    }

    public function getSubPersonalCareAppliances()
    {
        $i = "ProductData_Health_ProductType_PersonalCareAppliances_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}UnitCount_unitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "default" => "Count"
        ];
        return $subAttributes;
    }
}
