<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class EducationSupplies extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA,
    ];
    const ALLOWED_MARKETPLACE_TEACHING_EQUIPMENT = [
        \Amazon\Sdk\Marketplace::MARKETPLACE_ID_INDIA,
    ];

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'EducationSupplies';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "TeachingEquipment":
                $this->attributes = array_merge($this->attributes, $this->getTeachingEquipment());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * EducationSupplies => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_EducationSupplies_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getTeachingEquipment()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * EducationSupplies => 10
         * ProductType => 10
         * TeachingEquipment => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_EducationSupplies_ProductType_TeachingEquipment_";

        $this->attributes = [
            "ProductData_EducationSupplies_ProductType_TeachingEquipment" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "TeachingEquipment",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ]
                ]
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "ColorName",
                        "Color-Material",
                        "ItemPackageQuantity",
                        "ItemPackageQuantity-Size",
                        "Material",
                        "Material-Size",
                        "NumberOfItems",
                        "SizeName",
                        "SizeName-ColorName",
                        "SizeStyle",
                        "StyleName",
                    ]
                ]
            ],
            "{$i}MarkingColor" => [
                "sequence" => "{$s}240",
                "name" => "MarkingColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_EducationSupplies_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
