<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Computers extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_CARRYING_CASE_OR_BAG = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_ADDON = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_COMPONENT = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_COOLING_DEVICE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_DRIVE_OR_STORAGE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_INPUT_DEVICE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_PROCESSOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER_SPEAKER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COMPUTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FLASH_MEMORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_INKOR_TONER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_KEYBOARDS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MEMORY_READER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MONITOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MOTHER_BOARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_NETWORKING_DEVICE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_NOTEBOOK_COMPUTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PERSONAL_COMPUTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PRINTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RAM_MEMORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SCANNER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SOUND_CARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SYSTEM_CABINET = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SYSTEM_POWER_DEVICE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TABLET_COMPUTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEO_CARD = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEO_PROJECTOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_WEBCAM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    /**
     * Sequence prefix
     * ProductData => 100
     * Computers => 10
     */
    public $i = "ProductData_Computers_";

    /**
     * Index prefix
     */
    public $s = "100\\10\\";

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Computers';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;
        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "CarryingCaseOrBag":
                $this->attributes = array_merge($this->attributes, $this->getCarryingCaseOrBag());
                break;

            case "ComputerAddOn":
                $this->attributes = array_merge($this->attributes, $this->getComputerAddOn());
                break;
            case "ComputerComponent":
                $this->attributes = array_merge($this->attributes, $this->getComputerComponent());
                break;
            case "ComputerCoolingDevice":
                $this->attributes = array_merge($this->attributes, $this->getComputerCoolingDevice());
                break;
            case "ComputerDriveOrStorage":
                $this->attributes = array_merge($this->attributes, $this->getComputerDriveOrStorage());
                break;
            case "ComputerInputDevice":
                $this->attributes = array_merge($this->attributes, $this->getComputerInputDevice());
                break;
            case "ComputerProcessor":
                $this->attributes = array_merge($this->attributes, $this->getComputerProcessor());
                break;
            case "ComputerSpeaker":
                $this->attributes = array_merge($this->attributes, $this->getComputerSpeaker());
                break;
            case "Computer":
                $this->attributes = array_merge($this->attributes, $this->getComputer());
                break;
            case "FlashMemory":
                $this->attributes = array_merge($this->attributes, $this->getFlashMemory());
                break;
            case "InkOrToner":
                $this->attributes = array_merge($this->attributes, $this->getInkOrToner());
                break;
            case "Keyboards":
                $this->attributes = array_merge($this->attributes, $this->getKeyboards());
                break;
            case "MemoryReader":
                $this->attributes = array_merge($this->attributes, $this->getMemoryReader());
                break;
            case "Monitor":
                $this->attributes = array_merge($this->attributes, $this->getMonitor());
                break;
            case "Motherboard":
                $this->attributes = array_merge($this->attributes, $this->getMotherboard());
                break;
            case "NetworkingDevice":
                $this->attributes = array_merge($this->attributes, $this->getNetworkingDevice());
                break;
            case "NotebookComputer":
                $this->attributes = array_merge($this->attributes, $this->getNotebookComputer());
                break;
            case "PersonalComputer":
                $this->attributes = array_merge($this->attributes, $this->getPersonalComputer());
                break;
            case "Printer":
                $this->attributes = array_merge($this->attributes, $this->getPrinter());
                break;
            case "RamMemory":
                $this->attributes = array_merge($this->attributes, $this->getRamMemory());
                break;
            case "Scanner":
                $this->attributes = array_merge($this->attributes, $this->getScanner());
                break;
            case "SoundCard":
                $this->attributes = array_merge($this->attributes, $this->getSoundCard());
                break;
            case "SystemCabinet":
                $this->attributes = array_merge($this->attributes, $this->getSystemCabinet());
                break;
            case "SystemPowerDevice":
                $this->attributes = array_merge($this->attributes, $this->getSystemPowerDevice());
                break;
            case "TabletComputer":
                $this->attributes = array_merge($this->attributes, $this->getTabletComputer());
                break;
            case "VideoCard":
                $this->attributes = array_merge($this->attributes, $this->getVideoCard());
                break;
            case "VideoProjector":
                $this->attributes = array_merge($this->attributes, $this->getVideoProjector());
                break;
            case "Webcam":
                $this->attributes = array_merge($this->attributes, $this->getWebcam());
                break;
        }

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getCarryingCaseOrBag()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * CarryingCaseOrBag => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_CarryingCaseOrBag_";

        $attributes = [
            "ProductData_Computers_ProductType_CarryingCaseOrBag" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CarryingCaseOrBag",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CheckpointTSAFriendly" => [
                "sequence" => "{$s}20",
                "name" => "CheckpointTSAFriendly",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleDeviceSize" => [
                "sequence" => "{$s}30",
                "name" => "CompatibleDeviceSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleDeviceFormFactor" => [
                "sequence" => "{$s}40",
                "name" => "CompatibleDeviceFormFactor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HandOrientation" => [
                "sequence" => "{$s}50",
                "name" => "HandOrientation",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HolderCapacity" => [
                "sequence" => "{$s}60",
                "name" => "HolderCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}70",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}80",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getComputerAddOn()
    {

        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerAddOn => 20
         */
        $s = "100\\10\\10\\20\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerAddOn_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerAddOn" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "ComputerAddOn",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CableType" => [
                "sequence" => "{$s}20",
                "name" => "CableType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleDevices" => [
                "sequence" => "{$s}30",
                "name" => "CompatibleDevices",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleDeviceSize" => [
                "sequence" => "{$s}40",
                "name" => "CompatibleDeviceSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Conductor" => [
                "sequence" => "{$s}50",
                "name" => "Conductor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}100",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfFans" => [
                "sequence" => "{$s}110",
                "name" => "NumberOfFans",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getComputerComponent()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerComponent => 30
         */
        $s = "100\\10\\10\\30\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerComponent_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerComponent" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "ComputerComponent",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AudioOutputMode" => [
                "sequence" => "{$s}20",
                "name" => "AudioOutputMode",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ChipsetType" => [
                "sequence" => "{$s}30",
                "name" => "ChipsetType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleProcessorTypes" => [
                "sequence" => "{$s}40",
                "name" => "CompatibleProcessorTypes",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CommunicationInterface" => [
                "sequence" => "{$s}50",
                "name" => "CommunicationInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConnectorType" => [
                "sequence" => "{$s}100",
                "name" => "ConnectorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DigitalAudioCapacity" => [
                "sequence" => "{$s}110",
                "name" => "DigitalAudioCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InputType" => [
                "sequence" => "{$s}150",
                "name" => "InputType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MovementDetectionTechnology" => [
                "sequence" => "{$s}350",
                "name" => "MovementDetectionTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScannerResolution" => [
                "sequence" => "{$s}450",
                "name" => "ScannerResolution",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpeedRating" => [
                "sequence" => "{$s}550",
                "name" => "SpeedRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getComputerCoolingDevice()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerCoolingDevice => 40
         */
        $s = "100\\10\\10\\40\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerCoolingDevice_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerCoolingDevice" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "ComputerCoolingDevice",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}20",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CoolingType" => [
                "sequence" => "{$s}30",
                "name" => "CoolingType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CPUSocketCompatability" => [
                "sequence" => "{$s}40",
                "name" => "CPUSocketCompatability",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FanIncluded" => [
                "sequence" => "{$s}50",
                "name" => "FanIncluded",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}FanLED" => [
                "sequence" => "{$s}100",
                "name" => "FanLED",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}110",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getComputerDriveOrStorage()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerDriveOrStorage => 50
         */
        $s = "100\\10\\10\\50\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerDriveOrStorage_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerDriveOrStorage" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "ComputerDriveOrStorage",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ACAdapterIncluded" => [
                "sequence" => "{$s}20",
                "name" => "ACAdapterIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}Averagelatency" => [
                "sequence" => "{$s}30",
                "name" => "Averagelatency",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}Averageseektime" => [
                "sequence" => "{$s}40",
                "name" => "Averageseektime",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}Averagewritetime" => [
                "sequence" => "{$s}50",
                "name" => "Averagewritetime",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}CableInterface" => [
                "sequence" => "{$s}100",
                "name" => "CableInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfexternalBays" => [
                "sequence" => "{$s}210",
                "name" => "NumberOfexternalBays",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfHardDrives" => [
                "sequence" => "{$s}220",
                "name" => "NumberOfHardDrives",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfInternalBays" => [
                "sequence" => "{$s}230",
                "name" => "NumberOfInternalBays",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}OpticalDriveType" => [
                "sequence" => "{$s}250",
                "name" => "OpticalDriveType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SSDConnectorPins" => [
                "sequence" => "{$s}270",
                "name" => "SSDConnectorPins",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}StorageMaterialType" => [
                "sequence" => "{$s}300",
                "name" => "StorageMaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}StorageReadSpeed" => [
                "sequence" => "{$s}310",
                "name" => "StorageReadSpeed",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}StorageWriteSpeed" => [
                "sequence" => "{$s}320",
                "name" => "StorageWriteSpeed",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}TotalFirewire1600Connectors" => [
                "sequence" => "{$s}350",
                "name" => "TotalFirewire1600Connectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalFirewire3200Connectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalFirewire3200Connectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalFirewire400Connectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalFirewire400Connectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalFirewire800Connectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalFirewire800Connectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalSataConnectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalSataConnectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalSataConnectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalSataConnectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalUSB1.0Connectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalUSB1.0Connectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TotalUSB1.1Connectors" => [
                "sequence" => "{$s}320",
                "name" => "TotalUSB1.0Connectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ]
        ];
        return $attributes;
    }

    public function getComputerInputDevice()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerInputDevice => 60
         */
        $s = "100\\10\\10\\60\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerInputDevice_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerInputDevice" => [
                "sequence" => "100\\10\\10\\60",
                "name" => "ComputerInputDevice",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}20",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BuiltInMicrophone" => [
                "sequence" => "{$s}30",
                "name" => "BuiltInMicrophone",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DeviceHardwareCompatability" => [
                "sequence" => "{$s}40",
                "name" => "DeviceHardwareCompatability",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DeviceSoftwareCompatability" => [
                "sequence" => "{$s}50",
                "name" => "DeviceSoftwareCompatability",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HeadphoneStyle" => [
                "sequence" => "{$s}60",
                "name" => "FanLED",
                "minOccurs" => "0",
                "dataType" => "HeadphoneStyle",
            ],
            "{$i}InputDeviceDesignStyle" => [
                "sequence" => "{$s}70",
                "name" => "InputDeviceDesignStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}70",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NoiseCanceling" => [
                "sequence" => "{$s}150",
                "name" => "NoiseCanceling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfButtons" => [
                "sequence" => "{$s}170",
                "name" => "NumberOfButtons",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PresentationRemoteLaserColor" => [
                "sequence" => "{$s}180",
                "name" => "PresentationRemoteLaserColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PrimaryHeadphoneUse" => [
                "sequence" => "{$s}200",
                "name" => "PrimaryHeadphoneUse",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}TrackingMethod" => [
                "sequence" => "{$s}220",
                "name" => "TrackingMethod",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getComputerProcessor()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerProcessor => 70
         */
        $s = "100\\10\\10\\70\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerProcessor_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerProcessor" => [
                "sequence" => "100\\10\\10\\70",
                "name" => "ComputerProcessor",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}20",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}50",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorBrand" => [
                "sequence" => "{$s}60",
                "name" => "ProcessorBrand",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorCoolingDevice" => [
                "sequence" => "{$s}70",
                "name" => "ProcessorCoolingDevice",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorCount" => [
                "sequence" => "{$s}70",
                "name" => "ProcessorCount",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ProcessorSeriesTypeValues" => [
                "sequence" => "{$s}100",
                "name" => "ProcessorSeriesTypeValues",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "athlon_64",
                                "athlon_64_x2",
                                "intel_atom_230",
                                "intel_atom_330",
                                "intel_atom_n450",
                                "intel_atom_n455",
                                "intel_atom_z520",
                                "intel_atom_z530",
                                "intel_xeon",
                                "pentium_4",
                                "sempron",
                            ],
                    ],
            ],
            "{$i}ProcessorSocket" => [
                "sequence" => "{$s}120",
                "name" => "ProcessorSocket",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorSpeed" => [
                "sequence" => "{$s}150",
                "name" => "ProcessorSpeed",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ProcessorSpeed_unitOfMeasure_FrequencyUnitOfMeasure"
            ],

        ];
        return $attributes;
    }

    public function getComputerSpeaker()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * ComputerSpeaker => 80
         */
        $s = "100\\10\\10\\80\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_ComputerSpeaker_";

        $attributes = [
            "ProductData_Computers_ProductType_ComputerSpeaker" => [
                "sequence" => "100\\10\\10\\80",
                "name" => "ComputerSpeaker",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}20",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AudioOutputMode" => [
                "sequence" => "{$s}30",
                "name" => "AudioOutputMode",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CommunicationInterface" => [
                "sequence" => "{$s}40",
                "name" => "CommunicationInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DigitalAudioCapacity" => [
                "sequence" => "{$s}40",
                "name" => "DigitalAudioCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FrequencyRange" => [
                "sequence" => "{$s}50",
                "name" => "FrequencyRange",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InputType" => [
                "sequence" => "{$s}60",
                "name" => "InputType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MemorySlotsAvailable" => [
                "sequence" => "{$s}100",
                "name" => "MemorySlotsAvailable",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}110",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SpeakerDiameter" => [
                "sequence" => "{$s}250",
                "name" => "SpeakerDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}SpeakerDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],

        ];
        return $attributes;
    }

    public function getComputer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Computer => 90
         */
        $s = "100\\10\\10\\90\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Computer_";

        $attributes = [
            "ProductData_Computers_ProductType_Computer" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "Computer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConnectorNumber" => [
                "sequence" => "{$s}50",
                "name" => "ConnectorNumber",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}110",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfUSBHubConnectorPorts" => [
                "sequence" => "{$s}120",
                "name" => "NumberOfUSBHubConnectorPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}TVTunerMemory" => [
                "sequence" => "{$s}220",
                "name" => "TVTunerMemory",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}TVTunerMemory_unitOfMeasure_MemorySizeUnitOfMeasure"
            ],
            "{$i}TVTunerVideoOutputInterface" => [
                "sequence" => "{$s}330",
                "name" => "TVTunerVideoOutputInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}TVTunerVideoStandard" => [
                "sequence" => "{$s}350",
                "name" => "TVTunerVideoStandard",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],

        ];
        return $attributes;
    }

    public function getFlashMemory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * FlashMemory => 100
         */
        $s = "100\\10\\10\\100\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_FlashMemory_";

        $attributes = [
            "ProductData_Computers_ProductType_FlashMemory" => [
                "sequence" => "100\\10\\10\\100",
                "name" => "FlashMemory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AudioOutputMode" => [
                "sequence" => "{$s}40",
                "name" => "AudioOutputMode",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DigitalAudioCapacity" => [
                "sequence" => "{$s}40",
                "name" => "DigitalAudioCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MemoryCardType" => [
                "sequence" => "{$s}50",
                "name" => "MemoryCardType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "compactflash_type_i",
                                "compactflash_type_ii",
                                "hs_mmc",
                                "memory_stick",
                                "memory_stick_duo",
                                "memory_stick_micro",
                                "memory_stick_pro",
                                "memory_stick_pro_duo",
                                "memory_stick_pro_hg_duo",
                                "memory_stick_select",
                                "memory_stick_xc",
                                "memory_stick_xc_hg_micro",
                                "memory_stick_xc_micro",
                                "MiCard",
                                "microsd",
                                "micro_sdhc",
                                "micro_sdxc",
                                "minisd",
                                "mini_sdhc",
                                "mini_sdxc",
                                "mmc_micro",
                                "multimedia_card",
                                "multimedia_card_mobile",
                                "multimedia_card_plus",
                                "rs_mmc",
                                "sdhc",
                                "sdio",
                                "sdxc",
                                "secure_digital",
                                "secure_mmc",
                                "smartmedia_card",
                                "transflash",
                                "xd_picture_card",
                                "xd_picture_card_h",
                                "xd_picture_card_m",
                                "xd_picture_card_m_plus",
                            ],
                    ],
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}60",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],

        ];
        return $attributes;
    }

    public function getInkOrToner()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * InkOrToner => 120
         */
        $s = "100\\10\\10\\120\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_InkOrToner_";

        $attributes = [
            "ProductData_Computers_ProductType_InkOrToner" => [
                "sequence" => "100\\10\\10\\120",
                "name" => "InkOrToner",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InkColor" => [
                "sequence" => "{$s}30",
                "name" => "InkColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InkOrTonerCompatibleDevices" => [
                "sequence" => "{$s}40",
                "name" => "InkOrTonerCompatibleDevices",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getKeyboards()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Keyboards => 130
         */
        $s = "100\\10\\10\\130\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Keyboards_";

        $attributes = [
            "ProductData_Computers_ProductType_Keyboards" => [
                "sequence" => "100\\10\\10\\130",
                "name" => "Keyboards",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HandOrientation" => [
                "sequence" => "{$s}30",
                "name" => "HandOrientation",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}InputDeviceDesignStyle" => [
                "sequence" => "{$s}40",
                "name" => "InputDeviceDesignStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}50",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WirelessInputDeviceProtocol" => [
                "sequence" => "{$s}100",
                "name" => "WirelessInputDeviceProtocol",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "2.4_ghz_radio_frequency",
                                "5.8_ghz_radio_frequency",
                            ],
                    ],
            ],
            "{$i}WirelessInputDeviceTechnology" => [
                "sequence" => "{$s}110",
                "name" => "WirelessInputDeviceTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "bluetooth",
                                "infrared",
                                "ps/2",
                                "radio_frequency",
                                "usb",
                            ],
                    ],
            ],
        ];
        return $attributes;
    }

    public function getMemoryReader()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * MemoryReader => 140
         */
        $s = "100\\10\\10\\140\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_MemoryReader_";

        $attributes = [
            "ProductData_Computers_ProductType_MemoryReader" => [
                "sequence" => "100\\10\\10\\140",
                "name" => "MemoryReader",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AudioOutputMode" => [
                "sequence" => "{$s}40",
                "name" => "AudioOutputMode",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CardReaderInterface" => [
                "sequence" => "{$s}50",
                "name" => "CardReaderInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "firewire_1600",
                                "firewire_3200",
                                "firewire_400",
                                "firewire_800",
                                "firewire_esata",
                                "usb1.0",
                                "usb1.1",
                                "usb2.0",
                                "usb3.0",
                            ],
                    ],
            ],
            "{$i}CommunicationInterface" => [
                "sequence" => "{$s}60",
                "name" => "CommunicationInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CompatibleMemoryCard" => [
                "sequence" => "{$s}50",
                "name" => "CompatibleMemoryCard",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "compactflash_type_i",
                                "compactflash_type_ii",
                                "hs_mmc",
                                "memory_stick",
                                "memory_stick_duo",
                                "memory_stick_micro",
                                "memory_stick_pro",
                                "memory_stick_pro_duo",
                                "memory_stick_pro_hg_duo",
                                "memory_stick_select",
                                "memory_stick_xc",
                                "memory_stick_xc_hg_micro",
                                "memory_stick_xc_micro",
                                "MiCard",
                                "microsd",
                                "micro_sdhc",
                                "micro_sdxc",
                                "minisd",
                                "mini_sdhc",
                                "mini_sdxc",
                                "mmc_micro",
                                "multimedia_card",
                                "multimedia_card_mobile",
                                "multimedia_card_plus",
                                "rs_mmc",
                                "sdhc",
                                "sdio",
                                "sdxc",
                                "secure_digital",
                                "secure_mmc",
                                "smartmedia_card",
                                "transflash",
                                "xd_picture_card",
                                "xd_picture_card_h",
                                "xd_picture_card_m",
                                "xd_picture_card_m_plus",
                            ],
                    ],
            ],
            "{$i}DigitalAudioCapacity" => [
                "sequence" => "{$s}60",
                "name" => "DigitalAudioCapacity",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}70",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getMonitor()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Monitor => 150
         */
        $s = "100\\10\\10\\150\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Monitor_";

        $attributes = [
            "ProductData_Computers_ProductType_Monitor" => [
                "sequence" => "100\\10\\10\\150",
                "name" => "Keyboards",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ContrastRatio" => [
                "sequence" => "{$s}30",
                "name" => "ContrastRatio",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}DisplayResolutionMaximum" => [
                "sequence" => "{$s}40",
                "name" => "DisplayResolutionMaximum",
                "minOccurs" => "0",
                "dataType" => "FortyString",
            ],
            "{$i}DisplayTechnology" => [
                "sequence" => "{$s}50",
                "name" => "DisplayTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HasColorScreen" => [
                "sequence" => "{$s}60",
                "name" => "HasColorScreen",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}70",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MonitorTunerTechnology" => [
                "sequence" => "{$s}80",
                "name" => "MonitorTunerTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MonitorConnectors" => [
                "sequence" => "{$s}100",
                "name" => "MonitorConnectors",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "audio_video_port",
                                "dmi",
                                "ethernet",
                                "gameport",
                                "hdmi",
                                "ieee_1394",
                                "ps/2",
                                "serial_interface",
                                "usb2.0",
                                "usb3.0",
                                "vga",
                            ],
                    ],
            ],
            "{$i}ScreenResolution" => [
                "sequence" => "{$s}120",
                "name" => "ScreenResolution",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScreenSize" => [
                "sequence" => "{$s}130",
                "name" => "ScreenSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ScreenSize_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}TunerTechnology" => [
                "sequence" => "{$s}150",
                "name" => "TunerTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getMotherboard()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Motherboard => 160
         */
        $s = "100\\10\\10\\160\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Motherboard_";

        $attributes = [
            "ProductData_Computers_ProductType_Motherboard" => [
                "sequence" => "100\\10\\10\\160",
                "name" => "Motherboard",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CPUSocketType" => [
                "sequence" => "{$s}40",
                "name" => "CPUSocketType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FrontSideBusSpeed" => [
                "sequence" => "{$s}50",
                "name" => "FrontSideBusSpeed",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}GraphicsCardInterface" => [
                "sequence" => "{$s}60",
                "name" => "GraphicsCardInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "agp",
                                "integrated",
                                "pci",
                                "pci_e",
                                "unknown",
                            ],
                    ],
            ],
            "{$i}HDMIPorts" => [
                "sequence" => "{$s}70",
                "name" => "HDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}IntegratedAudioChannels" => [
                "sequence" => "{$s}80",
                "name" => "IntegratedAudioChannels",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}MemoryStandard" => [
                "sequence" => "{$s}90",
                "name" => "MemoryStandard",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}100",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MotherboardFormFactor" => [
                "sequence" => "{$s}110",
                "name" => "MotherboardFormFactor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MultiGPUTechnology" => [
                "sequence" => "{$s}120",
                "name" => "MultiGPUTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Northbridge" => [
                "sequence" => "{$s}150",
                "name" => "Northbridge",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfeSATAPorts" => [
                "sequence" => "{$s}200",
                "name" => "NumberOfeSATAPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfEthernetPorts" => [
                "sequence" => "{$s}210",
                "name" => "NumberOfEthernetPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfFireWire400Ports" => [
                "sequence" => "{$s}220",
                "name" => "NumberOfFireWire400Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfFireWire800Ports" => [
                "sequence" => "{$s}230",
                "name" => "NumberOfFireWire800Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfIDEPorts" => [
                "sequence" => "{$s}240",
                "name" => "NumberOfIDEPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMemorySlots" => [
                "sequence" => "{$s}250",
                "name" => "NumberOfMemorySlots",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfPCIExpressSlots" => [
                "sequence" => "{$s}260",
                "name" => "NumberOfPCIExpressSlots",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfSATAPorts" => [
                "sequence" => "{$s}270",
                "name" => "NumberOfPCIExpressSlots",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSBPorts" => [
                "sequence" => "{$s}280",
                "name" => "NumberOfUSBPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}Southbridge" => [
                "sequence" => "{$s}350",
                "name" => "Southbridge",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getNetworkingDevice()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * NetworkingDevice => 170
         */
        $s = "100\\10\\10\\170\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_NetworkingDevice_";

        $attributes = [
            "ProductData_Computers_ProductType_NetworkingDevice" => [
                "sequence" => "100\\10\\10\\170",
                "name" => "NetworkingDevice",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFunctionality" => [
                "sequence" => "{$s}40",
                "name" => "AdditionalFunctionality",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}IPProtocolStandards" => [
                "sequence" => "{$s}50",
                "name" => "IPProtocolStandards",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "802_11_ABG",
                                "802_11_ABGN",
                            ],
                    ],
            ],
            "{$i}LANPortBandwidth" => [
                "sequence" => "{$s}60",
                "name" => "LANPortBandwidth",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LANPortNumber" => [
                "sequence" => "{$s}70",
                "name" => "LANPortNumber",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}80",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModemType" => [
                "sequence" => "{$s}90",
                "name" => "ModemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "cable",
                                "dsl",
                            ],
                    ],
            ],
            "{$i}NetworkAdapterType" => [
                "sequence" => "{$s}100",
                "name" => "NetworkAdapterType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}OperatingSystemCompatability" => [
                "sequence" => "{$s}120",
                "name" => "OperatingSystemCompatability",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SecurityProtocol" => [
                "sequence" => "{$s}130",
                "name" => "SecurityProtocol",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}WirelessTechnology" => [
                "sequence" => "{$s}200",
                "name" => "WirelessTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getNotebookComputer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * NotebookComputer => 180
         */
        $s = "100\\10\\10\\180\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_NotebookComputer_";

        $attributes = [
            "ProductData_Computers_ProductType_NotebookComputer" => [
                "sequence" => "100\\10\\10\\180",
                "name" => "NotebookComputer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalDrives" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalDrives",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "blu_ray",
                                "blu_ray_re",
                                "blu_ray_rom",
                                "blu_ray_rw",
                                "cd_rom",
                                "cd_rw",
                                "dvd",
                                "dvd_cd_rw",
                                "dvd_minus_rw",
                                "dvd_plus_minus_rw",
                                "dvd_plus_r",
                                "dvd_plus_rw",
                                "dvd_r",
                                "dvd_ram",
                                "dvd_rom",
                                "dvd_rw",
                                "floppy",
                                "ide_tape_drive",
                                "jazz",
                                "scsi_cdrom",
                                "scsi_tape_drive",
                                "thumb_drive",
                                "zip",
                            ],
                    ],
            ],
            "{$i}Audio" => [
                "sequence" => "{$s}40",
                "name" => "Audio",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CardReader" => [
                "sequence" => "{$s}50",
                "name" => "CardReader",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "compactflash_type_i",
                                "compactflash_type_ii",
                                "hs_mmc",
                                "memory_stick",
                                "memory_stick_duo",
                                "memory_stick_micro",
                                "memory_stick_pro",
                                "memory_stick_pro_duo",
                                "memory_stick_pro_hg_duo",
                                "memory_stick_select",
                                "memory_stick_xc",
                                "memory_stick_xc_hg_micro",
                                "memory_stick_xc_micro",
                                "MiCard",
                                "microsd",
                                "micro_sdhc",
                                "micro_sdxc",
                                "minisd",
                                "mini_sdhc",
                                "mini_sdxc",
                                "mmc_micro",
                                "multimedia_card",
                                "multimedia_card_mobile",
                                "multimedia_card_plus",
                                "rs_mmc",
                                "sdhc",
                                "sdio",
                                "sdxc",
                                "secure_digital",
                                "secure_mmc",
                                "smartmedia_card",
                                "transflash",
                                "xd_picture_card",
                                "xd_picture_card_h",
                                "xd_picture_card_m",
                                "xd_picture_card_m_plus",
                            ],
                    ],
            ],
            "{$i}ComputerMemoryType" => [
                "sequence" => "{$s}60",
                "name" => "ComputerMemoryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "72_pin_edo_simm",
                                "ddr2_sdram",
                                "ddr3_sdram",
                                "ddr_dram",
                                "ddr_sdram",
                                "dimm",
                                "dram",
                                "edo_dram",
                                "eeprom",
                                "eprom",
                                "fpm_dram",
                                "fpm_ram",
                                "l2_cache",
                                "micro_dimm",
                                "pc2_4200",
                                "pc2_4300",
                                "pc2_5300",
                                "pc2_5400",
                                "pc2_6000",
                                "pc_100_sdram",
                                "pc_1066",
                                "pc_133_sdram",
                                "pc_1600",
                                "pc_2100_ddr",
                                "pc_2700_ddr",
                                "pc_3000",
                                "pc_3200_ddr",
                                "pc_3500_ddr",
                                "pc_3700",
                                "pc_4000_ddr",
                                "pc_4200",
                                "pc_4300",
                                "pc_4400",
                                "pc_66_sdram",
                                "pc_800",
                                "rambus",
                                "rdram",
                                "rimm",
                                "sdram",
                                "sgram",
                                "simm",
                                "sipp",
                                "sldram",
                                "sodimm",
                                "sorimm",
                                "sram",
                                "unknown",
                                "vram",
                                "wram",
                            ],
                    ],
            ],
            "{$i}ComputerTunerTechnology" => [
                "sequence" => "{$s}70",
                "name" => "ComputerTunerTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ComputerWirelessType" => [
                "sequence" => "{$s}80",
                "name" => "ComputerWirelessType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "2.4_ghz_radio_frequency",
                                "5.8_ghz_radio_frequency",
                                "54g",
                                "802_11_A",
                                "802_11_AB",
                                "802_11_ABG",
                                "802_11_AG",
                                "802_11_B",
                                "802_11_BGN",
                                "802_11_G",
                                "802_11_G_108Mbps",
                                "802_11_G_54Mbps",
                                "802_11_N",
                                "900_mhz_radio_frequency",
                                "bluetooth",
                                "dect",
                                "dect_6.0",
                                "infrared",
                                "irda",
                                "radio_frequency",
                            ],
                    ],
            ],
            "{$i}DisplayResolutionMaximum" => [
                "sequence" => "{$s}85",
                "name" => "DisplayResolutionMaximum",
                "minOccurs" => "0",
                "dataType" => "FortyString",
            ],
            "{$i}GraphicsCard_GraphicsCardDescription" => [
                "sequence" => "{$s}90\\10",
                "name" => "GraphicsCardDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsCard_GraphicsCardRamSize" => [
                "sequence" => "{$s}90\\20",
                "name" => "GraphicsCardRamSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}GraphicsCardRamSize_unitOfMeasure_MemorySizeUnitOfMeasure"
            ],
            "{$i}GraphicsCard_GraphicsCardInterface" => [
                "sequence" => "{$s}90\\30",
                "name" => "GraphicsCardInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "agp",
                                "integrated",
                                "pci",
                                "pci_e",
                                "unknown",
                            ],
                    ],
            ],
            "{$i}GraphicsCoProcessor" => [
                "sequence" => "{$s}95",
                "name" => "GraphicsCoProcessor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ConnectivityType" => [
                "sequence" => "{$s}100",
                "name" => "ConnectivityType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsChipsetBrand" => [
                "sequence" => "{$s}200",
                "name" => "GraphicsChipsetBrand",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsRAMType" => [
                "sequence" => "{$s}210",
                "name" => "GraphicsRAMType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "72_pin_edo_simm",
                                "ddr2_sdram",
                                "ddr3_sdram",
                                "ddr4_sdram",
                                "ddr5_sdram",
                                "ddr_dram",
                                "ddr_sdram",
                                "dimm",
                                "dram",
                                "edo_dram",
                                "eeprom",
                                "eprom",
                                "fpm_dram",
                                "fpm_ram",
                                "gddr3",
                                "gddr4",
                                "gddr5",
                                "l2_cache",
                                "micro_dimm",
                                "pc2_4200",
                                "pc2_4300",
                                "pc2_5300",
                                "pc2_5400",
                                "pc2_6000",
                                "pc_100_sdram",
                                "pc_1066",
                                "pc_133_sdram",
                                "pc_1600",
                                "pc_2100_ddr",
                                "pc_2700_ddr",
                                "pc_3000",
                                "pc_3200_ddr",
                                "pc_3500_ddr",
                                "pc_3700",
                                "pc_4000_ddr",
                                "pc_4200",
                                "pc_4300",
                                "pc_4400",
                                "pc_66_sdram",
                                "pc_800",
                                "rambus",
                                "rdram",
                                "rimm",
                                "sdram",
                                "sgram",
                                "shared",
                                "simm",
                                "sipp",
                                "sldram",
                                "sodimm",
                                "sorimm",
                                "sram",
                                "unknown",
                                "vram",
                                "wram",
                            ],
                    ],
            ],
            "{$i}HardDiskRotationalSpeed" => [
                "sequence" => "{$s}220",
                "name" => "HardDiskRotationalSpeed",
                "minOccurs" => "0",
                "dataType" => "Dimension",
            ],
            "{$i}HardDiskTechnology" => [
                "sequence" => "{$s}250",
                "name" => "HardDiskTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HardDriveInterface" => [
                "sequence" => "{$s}260",
                "name" => "HardDriveInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "ata",
                                "ata100",
                                "ata133",
                                "ata_2",
                                "ata_3",
                                "ata_4",
                                "ata_5",
                                "atapi",
                                "dma",
                                "eide",
                                "eio",
                                "esata",
                                "esdi",
                                "ethernet",
                                "ethernet_100base_t",
                                "ethernet_100base_tx",
                                "ethernet_10_100_1000",
                                "ethernet_10base_t",
                                "fast_scsi",
                                "fast_wide_scsi",
                                "fata",
                                "fc_al",
                                "fc_al_2",
                                "fdd",
                                "fibre_channel",
                                "firewire",
                                "ide",
                                "ieee_1284",
                                "ieee_1394b",
                                "iscsi",
                                "lvds",
                                "pc_card",
                                "pci_express_x16",
                                "pci_express_x4",
                                "pci_express_x8",
                                "raid",
                                "scsi",
                                "serial_ata",
                                "serial_ata150",
                                "serial_ata300",
                                "serial_ata600",
                                "serial_scsi",
                                "solid_state",
                                "ssa",
                                "st412",
                                "ultra2_scsi",
                                "ultra2_wide_scsi",
                                "ultra3_scsi",
                                "ultra_160_scsi",
                                "ultra_320_scsi",
                                "ultra_ata",
                                "ultra_scsi",
                                "ultra_wide_scsi",
                                "unknown",
                                "usb",
                                "usb_1.1",
                                "usb_2.0",
                                "usb_2.0_3.0",
                                "usb_3.0",
                            ],
                    ],
            ],
            "{$i}HardDriveSize" => [
                "sequence" => "{$s}300",
                "name" => "HardDriveSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}HardDriveSize_unitOfMeasure_MemorySizeUnitOfMeasure"

            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}310",
                "name" => "HardwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}350",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MonitorTunerTechnology" => [
                "sequence" => "{$s}360",
                "name" => "MonitorTunerTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfAudioOutPorts" => [
                "sequence" => "{$s}370",
                "name" => "NumberOfAudioOutPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfDMIPorts" => [
                "sequence" => "{$s}380",
                "name" => "NumberOfDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfEthernetPorts" => [
                "sequence" => "{$s}390",
                "name" => "NumberOfEthernetPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfFirewirePorts" => [
                "sequence" => "{$s}400",
                "name" => "NumberOfFirewirePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfGamingPorts" => [
                "sequence" => "{$s}410",
                "name" => "NumberOfGamingPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfHDMIPorts" => [
                "sequence" => "{$s}420",
                "name" => "NumberOfHDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfLPT1PrinterPorts" => [
                "sequence" => "{$s}430",
                "name" => "NumberOfLPT1PrinterPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMicrophonePorts" => [
                "sequence" => "{$s}440",
                "name" => "NumberOfMicrophonePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfPS2Ports" => [
                "sequence" => "{$s}450",
                "name" => "NumberOfPS2Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMicrophonePorts" => [
                "sequence" => "{$s}460",
                "name" => "NumberOfMicrophonePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfSerialPorts" => [
                "sequence" => "{$s}470",
                "name" => "NumberOfSerialPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSB2.0Ports" => [
                "sequence" => "{$s}480",
                "name" => "NumberOfUSB2.0Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSB3.0Ports" => [
                "sequence" => "{$s}490",
                "name" => "NumberOfUSB3.0Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfVGAPorts" => [
                "sequence" => "{$s}500",
                "name" => "NumberOfVGAPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NotebookDisplayTechnology" => [
                "sequence" => "{$s}510",
                "name" => "NotebookDisplayTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}OperatingSystem" => [
                "sequence" => "{$s}520",
                "name" => "OperatingSystem",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorBrand" => [
                "sequence" => "{$s}600",
                "name" => "ProcessorBrand",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorCount" => [
                "sequence" => "{$s}610",
                "name" => "ProcessorCount",
                "minOccurs" => "0",
                "dataType" => "PositiveInteger",
            ],
            "{$i}ProcessorSeries" => [
                "sequence" => "{$s}620",
                "name" => "ProcessorSeries",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" =>
                        [
                            "athlon_64",
                            "athlon_64_x2",
                            "intel_atom_230",
                            "intel_atom_330",
                            "intel_atom_n450",
                            "intel_atom_n455",
                            "intel_atom_z520",
                            "intel_atom_z530",
                            "intel_xeon",
                            "pentium_4",
                            "sempron",
                        ],
                ],
            ],
            "{$i}ProcessorSocket" => [
                "sequence" => "{$s}630",
                "name" => "ProcessorSocket",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ProcessorSpeed" => [
                "sequence" => "{$s}640",
                "name" => "ProcessorSpeed",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ProcessorSpeed_unitOfMeasure_FrequencyUnitOfMeasure"
            ],
            "{$i}ProcessorType" => [
                "sequence" => "{$s}650",
                "name" => "ProcessorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" =>
                        [
                            "5x86",
                            "68000",
                            "68030",
                            "68040",
                            "68328",
                            "68882",
                            "68ez328",
                            "68lc040",
                            "6x86",
                            "6x86mx",
                            "8031",
                            "8032",
                            "80386",
                            "80486",
                            "80486dx2",
                            "80486slc",
                            "80486sx",
                            "80c186",
                            "80c31",
                            "80c32",
                            "80c88",
                            "alpha_21064a",
                            "alpha_21164",
                            "alpha_21164a",
                            "alpha_21264",
                            "alpha_21264a",
                            "alpha_21264b",
                            "alpha_21264c",
                            "alpha_21264d",
                            "alpha_21364",
                            "alpha_ev7",
                            "amd_a_series",
                            "amd_c_series",
                            "amd_e_series",
                            "amd_v_series",
                            "arm610",
                            "arm710",
                            "arm_7100",
                            "arm710a",
                            "arm710t",
                            "arm7500fe",
                            "athlon",
                            "Athlon_2650e",
                            "Athlon_2850e",
                            "athlon_4",
                            "athlon_64",
                            "Athlon_64_2650",
                            "Athlon_64_3500",
                            "Athlon_64_4200_plus",
                            "Athlon_64_4800_plus",
                            "athlon_64_for_dtr",
                            "athlon_64_fx",
                            "Athlon_64_Single_Core_TF_20",
                            "Athlon_64_TF_36",
                            "athlon_64_x2",
                            "athlon_64_X2",
                            "Athlon_64_X2_3600_plus",
                            "Athlon_64_X2_4000_plus",
                            "Athlon_64_X2_4200_plus",
                            "Athlon_64_X2_4450B",
                            "Athlon_64_X2_4800",
                            "Athlon_64_X2_5000_plus",
                            "Athlon_64_X2_5050",
                            "Athlon_64_X2_5200_plus",
                            "Athlon_64_X2_5400_plus",
                            "Athlon_64_X2_5600_plus",
                            "Athlon_64_X2_6000_plus",
                            "Athlon_64_X2_6400_plus",
                            "Athlon_64_X2_Dual_Core_3800_plus",
                            "Athlon_64_X2_Dual_Core_4400",
                            "Athlon_64_X2_Dual_Core_4450",
                            "Athlon_64_X2_Dual_Core_L310",
                            "Athlon_64_X2_Dual_Core_TK_42",
                            "Athlon_64_X2_QL_64_Dual_Core",
                            "Athlon_Dual_Core_QL62A",
                            "Athlon_II",
                            "Athlon_II_170u",
                            "Athlon_II_Dual_Core_240e",
                            "Athlon_II_Dual_Core_245",
                            "Athlon_II_Dual_Core_260",
                            "Athlon_II_Dual_Core_260u",
                            "Athlon_II_Dual_Core_M320",
                            "Athlon_II_Dual_Core_P320",
                            "Athlon_II_Dual_Core_P360",
                            "Athlon_II_Neo_Single_Core_K125",
                            "Athlon_II_Neo_X2_Dual_Core_K325",
                            "Athlon_II_Neo_X2_Dual_Core_K625",
                            "Athlon_II_Single_Core_160u",
                            "Athlon_II_X2_B24",
                            "Athlon_II_X2_Dual_Core_170u",
                            "Athlon_II_X2_Dual_Core_215",
                            "Athlon_II_X2_Dual_Core_235e",
                            "Athlon_II_X2_Dual_Core_240",
                            "Athlon_II_X2_Dual_Core_240e",
                            "Athlon_II_X2_Dual_Core_245",
                            "Athlon_II_X2_Dual_Core_250",
                            "Athlon_II_X2_Dual_Core_250U",
                            "Athlon_II_X2_Dual_Core_255",
                            "Athlon_II_X2_Dual_Core_3250e",
                            "Athlon_II_X2_Dual_Core_M300",
                            "Athlon_II_X2_Dual_Core_M320",
                            "Athlon_II_X2_Dual_Core_M340",
                            "Athlon_II_X2_Dual_Core_M520",
                            "Athlon_II_X2_Dual_Core_P320",
                            "Athlon_II_X2_Dual_Core_P340",
                            "Athlon_II_X2_Dual_Core_P360",
                            "Athlon_II_X2_Dual_Core_QL_60",
                            "Athlon_II_X2_Dual_Core_QL_62",
                            "Athlon_II_X2_Dual_Core_TK_53",
                            "Athlon_II_X2_Dual_Core_TK_57",
                            "athlon_ii_x3",
                            "Athlon_II_X3_Triple_Core_400E",
                            "Athlon_II_X3_Triple_Core_425",
                            "Athlon_II_X3_Triple_Core_435",
                            "athlon_ii_x4",
                            "Athlon_II_X4_Dual_Core_240e",
                            "Athlon_II_X4_Quad_Core",
                            "Athlon_II_X4_Quad_Core_600E",
                            "Athlon_II_X4_Quad_Core_605e",
                            "Athlon_II_X4_Quad_Core_615e",
                            "Athlon_II_X4_Quad_Core_620",
                            "Athlon_II_X4_Quad_Core_630",
                            "Athlon_II_X4_Quad_Core_635",
                            "Athlon_II_X4_Quad_Core_640",
                            "Athlon_II_X4_Quad_Core_645",
                            "Athlon_LE_1640",
                            "athlon_mp",
                            "Athlon_Neo_Single_Core_MV_40",
                            "Athlon_Neo_X2_Dual_Core_L325",
                            "Athlon_Neo_X2_Dual_Core_L335",
                            "Athlon_X2_Dual_Core_4200_plus",
                            "Athlon_X2_Dual_Core_5000",
                            "Athlon_X2_Dual_Core_5000_plus",
                            "Athlon_X2_Dual_Core_5400_plus",
                            "Athlon_X2_Dual_Core_7550",
                            "Athlon_X2_Dual_Core_7750",
                            "Athlon_X2_Dual_Core_QL_66",
                            "athlon_xp",
                            "athlon_xp_m",
                            "Atom_D410",
                            "Atom_D425",
                            "Atom_D510",
                            "Atom_D525",
                            "Atom_N230",
                            "Atom_N270",
                            "Atom_N280",
                            "Atom_N330",
                            "Atom_N470",
                            "Atom_N475",
                            "Atom_N550",
                            "Atom_Silverthorne",
                            "Atom_Z330",
                            "Atom_Z515",
                            "bulverde",
                            "c167cr",
                            "celeron",
                            "Celeron_450",
                            "Celeron_585",
                            "Celeron_743",
                            "Celeron_900",
                            "Celeron_925",
                            "Celeron_D_Processor_360",
                            "Celeron_D_Processor_420",
                            "Celeron_D_Processor_440",
                            "Celeron_E1200",
                            "Celeron_E1500",
                            "Celeron_E3200",
                            "Celeron_E3300",
                            "Celeron_M_353",
                            "Celeron_M_440",
                            "Celeron_M_520",
                            "Celeron_M_530",
                            "Celeron_M_540",
                            "Celeron_M_550",
                            "Celeron_M_560",
                            "Celeron_M_575",
                            "Celeron_M_585",
                            "Celeron_M_T1400",
                            "Celeron_SU2300",
                            "Celeron_T1500",
                            "Celeron_T3000",
                            "Celeron_T4500",
                            "Core_2_Duo",
                            "Core_2_Duo_E2200",
                            "Core_2_Duo_E4000",
                            "Core_2_Duo_E4300",
                            "Core_2_Duo_E4400",
                            "Core_2_Duo_E4500",
                            "Core_2_Duo_E4600",
                            "Core_2_Duo_E5500",
                            "Core_2_Duo_E6300",
                            "Core_2_Duo_E6400",
                            "Core_2_Duo_E6420",
                            "Core_2_Duo_E6600",
                            "Core_2_Duo_E7200",
                            "Core_2_Duo_E7300",
                            "Core_2_Duo_E7400",
                            "Core_2_Duo_E7500",
                            "Core_2_Duo_E7600",
                            "Core_2_Duo_E8400",
                            "Core_2_Duo_E8500",
                            "Core_2_Duo_L7500",
                            "Core_2_Duo_P3750",
                            "Core_2_Duo_P7350",
                            "Core_2_Duo_P7370",
                            "Core_2_Duo_P7450",
                            "Core_2_Duo_P7550",
                            "Core_2_Duo_P8400",
                            "Core_2_Duo_P8600",
                            "Core_2_Duo_P8700",
                            "Core_2_Duo_P8800",
                            "Core_2_Duo_P9500",
                            "Core_2_Duo_P9600",
                            "Core_2_Duo_SL7100",
                            "Core_2_Duo_SL9300",
                            "Core_2_Duo_SL9400",
                            "Core_2_Duo_SL9600",
                            "Core_2_Duo_SP9400",
                            "Core_2_Duo_SU4100",
                            "Core_2_Duo_SU7300",
                            "Core_2_Duo_SU9300",
                            "Core_2_Duo_SU9400",
                            "Core_2_Duo_SU_9600",
                            "Core_2_Duo_T2310",
                            "Core_2_Duo_T2330",
                            "Core_2_Duo_T2390",
                            "Core_2_Duo_T2450",
                            "Core_2_Duo_T4200",
                            "Core_2_Duo_T5200",
                            "Core_2_Duo_T5250",
                            "Core_2_Duo_T5270",
                            "Core_2_Duo_T5300",
                            "Core_2_Duo_T5450",
                            "Core_2_Duo_T5470",
                            "Core_2_Duo_T5500",
                            "Core_2_Duo_T5550",
                            "Core_2_Duo_T5600",
                            "Core_2_Duo_T5670",
                            "Core_2_Duo_T5750",
                            "Core_2_Duo_T5800",
                            "Core_2_Duo_T5850",
                            "Core_2_Duo_T5870",
                            "Core_2_Duo_T6400",
                            "Core_2_Duo__T6500",
                            "Core_2_Duo_T6570",
                            "Core_2_Duo_T6600",
                            "Core_2_Duo_T6670",
                            "Core_2_Duo_T7100",
                            "Core_2_Duo_T7200",
                            "Core_2_Duo_T7250",
                            "Core_2_Duo_T7270",
                            "Core_2_Duo_T7300",
                            "Core_2_Duo_T7350",
                            "Core_2_Duo_T7400",
                            "Core_2_Duo_T7500",
                            "Core_2_Duo_T7700",
                            "Core_2_Duo_T8100",
                            "Core_2_Duo_T8300",
                            "Core_2_Duo_T8400",
                            "Core_2_Duo_T8700",
                            "Core_2_Duo_T9300",
                            "Core_2_Duo_T9400",
                            "Core_2_Duo_T9500",
                            "Core_2_Duo_T9550",
                            "Core_2_Duo_T9600",
                            "Core_2_Duo_T9900",
                            "Core_2_Duo_U1400",
                            "Core_2_Duo_U2200",
                            "Core_2_Duo_U7500",
                            "Core_2_Duo_U7700",
                            "Core_2_Quad_9600",
                            "Core_2_Quad_Q6600",
                            "Core_2_Quad_Q6700",
                            "Core_2_Quad_Q8200",
                            "Core_2_Quad_Q8200S",
                            "Core_2_Quad_Q8300",
                            "Core_2_Quad_Q8400",
                            "Core_2_Quad_Q8400S",
                            "Core_2_Quad_Q9000",
                            "Core_2_Quad_Q9300",
                            "Core_2_Quad_Q9400",
                            "Core_2_Quad_Q9400S",
                            "Core_2_Quad_Q9450",
                            "Core_2_Quad_Q9500",
                            "Core_2_Quad_Q9550",
                            "Core_2_Solo_SU3500",
                            "Core_Duo_1V_L2400",
                            "Core_Duo_LV_L2400",
                            "Core_Duo_T2250",
                            "Core_Duo_T2400",
                            "Core_Duo_U2400",
                            "core_i3",
                            "Core_i3_2330M",
                            "Core_i3_330UM",
                            "Core_i3_350M",
                            "Core_i3_370M",
                            "Core_i3_380M",
                            "Core_i3_380UM",
                            "Core_i3_520M",
                            "Core_i3_530",
                            "Core_i3_530M",
                            "Core_i3_540",
                            "Core_i3_540M",
                            "Core_i3_550",
                            "core_i5",
                            "Core_i5_2300",
                            "Core_i5_2520M",
                            "Core_i5_2540M",
                            "Core_i5_430M",
                            "Core_i5_430UM",
                            "Core_i5_450M",
                            "Core_i5_460M",
                            "Core_i5_470UM",
                            "Core_i5_480M",
                            "Core_i5_560M",
                            "Core_i5_650",
                            "Core_i5_655K",
                            "Core_i5_660",
                            "Core_i5_750",
                            "Core_i5_760",
                            "Core_i5__760",
                            "core_i7",
                            "Core_i7_2600",
                            "Core_i7_2620QM",
                            "Core_i7_2630QM",
                            "Core_i7_2720QM",
                            "Core_i7_2820QM",
                            "Core_i7_4800MQ",
                            "Core_i7_620LM",
                            "Core_i7_620M",
                            "Core_i7_640LM",
                            "Core_i7_640M",
                            "Core_i7_640UM",
                            "Core_i7_680UM",
                            "Core_i7_740QM",
                            "Core_i7_860",
                            "Core_i7_870",
                            "Core_i7_875K",
                            "Core_i7_920",
                            "Core_i7_930",
                            "Core_i7_940",
                            "Core_i7_950",
                            "Core_i7_960",
                            "Core_i7_980",
                            "Core_Solo_U1500",
                            "crusoe_5800",
                            "crusoe_tm3200",
                            "crusoe_tm5500",
                            "crusoe_tm5600",
                            "C_Series_C_50",
                            "cyrix_iii",
                            "cyrix_mii",
                            "duron",
                            "eden",
                            "eden_esp",
                            "eden_esp_4000",
                            "eden_esp_5000",
                            "eden_esp_6000",
                            "eden_esp_7000",
                            "efficeon",
                            "efficeon_tm8000",
                            "efficeon_tm8600",
                            "efficion_8800",
                            "elansc300",
                            "elansc310",
                            "elansc400",
                            "E_Series_Dual_Core_E_350",
                            "E_Series_Processor_E_240",
                            "extremecpu",
                            "fx_series_eight_core_fx_8100",
                            "fx_series_eight_core_fx_8120",
                            "fx_series_eight_core_fx_8150",
                            "fx_series_quad_core_fx_4100",
                            "fx_series_quad_core_fx_4170",
                            "fx_series_quad_core_fx_b4150",
                            "fx_series_six_core_fx_6100",
                            "fx_series_six_core_fx_6120",
                            "g3",
                            "g4",
                            "g5",
                            "geode_gx",
                            "Geode_GX",
                            "geode_gx1",
                            "geode_gxlv",
                            "geode_gxm",
                            "geoden_x",
                            "h8s",
                            "handheld_engine_cxd2230ga",
                            "handheld_engine_cxd2230ga_temp",
                            "hitachi_sh3",
                            "hypersparc",
                            "intel_atom",
                            "intel_atom_230",
                            "intel_atom_330",
                            "intel_atom_n270",
                            "intel_atom_n280",
                            "intel_atom_n450",
                            "intel_atom_n455",
                            "intel_atom_z520",
                            "intel_atom_z530",
                            "intel_celeron_d",
                            "intel_centrino",
                            "intel_centrino_2",
                            "intel_core_2_duo",
                            "intel_core_2_duo_mobile",
                            "intel_core_2_extreme",
                            "intel_core_2_quad",
                            "intel_core_2_solo",
                            "intel_core_duo",
                            "intel_core_solo",
                            "Intel_Mobile_CPU",
                            "intel_pentium_4_ht",
                            "intel_pentium_d",
                            "intel_strongarm",
                            "intel_xeon",
                            "intel_xeon_mp",
                            "intel_xscale_pxa250",
                            "intel_xscale_pxa255",
                            "intel_xscale_pxa263",
                            "itanium",
                            "itanium_2",
                            "k5",
                            "k6_2",
                            "k6_2e",
                            "k6_2_plus",
                            "k6_3",
                            "k6_iii_plus",
                            "k6_mmx",
                            "mc68328",
                            "mc68ez328",
                            "mc68sz328",
                            "mc68vz328",
                            "mc88110",
                            "mediagx",
                            "mediagxi",
                            "mediagxlv",
                            "mediagxm",
                            "microsparc_ii",
                            "microsparc_iiep",
                            "mobile_athlon_4",
                            "mobile_athlon_xp_m",
                            "mobile_athon_64",
                            "mobile_celeron",
                            "mobile_duron",
                            "mobile_k6_2_plus",
                            "mobile_pentium_2",
                            "mobile_pentium_3",
                            "mobile_pentium_4",
                            "mobile_pentium_4_ht",
                            "mobile_sempron",
                            "motorola_dragonball",
                            "nec_mips",
                            "none",
                            "omap1710",
                            "omap310",
                            "omap311",
                            "omap850",
                            "opteron",
                            "pa_7100lc",
                            "pa_7200",
                            "pa_7300lc",
                            "pa_8000",
                            "pa_8200",
                            "pa_8500",
                            "pa_8600",
                            "pa_8700",
                            "pa_8700_plus",
                            "pa_8800",
                            "pa_8900",
                            "pentium",
                            "pentium_2",
                            "pentium_3",
                            "pentium_3_xeon",
                            "pentium_4",
                            "pentium_4_extreme_edition",
                            "Pentium_D_925",
                            "Pentium_D_T2060",
                            "pentium_dual_core",
                            "Pentium_E2140",
                            "Pentium_E2160",
                            "Pentium_E2180",
                            "Pentium_E2200",
                            "Pentium_E2220",
                            "Pentium_E3200",
                            "Pentium_E4400",
                            "Pentium_E5200",
                            "Pentium_E5300",
                            "Pentium_E5301",
                            "Pentium_E5400",
                            "Pentium_E5500",
                            "Pentium_E5700",
                            "Pentium_E5800",
                            "Pentium_E6300",
                            "Pentium_E6600",
                            "Pentium_E6700",
                            "Pentium_E7200",
                            "Pentium_E7400",
                            "Pentium_E8400",
                            "Pentium_G6950",
                            "pentium_iii_e",
                            "pentium_iii_s",
                            "pentium_ii_xeon",
                            "pentium_m",
                            "Pentium_M_738",
                            "Pentium_M_778",
                            "pentium_mmx",
                            "Pentium_P6000",
                            "Pentium_P6100",
                            "Pentium_P6200",
                            "pentium_pro",
                            "Pentium_SU2700",
                            "Pentium_SU4100",
                            "Pentium_T2080",
                            "Pentium_T2130",
                            "Pentium_T2310",
                            "Pentium_T2330",
                            "Pentium_T2350",
                            "Pentium_T2370",
                            "Pentium_T2390",
                            "Pentium_T3200",
                            "Pentium_T3400",
                            "Pentium_T4200",
                            "Pentium_T4300",
                            "Pentium_T4400",
                            "Pentium_T4500",
                            "Pentium_T6570",
                            "Pentium_U5400",
                            "Pentium_U5600",
                            "pentium_xeon",
                            "phenom_dual_core",
                            "phenom_ii_x2",
                            "Phenom_II_X2_Dual_Core_511",
                            "Phenom_II_X2_Dual_Core_550",
                            "Phenom_II_X2_Dual_Core_N620",
                            "Phenom_II_X2_Dual_Core_N640",
                            "Phenom_II_X2_Dual_Core_N650",
                            "Phenom_II_X2_Dual_Core_N660",
                            "phenom_ii_x3",
                            "Phenom_II_X3_Triple_Core_8400",
                            "Phenom_II_X3_Triple_Core_8450",
                            "Phenom_II_X3_Triple_Core_8550",
                            "Phenom_II_X3_Triple_Core_8650",
                            "Phenom_II_X3_Triple_Core_B75",
                            "Phenom_II_X3_Triple_Core_N830",
                            "Phenom_II_X3_Triple_Core_N850",
                            "Phenom_II_X3_Triple_Core_P820",
                            "Phenom_II_X3_Triple_Core_P840",
                            "Phenom_II_X3_Triple_Core_P860",
                            "phenom_ii_x4",
                            "Phenom_II_X4_Quad_Core_810",
                            "Phenom_II_X4_Quad_Core_820",
                            "Phenom_II_X4_Quad_Core_830",
                            "Phenom_II_X4_Quad_Core_840T",
                            "Phenom_II_X4_Quad_Core_910",
                            "Phenom_II_X4_Quad_Core_9100E",
                            "Phenom_II_X4_Quad_Core_9150",
                            "Phenom_II_X4_Quad_Core_920",
                            "Phenom_II_X4_Quad_Core_925",
                            "Phenom_II_X4_Quad_Core_9350",
                            "Phenom_II_X4_Quad_Core_945",
                            "Phenom_II_X4_Quad_Core_9450",
                            "Phenom_II_X4_Quad_Core_9500",
                            "Phenom_II_X4_Quad_Core_955",
                            "Phenom_II_X4_Quad_Core_9550",
                            "Phenom_II_X4_Quad_Core_9600",
                            "Phenom_II_X4_Quad_Core_965",
                            "Phenom_II_X4_Quad_Core_9650",
                            "Phenom_II_X4_Quad_Core_9750",
                            "Phenom_II_X4_Quad_Core_9850",
                            "Phenom_II_X4_Quad_Core_9950",
                            "Phenom_II_X4_Quad_Core_N820",
                            "Phenom_II_X4_Quad_Core_N930",
                            "Phenom_II_X4_Quad_Core_N950",
                            "Phenom_II_X4_Quad_Core_P920",
                            "Phenom_II_X4_Quad_Core_P940",
                            "Phenom_II_X4_Quad_Core_P960",
                            "phenom_ii_x6",
                            "Phenom_II_X6_Six_Core_1035T",
                            "Phenom_II_X6_Six_Core_1045T",
                            "Phenom_II_X6_Six_Core_1055T",
                            "Phenom_II_X6_Six_Core_1090T",
                            "phenom_quad_core",
                            "phenom_triple_core",
                            "power3",
                            "power3_ii",
                            "power4",
                            "power4_plus",
                            "power5",
                            "powerpc",
                            "powerpc_403",
                            "powerpc_403ga",
                            "powerpc_403_gcx",
                            "powerpc_440gx",
                            "powerpc_601",
                            "powerpc_603",
                            "powerpc_603e",
                            "powerpc_603ev",
                            "powerpc_604",
                            "powerpc_604e",
                            "powerpc_740_g3",
                            "powerpc_750cx",
                            "powerpc_750_g3",
                            "powerpc_970",
                            "powerpc_rs64",
                            "powerpc_rs64_ii",
                            "powerpc_rs64_iii",
                            "powerpc_rs64_iv",
                            "pr31700",
                            "r10000",
                            "r12000",
                            "r12000a",
                            "r14000",
                            "r14000a",
                            "r16000",
                            "r16000a",
                            "r16000b",
                            "r3900",
                            "r3910",
                            "r3912",
                            "r4000",
                            "r4300",
                            "r4310",
                            "r4640",
                            "r4700",
                            "r5000",
                            "r5230",
                            "rm5231",
                            "s3c2410",
                            "s3c2440",
                            "s3c2442",
                            "sa_110",
                            "sa_1100",
                            "sa_1110",
                            "sempron",
                            "Sempron_140",
                            "Sempron_3500_plus",
                            "Sempron_3600_plus",
                            "Sempron_LE_1250",
                            "Sempron_LE_1300",
                            "Sempron_M100",
                            "Sempron_M120",
                            "sh_4",
                            "sh7709a",
                            "sis550",
                            "snapdragon",
                            "sparc",
                            "sparc64v",
                            "sparc_ii",
                            "supersparc",
                            "supersparc_ii",
                            "tegra",
                            "tegra_2_0",
                            "tegra_250",
                            "tegra_3_0",
                            "texas_instruments_omap1510",
                            "tm_44",
                            "tmpr3922au",
                            "turbosparc",
                            "turion_64",
                            "turion_64_x2",
                            "Turion_64_X2_Dual_Core_RM_70",
                            "Turion_64_X2_Dual_Core_RM_72",
                            "Turion_64_X2_Dual_Core_TL_52",
                            "Turion_64_X2_Dual_Core_TL_56",
                            "Turion_64_X2_Mobile",
                            "Turion_64_X2_RM_74",
                            "Turion_64_X2_TK_53",
                            "Turion_64_X2_TK_55",
                            "Turion_64_X2_TK_57",
                            "Turion_64_X2_TK_58",
                            "Turion_64_X2_TL_50",
                            "Turion_64_X2_TL_57",
                            "Turion_64_X2_TL_58",
                            "Turion_64_X2_TL_60",
                            "Turion_64_X2_TL_62",
                            "Turion_64_X2_TL_64_Gold",
                            "Turion_64_X2_TL_66",
                            "Turion_64_X2_Ultra_ZM_82",
                            "Turion_64_X2_Ultra_ZM_85",
                            "Turion_64_X2_Ultra_ZM_87",
                            "Turion_64_X2_ZM_72",
                            "Turion_64_X2_ZM_74",
                            "Turion_64_X2_ZM_80",
                            "Turion_II_Neo_X2_Dual_Core_K625",
                            "Turion_II_Neo_X2_Dual_Core_L625",
                            "Turion_II_Ultra_X2_Dual_Core_M600",
                            "Turion_II_Ultra_X2_Dual_Core_M620",
                            "Turion_II_X2_Dual_Core_M300",
                            "Turion_II_X2_Dual_Core_M500",
                            "Turion_II_X2_Dual_Core_M520",
                            "Turion_II_X2_Dual_Core_P520",
                            "Turion_II_X2_Dual_Core_P540",
                            "Turion_II_X2_Dual_Core_P560",
                            "Turion_X2_Dual_Core_RM_75",
                            "Turion_X2_Ultra_Dual_Core_ZM_85",
                            "tx3922",
                            "ultrasparc_i",
                            "ultrasparc_ii",
                            "ultrasparc_iie",
                            "ultrasparc_iii",
                            "ultrasparc_iii_cu",
                            "ultrasparc_iiii",
                            "ultrasparc_iii_plus",
                            "ultrasparc_iis",
                            "ultrasparc_iv",
                            "ultrasparc_iv_plus",
                            "ultrasparc_s400",
                            "ultrasparc_t1",
                            "unknown",
                            "v25",
                            "v30",
                            "v30mx",
                            "via_cyrix_c3",
                            "vr4111",
                            "vr4121",
                            "vr4122",
                            "vr4131",
                            "vr4181",
                            "vr4300",
                            "V_Series_Single_Core_V105",
                            "V_Series_Single_Core_V120",
                            "V_Series_Single_Core_V140",
                            "winchip_2",
                            "winchip_c6",
                            "Xeon",
                            "Xeon_3000",
                            "Xeon_3530",
                            "Xeon_5000",
                            "Xeon_5400",
                            "Xeon_E5504",
                            "Xeon_E5506",
                            "Xeon_E5520",
                            "Xeon_E5530",
                            "Xeon_W3503",
                            "Xeon_W5580",
                            "Xeon_X5560",
                            "xscale",
                            "xscale_pxa260",
                            "xscale_pxa261",
                            "xscale_pxa262",
                            "xscale_pxa270",
                            "xscale_pxa272",
                            "xscale_pxa901",
                            "",
                        ],
                ],
            ],
            "{$i}RAMSize" => [
                "sequence" => "{$s}660",
                "name" => "RAMSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}RAMSize_unitOfMeasure_MemorySizeUnitOfMeasure"
            ],
            "{$i}ScreenSize" => [
                "sequence" => "{$s}800",
                "name" => "ScreenSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ScreenSize_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Series" => [
                "sequence" => "{$s}900",
                "name" => "Series",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getPersonalComputer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * PersonalComputer => 190
         */
        $s = "100\\10\\10\\190\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_PersonalComputer_";

        $attributes = [
            "ProductData_Computers_ProductType_PersonalComputer" => [
                "sequence" => "100\\10\\10\\190",
                "name" => "PersonalComputer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalDrives" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalDrives",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "blu_ray",
                                "blu_ray_re",
                                "blu_ray_rom",
                                "blu_ray_rw",
                                "cd_rom",
                                "cd_rw",
                                "dvd",
                                "dvd_cd_rw",
                                "dvd_minus_rw",
                                "dvd_plus_minus_rw",
                                "dvd_plus_r",
                                "dvd_plus_rw",
                                "dvd_r",
                                "dvd_ram",
                                "dvd_rom",
                                "dvd_rw",
                                "floppy",
                                "ide_tape_drive",
                                "jazz",
                                "scsi_cdrom",
                                "scsi_tape_drive",
                                "thumb_drive",
                                "zip",
                            ],
                    ],
            ],
            "{$i}Audio" => [
                "sequence" => "{$s}40",
                "name" => "Audio",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CardReader" => [
                "sequence" => "{$s}50",
                "name" => "CardReader",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "compactflash_type_i",
                                "compactflash_type_ii",
                                "hs_mmc",
                                "memory_stick",
                                "memory_stick_duo",
                                "memory_stick_micro",
                                "memory_stick_pro",
                                "memory_stick_pro_duo",
                                "memory_stick_pro_hg_duo",
                                "memory_stick_select",
                                "memory_stick_xc",
                                "memory_stick_xc_hg_micro",
                                "memory_stick_xc_micro",
                                "MiCard",
                                "microsd",
                                "micro_sdhc",
                                "micro_sdxc",
                                "minisd",
                                "mini_sdhc",
                                "mini_sdxc",
                                "mmc_micro",
                                "multimedia_card",
                                "multimedia_card_mobile",
                                "multimedia_card_plus",
                                "rs_mmc",
                                "sdhc",
                                "sdio",
                                "sdxc",
                                "secure_digital",
                                "secure_mmc",
                                "smartmedia_card",
                                "transflash",
                                "xd_picture_card",
                                "xd_picture_card_h",
                                "xd_picture_card_m",
                                "xd_picture_card_m_plus",
                            ],
                    ],
            ],
            "{$i}ComputerMemoryType" => [
                "sequence" => "{$s}60",
                "name" => "ComputerMemoryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "72_pin_edo_simm",
                                "ddr2_sdram",
                                "ddr3_sdram",
                                "ddr_dram",
                                "ddr_sdram",
                                "dimm",
                                "dram",
                                "edo_dram",
                                "eeprom",
                                "eprom",
                                "fpm_dram",
                                "fpm_ram",
                                "l2_cache",
                                "micro_dimm",
                                "pc2_4200",
                                "pc2_4300",
                                "pc2_5300",
                                "pc2_5400",
                                "pc2_6000",
                                "pc_100_sdram",
                                "pc_1066",
                                "pc_133_sdram",
                                "pc_1600",
                                "pc_2100_ddr",
                                "pc_2700_ddr",
                                "pc_3000",
                                "pc_3200_ddr",
                                "pc_3500_ddr",
                                "pc_3700",
                                "pc_4000_ddr",
                                "pc_4200",
                                "pc_4300",
                                "pc_4400",
                                "pc_66_sdram",
                                "pc_800",
                                "rambus",
                                "rdram",
                                "rimm",
                                "sdram",
                                "sgram",
                                "simm",
                                "sipp",
                                "sldram",
                                "sodimm",
                                "sorimm",
                                "sram",
                                "unknown",
                                "vram",
                                "wram",
                            ],
                    ],
            ],
            "{$i}ComputerTunerTechnology" => [
                "sequence" => "{$s}70",
                "name" => "ComputerTunerTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ComputerWirelessType" => [
                "sequence" => "{$s}80",
                "name" => "ComputerWirelessType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "2.4_ghz_radio_frequency",
                                "5.8_ghz_radio_frequency",
                                "54g",
                                "802_11_A",
                                "802_11_AB",
                                "802_11_ABG",
                                "802_11_AG",
                                "802_11_B",
                                "802_11_BGN",
                                "802_11_G",
                                "802_11_G_108Mbps",
                                "802_11_G_54Mbps",
                                "802_11_N",
                                "900_mhz_radio_frequency",
                                "bluetooth",
                                "dect",
                                "dect_6.0",
                                "infrared",
                                "irda",
                                "radio_frequency",
                            ],
                    ],
            ],
            "{$i}ConnectivityType" => [
                "sequence" => "{$s}85",
                "name" => "ConnectivityType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsCard_GraphicsCardDescription" => [
                "sequence" => "{$s}90\\10",
                "name" => "GraphicsCardDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsCard_GraphicsCardRamSize" => [
                "sequence" => "{$s}90\\20",
                "name" => "GraphicsCardRamSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}GraphicsCardRamSize_unitOfMeasure_MemorySizeUnitOfMeasure"
            ],
            "{$i}GraphicsCard_GraphicsCardInterface" => [
                "sequence" => "{$s}90\\30",
                "name" => "GraphicsCardInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "agp",
                                "integrated",
                                "pci",
                                "pci_e",
                                "unknown",
                            ],
                    ],
            ],
            "{$i}GraphicsChipsetBrand" => [
                "sequence" => "{$s}200",
                "name" => "GraphicsChipsetBrand",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HardDiskTechnology" => [
                "sequence" => "{$s}250",
                "name" => "HardDiskTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HardDriveSize" => [
                "sequence" => "{$s}300",
                "name" => "HardDriveSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}HardDriveSize_unitOfMeasure_MemorySizeUnitOfMeasure"

            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}310",
                "name" => "HardwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}350",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfAudioOutPorts" => [
                "sequence" => "{$s}370",
                "name" => "NumberOfAudioOutPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfDMIPorts" => [
                "sequence" => "{$s}380",
                "name" => "NumberOfDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfEthernetPorts" => [
                "sequence" => "{$s}390",
                "name" => "NumberOfEthernetPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfFirewirePorts" => [
                "sequence" => "{$s}400",
                "name" => "NumberOfFirewirePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfGamingPorts" => [
                "sequence" => "{$s}410",
                "name" => "NumberOfGamingPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfHDMIPorts" => [
                "sequence" => "{$s}420",
                "name" => "NumberOfHDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfLPT1PrinterPorts" => [
                "sequence" => "{$s}430",
                "name" => "NumberOfLPT1PrinterPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMicrophonePorts" => [
                "sequence" => "{$s}440",
                "name" => "NumberOfMicrophonePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfPS2Ports" => [
                "sequence" => "{$s}450",
                "name" => "NumberOfPS2Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMicrophonePorts" => [
                "sequence" => "{$s}460",
                "name" => "NumberOfMicrophonePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfSerialPorts" => [
                "sequence" => "{$s}470",
                "name" => "NumberOfSerialPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSB2.0Ports" => [
                "sequence" => "{$s}480",
                "name" => "NumberOfUSB2.0Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSB3.0Ports" => [
                "sequence" => "{$s}490",
                "name" => "NumberOfUSB3.0Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfVGAPorts" => [
                "sequence" => "{$s}500",
                "name" => "NumberOfVGAPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}OperatingSystem" => [
                "sequence" => "{$s}520",
                "name" => "OperatingSystem",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScreenResolution" => [
                "sequence" => "{$s}530",
                "name" => "ScreenResolution",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Series" => [
                "sequence" => "{$s}550",
                "name" => "Series",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getPrinter()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Printer => 200
         */
        $s = "100\\10\\10\\200\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Printer_";

        $attributes = [
            "ProductData_Computers_ProductType_Printer" => [
                "sequence" => "100\\10\\10\\200",
                "name" => "Printer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HasGreyScale" => [
                "sequence" => "{$s}30",
                "name" => "HasGreyScale",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LightSourceType" => [
                "sequence" => "{$s}40",
                "name" => "LightSourceType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaxInputSheetCapacity" => [
                "sequence" => "{$s}60",
                "name" => "MaxInputSheetCapacity",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}MaxPrintResolutionBlackWhite" => [
                "sequence" => "{$s}70",
                "name" => "MaxPrintResolutionBlackWhite",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PrinterOutputType" => [
                "sequence" => "{$s}150",
                "name" => "PrinterOutputType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PrinterWirelessType" => [
                "sequence" => "{$s}160",
                "name" => "PrinterWirelessType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "2.4_ghz_radio_frequency",
                                "5.8_ghz_radio_frequency",
                                "54g",
                                "802_11_A",
                                "802_11_AB",
                                "802_11_ABG",
                                "802_11_AG",
                                "802_11_B",
                                "802_11_BGN",
                                "802_11_G",
                                "802_11_G_108Mbps",
                                "802_11_G_54Mbps",
                                "802_11_N",
                                "900_mhz_radio_frequency",
                                "bluetooth",
                                "dect",
                                "dect_6.0",
                                "infrared",
                                "irda",
                                "radio_frequency",
                            ],
                    ],
            ],
            "{$i}PrintingMediaType" => [
                "sequence" => "{$s}170",
                "name" => "PrintingMediaType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "back_print_film",
                                "banner_paper",
                                "card_stock",
                                "envelopes",
                                "fabric",
                                "glossy_film",
                                "glossy_photo_paper",
                                "high_resolution_paper",
                                "labels",
                                "paper_plain",
                                "transparencies",
                                "unknown",
                            ],
                    ],
            ],
            "{$i}ScanRate" => [
                "sequence" => "{$s}200",
                "name" => "ScanRate",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScannerResolution" => [
                "sequence" => "{$s}210",
                "name" => "ScannerResolution",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getRamMemory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * RamMemory => 210
         */
        $s = "100\\10\\10\\210\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_RamMemory_";

        $attributes = [
            "ProductData_Computers_ProductType_RamMemory" => [
                "sequence" => "100\\10\\10\\210",
                "name" => "RamMemory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CasLatency" => [
                "sequence" => "{$s}40",
                "name" => "CasLatency",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}160",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getScanner()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Scanner => 220
         */
        $s = "100\\10\\10\\220\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Scanner_";

        $attributes = [
            "ProductData_Computers_ProductType_Scanner" => [
                "sequence" => "100\\10\\10\\220",
                "name" => "Scanner",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HasGreyScale" => [
                "sequence" => "{$s}30",
                "name" => "HasGreyScale",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}LightSourceType" => [
                "sequence" => "{$s}40",
                "name" => "LightSourceType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaxInputSheetCapacity" => [
                "sequence" => "{$s}50",
                "name" => "MaxInputSheetCapacity",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}MaxPrintResolutionBlackWhite" => [
                "sequence" => "{$s}40",
                "name" => "MaxPrintResolutionBlackWhite",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PrinterOutputType" => [
                "sequence" => "{$s}100",
                "name" => "PrinterOutputType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScanRate" => [
                "sequence" => "{$s}120",
                "name" => "ScanRate",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScannerResolution" => [
                "sequence" => "{$s}130",
                "name" => "LightSourceType",
                "minOccurs" => "0",
                "dataType" => "ScannerResolution",
            ],
        ];
        return $attributes;
    }

    public function getSoundCard()
    {
        return [];
    }

    public function getSystemCabinet()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * SystemCabinet => 240
         */
        $s = "100\\10\\10\\240\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_SystemCabinet_";

        $attributes = [
            "ProductData_Computers_ProductType_SystemCabinet" => [
                "sequence" => "100\\10\\10\\240",
                "name" => "SystemCabinet",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AirDuctLocation" => [
                "sequence" => "{$s}40",
                "name" => "AirDuctLocation",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ExpansionSlots" => [
                "sequence" => "{$s}50",
                "name" => "ExpansionSlots",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}70",
                "name" => "MaterialType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}100",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSystemPowerDevice()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * SystemPowerDevice => 250
         */
        $s = "100\\10\\10\\250\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_SystemPowerDevice_";

        $attributes = [
            "ProductData_Computers_ProductType_SystemPowerDevice" => [
                "sequence" => "100\\10\\10\\250",
                "name" => "SystemPowerDevice",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}EnergyEfficiencyRating" => [
                "sequence" => "{$s}40",
                "name" => "EnergyEfficiencyRating",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MainPowerConnector" => [
                "sequence" => "{$s}50",
                "name" => "MainPowerConnector",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}70",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Modular" => [
                "sequence" => "{$s}100",
                "name" => "Modular",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfSATAPowerConnectors" => [
                "sequence" => "{$s}150",
                "name" => "NumberOfSATAPowerConnectors",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
        ];
        return $attributes;
    }

    public function getTabletComputer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * TabletComputer => 260
         */
        $s = "100\\10\\10\\260\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_TabletComputer_";

        $attributes = [
            "ProductData_Computers_ProductType_TabletComputer" => [
                "sequence" => "100\\10\\10\\260",
                "name" => "TabletComputer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalDrives" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalDrives",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "blu_ray",
                                "blu_ray_re",
                                "blu_ray_rom",
                                "blu_ray_rw",
                                "cd_rom",
                                "cd_rw",
                                "dvd",
                                "dvd_cd_rw",
                                "dvd_minus_rw",
                                "dvd_plus_minus_rw",
                                "dvd_plus_r",
                                "dvd_plus_rw",
                                "dvd_r",
                                "dvd_ram",
                                "dvd_rom",
                                "dvd_rw",
                                "floppy",
                                "ide_tape_drive",
                                "jazz",
                                "scsi_cdrom",
                                "scsi_tape_drive",
                                "thumb_drive",
                                "zip",
                            ],
                    ],
            ],
            "{$i}Audio" => [
                "sequence" => "{$s}40",
                "name" => "Audio",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CardReader" => [
                "sequence" => "{$s}50",
                "name" => "CardReader",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "compactflash_type_i",
                                "compactflash_type_ii",
                                "hs_mmc",
                                "memory_stick",
                                "memory_stick_duo",
                                "memory_stick_micro",
                                "memory_stick_pro",
                                "memory_stick_pro_duo",
                                "memory_stick_pro_hg_duo",
                                "memory_stick_select",
                                "memory_stick_xc",
                                "memory_stick_xc_hg_micro",
                                "memory_stick_xc_micro",
                                "MiCard",
                                "microsd",
                                "micro_sdhc",
                                "micro_sdxc",
                                "minisd",
                                "mini_sdhc",
                                "mini_sdxc",
                                "mmc_micro",
                                "multimedia_card",
                                "multimedia_card_mobile",
                                "multimedia_card_plus",
                                "rs_mmc",
                                "sdhc",
                                "sdio",
                                "sdxc",
                                "secure_digital",
                                "secure_mmc",
                                "smartmedia_card",
                                "transflash",
                                "xd_picture_card",
                                "xd_picture_card_h",
                                "xd_picture_card_m",
                                "xd_picture_card_m_plus",
                            ],
                    ],
            ],
            "{$i}ComputerMemoryType" => [
                "sequence" => "{$s}60",
                "name" => "ComputerMemoryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "72_pin_edo_simm",
                                "ddr2_sdram",
                                "ddr3_sdram",
                                "ddr_dram",
                                "ddr_sdram",
                                "dimm",
                                "dram",
                                "edo_dram",
                                "eeprom",
                                "eprom",
                                "fpm_dram",
                                "fpm_ram",
                                "l2_cache",
                                "micro_dimm",
                                "pc2_4200",
                                "pc2_4300",
                                "pc2_5300",
                                "pc2_5400",
                                "pc2_6000",
                                "pc_100_sdram",
                                "pc_1066",
                                "pc_133_sdram",
                                "pc_1600",
                                "pc_2100_ddr",
                                "pc_2700_ddr",
                                "pc_3000",
                                "pc_3200_ddr",
                                "pc_3500_ddr",
                                "pc_3700",
                                "pc_4000_ddr",
                                "pc_4200",
                                "pc_4300",
                                "pc_4400",
                                "pc_66_sdram",
                                "pc_800",
                                "rambus",
                                "rdram",
                                "rimm",
                                "sdram",
                                "sgram",
                                "simm",
                                "sipp",
                                "sldram",
                                "sodimm",
                                "sorimm",
                                "sram",
                                "unknown",
                                "vram",
                                "wram",
                            ],
                    ],
            ],
            "{$i}ConnectivityType" => [
                "sequence" => "{$s}85",
                "name" => "ConnectivityType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsCard_GraphicsCardDescription" => [
                "sequence" => "{$s}90\\10",
                "name" => "GraphicsCardDescription",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GraphicsCard_GraphicsCardRamSize" => [
                "sequence" => "{$s}90\\20",
                "name" => "GraphicsCardRamSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}GraphicsCardRamSize_unitOfMeasure_MemorySizeUnitOfMeasure"
            ],
            "{$i}GraphicsCard_GraphicsCardInterface" => [
                "sequence" => "{$s}90\\30",
                "name" => "GraphicsCardInterface",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "agp",
                                "integrated",
                                "pci",
                                "pci_e",
                                "unknown",
                            ],
                    ],
            ],
            "{$i}GraphicsChipsetBrand" => [
                "sequence" => "{$s}200",
                "name" => "GraphicsChipsetBrand",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HardDiskTechnology" => [
                "sequence" => "{$s}250",
                "name" => "HardDiskTechnology",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}HardDriveSize" => [
                "sequence" => "{$s}300",
                "name" => "HardDriveSize",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "attribute" => "{$i}HardDriveSize_unitOfMeasure_MemorySizeUnitOfMeasure"

            ],
            "{$i}HardwarePlatform" => [
                "sequence" => "{$s}310",
                "name" => "HardwarePlatform",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ModelNumber" => [
                "sequence" => "{$s}350",
                "name" => "ModelNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}NumberOfAudioOutPorts" => [
                "sequence" => "{$s}370",
                "name" => "NumberOfAudioOutPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfDMIPorts" => [
                "sequence" => "{$s}380",
                "name" => "NumberOfDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfEthernetPorts" => [
                "sequence" => "{$s}390",
                "name" => "NumberOfEthernetPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfFirewirePorts" => [
                "sequence" => "{$s}400",
                "name" => "NumberOfFirewirePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfGamingPorts" => [
                "sequence" => "{$s}410",
                "name" => "NumberOfGamingPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfHDMIPorts" => [
                "sequence" => "{$s}420",
                "name" => "NumberOfHDMIPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfLPT1PrinterPorts" => [
                "sequence" => "{$s}430",
                "name" => "NumberOfLPT1PrinterPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMicrophonePorts" => [
                "sequence" => "{$s}440",
                "name" => "NumberOfMicrophonePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfPS2Ports" => [
                "sequence" => "{$s}450",
                "name" => "NumberOfPS2Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfMicrophonePorts" => [
                "sequence" => "{$s}460",
                "name" => "NumberOfMicrophonePorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfSerialPorts" => [
                "sequence" => "{$s}470",
                "name" => "NumberOfSerialPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSB2.0Ports" => [
                "sequence" => "{$s}480",
                "name" => "NumberOfUSB2.0Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfUSB3.0Ports" => [
                "sequence" => "{$s}490",
                "name" => "NumberOfUSB3.0Ports",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}NumberOfVGAPorts" => [
                "sequence" => "{$s}500",
                "name" => "NumberOfVGAPorts",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}OperatingSystem" => [
                "sequence" => "{$s}520",
                "name" => "OperatingSystem",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ScreenResolution" => [
                "sequence" => "{$s}530",
                "name" => "ScreenResolution",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Series" => [
                "sequence" => "{$s}550",
                "name" => "Series",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getVideoCard()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * VideoCard => 280
         */
        $s = "100\\10\\10\\280\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_VideoCard_";

        $attributes = [
            "ProductData_Computers_ProductType_VideoCard" => [
                "sequence" => "100\\10\\10\\280",
                "name" => "VideoCard",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getVideoProjector()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * VideoProjector => 290
         */
        $s = "100\\10\\10\\290\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_VideoProjector_";

        $attributes = [
            "ProductData_Computers_ProductType_VideoProjector" => [
                "sequence" => "100\\10\\10\\290",
                "name" => "VideoProjector",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getWebcam()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Computers => 10
         * ProductType => 10
         * Webcam => 300
         */
        $s = "100\\10\\10\\300\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Computers_ProductType_Webcam_";

        $attributes = [
            "ProductData_Computers_ProductType_Webcam" => [
                "sequence" => "100\\10\\10\\300",
                "name" => "Webcam",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\20",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}AdditionalFeatures" => [
                "sequence" => "{$s}30",
                "name" => "AdditionalFeatures",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSubAttributes()
    {
        $subAttributes = self::SUB_ATTRIBUTES;

        $i = "ProductData_Computers_";

        switch ($this->subCategory) {
            case "ComputerProcessor":
                $subAttributes = array_merge($subAttributes, $this->getSubComputerProcessor());
                break;
            case "ComputerSpeaker":
                $subAttributes = array_merge($subAttributes, $this->getSubComputerSpeaker());
                break;
            case "Computer":
                $subAttributes = array_merge($subAttributes, $this->getSubComputer());
                break;
            case "MotherBoard":
                $subAttributes = array_merge($subAttributes, $this->getSubMotherBoard());
                break;
            case "NotebookComputer":
                $subAttributes = array_merge($subAttributes, $this->getSubNotebookComputer());
                break;
            case "PersonalComputer":
                $subAttributes = array_merge($subAttributes, $this->getSubPersonalComputer());
                break;
            case "Monitor":
                $subAttributes = array_merge($subAttributes, $this->getSubMonitor());
                break;
            case "TabletComputer":
                $subAttributes = array_merge($subAttributes, $this->getTabletComputer());
                break;
        }

        return $subAttributes;
    }

    public function getSubComputerProcessor()
    {
        $i = "ProductData_Computers_ProductType_ComputerProcessor_";
        $subAttributes = [
            "{$i}ProcessorSpeed_unitOfMeasure_FrequencyUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "Hz",
                                1 => "KHz",
                                2 => "MHz",
                                3 => "GHz",
                            ],
                    ],
                "default" => "Hz"
            ],
        ];
        return $subAttributes;
    }

    public function getSubComputerSpeaker()
    {
        $i = "ProductData_Computers_ProductType_ComputerSpeaker_";
        $subAttributes = [
            "{$i}SpeakerDiameter_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubComputer()
    {
        $i = "ProductData_Computers_ProductType_Computer_";
        $subAttributes = [
            "{$i}TVTunerMemory_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
        ];
        return $subAttributes;
    }

    public function getSubMotherBoard()
    {
        $i = "ProductData_Computers_ProductType_Motherboard_";
        $subAttributes = [
            "{$i}MemoryStorageCapacity_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
        ];
        return $subAttributes;
    }

    public function getSubNotebookComputer()
    {
        $i = "ProductData_Computers_ProductType_NotebookComputer_";
        $subAttributes = [
            "{$i}GraphicsCardRamSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
            "{$i}HardDriveSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
            "{$i}ScreenSize_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}ProcessorSpeed_unitOfMeasure_FrequencyUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "Hz",
                                1 => "KHz",
                                2 => "MHz",
                                2 => "GHz",
                            ],
                    ],
                "default" => "GHz"
            ],
            "{$i}RAMSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
        ];
        return $subAttributes;
    }

    public function getSubPersonalComputer()
    {
        $i = "ProductData_Computers_ProductType_PersonalComputer_";
        $subAttributes = [
            "{$i}GraphicsCardRamSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
            "{$i}HardDriveSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
            "{$i}ScreenSize_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubMonitor()
    {
        $i = "ProductData_Computers_ProductType_Monitor_";
        $subAttributes = [
            "{$i}ScreenSize_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }

    public function getSubTabletComputer()
    {
        $i = "ProductData_Computers_ProductType_TabletComputer_";
        $subAttributes = [
            "{$i}GraphicsCardRamSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
            "{$i}HardDriveSize_unitOfMeasure_MemorySizeUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "TB",
                                1 => "GB",
                                2 => "MB",
                                3 => "KB",
                            ],
                    ],
                "default" => "GB"
            ],
            "{$i}ScreenSize_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }
}
