<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class Collection implements \Amazon\Sdk\Product\CollectionInterface
{
    protected $definitions = [
        'Arts' => [
            'level' => 0,
            'label' => 'Arts',
            'value' => 'Arts',
            'parent' => 'Arts',
            'marketplace' => \Amazon\Sdk\Product\Category\Arts::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Arts::class
        ],
        'Arts_FineArt' => [
            'level' => 1,
            'label' => 'FineArt',
            'value' => 'FineArt',
            'parent' => 'Arts',
            'marketplace' => \Amazon\Sdk\Product\Category\Arts::ALLOWED_MARKETPLACE_FINE_ART,
            'class' => \Amazon\Sdk\Product\Category\Arts::class
        ],
        'Arts_FineArtEditioned' => [
            'level' => 1,
            'label' => 'FineArtEditioned',
            'value' => 'FineArtEditioned',
            'parent' => 'Arts',
            'marketplace' => \Amazon\Sdk\Product\Category\Arts::ALLOWED_MARKETPLACE_FINE_ART_EDITIONED,
            'class' => \Amazon\Sdk\Product\Category\Arts::class
        ],
        'AutoAccessory' => [
            'level' => 0,
            'label' => 'AutoAccessory',
            'value' => 'AutoAccessory',
            'parent' => 'AutoAccessory',
            'marketplace' => \Amazon\Sdk\Product\Category\AutoAccessory::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\AutoAccessory::class
        ],
        'AutoAccessory_Motorcycleaccessory' => [
            'level' => 1,
            'label' => 'Motorcycleaccessory',
            'value' => 'Motorcycleaccessory',
            'parent' => 'AutoAccessory',
            'marketplace' => \Amazon\Sdk\Product\Category\AutoAccessory::ALLOWED_MARKETPLACE_MOTORCYCLE_ACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\AutoAccessory::class
        ],
        'AutoAccessory_AutoAccessoryMisc' => [
            'level' => 1,
            'label' => 'AutoAccessoryMisc',
            'value' => 'AutoAccessoryMisc',
            'parent' => 'AutoAccessory',
            'marketplace' => \Amazon\Sdk\Product\Category\AutoAccessory::ALLOWED_MARKETPLACE_AUTOACCESSORYMISC,
            'class' => \Amazon\Sdk\Product\Category\AutoAccessory::class
        ],
        'AutoAccessory_AutoPart' => [
            'level' => 1,
            'label' => 'AutoPart',
            'value' => 'AutoPart',
            'parent' => 'AutoAccessory',
            'marketplace' => \Amazon\Sdk\Product\Category\AutoAccessory::ALLOWED_MARKETPLACE_AUTOPART_ACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\AutoAccessory::class
        ],
        'Baby' => [
            'level' => 0,
            'label' => 'Baby',
            'value' => 'Baby',
            'parent' => 'Baby',
            'marketplace' => \Amazon\Sdk\Product\Category\Baby::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Baby::class
        ],
        'Baby_BabyProducts' => [
            'level' => 1,
            'label' => 'BabyProducts',
            'value' => 'BabyProducts',
            'parent' => 'Baby',
            'marketplace' => \Amazon\Sdk\Product\Category\Baby::ALLOWED_MARKETPLACE_BABY_PRODUCTS,
            'class' => \Amazon\Sdk\Product\Category\Baby::class
        ],
        'Beauty' => [
            'level' => 0,
            'label' => 'Beauty',
            'value' => 'Beauty',
            'parent' => 'Beauty',
            'marketplace' => \Amazon\Sdk\Product\Category\Beauty::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Beauty::class
        ],
        'Beauty_BeautyMisc' => [
            'level' => 1,
            'label' => 'BeautyMisc',
            'value' => 'BeautyMisc',
            'parent' => 'Beauty',
            'marketplace' => \Amazon\Sdk\Product\Category\Beauty::ALLOWED_MARKETPLACE_BEAUTY_MISC,
            'class' => \Amazon\Sdk\Product\Category\Beauty::class
        ],
        'Books' => [
            'level' => 0,
            'label' => 'Books',
            'value' => 'Books',
            'parent' => 'Books',
            'marketplace' => \Amazon\Sdk\Product\Category\Books::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Books::class
        ],
        'Books_BooksMisc' => [
            'level' => 1,
            'label' => 'BooksMisc',
            'value' => 'BooksMisc',
            'parent' => 'Books',
            'marketplace' => \Amazon\Sdk\Product\Category\Books::ALLOWED_MARKETPLACE_BOOKS_MISC,
            'class' => \Amazon\Sdk\Product\Category\Books::class
        ],
        'CameraPhoto' => [
            'level' => 0,
            'label' => 'CameraPhoto',
            'value' => 'CameraPhoto',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_FilmCamera' => [
            'level' => 1,
            'label' => 'FilmCamera',
            'value' => 'FilmCamera',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_FILM_CAMERA,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Camcorder' => [
            'level' => 1,
            'label' => 'Camcorder',
            'value' => 'Camcorder',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_CAMCORDER,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_DigitalCamera' => [
            'level' => 1,
            'label' => 'DigitalCamera',
            'value' => 'DigitalCamera',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_DIGITAL_CAMERA,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Binocular' => [
            'level' => 1,
            'label' => 'Binocular',
            'value' => 'Binocular',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_BINOCULAR,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_SurveillanceSystem' => [
            'level' => 1,
            'label' => 'SurveillanceSystem',
            'value' => 'SurveillanceSystem',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_SURVEILLANCE_SYSTEM,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Telescope' => [
            'level' => 1,
            'label' => 'Telescope',
            'value' => 'Telescope',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_TELESCOPE,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Microscope' => [
            'level' => 1,
            'label' => 'Microscope',
            'value' => 'Microscope',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_MICROSCOPE,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Darkroom' => [
            'level' => 1,
            'label' => 'Darkroom',
            'value' => 'Darkroom',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_DARK_ROOM,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Lens' => [
            'level' => 1,
            'label' => 'Lens',
            'value' => 'Lens',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_LENS,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_LensAccessory' => [
            'level' => 1,
            'label' => 'LensAccessory',
            'value' => 'LensAccessory',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_LENSACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Filter' => [
            'level' => 1,
            'label' => 'Filter',
            'value' => 'Filter',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_FILTER,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Film' => [
            'level' => 1,
            'label' => 'Film',
            'value' => 'Film',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_FILM,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_BagCase' => [
            'level' => 1,
            'label' => 'BagCase',
            'value' => 'BagCase',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_BAG_CASE,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_BlankMedia' => [
            'level' => 1,
            'label' => 'BlankMedia',
            'value' => 'BlankMedia',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_BLANK_MEDIA,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_PhotoPaper' => [
            'level' => 1,
            'label' => 'PhotoPaper',
            'value' => 'PhotoPaper',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_PHOTO_PAPER,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Cleaner' => [
            'level' => 1,
            'label' => 'Cleaner',
            'value' => 'Cleaner',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_CLEANER,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Flash' => [
            'level' => 1,
            'label' => 'Flash',
            'value' => 'Flash',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_FLASH,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_TripodStand' => [
            'level' => 1,
            'label' => 'TripodStand',
            'value' => 'TripodStand',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_TRIPOD_STAND,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Lighting' => [
            'level' => 1,
            'label' => 'Lighting',
            'value' => 'Lighting',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_LIGHTING,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_Projection' => [
            'level' => 1,
            'label' => 'Projection',
            'value' => 'Projection',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_PROJECTION,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_PhotoStudio' => [
            'level' => 1,
            'label' => 'PhotoStudio',
            'value' => 'PhotoStudio',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_PHOTO_STUDIO,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_LightMeter' => [
            'level' => 1,
            'label' => 'LightMeter',
            'value' => 'LightMeter',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_LIGHT_METER,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_PowerSupply' => [
            'level' => 1,
            'label' => 'PowerSupply',
            'value' => 'PowerSupply',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_POWER_SUPPLY,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CameraPhoto_OtherAccessory' => [
            'level' => 1,
            'label' => 'OtherAccessory',
            'value' => 'OtherAccessory',
            'parent' => 'CameraPhoto',
            'marketplace' => \Amazon\Sdk\Product\Category\CameraPhoto::ALLOWED_MARKETPLACE_OTHER_ACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\CameraPhoto::class
        ],
        'CE' => [
            'level' => 0,
            'label' => 'CE',
            'value' => 'CE',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_Antenna' => [
            'level' => 1,
            'label' => 'Antenna',
            'value' => 'Antenna',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_ANTENNA,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_AudioVideoAccessory' => [
            'level' => 1,
            'label' => 'AudioVideoAccessory',
            'value' => 'AudioVideoAccessory',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_AUDIOVIDEOACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_AVFurniture' => [
            'level' => 1,
            'label' => 'AVFurniture',
            'value' => 'AVFurniture',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_AVFURNITURE,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_BarCodeReader' => [
            'level' => 1,
            'label' => 'BarCodeReader',
            'value' => 'BarCodeReader',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_BARCODEREADER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CEBinocular' => [
            'level' => 1,
            'label' => 'CEBinocular',
            'value' => 'CEBinocular',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CEBINOCULAR,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CECamcorder' => [
            'level' => 1,
            'label' => 'CECamcorder',
            'value' => 'CECamcorder',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CECAMCORDER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CameraBagsAndCases' => [
            'level' => 1,
            'label' => 'CameraBagsAndCases',
            'value' => 'CameraBagsAndCases',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CAMERABAGSANDCASES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CEBattery' => [
            'level' => 1,
            'label' => 'CEBattery',
            'value' => 'CEBattery',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CEBATTERY,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CEBlankMedia' => [
            'level' => 1,
            'label' => 'CEBlankMedia',
            'value' => 'CEBlankMedia',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CEBLANKMEDIA,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CableOrAdapter' => [
            'level' => 1,
            'label' => 'CableOrAdapter',
            'value' => 'CableOrAdapter',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CABLEORADAPTER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CECameraFlash' => [
            'level' => 1,
            'label' => 'CECameraFlash',
            'value' => 'CECameraFlash',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CECAMERAFLASH,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CameraLenses' => [
            'level' => 1,
            'label' => 'CameraLenses',
            'value' => 'CameraLenses',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CAMERALENSES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CameraOtherAccessories' => [
            'level' => 1,
            'label' => 'CameraOtherAccessories',
            'value' => 'CameraOtherAccessories',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CAMERAOTHERACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CameraPowerSupply' => [
            'level' => 1,
            'label' => 'CameraPowerSupply',
            'value' => 'CameraPowerSupply',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CAMERAPOWERSUPPLY,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CarAlarm' => [
            'level' => 1,
            'label' => 'CarAlarm',
            'value' => 'CarAlarm',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CARALARM,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CarAudioOrTheater' => [
            'level' => 1,
            'label' => 'CarAudioOrTheater',
            'value' => 'CarAudioOrTheater',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CARAUDIOORTHEATER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CarElectronics' => [
            'level' => 1,
            'label' => 'CarElectronics',
            'value' => 'CarElectronics',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CARELECTRONICS,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_ConsumerElectronics' => [
            'level' => 1,
            'label' => 'ConsumerElectronics',
            'value' => 'ConsumerElectronics',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CONSUMERELECTRONICS,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CEDigitalCamera' => [
            'level' => 1,
            'label' => 'CEDigitalCamera',
            'value' => 'CEDigitalCamera',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CEDIGITALCAMERA,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_DigitalPictureFrame' => [
            'level' => 1,
            'label' => 'DigitalPictureFrame',
            'value' => 'DigitalPictureFrame',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_DIGITALPICTUREFRAME,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_DigitalVideoRecorder' => [
            'level' => 1,
            'label' => 'DigitalVideoRecorder',
            'value' => 'DigitalVideoRecorder',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_DIGITALVIDEORECORDER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_DVDPlayerOrRecorder' => [
            'level' => 1,
            'label' => 'DVDPlayerOrRecorder',
            'value' => 'DVDPlayerOrRecorder',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_DVDPLAYERORRECORDER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CEFilmCamera' => [
            'level' => 1,
            'label' => 'CEFilmCamera',
            'value' => 'CEFilmCamera',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CEFILMCAMERA,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_GPSOrNavigationAccessory' => [
            'level' => 1,
            'label' => 'GPSOrNavigationAccessory',
            'value' => 'GPSOrNavigationAccessory',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_GPSORNAVIGATIONACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_GPSOrNavigationSystem' => [
            'level' => 1,
            'label' => 'GPSOrNavigationSystem',
            'value' => 'GPSOrNavigationSystem',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_GPSORNAVIGATIONSYSTEM,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_HandheldOrPDA' => [
            'level' => 1,
            'label' => 'HandheldOrPDA',
            'value' => 'HandheldOrPDA',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_HANDHELDORPDA,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_Headphones' => [
            'level' => 1,
            'label' => 'Headphones',
            'value' => 'Headphones',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_HEADPHONES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_HomeTheaterSystemOrHTIB' => [
            'level' => 1,
            'label' => 'HomeTheaterSystemOrHTIB',
            'value' => 'HomeTheaterSystemOrHTIB',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_HOMETHEATERSYSTEMORHTIB,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_KindleAccessories' => [
            'level' => 1,
            'label' => 'KindleAccessories',
            'value' => 'KindleAccessories',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_KINDLEACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_KindleEReaderAccessories' => [
            'level' => 1,
            'label' => 'KindleEReaderAccessories',
            'value' => 'KindleEReaderAccessories',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_KINDLEEREADERACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_KindleFireAccessories' => [
            'level' => 1,
            'label' => 'KindleFireAccessories',
            'value' => 'KindleFireAccessories',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_KINDLEFIREACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_MediaPlayer' => [
            'level' => 1,
            'label' => 'MediaPlayer',
            'value' => 'MediaPlayer',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_MEDIAPLAYER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_MediaPlayerOrEReaderAccessory' => [
            'level' => 1,
            'label' => 'MediaPlayerOrEReaderAccessory',
            'value' => 'MediaPlayerOrEReaderAccessory',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_MEDIAPLAYEROREREADERACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_MediaStorage' => [
            'level' => 1,
            'label' => 'MediaStorage',
            'value' => 'MediaStorage',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_MEDIASTORAGE,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_MiscAudioComponents' => [
            'level' => 1,
            'label' => 'MiscAudioComponents',
            'value' => 'MiscAudioComponents',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_MISCAUDIOCOMPONENTS,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PC' => [
            'level' => 1,
            'label' => 'PC',
            'value' => 'PC',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PC,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PDA' => [
            'level' => 1,
            'label' => 'PDA',
            'value' => 'PDA',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PDA,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_Phone' => [
            'level' => 1,
            'label' => 'Phone',
            'value' => 'Phone',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PHONE,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PhoneAccessory' => [
            'level' => 1,
            'label' => 'PhoneAccessory',
            'value' => 'PhoneAccessory',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PHONEACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PhotographicStudioItems' => [
            'level' => 1,
            'label' => 'PhotographicStudioItems',
            'value' => 'PhotographicStudioItems',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PHOTOGRAPHICSTUDIOITEMS,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PortableAudio' => [
            'level' => 1,
            'label' => 'PortableAudio',
            'value' => 'PortableAudio',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PORTABLEAUDIO,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PortableAvDevice' => [
            'level' => 1,
            'label' => 'PortableAvDevice',
            'value' => 'PortableAvDevice',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_PORTABLEAVDEVICE,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_PowerSuppliesOrProtection' => [
            'level' => 1,
            'label' => 'PowerSuppliesOrProtection',
            'value' => 'PowerSuppliesOrProtection',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_POWERSUPPLIESORPROTECTION,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_RadarDetector' => [
            'level' => 1,
            'label' => 'RadarDetector',
            'value' => 'RadarDetector',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_RADARDETECTOR,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_RadioOrClockRadio' => [
            'level' => 1,
            'label' => 'RadioOrClockRadio',
            'value' => 'RadioOrClockRadio',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_RADIOORCLOCKRADIO,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_ReceiverOrAmplifier' => [
            'level' => 1,
            'label' => 'ReceiverOrAmplifier',
            'value' => 'ReceiverOrAmplifier',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_RECEIVERORAMPLIFIER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_RemoteControl' => [
            'level' => 1,
            'label' => 'RemoteControl',
            'value' => 'RemoteControl',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_REMOTECONTROL,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_Speakers' => [
            'level' => 1,
            'label' => 'Speakers',
            'value' => 'Speakers',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_SPEAKERS,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_StereoShelfSystem' => [
            'level' => 1,
            'label' => 'StereoShelfSystem',
            'value' => 'StereoShelfSystem',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_STEREOSHELFSYSTEM,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CETelescope' => [
            'level' => 1,
            'label' => 'CETelescope',
            'value' => 'CETelescope',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CETELESCOPE,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_Television' => [
            'level' => 1,
            'label' => 'Television',
            'value' => 'Television',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_TELEVISION,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_Tuner' => [
            'level' => 1,
            'label' => 'Tuner',
            'value' => 'Tuner',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_TUNER,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_TVCombos' => [
            'level' => 1,
            'label' => 'TVCombos',
            'value' => 'TVCombos',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_TVCOMBOS,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_TwoWayRadio' => [
            'level' => 1,
            'label' => 'TwoWayRadio',
            'value' => 'TwoWayRadio',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_TWOWAYRADIO,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_VCR' => [
            'level' => 1,
            'label' => 'VCR',
            'value' => 'VCR',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_VCR,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_CEVideoProjector' => [
            'level' => 1,
            'label' => 'CEVideoProjector',
            'value' => 'CEVideoProjector',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_CEVIDEOPROJECTOR,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'CE_VideoProjectorsAndAccessories' => [
            'level' => 1,
            'label' => 'VideoProjectorsAndAccessories',
            'value' => 'VideoProjectorsAndAccessories',
            'parent' => 'CE',
            'marketplace' => \Amazon\Sdk\Product\Category\CE::ALLOWED_MARKETPLACE_VIDEOPROJECTORSANDACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\CE::class
        ],
        'Clothing' => [
            'level' => 0,
            'label' => 'Clothing',
            'value' => 'Clothing',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Clothing' => [
            'level' => 1,
            'label' => 'Clothing',
            'value' => 'Clothing',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Shirt' => [
            'level' => 1,
            'label' => 'Shirt',
            'value' => 'Shirt',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Sweater' => [
            'level' => 1,
            'label' => 'Sweater',
            'value' => 'Sweater',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Pants' => [
            'level' => 1,
            'label' => 'Pants',
            'value' => 'Pants',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Shorts' => [
            'level' => 1,
            'label' => 'Shorts',
            'value' => 'Shorts',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Skirt' => [
            'level' => 1,
            'label' => 'Skirt',
            'value' => 'Skirt',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Dress' => [
            'level' => 1,
            'label' => 'Dress',
            'value' => 'Dress',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Suit' => [
            'level' => 1,
            'label' => 'Suit',
            'value' => 'Suit',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Blazer' => [
            'level' => 1,
            'label' => 'Blazer',
            'value' => 'Blazer',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Outerwear' => [
            'level' => 1,
            'label' => 'Outerwear',
            'value' => 'Outerwear',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_SocksHosiery' => [
            'level' => 1,
            'label' => 'SocksHosiery',
            'value' => 'SocksHosiery',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Underwear' => [
            'level' => 1,
            'label' => 'Underwear',
            'value' => 'Underwear',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Bra' => [
            'level' => 1,
            'label' => 'Bra',
            'value' => 'Bra',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Shoes' => [
            'level' => 1,
            'label' => 'Shoes',
            'value' => 'Shoes',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Hat' => [
            'level' => 1,
            'label' => 'Hat',
            'value' => 'Hat',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Bag' => [
            'level' => 1,
            'label' => 'Bag',
            'value' => 'Bag',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Accessory' => [
            'level' => 1,
            'label' => 'Accessory',
            'value' => 'Accessory',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Jewelry' => [
            'level' => 1,
            'label' => 'Jewelry',
            'value' => 'Jewelry',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Sleepwear' => [
            'level' => 1,
            'label' => 'Sleepwear',
            'value' => 'Sleepwear',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Swimwear' => [
            'level' => 1,
            'label' => 'Swimwear',
            'value' => 'Swimwear',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_PersonalBodyCare' => [
            'level' => 1,
            'label' => 'PersonalBodyCare',
            'value' => 'PersonalBodyCare',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_HomeAccessory' => [
            'level' => 1,
            'label' => 'HomeAccessory',
            'value' => 'HomeAccessory',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_NonApparelMisc' => [
            'level' => 1,
            'label' => 'NonApparelMisc',
            'value' => 'NonApparelMisc',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Kimono' => [
            'level' => 1,
            'label' => 'Kimono',
            'value' => 'Kimono',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Obi' => [
            'level' => 1,
            'label' => 'Obi',
            'value' => 'Obi',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Chanchanko' => [
            'level' => 1,
            'label' => 'Chanchanko',
            'value' => 'Chanchanko',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Jinbei' => [
            'level' => 1,
            'label' => 'Jinbei',
            'value' => 'Jinbei',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Yukata' => [
            'level' => 1,
            'label' => 'Yukata',
            'value' => 'Yukata',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_EthnicWear' => [
            'level' => 1,
            'label' => 'EthnicWear',
            'value' => 'EthnicWear',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_Costume' => [
            'level' => 1,
            'label' => 'Costume',
            'value' => 'Costume',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_AdultCostume' => [
            'level' => 1,
            'label' => 'AdultCostume',
            'value' => 'AdultCostume',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_BabyCostume' => [
            'level' => 1,
            'label' => 'BabyCostume',
            'value' => 'BabyCostume',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'Clothing_ChildrensCostume' => [
            'level' => 1,
            'label' => 'ChildrensCostume',
            'value' => 'ChildrensCostume',
            'parent' => 'Clothing',
            'marketplace' => \Amazon\Sdk\Product\Category\Clothing::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Clothing::class
        ],
        'ClothingAccessories' => [
            'level' => 0,
            'label' => 'ClothingAccessories',
            'value' => 'ClothingAccessories',
            'parent' => 'ClothingAccessories',
            'marketplace' => \Amazon\Sdk\Product\Category\ClothingAccessories::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\ClothingAccessories::class
        ],
        'ClothingAccessories_ClothingAccessories' => [
            'level' => 1,
            'label' => 'ClothingAccessories',
            'value' => 'ClothingAccessories',
            'parent' => 'ClothingAccessories',
            'marketplace' => \Amazon\Sdk\Product\Category\ClothingAccessories::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\ClothingAccessories::class
        ],
        'Coins' => [
            'level' => 0,
            'label' => 'Coins',
            'value' => 'Coins',
            'parent' => 'Coins',
            'marketplace' => \Amazon\Sdk\Product\Category\Coins::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Coins::class
        ],
        'Coins_Coin' => [
            'level' => 1,
            'label' => 'Coin',
            'value' => 'Coin',
            'parent' => 'Coins',
            'marketplace' => \Amazon\Sdk\Product\Category\Coins::ALLOWED_MARKETPLACE_COIN,
            'class' => \Amazon\Sdk\Product\Category\Coins::class
        ],
        'Coins_CollectibleCoins' => [
            'level' => 1,
            'label' => 'CollectibleCoins',
            'value' => 'CollectibleCoins',
            'parent' => 'Coins',
            'marketplace' => \Amazon\Sdk\Product\Category\Coins::ALLOWED_MARKETPLACE_COLLECTIBLE_COINS,
            'class' => \Amazon\Sdk\Product\Category\Coins::class
        ],
        'Coins_Bullion' => [
            'level' => 1,
            'label' => 'Bullion',
            'value' => 'Bullion',
            'parent' => 'Coins',
            'marketplace' => \Amazon\Sdk\Product\Category\Coins::ALLOWED_MARKETPLACE_BULLION,
            'class' => \Amazon\Sdk\Product\Category\Coins::class
        ],
        'Collectibles' => [
            'level' => 0,
            'label' => 'Collectibles',
            'value' => 'Collectibles',
            'parent' => 'Collectibles',
            'marketplace' => \Amazon\Sdk\Product\Category\Collectibles::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Collectibles::class
        ],
        'Collectibles_AdvertisementCollectibles' => [
            'level' => 1,
            'label' => 'AdvertisementCollectibles',
            'value' => 'AdvertisementCollectibles',
            'parent' => 'Collectibles',
            'marketplace' => \Amazon\Sdk\Product\Category\Collectibles::ALLOWED_MARKETPLACE_ADVERTISEMENT_COLLECTIBLES,
            'class' => \Amazon\Sdk\Product\Category\Collectibles::class
        ],
        'Collectibles_HistoricalCollectibles' => [
            'level' => 1,
            'label' => 'HistoricalCollectibles',
            'value' => 'HistoricalCollectibles',
            'parent' => 'Collectibles',
            'marketplace' => \Amazon\Sdk\Product\Category\Collectibles::ALLOWED_MARKETPLACE_HISTORICAL_COLLECTIBLES,
            'class' => \Amazon\Sdk\Product\Category\Collectibles::class
        ],
        'Computers' => [
            'level' => 0,
            'label' => 'Computers',
            'value' => 'Computers',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_CarryingCaseOrBag' => [
            'level' => 1,
            'label' => 'CarryingCaseOrBag',
            'value' => 'CarryingCaseOrBag',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_CARRYING_CASE_OR_BAG,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerAddOn' => [
            'level' => 1,
            'label' => 'ComputerAddOn',
            'value' => 'ComputerAddOn',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_ADDON,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerComponent' => [
            'level' => 1,
            'label' => 'ComputerComponent',
            'value' => 'ComputerComponent',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_COMPONENT,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerCoolingDevice' => [
            'level' => 1,
            'label' => 'ComputerCoolingDevice',
            'value' => 'ComputerCoolingDevice',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_COOLING_DEVICE,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerDriveOrStorage' => [
            'level' => 1,
            'label' => 'ComputerDriveOrStorage',
            'value' => 'ComputerDriveOrStorage',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_DRIVE_OR_STORAGE,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerInputDevice' => [
            'level' => 1,
            'label' => 'ComputerInputDevice',
            'value' => 'ComputerInputDevice',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_INPUT_DEVICE,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerProcessor' => [
            'level' => 1,
            'label' => 'ComputerProcessor',
            'value' => 'ComputerProcessor',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_PROCESSOR,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_ComputerSpeaker' => [
            'level' => 1,
            'label' => 'ComputerSpeaker',
            'value' => 'ComputerSpeaker',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER_SPEAKER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Computer' => [
            'level' => 1,
            'label' => 'Computer',
            'value' => 'Computer',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_COMPUTER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_FlashMemory' => [
            'level' => 1,
            'label' => 'FlashMemory',
            'value' => 'FlashMemory',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_FLASH_MEMORY,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_InkOrToner' => [
            'level' => 1,
            'label' => 'InkOrToner',
            'value' => 'InkOrToner',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_INKOR_TONER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Keyboards' => [
            'level' => 1,
            'label' => 'Keyboards',
            'value' => 'Keyboards',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_KEYBOARDS,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_MemoryReader' => [
            'level' => 1,
            'label' => 'MemoryReader',
            'value' => 'MemoryReader',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_MEMORY_READER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Monitor' => [
            'level' => 1,
            'label' => 'Monitor',
            'value' => 'Monitor',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_MONITOR,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Motherboard' => [
            'level' => 1,
            'label' => 'Motherboard',
            'value' => 'Motherboard',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_MOTHER_BOARD,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_NetworkingDevice' => [
            'level' => 1,
            'label' => 'NetworkingDevice',
            'value' => 'NetworkingDevice',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_NETWORKING_DEVICE,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_NotebookComputer' => [
            'level' => 1,
            'label' => 'NotebookComputer',
            'value' => 'NotebookComputer',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_NOTEBOOK_COMPUTER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_PersonalComputer' => [
            'level' => 1,
            'label' => 'PersonalComputer',
            'value' => 'PersonalComputer',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_PERSONAL_COMPUTER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Printer' => [
            'level' => 1,
            'label' => 'Printer',
            'value' => 'Printer',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_PRINTER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_RamMemory' => [
            'level' => 1,
            'label' => 'RamMemory',
            'value' => 'RamMemory',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_RAM_MEMORY,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Scanner' => [
            'level' => 1,
            'label' => 'Scanner',
            'value' => 'Scanner',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_SCANNER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_SoundCard' => [
            'level' => 1,
            'label' => 'SoundCard',
            'value' => 'SoundCard',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_SOUND_CARD,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_SystemCabinet' => [
            'level' => 1,
            'label' => 'SystemCabinet',
            'value' => 'SystemCabinet',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_SYSTEM_CABINET,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_SystemPowerDevice' => [
            'level' => 1,
            'label' => 'SystemPowerDevice',
            'value' => 'SystemPowerDevice',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_SYSTEM_POWER_DEVICE,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_TabletComputer' => [
            'level' => 1,
            'label' => 'TabletComputer',
            'value' => 'TabletComputer',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_TABLET_COMPUTER,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_VideoCard' => [
            'level' => 1,
            'label' => 'VideoCard',
            'value' => 'VideoCard',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_VIDEO_CARD,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_VideoProjector' => [
            'level' => 1,
            'label' => 'VideoProjector',
            'value' => 'VideoProjector',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_VIDEO_PROJECTOR,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'Computers_Webcam' => [
            'level' => 1,
            'label' => 'Webcam',
            'value' => 'Webcam',
            'parent' => 'Computers',
            'marketplace' => \Amazon\Sdk\Product\Category\Computers::ALLOWED_MARKETPLACE_WEBCAM,
            'class' => \Amazon\Sdk\Product\Category\Computers::class
        ],
        'DefaultCategory' => [
            'level' => 0,
            'label' => 'DefaultCategory',
            'value' => 'DefaultCategory',
            'parent' => 'DefaultCategory',
            'marketplace' => \Amazon\Sdk\Product\Category\DefaultCategory::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\DefaultCategory::class
        ],
        'DefaultCategory_DefaultCategory' => [
            'level' => 1,
            'label' => 'DefaultCategory',
            'value' => 'DefaultCategory',
            'parent' => 'DefaultCategory',
            'marketplace' => \Amazon\Sdk\Product\Category\DefaultCategory::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\DefaultCategory::class
        ],
        'EducationSupplies' => [
            'level' => 0,
            'label' => 'EducationSupplies',
            'value' => 'EducationSupplies',
            'parent' => 'EducationSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\EducationSupplies::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\EducationSupplies::class
        ],
        'EducationSupplies_TeachingEquipment' => [
            'level' => 1,
            'label' => 'TeachingEquipment',
            'value' => 'TeachingEquipment',
            'parent' => 'EducationSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\EducationSupplies::ALLOWED_MARKETPLACE_TEACHING_EQUIPMENT,
            'class' => \Amazon\Sdk\Product\Category\EducationSupplies::class
        ],
        'EntertainmentCollectibles' => [
            'level' => 0,
            'label' => 'EntertainmentCollectibles',
            'value' => 'EntertainmentCollectibles',
            'parent' => 'EntertainmentCollectibles',
            'marketplace' => \Amazon\Sdk\Product\Category\EntertainmentCollectibles::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\EntertainmentCollectibles::class
        ],
        'EntertainmentCollectibles_EntertainmentMemorabilia' => [
            'level' => 1,
            'label' => 'EntertainmentMemorabilia',
            'value' => 'EntertainmentMemorabilia',
            'parent' => 'EntertainmentCollectibles',
            'marketplace' => \Amazon\Sdk\Product\Category\EntertainmentCollectibles::ALLOWED_MARKETPLACE_ENTERTAINMENT_MEMORABILIA,
            'class' => \Amazon\Sdk\Product\Category\EntertainmentCollectibles::class
        ],
        'FoodAndBeverages' => [
            'level' => 0,
            'label' => 'FoodAndBeverages',
            'value' => 'FoodAndBeverages',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_Food' => [
            'level' => 1,
            'label' => 'Food',
            'value' => 'Food',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_FOOD,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_HouseholdSupplies' => [
            'level' => 1,
            'label' => 'HouseholdSupplies',
            'value' => 'HouseholdSupplies',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_HOUSEHOLD_SUPPLIES,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_Beverages' => [
            'level' => 1,
            'label' => 'Beverages',
            'value' => 'Beverages',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_BEVERAGES,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_HardLiquor' => [
            'level' => 1,
            'label' => 'HardLiquor',
            'value' => 'HardLiquor',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_HARD_LIQUOR,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_AlcoholicBeverages' => [
            'level' => 1,
            'label' => 'AlcoholicBeverages',
            'value' => 'AlcoholicBeverages',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_ALCOHOLIC_BEVERAGES,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_Wine' => [
            'level' => 1,
            'label' => 'Wine',
            'value' => 'Wine',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_WINE,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_Beer' => [
            'level' => 1,
            'label' => 'Beer',
            'value' => 'Beer',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_BEER,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodAndBeverages_Spirits' => [
            'level' => 1,
            'label' => 'Spirits',
            'value' => 'Spirits',
            'parent' => 'FoodAndBeverages',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodAndBeverages::ALLOWED_MARKETPLACE_SPIRITS,
            'class' => \Amazon\Sdk\Product\Category\FoodAndBeverages::class
        ],
        'FoodServiceAndJanSan' => [
            'level' => 0,
            'label' => 'FoodServiceAndJanSan',
            'value' => 'FoodServiceAndJanSan',
            'parent' => 'FoodServiceAndJanSan',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodServiceAndJanSan::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\FoodServiceAndJanSan::class
        ],
        'FoodServiceAndJanSan_FoodServiceAndJanSan' => [
            'level' => 1,
            'label' => 'FoodServiceAndJanSan',
            'value' => 'FoodServiceAndJanSan',
            'parent' => 'FoodServiceAndJanSan',
            'marketplace' => \Amazon\Sdk\Product\Category\FoodServiceAndJanSan::ALLOWED_MARKETPLACE_FOOD_SERVICE_AND_JANSAN,
            'class' => \Amazon\Sdk\Product\Category\FoodServiceAndJanSan::class
        ],
        'Furniture' => [
            'level' => 0,
            'label' => 'Furniture',
            'value' => 'Furniture',
            'parent' => 'Furniture',
            'marketplace' => \Amazon\Sdk\Product\Category\Furniture::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Furniture::class
        ],
        'Furniture_Furniture' => [
            'level' => 1,
            'label' => 'Furniture',
            'value' => 'Furniture',
            'parent' => 'Furniture',
            'marketplace' => \Amazon\Sdk\Product\Category\Furniture::ALLOWED_MARKETPLACE_FURNITURE,
            'class' => \Amazon\Sdk\Product\Category\Furniture::class
        ],
        'GiftCard' => [
            'level' => 0,
            'label' => 'GiftCard',
            'value' => 'GiftCard',
            'parent' => 'GiftCard',
            'marketplace' => \Amazon\Sdk\Product\Category\GiftCard::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\GiftCard::class
        ],
        'GiftCard_GiftCard' => [
            'level' => 1,
            'label' => 'GiftCard',
            'value' => 'GiftCard',
            'parent' => 'GiftCard',
            'marketplace' => \Amazon\Sdk\Product\Category\GiftCard::ALLOWED_MARKETPLACE_GIFT_CARD,
            'class' => \Amazon\Sdk\Product\Category\GiftCard::class
        ],
        'GiftCard_PhysicalGiftCard' => [
            'level' => 1,
            'label' => 'PhysicalGiftCard',
            'value' => 'PhysicalGiftCard',
            'parent' => 'GiftCard',
            'marketplace' => \Amazon\Sdk\Product\Category\GiftCard::ALLOWED_MARKETPLACE_PHYSICAL_GIFT_CARD,
            'class' => \Amazon\Sdk\Product\Category\GiftCard::class
        ],
        'GiftCard_ElectronicGiftCard' => [
            'level' => 1,
            'label' => 'ElectronicGiftCard',
            'value' => 'ElectronicGiftCard',
            'parent' => 'GiftCard',
            'marketplace' => \Amazon\Sdk\Product\Category\GiftCard::ALLOWED_MARKETPLACE_ELECTRONIC_GIFT_CARD,
            'class' => \Amazon\Sdk\Product\Category\GiftCard::class
        ],
        'Gourmet' => [
            'level' => 0,
            'label' => 'Gourmet',
            'value' => 'Gourmet',
            'parent' => 'Gourmet',
            'marketplace' => \Amazon\Sdk\Product\Category\Gourmet::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Gourmet::class
        ],
        'Gourmet_GourmetMisc' => [
            'level' => 1,
            'label' => 'GourmetMisc',
            'value' => 'GourmetMisc',
            'parent' => 'Gourmet',
            'marketplace' => \Amazon\Sdk\Product\Category\Gourmet::ALLOWED_MARKETPLACE_GOURMET_MISC,
            'class' => \Amazon\Sdk\Product\Category\Gourmet::class
        ],
        'Health' => [
            'level' => 0,
            'label' => 'Health',
            'value' => 'Health',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_HealthMisc' => [
            'level' => 1,
            'label' => 'HealthMisc',
            'value' => 'HealthMisc',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_HEALTH_MISC,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_PersonalCareAppliances' => [
            'level' => 1,
            'label' => 'PersonalCareAppliances',
            'value' => 'PersonalCareAppliances',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_PERSONAL_CARE_APPLIANCES,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_PrescriptionDrug' => [
            'level' => 1,
            'label' => 'PrescriptionDrug',
            'value' => 'PrescriptionDrug',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_PRESCRIPTION_DRUG,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_DietarySupplements' => [
            'level' => 1,
            'label' => 'DietarySupplements',
            'value' => 'DietarySupplements',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_DIETARY_SUPPLEMENTS,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_OTCMedication' => [
            'level' => 1,
            'label' => 'OTCMedication',
            'value' => 'OTCMedication',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_OTCMEDICATION,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_PrescriptionEyewear' => [
            'level' => 1,
            'label' => 'PrescriptionEyewear',
            'value' => 'PrescriptionEyewear',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_PRESCRIPTION_EYE_WEAR,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Health_SexualWellness' => [
            'level' => 1,
            'label' => 'SexualWellness',
            'value' => 'SexualWellness',
            'parent' => 'Health',
            'marketplace' => \Amazon\Sdk\Product\Category\Health::ALLOWED_MARKETPLACE_SEXUAL_WELLNESS,
            'class' => \Amazon\Sdk\Product\Category\Health::class
        ],
        'Home' => [
            'level' => 0,
            'label' => 'Home',
            'value' => 'Home',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_Home' => [
            'level' => 1,
            'label' => 'Home',
            'value' => 'Home',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_BedAndBath' => [
            'level' => 1,
            'label' => 'BedAndBath',
            'value' => 'BedAndBath',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_FurnitureAndDecor' => [
            'level' => 1,
            'label' => 'FurnitureAndDecor',
            'value' => 'FurnitureAndDecor',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_Kitchen' => [
            'level' => 1,
            'label' => 'Kitchen',
            'value' => 'Kitchen',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_OutdoorLiving' => [
            'level' => 1,
            'label' => 'OutdoorLiving',
            'value' => 'OutdoorLiving',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_SeedsAndPlants' => [
            'level' => 1,
            'label' => 'SeedsAndPlants',
            'value' => 'SeedsAndPlants',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'Home_Art' => [
            'level' => 1,
            'label' => 'Art',
            'value' => 'Art',
            'parent' => 'Home',
            'marketplace' => \Amazon\Sdk\Product\Category\Home::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Home::class
        ],
        'HomeImprovement' => [
            'level' => 0,
            'label' => 'HomeImprovement',
            'value' => 'HomeImprovement',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_BuildingMaterials' => [
            'level' => 1,
            'label' => 'BuildingMaterials',
            'value' => 'BuildingMaterials',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_BUILDING_MATERIALS,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_Hardware' => [
            'level' => 1,
            'label' => 'Hardware',
            'value' => 'Hardware',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_HARDWARE,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_Electrical' => [
            'level' => 1,
            'label' => 'Electrical',
            'value' => 'Electrical',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_ELECTRICAL,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_PlumbingFixtures' => [
            'level' => 1,
            'label' => 'PlumbingFixtures',
            'value' => 'PlumbingFixtures',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_PLUMBING_FIXTURES,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_OrganizersAndStorage' => [
            'level' => 1,
            'label' => 'OrganizersAndStorage',
            'value' => 'OrganizersAndStorage',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_ORGANIZERS_AND_STORAGE,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_MajorHomeAppliances' => [
            'level' => 1,
            'label' => 'MajorHomeAppliances',
            'value' => 'MajorHomeAppliances',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_MAJOR_HOME_APPLIANCES,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_Tools' => [
            'level' => 1,
            'label' => 'Tools',
            'value' => 'Tools',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_TOOLS,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'HomeImprovement_SecurityElectronics' => [
            'level' => 1,
            'label' => 'SecurityElectronics',
            'value' => 'SecurityElectronics',
            'parent' => 'HomeImprovement',
            'marketplace' => \Amazon\Sdk\Product\Category\HomeImprovement::ALLOWED_MARKETPLACE_SECURITY_ELECTRONICS,
            'class' => \Amazon\Sdk\Product\Category\HomeImprovement::class
        ],
        'Industrial' => [
            'level' => 0,
            'label' => 'Industrial',
            'value' => 'Industrial',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_Abrasives' => [
            'level' => 1,
            'label' => 'Abrasives',
            'value' => 'Abrasives',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_ABRASIVES,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_AdhesivesAndSealants' => [
            'level' => 1,
            'label' => 'AdhesivesAndSealants',
            'value' => 'AdhesivesAndSealants',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_ADHESIVES_AND_SEALANTS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_CuttingTools' => [
            'level' => 1,
            'label' => 'CuttingTools',
            'value' => 'CuttingTools',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_CUTTING_TOOLS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_ElectronicComponents' => [
            'level' => 1,
            'label' => 'ElectronicComponents',
            'value' => 'ElectronicComponents',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_ELECTRONIC_COMPONENTS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_Gears' => [
            'level' => 1,
            'label' => 'Gears',
            'value' => 'Gears',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_GEARS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_Grommets' => [
            'level' => 1,
            'label' => 'Grommets',
            'value' => 'Grommets',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_GROMMETS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_IndustrialHose' => [
            'level' => 1,
            'label' => 'IndustrialHose',
            'value' => 'IndustrialHose',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_INDUSTRIAL_HOSE,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_IndustrialWheels' => [
            'level' => 1,
            'label' => 'IndustrialWheels',
            'value' => 'IndustrialWheels',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_INDUSTRIAL_WHEELS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_MechanicalComponents' => [
            'level' => 1,
            'label' => 'MechanicalComponents',
            'value' => 'MechanicalComponents',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_MECHANICAL_COMPONENTS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_ORings' => [
            'level' => 1,
            'label' => 'ORings',
            'value' => 'ORings',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_ORINGS,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Industrial_PrecisionMeasuring' => [
            'level' => 1,
            'label' => 'PrecisionMeasuring',
            'value' => 'PrecisionMeasuring',
            'parent' => 'Industrial',
            'marketplace' => \Amazon\Sdk\Product\Category\Industrial::ALLOWED_MARKETPLACE_PRECISION_MEASURING,
            'class' => \Amazon\Sdk\Product\Category\Industrial::class
        ],
        'Jewelry' => [
            'level' => 0,
            'label' => 'Jewelry',
            'value' => 'Jewelry',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_Watch' => [
            'level' => 1,
            'label' => 'Watch',
            'value' => 'Watch',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_WATCH,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FashionNecklaceBraceletAnklet' => [
            'level' => 1,
            'label' => 'FashionNecklaceBraceletAnklet',
            'value' => 'FashionNecklaceBraceletAnklet',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FASHION_NECKLACE_BRACELET_ANKLET,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FashionRing' => [
            'level' => 1,
            'label' => 'FashionRing',
            'value' => 'FashionRing',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FASHION_RING,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FashionEarring' => [
            'level' => 1,
            'label' => 'FashionEarring',
            'value' => 'FashionEarring',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FASHION_EARRING,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FashionOther' => [
            'level' => 1,
            'label' => 'FashionOther',
            'value' => 'FashionOther',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FASHION_OTHER,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FineNecklaceBraceletAnklet' => [
            'level' => 1,
            'label' => 'FineNecklaceBraceletAnklet',
            'value' => 'FineNecklaceBraceletAnklet',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FINE_NECKLACE_BRACELET_ANKLET,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FineRing' => [
            'level' => 1,
            'label' => 'FineRing',
            'value' => 'FineRing',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FINE_RING,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FineEarring' => [
            'level' => 1,
            'label' => 'FineEarring',
            'value' => 'FineEarring',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FINE_EARRING,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'Jewelry_FineOther' => [
            'level' => 1,
            'label' => 'FineOther',
            'value' => 'FineOther',
            'parent' => 'Jewelry',
            'marketplace' => \Amazon\Sdk\Product\Category\Jewelry::ALLOWED_MARKETPLACE_FINE_OTHER,
            'class' => \Amazon\Sdk\Product\Category\Jewelry::class
        ],
        'LabSupplies' => [
            'level' => 0,
            'label' => 'LabSupplies',
            'value' => 'LabSupplies',
            'parent' => 'LabSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\LabSupplies::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\LabSupplies::class
        ],
        'LabSupplies_LabSupply' => [
            'level' => 1,
            'label' => 'LabSupply',
            'value' => 'LabSupply',
            'parent' => 'LabSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\LabSupplies::ALLOWED_MARKETPLACE_LAB_SUPPLY,
            'class' => \Amazon\Sdk\Product\Category\LabSupplies::class
        ],
        'LabSupplies_SafetySupply' => [
            'level' => 1,
            'label' => 'SafetySupply',
            'value' => 'SafetySupply',
            'parent' => 'LabSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\LabSupplies::ALLOWED_MARKETPLACE_SAFETY_SUPPLY,
            'class' => \Amazon\Sdk\Product\Category\LabSupplies::class
        ],
        'LargeAppliances' => [
            'level' => 0,
            'label' => 'LargeAppliances',
            'value' => 'LargeAppliances',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_AirConditioner' => [
            'level' => 1,
            'label' => 'AirConditioner',
            'value' => 'AirConditioner',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_AIR_CONDITIONER,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_ApplianceAccessory' => [
            'level' => 1,
            'label' => 'ApplianceAccessory',
            'value' => 'ApplianceAccessory',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_APPLIANCE_ACCESSORY,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_CookingOven' => [
            'level' => 1,
            'label' => 'CookingOven',
            'value' => 'CookingOven',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_COOKING_OVEN,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_Cooktop' => [
            'level' => 1,
            'label' => 'Cooktop',
            'value' => 'Cooktop',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_COOKTOP,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_Dishwasher' => [
            'level' => 1,
            'label' => 'Dishwasher',
            'value' => 'Dishwasher',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_DISH_WASHER,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_LaundryAppliance' => [
            'level' => 1,
            'label' => 'LaundryAppliance',
            'value' => 'LaundryAppliance',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_LAUNDRY_APPLIANCE,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_MicrowaveOven' => [
            'level' => 1,
            'label' => 'MicrowaveOven',
            'value' => 'MicrowaveOven',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_MICROWAVE_OVEN,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_Range' => [
            'level' => 1,
            'label' => 'Range',
            'value' => 'Range',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_RANGE,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_RefrigerationAppliance' => [
            'level' => 1,
            'label' => 'RefrigerationAppliance',
            'value' => 'RefrigerationAppliance',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_REFRIGERATION_APPLIANCE,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_TrashCompactor' => [
            'level' => 1,
            'label' => 'TrashCompactor',
            'value' => 'TrashCompactor',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_TRASH_COMPACTOR,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'LargeAppliances_VentHood' => [
            'level' => 1,
            'label' => 'VentHood',
            'value' => 'VentHood',
            'parent' => 'LargeAppliances',
            'marketplace' => \Amazon\Sdk\Product\Category\LargeAppliances::ALLOWED_MARKETPLACE_VENT_HOOD,
            'class' => \Amazon\Sdk\Product\Category\LargeAppliances::class
        ],
        'Lighting' => [
            'level' => 0,
            'label' => 'Lighting',
            'value' => 'Lighting',
            'parent' => 'Lighting',
            'marketplace' => \Amazon\Sdk\Product\Category\Lighting::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Lighting::class
        ],
        'Lighting_LightsAndFixtures' => [
            'level' => 1,
            'label' => 'LightsAndFixtures',
            'value' => 'LightsAndFixtures',
            'parent' => 'Lighting',
            'marketplace' => \Amazon\Sdk\Product\Category\Lighting::ALLOWED_MARKETPLACE_LIGHTS_AND_FIXTURES,
            'class' => \Amazon\Sdk\Product\Category\Lighting::class
        ],
        'Lighting_LightingAccessories' => [
            'level' => 1,
            'label' => 'LightingAccessories',
            'value' => 'LightingAccessories',
            'parent' => 'Lighting',
            'marketplace' => \Amazon\Sdk\Product\Category\Lighting::ALLOWED_MARKETPLACE_LIGHTING_ACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\Lighting::class
        ],
        'Lighting_LightBulbs' => [
            'level' => 1,
            'label' => 'LightBulbs',
            'value' => 'LightBulbs',
            'parent' => 'Lighting',
            'marketplace' => \Amazon\Sdk\Product\Category\Lighting::ALLOWED_MARKETPLACE_LIGHT_BULBS,
            'class' => \Amazon\Sdk\Product\Category\Lighting::class
        ],
        'Luggage' => [
            'level' => 0,
            'label' => 'Luggage',
            'value' => 'Luggage',
            'parent' => 'Luggage',
            'marketplace' => \Amazon\Sdk\Product\Category\Luggage::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Luggage::class
        ],
        'Luggage_Luggage' => [
            'level' => 1,
            'label' => 'Luggage',
            'value' => 'Luggage',
            'parent' => 'Luggage',
            'marketplace' => \Amazon\Sdk\Product\Category\Luggage::ALLOWED_MARKETPLACE_LUGGAGE,
            'class' => \Amazon\Sdk\Product\Category\Luggage::class
        ],
        'LuxuryBeauty' => [
            'level' => 0,
            'label' => 'LuxuryBeauty',
            'value' => 'LuxuryBeauty',
            'parent' => 'LuxuryBeauty',
            'marketplace' => \Amazon\Sdk\Product\Category\LuxuryBeauty::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\LuxuryBeauty::class
        ],
        'LuxuryBeauty_LuxuryBeauty' => [
            'level' => 1,
            'label' => 'LuxuryBeauty',
            'value' => 'LuxuryBeauty',
            'parent' => 'LuxuryBeauty',
            'marketplace' => \Amazon\Sdk\Product\Category\LuxuryBeauty::ALLOWED_MARKETPLACE_LUXURY_BEAUTY,
            'class' => \Amazon\Sdk\Product\Category\LuxuryBeauty::class
        ],
        'MaterialHandling' => [
            'level' => 0,
            'label' => 'MaterialHandling',
            'value' => 'MaterialHandling',
            'parent' => 'MaterialHandling',
            'marketplace' => \Amazon\Sdk\Product\Category\MaterialHandling::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\MaterialHandling::class
        ],
        'MechanicalFasteners' => [
            'level' => 0,
            'label' => 'MechanicalFasteners',
            'value' => 'MechanicalFasteners',
            'parent' => 'MechanicalFasteners',
            'marketplace' => \Amazon\Sdk\Product\Category\MechanicalFasteners::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\MechanicalFasteners::class
        ],
        'MechanicalFasteners_MechanicalFasteners' => [
            'level' => 1,
            'label' => 'MechanicalFasteners',
            'value' => 'MechanicalFasteners',
            'parent' => 'MechanicalFasteners',
            'marketplace' => \Amazon\Sdk\Product\Category\MechanicalFasteners::ALLOWED_MARKETPLACE_MECHANICAL_FASTENERS,
            'class' => \Amazon\Sdk\Product\Category\MechanicalFasteners::class
        ],
        'Miscellaneous' => [
            'level' => 0,
            'label' => 'Miscellaneous',
            'value' => 'Miscellaneous',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Antiques' => [
            'level' => 1,
            'label' => 'Antiques',
            'value' => 'Antiques',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Art' => [
            'level' => 1,
            'label' => 'Art',
            'value' => 'Art',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Car_Parts_and_Accessories' => [
            'level' => 1,
            'label' => 'Car_Parts_and_Accessories',
            'value' => 'Car_Parts_and_Accessories',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Coins' => [
            'level' => 1,
            'label' => 'Coins',
            'value' => 'Coins',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Collectibles' => [
            'level' => 1,
            'label' => 'Collectibles',
            'value' => 'Collectibles',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Crafts' => [
            'level' => 1,
            'label' => 'Crafts',
            'value' => 'Crafts',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Event_Tickets' => [
            'level' => 1,
            'label' => 'Event_Tickets',
            'value' => 'Event_Tickets',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Flowers' => [
            'level' => 1,
            'label' => 'Flowers',
            'value' => 'Flowers',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Gifts_and_Occasions' => [
            'level' => 1,
            'label' => 'Gifts_and_Occasions',
            'value' => 'Gifts_and_Occasions',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Gourmet_Food_and_Wine' => [
            'level' => 1,
            'label' => 'Gourmet_Food_and_Wine',
            'value' => 'Gourmet_Food_and_Wine',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Hobbies' => [
            'level' => 1,
            'label' => 'Hobbies',
            'value' => 'Hobbies',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Home_Furniture_and_Decor' => [
            'level' => 1,
            'label' => 'Home_Furniture_and_Decor',
            'value' => 'Home_Furniture_and_Decor',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Home_Lighting_and_Lamps' => [
            'level' => 1,
            'label' => 'Home_Lighting_and_Lamps',
            'value' => 'Home_Lighting_and_Lamps',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Home_Organizers_and_Storage' => [
            'level' => 1,
            'label' => 'Home_Organizers_and_Storage',
            'value' => 'Home_Organizers_and_Storage',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Jewelry_and_Gems' => [
            'level' => 1,
            'label' => 'Jewelry_and_Gems',
            'value' => 'Jewelry_and_Gems',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Luggage' => [
            'level' => 1,
            'label' => 'Luggage',
            'value' => 'Luggage',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Major_Home_Appliances' => [
            'level' => 1,
            'label' => 'Major_Home_Appliances',
            'value' => 'Major_Home_Appliances',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Medical_Supplies' => [
            'level' => 1,
            'label' => 'Medical_Supplies',
            'value' => 'Medical_Supplies',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Motorcycles' => [
            'level' => 1,
            'label' => 'Motorcycles',
            'value' => 'Motorcycles',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Musical_Instruments' => [
            'level' => 1,
            'label' => 'Musical_Instruments',
            'value' => 'Musical_Instruments',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Pet_Supplies' => [
            'level' => 1,
            'label' => 'Pet_Supplies',
            'value' => 'Pet_Supplies',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Pottery_and_Glass' => [
            'level' => 1,
            'label' => 'Pottery_and_Glass',
            'value' => 'Pottery_and_Glass',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Prints_and_Posters' => [
            'level' => 1,
            'label' => 'Prints_and_Posters',
            'value' => 'Prints_and_Posters',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Scientific_Supplies' => [
            'level' => 1,
            'label' => 'Scientific_Supplies',
            'value' => 'Scientific_Supplies',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Sporting_and_Outdoor_Goods' => [
            'level' => 1,
            'label' => 'Sporting_and_Outdoor_Goods',
            'value' => 'Sporting_and_Outdoor_Goods',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Sports_Memorabilia' => [
            'level' => 1,
            'label' => 'Sports_Memorabilia',
            'value' => 'Sports_Memorabilia',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Stamps' => [
            'level' => 1,
            'label' => 'Stamps',
            'value' => 'Stamps',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Teaching_and_School_Supplies' => [
            'level' => 1,
            'label' => 'Teaching_and_School_Supplies',
            'value' => 'Teaching_and_School_Supplies',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Watches' => [
            'level' => 1,
            'label' => 'Watches',
            'value' => 'Watches',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Wholesale_and_Industrial' => [
            'level' => 1,
            'label' => 'Wholesale_and_Industrial',
            'value' => 'Wholesale_and_Industrial',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Miscellaneous_Misc_Other' => [
            'level' => 1,
            'label' => 'Misc_Other',
            'value' => 'Misc_Other',
            'parent' => 'Miscellaneous',
            'marketplace' => \Amazon\Sdk\Product\Category\Miscellaneous::ALLOWED_MARKETPLACE_MISC_TYPE,
            'class' => \Amazon\Sdk\Product\Category\Miscellaneous::class
        ],
        'Motorcycles' => [
            'level' => 0,
            'label' => 'Motorcycles',
            'value' => 'Motorcycles',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_Vehicles' => [
            'level' => 1,
            'label' => 'Vehicles',
            'value' => 'Vehicles',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_VEHICLES,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_ProtectiveClothing' => [
            'level' => 1,
            'label' => 'ProtectiveClothing',
            'value' => 'ProtectiveClothing',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_PROTECTIVE_CLOTHING,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_Helmets' => [
            'level' => 1,
            'label' => 'Helmets',
            'value' => 'Helmets',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_HELMETS,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_RidingBoots' => [
            'level' => 1,
            'label' => 'RidingBoots',
            'value' => 'RidingBoots',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_RIDING_BOOTS,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_Gloves' => [
            'level' => 1,
            'label' => 'Gloves',
            'value' => 'Gloves',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_GLOVES,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_Accessories' => [
            'level' => 1,
            'label' => 'Accessories',
            'value' => 'Accessories',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_ACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Motorcycles_Parts' => [
            'level' => 1,
            'label' => 'Parts',
            'value' => 'Parts',
            'parent' => 'Motorcycles',
            'marketplace' => \Amazon\Sdk\Product\Category\Motorcycles::ALLOWED_MARKETPLACE_PARTS,
            'class' => \Amazon\Sdk\Product\Category\Motorcycles::class
        ],
        'Music' => [
            'level' => 0,
            'label' => 'Music',
            'value' => 'Music',
            'parent' => 'Music',
            'marketplace' => \Amazon\Sdk\Product\Category\Music::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Music::class
        ],
        'Music_MusicPopular' => [
            'level' => 1,
            'label' => 'MusicPopular',
            'value' => 'MusicPopular',
            'parent' => 'Music',
            'marketplace' => \Amazon\Sdk\Product\Category\Music::ALLOWED_MARKETPLACE_MUSIC_POPULAR,
            'class' => \Amazon\Sdk\Product\Category\Music::class
        ],
        'Music_MusicClassical' => [
            'level' => 1,
            'label' => 'MusicClassical',
            'value' => 'MusicClassical',
            'parent' => 'Music',
            'marketplace' => \Amazon\Sdk\Product\Category\Music::ALLOWED_MARKETPLACE_MUSIC_CLASSICAL,
            'class' => \Amazon\Sdk\Product\Category\Music::class
        ],
        'MusicalInstruments' => [
            'level' => 0,
            'label' => 'MusicalInstruments',
            'value' => 'MusicalInstruments',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_BrassAndWoodwindInstruments' => [
            'level' => 1,
            'label' => 'BrassAndWoodwindInstruments',
            'value' => 'BrassAndWoodwindInstruments',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_BRASS_AND_WOODWIND_INSTRUMENTS,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_Guitars' => [
            'level' => 1,
            'label' => 'Guitars',
            'value' => 'Guitars',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_GUITARS,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_InstrumentPartsAndAccessories' => [
            'level' => 1,
            'label' => 'InstrumentPartsAndAccessories',
            'value' => 'InstrumentPartsAndAccessories',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_INSTRUMENT_PARTS_AND_ACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_KeyboardInstruments' => [
            'level' => 1,
            'label' => 'KeyboardInstruments',
            'value' => 'KeyboardInstruments',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_KEYBOARD_INSTRUMENTS,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_MiscWorldInstruments' => [
            'level' => 1,
            'label' => 'MiscWorldInstruments',
            'value' => 'MiscWorldInstruments',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_MISC_WORLD_INSTRUMENTS,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_PercussionInstruments' => [
            'level' => 1,
            'label' => 'PercussionInstruments',
            'value' => 'PercussionInstruments',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_PERCUSSION_INSTRUMENTS,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_SoundAndRecordingEquipment' => [
            'level' => 1,
            'label' => 'SoundAndRecordingEquipment',
            'value' => 'SoundAndRecordingEquipment',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_SOUND_AND_RECORDING_EQUIPMENT,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'MusicalInstruments_StringedInstruments' => [
            'level' => 1,
            'label' => 'StringedInstruments',
            'value' => 'StringedInstruments',
            'parent' => 'MusicalInstruments',
            'marketplace' => \Amazon\Sdk\Product\Category\MusicalInstruments::ALLOWED_MARKETPLACE_STRINGED_INSTRUMENTS,
            'class' => \Amazon\Sdk\Product\Category\MusicalInstruments::class
        ],
        'Office' => [
            'level' => 0,
            'label' => 'Office',
            'value' => 'Office',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_ArtSupplies' => [
            'level' => 1,
            'label' => 'ArtSupplies',
            'value' => 'ArtSupplies',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_ART_SUPPLIES,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_EducationalSupplies' => [
            'level' => 1,
            'label' => 'EducationalSupplies',
            'value' => 'EducationalSupplies',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_EDUCATIONAL_SUPPLIES,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_OfficeProducts' => [
            'level' => 1,
            'label' => 'OfficeProducts',
            'value' => 'OfficeProducts',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_OFFICE_PRODUCTS,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_PaperProducts' => [
            'level' => 1,
            'label' => 'PaperProducts',
            'value' => 'PaperProducts',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_PAPER_PRODUCTS,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_WritingInstruments' => [
            'level' => 1,
            'label' => 'WritingInstruments',
            'value' => 'WritingInstruments',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_WRITING_INSTRUMENTS,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_BarCode' => [
            'level' => 1,
            'label' => 'BarCode',
            'value' => 'BarCode',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_BARCODE,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_Calculator' => [
            'level' => 1,
            'label' => 'Calculator',
            'value' => 'Calculator',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_CALCULATOR,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_InkToner' => [
            'level' => 1,
            'label' => 'InkToner',
            'value' => 'InkToner',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_INK_TONER,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_MultifunctionDevice' => [
            'level' => 1,
            'label' => 'MultifunctionDevice',
            'value' => 'MultifunctionDevice',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_MULTIFUNCTION_DEVICE,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_OfficeElectronics' => [
            'level' => 1,
            'label' => 'OfficeElectronics',
            'value' => 'OfficeElectronics',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_OFFICE_ELECTRONICS,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_OfficePhone' => [
            'level' => 1,
            'label' => 'OfficePhone',
            'value' => 'OfficePhone',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_OFFICE_PHONE,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_OfficePrinter' => [
            'level' => 1,
            'label' => 'OfficePrinter',
            'value' => 'OfficePrinter',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_OFFICE_PRINTER,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_OfficeScanner' => [
            'level' => 1,
            'label' => 'OfficeScanner',
            'value' => 'OfficeScanner',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_OFFICE_SCANNER,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Office_VoiceRecorder' => [
            'level' => 1,
            'label' => 'VoiceRecorder',
            'value' => 'VoiceRecorder',
            'parent' => 'Office',
            'marketplace' => \Amazon\Sdk\Product\Category\Office::ALLOWED_MARKETPLACE_VOICE_RECORDER,
            'class' => \Amazon\Sdk\Product\Category\Office::class
        ],
        'Outdoors' => [
            'level' => 0,
            'label' => 'Outdoors',
            'value' => 'Outdoors',
            'parent' => 'Outdoors',
            'marketplace' => \Amazon\Sdk\Product\Category\Outdoors::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Outdoors::class
        ],
        'Outdoors_OutdoorRecreationProduct' => [
            'level' => 1,
            'label' => 'OutdoorRecreationProduct',
            'value' => 'OutdoorRecreationProduct',
            'parent' => 'Outdoors',
            'marketplace' => \Amazon\Sdk\Product\Category\Outdoors::ALLOWED_MARKETPLACE_OUTDOOR_RECREATION_PRODUCT,
            'class' => \Amazon\Sdk\Product\Category\Outdoors::class
        ],
        'PetSupplies' => [
            'level' => 0,
            'label' => 'PetSupplies',
            'value' => 'PetSupplies',
            'parent' => 'PetSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\PetSupplies::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\PetSupplies::class
        ],
        'PetSupplies_PetSuppliesMisc' => [
            'level' => 1,
            'label' => 'PetSuppliesMisc',
            'value' => 'PetSuppliesMisc',
            'parent' => 'PetSupplies',
            'marketplace' => \Amazon\Sdk\Product\Category\PetSupplies::ALLOWED_MARKETPLACE_PET_SUPPLIES_MISC,
            'class' => \Amazon\Sdk\Product\Category\PetSupplies::class
        ],
        'PowerTransmission' => [
            'level' => 0,
            'label' => 'PowerTransmission',
            'value' => 'PowerTransmission',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_BearingsAndBushings' => [
            'level' => 1,
            'label' => 'BearingsAndBushings',
            'value' => 'BearingsAndBushings',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_BEARINGS_AND_BUSHINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_Belts' => [
            'level' => 1,
            'label' => 'Belts',
            'value' => 'Belts',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_BELTS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_CompressionSprings' => [
            'level' => 1,
            'label' => 'CompressionSprings',
            'value' => 'CompressionSprings',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_COMPRESSION_SPRINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_ExtensionSprings' => [
            'level' => 1,
            'label' => 'ExtensionSprings',
            'value' => 'ExtensionSprings',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_EXTENSION_SPRINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_FlexibleCouplings' => [
            'level' => 1,
            'label' => 'FlexibleCouplings',
            'value' => 'FlexibleCouplings',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_FLEXIBLE_COUPLINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_Gears' => [
            'level' => 1,
            'label' => 'Gears',
            'value' => 'Gears',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_GEARS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_RigidCouplings' => [
            'level' => 1,
            'label' => 'RigidCouplings',
            'value' => 'RigidCouplings',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_RIGID_COUPLINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_ShaftCollar' => [
            'level' => 1,
            'label' => 'ShaftCollar',
            'value' => 'ShaftCollar',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_SHAFTCOLLAR,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_TorsionSprings' => [
            'level' => 1,
            'label' => 'TorsionSprings',
            'value' => 'TorsionSprings',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_TORSION_SPRINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_LinearGuidesAndRails' => [
            'level' => 1,
            'label' => 'LinearGuidesAndRails',
            'value' => 'LinearGuidesAndRails',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_LINEAR_GUIDES_AND_RAILS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_Pulleys' => [
            'level' => 1,
            'label' => 'Pulleys',
            'value' => 'Pulleys',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_PULLEYS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_RollerChain' => [
            'level' => 1,
            'label' => 'RollerChain',
            'value' => 'RollerChain',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_ROLLER_CHAIN,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_CouplingsCollarsAndUniversalJoints' => [
            'level' => 1,
            'label' => 'CouplingsCollarsAndUniversalJoints',
            'value' => 'CouplingsCollarsAndUniversalJoints',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_COUPLINGS_COLLARS_AND_UNIVERSAL_JOINTS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_Springs' => [
            'level' => 1,
            'label' => 'Springs',
            'value' => 'Springs',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_SPRINGS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_Sprockets' => [
            'level' => 1,
            'label' => 'Sprockets',
            'value' => 'Sprockets',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_SPROCKETS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'PowerTransmission_UniversalJoints' => [
            'level' => 1,
            'label' => 'UniversalJoints',
            'value' => 'UniversalJoints',
            'parent' => 'PowerTransmission',
            'marketplace' => \Amazon\Sdk\Product\Category\PowerTransmission::ALLOWED_MARKETPLACE_UNIVERSAL_JOINTS,
            'class' => \Amazon\Sdk\Product\Category\PowerTransmission::class
        ],
        'ProfessionalHealthCare' => [
            'level' => 0,
            'label' => 'ProfessionalHealthCare',
            'value' => 'ProfessionalHealthCare',
            'parent' => 'ProfessionalHealthCare',
            'marketplace' => \Amazon\Sdk\Product\Category\ProfessionalHealthCare::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\ProfessionalHealthCare::class
        ],
        'ProfessionalHealthCare_ProfessionalHealthCare' => [
            'level' => 1,
            'label' => 'ProfessionalHealthCare',
            'value' => 'ProfessionalHealthCare',
            'parent' => 'ProfessionalHealthCare',
            'marketplace' => \Amazon\Sdk\Product\Category\ProfessionalHealthCare::ALLOWED_MARKETPLACE_PROFESSIONAL_HEALTH_CARE,
            'class' => \Amazon\Sdk\Product\Category\ProfessionalHealthCare::class
        ],
        'RawMaterials' => [
            'level' => 0,
            'label' => 'RawMaterials',
            'value' => 'RawMaterials',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_CeramicBalls' => [
            'level' => 1,
            'label' => 'CeramicBalls',
            'value' => 'CeramicBalls',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_CERAMIC_BALLS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_CeramicTubing' => [
            'level' => 1,
            'label' => 'CeramicTubing',
            'value' => 'CeramicTubing',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_CERAMIC_TUBING,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_Ceramics' => [
            'level' => 1,
            'label' => 'Ceramics',
            'value' => 'Ceramics',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_CERAMICS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_MetalBalls' => [
            'level' => 1,
            'label' => 'MetalBalls',
            'value' => 'MetalBalls',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_METAL_BALLS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_MetalMesh' => [
            'level' => 1,
            'label' => 'MetalMesh',
            'value' => 'MetalMesh',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_METAL_MESH,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_MetalTubing' => [
            'level' => 1,
            'label' => 'MetalTubing',
            'value' => 'MetalTubing',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_METAL_TUBING,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_Metals' => [
            'level' => 1,
            'label' => 'Metals',
            'value' => 'Metals',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_METALS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_PlasticBalls' => [
            'level' => 1,
            'label' => 'PlasticBalls',
            'value' => 'PlasticBalls',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_PLASTIC_BALLS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_PlasticMesh' => [
            'level' => 1,
            'label' => 'PlasticMesh',
            'value' => 'PlasticMesh',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_PLASTIC_MESH,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_PlasticTubing' => [
            'level' => 1,
            'label' => 'PlasticTubing',
            'value' => 'PlasticTubing',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_PLASTIC_TUBING,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_Plastics' => [
            'level' => 1,
            'label' => 'Plastics',
            'value' => 'Plastics',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_PLASTICS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_RawMaterials' => [
            'level' => 1,
            'label' => 'RawMaterials',
            'value' => 'RawMaterials',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_RAW_MATERIALS,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'RawMaterials_Wire' => [
            'level' => 1,
            'label' => 'Wire',
            'value' => 'Wire',
            'parent' => 'RawMaterials',
            'marketplace' => \Amazon\Sdk\Product\Category\RawMaterials::ALLOWED_MARKETPLACE_WIRE,
            'class' => \Amazon\Sdk\Product\Category\RawMaterials::class
        ],
        'Shoes' => [
            'level' => 0,
            'label' => 'Shoes',
            'value' => 'Shoes',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'Shoes_Shoes' => [
            'level' => 1,
            'label' => 'Shoes',
            'value' => 'Shoes',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'Shoes_Accessory' => [
            'level' => 1,
            'label' => 'Accessory',
            'value' => 'Accessory',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'Shoes_Bag' => [
            'level' => 1,
            'label' => 'Bag',
            'value' => 'Bag',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'Shoes_ShoeAccessory' => [
            'level' => 1,
            'label' => 'ShoeAccessory',
            'value' => 'ShoeAccessory',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'Shoes_Handbag' => [
            'level' => 1,
            'label' => 'Handbag',
            'value' => 'Handbag',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'Shoes_Eyewear' => [
            'level' => 1,
            'label' => 'Eyewear',
            'value' => 'Eyewear',
            'parent' => 'Shoes',
            'marketplace' => \Amazon\Sdk\Product\Category\Shoes::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Shoes::class
        ],
        'SoftwareVideoGames' => [
            'level' => 0,
            'label' => 'SoftwareVideoGames',
            'value' => 'SoftwareVideoGames',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'SoftwareVideoGames_Software' => [
            'level' => 1,
            'label' => 'Software',
            'value' => 'Software',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE_SOFTWARE,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'SoftwareVideoGames_HandheldSoftwareDownloads' => [
            'level' => 1,
            'label' => 'HandheldSoftwareDownloads',
            'value' => 'HandheldSoftwareDownloads',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE_HAND_HELD_SOFTWARE_DOWNLOADS,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'SoftwareVideoGames_SoftwareGames' => [
            'level' => 1,
            'label' => 'SoftwareGames',
            'value' => 'SoftwareGames',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE_SOFTWARE_GAMES,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'SoftwareVideoGames_VideoGames' => [
            'level' => 1,
            'label' => 'VideoGames',
            'value' => 'VideoGames',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE_VIDEO_GAMES,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'SoftwareVideoGames_VideoGamesAccessories' => [
            'level' => 1,
            'label' => 'VideoGamesAccessories',
            'value' => 'VideoGamesAccessories',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE_VIDEO_GAMES_ACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'SoftwareVideoGames_VideoGamesHardware' => [
            'level' => 1,
            'label' => 'VideoGamesHardware',
            'value' => 'VideoGamesHardware',
            'parent' => 'SoftwareVideoGames',
            'marketplace' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::ALLOWED_MARKETPLACE_VIDEO_GAMES_HARDWARE,
            'class' => \Amazon\Sdk\Product\Category\SoftwareVideoGames::class
        ],
        'Sports' => [
            'level' => 0,
            'label' => 'Sports',
            'value' => 'Sports',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_SportingGoods' => [
            'level' => 1,
            'label' => 'SportingGoods',
            'value' => 'SportingGoods',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_SPORTING_GOODS,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_GolfClubHybrid' => [
            'level' => 1,
            'label' => 'GolfClubHybrid',
            'value' => 'GolfClubHybrid',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_GOLF_CLUB_HYBRID,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_GolfClubIron' => [
            'level' => 1,
            'label' => 'GolfClubIron',
            'value' => 'GolfClubIron',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_GOLF_CLUB_IRON,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_GolfClubPutter' => [
            'level' => 1,
            'label' => 'GolfClubPutter',
            'value' => 'GolfClubPutter',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_GOLF_CLUB_PUTTER,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_GolfClubWedge' => [
            'level' => 1,
            'label' => 'GolfClubWedge',
            'value' => 'GolfClubWedge',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_GOLF_CLUB_WEDGE,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_GolfClubWood' => [
            'level' => 1,
            'label' => 'GolfClubWood',
            'value' => 'GolfClubWood',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_GOLF_CLUB_WOOD,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'Sports_GolfClubs' => [
            'level' => 1,
            'label' => 'GolfClubs',
            'value' => 'GolfClubs',
            'parent' => 'Sports',
            'marketplace' => \Amazon\Sdk\Product\Category\Sports::ALLOWED_MARKETPLACE_GOLF_CLUBS,
            'class' => \Amazon\Sdk\Product\Category\Sports::class
        ],
        'SportsMemorabilia' => [
            'level' => 0,
            'label' => 'SportsMemorabilia',
            'value' => 'SportsMemorabilia',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'SportsMemorabilia_SportsMemorabilia' => [
            'level' => 1,
            'label' => 'SportsMemorabilia',
            'value' => 'SportsMemorabilia',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE_SPORTS_MEMORABILIA,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'SportsMemorabilia_TradingCardsCardsSets' => [
            'level' => 1,
            'label' => 'TradingCardsCardsSets',
            'value' => 'TradingCardsCardsSets',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE_TRADING_CARDS_CARDS_SETS,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'SportsMemorabilia_TradingCardsGradedCardsInserts' => [
            'level' => 1,
            'label' => 'TradingCardsGradedCardsInserts',
            'value' => 'TradingCardsGradedCardsInserts',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE_TRADING_CARDS_GRADED_CARDS_INSERTS,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'SportsMemorabilia_TradingCardsUngradedInserts' => [
            'level' => 1,
            'label' => 'TradingCardsUngradedInserts',
            'value' => 'TradingCardsUngradedInserts',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE_TRADING_CARDS_UNGRADED_INSERTS,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'SportsMemorabilia_TradingCardsFactorySealed' => [
            'level' => 1,
            'label' => 'TradingCardsFactorySealed',
            'value' => 'TradingCardsFactorySealed',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE_TRADING_CARDS_FACTORY_SEALED,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'SportsMemorabilia_TradingCardsMiscTradingCards' => [
            'level' => 1,
            'label' => 'TradingCardsMiscTradingCards',
            'value' => 'TradingCardsMiscTradingCards',
            'parent' => 'SportsMemorabilia',
            'marketplace' => \Amazon\Sdk\Product\Category\SportsMemorabilia::ALLOWED_MARKETPLACE_TRADING_CARDS_MISC_TRADING_CARDS,
            'class' => \Amazon\Sdk\Product\Category\SportsMemorabilia::class
        ],
        'ThreeDPrinting' => [
            'level' => 0,
            'label' => 'ThreeDPrinting',
            'value' => 'ThreeDPrinting',
            'parent' => 'ThreeDPrinting',
            'marketplace' => \Amazon\Sdk\Product\Category\ThreeDPrinting::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\ThreeDPrinting::class
        ],
        'ThreeDPrinting_DigitalDesigns' => [
            'level' => 1,
            'label' => 'DigitalDesigns',
            'value' => 'DigitalDesigns',
            'parent' => 'ThreeDPrinting',
            'marketplace' => \Amazon\Sdk\Product\Category\ThreeDPrinting::ALLOWED_MARKETPLACE_DIGITAL_DESIGNS,
            'class' => \Amazon\Sdk\Product\Category\ThreeDPrinting::class
        ],
        'ThreeDPrinting_ThreeDPrintedProduct' => [
            'level' => 1,
            'label' => 'ThreeDPrintedProduct',
            'value' => 'ThreeDPrintedProduct',
            'parent' => 'ThreeDPrinting',
            'marketplace' => \Amazon\Sdk\Product\Category\ThreeDPrinting::ALLOWED_MARKETPLACE_THREE_D_PRINTED_PRODUCTS,
            'class' => \Amazon\Sdk\Product\Category\ThreeDPrinting::class
        ],
        'ThreeDPrinting_ThreeDPrintableDesigns' => [
            'level' => 1,
            'label' => 'ThreeDPrintableDesigns',
            'value' => 'ThreeDPrintableDesigns',
            'parent' => 'ThreeDPrinting',
            'marketplace' => \Amazon\Sdk\Product\Category\ThreeDPrinting::ALLOWED_MARKETPLACE_THREE_D_PRINTABLE_DESIGNS,
            'class' => \Amazon\Sdk\Product\Category\ThreeDPrinting::class
        ],
        'TiresAndWheels' => [
            'level' => 0,
            'label' => 'TiresAndWheels',
            'value' => 'TiresAndWheels',
            'parent' => 'TiresAndWheels',
            'marketplace' => \Amazon\Sdk\Product\Category\TiresAndWheels::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\TiresAndWheels::class
        ],
        'TiresAndWheels_Tires' => [
            'level' => 1,
            'label' => 'Tires',
            'value' => 'Tires',
            'parent' => 'TiresAndWheels',
            'marketplace' => \Amazon\Sdk\Product\Category\TiresAndWheels::ALLOWED_MARKETPLACE_TIRES,
            'class' => \Amazon\Sdk\Product\Category\TiresAndWheels::class
        ],
        'TiresAndWheels_Wheels' => [
            'level' => 1,
            'label' => 'Wheels',
            'value' => 'Wheels',
            'parent' => 'TiresAndWheels',
            'marketplace' => \Amazon\Sdk\Product\Category\TiresAndWheels::ALLOWED_MARKETPLACE_WHEELS,
            'class' => \Amazon\Sdk\Product\Category\TiresAndWheels::class
        ],
        'TiresAndWheels_TireAndWheelAssemblies' => [
            'level' => 1,
            'label' => 'TireAndWheelAssemblies',
            'value' => 'TireAndWheelAssemblies',
            'parent' => 'TiresAndWheels',
            'marketplace' => \Amazon\Sdk\Product\Category\TiresAndWheels::ALLOWED_MARKETPLACE_TIRES_AND_WHEEL_ASSEMBLIES,
            'class' => \Amazon\Sdk\Product\Category\TiresAndWheels::class
        ],
        'Tools' => [
            'level' => 0,
            'label' => 'Tools',
            'value' => 'Tools',
            'parent' => 'Tools',
            'marketplace' => \Amazon\Sdk\Product\Category\Tools::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Tools::class
        ],
        'Tools_Tools' => [
            'level' => 1,
            'label' => 'Tools',
            'value' => 'Tools',
            'parent' => 'Tools',
            'marketplace' => \Amazon\Sdk\Product\Category\Tools::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Tools::class
        ],
        'Toys' => [
            'level' => 0,
            'label' => 'Toys',
            'value' => 'Toys',
            'parent' => 'Toys',
            'marketplace' => \Amazon\Sdk\Product\Category\Toys::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Toys::class
        ],
        'Toys_ToysAndGames' => [
            'level' => 1,
            'label' => 'ToysAndGames',
            'value' => 'ToysAndGames',
            'parent' => 'Toys',
            'marketplace' => \Amazon\Sdk\Product\Category\Toys::ALLOWED_MARKETPLACE_TOYS_AND_GAMES,
            'class' => \Amazon\Sdk\Product\Category\Toys::class
        ],
        'Toys_Hobbies' => [
            'level' => 1,
            'label' => 'Hobbies',
            'value' => 'Hobbies',
            'parent' => 'Toys',
            'marketplace' => \Amazon\Sdk\Product\Category\Toys::ALLOWED_MARKETPLACE_HOBBIES,
            'class' => \Amazon\Sdk\Product\Category\Toys::class
        ],
        'Toys_CollectibleCard' => [
            'level' => 1,
            'label' => 'CollectibleCard',
            'value' => 'CollectibleCard',
            'parent' => 'Toys',
            'marketplace' => \Amazon\Sdk\Product\Category\Toys::ALLOWED_MARKETPLACE_COLLECTIBLE_CARD,
            'class' => \Amazon\Sdk\Product\Category\Toys::class
        ],
        'Toys_Costume' => [
            'level' => 1,
            'label' => 'Costume',
            'value' => 'Costume',
            'parent' => 'Toys',
            'marketplace' => \Amazon\Sdk\Product\Category\Toys::ALLOWED_MARKETPLACE_COSTUME,
            'class' => \Amazon\Sdk\Product\Category\Toys::class
        ],
        'ToysBaby' => [
            'level' => 0,
            'label' => 'ToysBaby',
            'value' => 'ToysBaby',
            'parent' => 'ToysBaby',
            'marketplace' => \Amazon\Sdk\Product\Category\ToysBaby::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\ToysBaby::class
        ],
        'ToysBaby_ToysAndGames' => [
            'level' => 1,
            'label' => 'ToysAndGames',
            'value' => 'ToysAndGames',
            'parent' => 'ToysBaby',
            'marketplace' => \Amazon\Sdk\Product\Category\ToysBaby::ALLOWED_MARKETPLACE_TOYS_AND_GAMES,
            'class' => \Amazon\Sdk\Product\Category\ToysBaby::class
        ],
        'ToysBaby_BabyProducts' => [
            'level' => 1,
            'label' => 'BabyProducts',
            'value' => 'BabyProducts',
            'parent' => 'ToysBaby',
            'marketplace' => \Amazon\Sdk\Product\Category\ToysBaby::ALLOWED_MARKETPLACE_BABY_PRODUCTS,
            'class' => \Amazon\Sdk\Product\Category\ToysBaby::class
        ],
        'Video' => [
            'level' => 0,
            'label' => 'Video',
            'value' => 'Video',
            'parent' => 'Video',
            'marketplace' => \Amazon\Sdk\Product\Category\Video::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Video::class
        ],
        'Video_VideoDVD' => [
            'level' => 1,
            'label' => 'VideoDVD',
            'value' => 'VideoDVD',
            'parent' => 'Video',
            'marketplace' => \Amazon\Sdk\Product\Category\Video::ALLOWED_MARKETPLACE_VIDEO_DVD,
            'class' => \Amazon\Sdk\Product\Category\Video::class
        ],
        'Video_VideoVHS' => [
            'level' => 1,
            'label' => 'VideoVHS',
            'value' => 'VideoVHS',
            'parent' => 'Video',
            'marketplace' => \Amazon\Sdk\Product\Category\Video::ALLOWED_MARKETPLACE_VIDEO_VHS,
            'class' => \Amazon\Sdk\Product\Category\Video::class
        ],
        'WineAndAlcohol' => [
            'level' => 0,
            'label' => 'WineAndAlcohol',
            'value' => 'WineAndAlcohol',
            'parent' => 'WineAndAlcohol',
            'marketplace' => \Amazon\Sdk\Product\Category\WineAndAlcohol::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\WineAndAlcohol::class
        ],
        'WineAndAlcohol_Wine' => [
            'level' => 1,
            'label' => 'Wine',
            'value' => 'Wine',
            'parent' => 'WineAndAlcohol',
            'marketplace' => \Amazon\Sdk\Product\Category\WineAndAlcohol::ALLOWED_MARKETPLACE_WINE,
            'class' => \Amazon\Sdk\Product\Category\WineAndAlcohol::class
        ],
        'WineAndAlcohol_Spirits' => [
            'level' => 1,
            'label' => 'Spirits',
            'value' => 'Spirits',
            'parent' => 'WineAndAlcohol',
            'marketplace' => \Amazon\Sdk\Product\Category\WineAndAlcohol::ALLOWED_MARKETPLACE_SPIRITS,
            'class' => \Amazon\Sdk\Product\Category\WineAndAlcohol::class
        ],
        'WineAndAlcohol_Beer' => [
            'level' => 1,
            'label' => 'Beer',
            'value' => 'Beer',
            'parent' => 'WineAndAlcohol',
            'marketplace' => \Amazon\Sdk\Product\Category\WineAndAlcohol::ALLOWED_MARKETPLACE_BEER,
            'class' => \Amazon\Sdk\Product\Category\WineAndAlcohol::class
        ],
        'Wireless' => [
            'level' => 0,
            'label' => 'Wireless',
            'value' => 'Wireless',
            'parent' => 'Wireless',
            'marketplace' => \Amazon\Sdk\Product\Category\Wireless::ALLOWED_MARKETPLACE,
            'class' => \Amazon\Sdk\Product\Category\Wireless::class
        ],
        'Wireless_WirelessAccessories' => [
            'level' => 1,
            'label' => 'WirelessAccessories',
            'value' => 'WirelessAccessories',
            'parent' => 'Wireless',
            'marketplace' => \Amazon\Sdk\Product\Category\Wireless::ALLOWED_MARKETPLACE_WIRELESS_ACCESSORIES,
            'class' => \Amazon\Sdk\Product\Category\Wireless::class
        ],
        'Wireless_WirelessDownloads' => [
            'level' => 1,
            'label' => 'WirelessDownloads',
            'value' => 'WirelessDownloads',
            'parent' => 'Wireless',
            'marketplace' => \Amazon\Sdk\Product\Category\Wireless::ALLOWED_MARKETPLACE_WIRELESS_DOWNLOADS,
            'class' => \Amazon\Sdk\Product\Category\Wireless::class
        ],
    ];

    /**
     * Get data
     * @return array
     */
    public function getData()
    {
        return $this->definitions;
    }

    /**
     * Get Amazon Categories
     * @param int $level
     * @return array
     */
    public function getCategories($level = self::CATEGORY_LEVEL_ROOT)
    {
        $categories = [];
        foreach ($this->definitions as $category) {
            if ($category['level'] == $level) {
                $categories[] = $category;
            }
        }

        return $categories;
    }

    /**
     * Finds an entry of the container by its identifier and returns it.
     *
     * @param string $id Identifier of the entry to look for.
     *
     * @throws NotFoundExceptionInterface  No entry was found for **this** identifier.
     * @throws ContainerExceptionInterface Error while retrieving the entry.
     *
     * @return mixed Entry.
     */
    public function get($id)
    {
        if (isset($this->definitions[$id])) {
            return $this->definitions[$id];
        } else {
            throw new \Amazon\Sdk\Exceptions\NotFoundException("Category not found {$id}");
        }
    }

    /**
     * Returns true if the container can return an entry for the given identifier.
     * Returns false otherwise.
     *
     * `has($id)` returning true does not mean that `get($id)` will not throw an exception.
     * It does however mean that `get($id)` will not throw a `NotFoundExceptionInterface`.
     *
     * @param string $id Identifier of the entry to look for.
     *
     * @return bool
     */
    public function has($id)
    {
        if (isset($this->definitions[$id])) {
            return true;
        }

        return false;
    }
}
