<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Coins extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_COIN = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_COLLECTIBLE_COINS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BULLION = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Coins';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        // Overriding Barcode as not required.
        $this->attributes['StandardProductID_Value']['minOccurs'] = '0';

        switch ($this->subCategory) {
            case "Coin":
                $this->attributes = array_merge($this->attributes, $this->getCoin());
                break;
            case "CollectibleCoins":
                $this->attributes = array_merge($this->attributes, $this->getCollectibleCoins());
                break;
            case "Bullion":
                $this->attributes = array_merge($this->attributes, $this->getBullion());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Coins => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Coins_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getCoin()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Coins => 10
         * ProductType => 10
         * Coin => 10
         */
        $s = "100\\10\\10\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Coins_ProductType_Coin_";
        $this->attributes = [
            'DescriptionData_ItemType' => [
                'sequence' => '30\170',
                'name' => 'ItemType',
                'dataType' => 'LongStringNotNull',
                'minOccurs' => '1',
            ],
            "ProductData_Coins_ProductType_Coin" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Coin",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}10",
                "name" => "ModelYear",
                "minOccurs" => "1",
                "dataType" => "FourDigitYear",
            ],
            "{$i}MintMark" => [
                "sequence" => "{$s}15",
                "name" => "MintMark",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}DenominationUnit" => [
                "sequence" => "{$s}20",
                "name" => "DenominationUnit",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}SeriesTitle" => [
                "sequence" => "{$s}21",
                "name" => "SeriesTitle",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Variety" => [
                "sequence" => "{$s}22",
                "name" => "SeriesTitle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SubVariety" => [
                "sequence" => "{$s}23",
                "name" => "SubVariety",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}24",
                "name" => "ItemStyling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GradedBy" => [
                "sequence" => "{$s}25",
                "name" => "GradeRating",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}GradeRating" => [
                "sequence" => "{$s}26",
                "name" => "GradeRating",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}CertificateNumber" => [
                "sequence" => "{$s}110",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}UnitGrouping" => [
                "sequence" => "{$s}120",
                "name" => "MaterialType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}EdgeStyle" => [
                "sequence" => "{$s}200",
                "name" => "EdgeStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemDiameter" => [
                "sequence" => "{$s}270",
                "name" => "ItemDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getCollectibleCoins()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Coins => 10
         * ProductType => 10
         * CollectibleCoins => 20
         */
        $s = "100\\10\\10\\20\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Coins_ProductType_CollectibleCoins_";
        $attributes = [
            'DescriptionData_ItemType' => [
                'sequence' => '30\170',
                'name' => 'ItemType',
                'dataType' => 'LongStringNotNull',
                'minOccurs' => '1',
            ],
            "ProductData_Coins_ProductType_CollectibleCoins" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Coin",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}10",
                "name" => "ModelYear",
                "minOccurs" => "1",
                "dataType" => "FourDigitYear",
            ],
            "{$i}MintMark" => [
                "sequence" => "{$s}15",
                "name" => "MintMark",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}DenominationUnit" => [
                "sequence" => "{$s}20",
                "name" => "DenominationUnit",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}SeriesTitle" => [
                "sequence" => "{$s}21",
                "name" => "SeriesTitle",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}Variety" => [
                "sequence" => "{$s}22",
                "name" => "SeriesTitle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}SubVariety" => [
                "sequence" => "{$s}23",
                "name" => "SubVariety",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemStyling" => [
                "sequence" => "{$s}24",
                "name" => "ItemStyling",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}GradedBy" => [
                "sequence" => "{$s}25",
                "name" => "GradeRating",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}GradeRating" => [
                "sequence" => "{$s}26",
                "name" => "GradeRating",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}CertificateNumber" => [
                "sequence" => "{$s}110",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}UnitGrouping" => [
                "sequence" => "{$s}120",
                "name" => "UnitGrouping",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}EdgeStyle" => [
                "sequence" => "{$s}200",
                "name" => "EdgeStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemDiameter" => [
                "sequence" => "{$s}270",
                "name" => "ItemDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getBullion()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Coins => 10
         * ProductType => 10
         * Bullion => 30
         */
        $s = "100\\10\\10\\30\\";
        /**
         * Index prefix
         */
        $i = "ProductData_Coins_ProductType_Bullion_";
        $attributes = [
            "ProductData_Coins_ProductType_Bullion" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "Bullion",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ModelYear" => [
                "sequence" => "{$s}10",
                "name" => "ModelYear",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CertificateNumber" => [
                "sequence" => "{$s}110",
                "name" => "CertificateNumber",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}EdgeStyle" => [
                "sequence" => "{$s}200",
                "name" => "EdgeStyle",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaterialType" => [
                "sequence" => "{$s}250",
                "name" => "MaterialType",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ItemDiameter" => [
                "sequence" => "{$s}270",
                "name" => "ItemDiameter",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Coins_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
