<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class ClothingAccessories extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        $this->category = 'ClothingAccessories';
        $this->data["ProductData_{$this->category}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

	if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * ClothingAccessories => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_ClothingAccessories_";
        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "parent",
                        1 => "child",
                    ],
                ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\20",
                "name" => "Size",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\30",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "Size",
                        1 => "Color",
                        2 => "SizeColor",
                    ],
                ],
            ],
            "{$i}ClassificationData_Department" => [
                "sequence" => "{$s}20\\10",
                "name" => "Department",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_ColorMap" => [
                "sequence" => "{$s}20\\20",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_SpecialSizeType" => [
                "sequence" => "{$s}20\\30",
                "name" => "SpecialSizeType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_SpecialFeature" => [
                "sequence" => "{$s}20\\40",
                "name" => "SpecialFeature",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_MaterialAndFabric" => [
                "sequence" => "{$s}20\\50",
                "name" => "MaterialAndFabric",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_ButtonQuantity" => [
                "sequence" => "{$s}20\\150",
                "name" => "ButtonQuantity",
                "minOccurs" => "0",
                "dataType" => "Integer",
            ],
            "{$i}ClassificationData_CollarType" => [
                "sequence" => "{$s}20\\160",
                "name" => "CollarType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_SleeveType" => [
                "sequence" => "{$s}20\\170",
                "name" => "SleeveType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ClassificationData_NeckSize" => [
                "sequence" => "{$s}20\\180",
                "name" => "NeckSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}NeckSize_unitOfMeasure_ClothingSizeUnitOfMeasure"
            ],
            "{$i}ClassificationData_ChestSize" => [
                "sequence" => "{$s}20\\190",
                "name" => "ChestSize",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}ChestSize_unitOfMeasure_ClothingSizeUnitOfMeasure"
            ],
            "{$i}ClassificationData_LegDiameter" => [
                "sequence" => "{$s}20\\290",
                "name" => "LegDiameter",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}LegDiameter_unitOfMeasure_LengthUnitOfMeasure"
            ],
        ];
        $this->attributes = array_merge($this->attributes, $common);
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_ClothingAccessories_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}NeckSize_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        $subAttributes["{$i}ChestSize_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        $subAttributes["{$i}LegDiameter_unitOfMeasure_LengthUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" =>
                [
                    "optionValues" =>
                        [
                            0 => "MM",
                            1 => "CM",
                            2 => "M",
                        ],
                ],
            "default" => "CM"
        ];
        return $subAttributes;
    }
}
