<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

/**
 * Class Clothing
 * @package Amazon\Sdk\Product\Category
 * @xsd xsd/US/ProductClothing.xsd
 */
class Clothing extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Clothing';
        $this->data["ProductData_{$this->category}"] = '';
        if (!empty($this->subCategory) && $this->subCategory !== 'Clothing') {
            $this->data["ProductData_{$this->category}_ClassificationData_ClothingType"] = $this->subCategory;
        }
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value']['minOccurs'] = '0';
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Clothing => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Clothing_";

        $common = [
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}10\\10",
                "name" => "Parentage",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        "parent",
                        "child",
                    ],
                ],
            ],
            "{$i}VariationData_Size" => [
                "sequence" => "{$s}10\\20",
                "name" => "Size",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_Color" => [
                "sequence" => "{$s}10\\30",
                "name" => "Color",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}10\\40",
                "name" => "VariationTheme",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        "Size",
                        "Color",
                        "SizeColor",
                        "Color-Itempackagequantity",
                        "Color-Material",
                        "Color-Patternname",
                        "ColorSize",
                        "Itempackagequantity",
                        "Itempackagequantity-Color",
                        "Itempackagequantity-Material",
                        "Itempackagequantity-Size",
                        "Material",
                        "Material-Color",
                        "Material-Patternname",
                        "Material-Size",
                        "Patternname",
                        "Patternname-Color",
                        "Patternname-Material",
                        "Patternname-Size",
                        "Size-Material",
                        "Size-Patternname",
                        "Cupsize",
                        "Cupsize-Color",
                        "Cupsize-Color-Size",
                        "Cupsize-Size",
                    ],
                ],
            ],
            "{$i}ClassificationData_BatteryAverageLife" => [
                "sequence" => "{$s}20\\10",
                "name" => "BatteryAverageLife",
                "dataType" => "Dimension",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_BatteryAverageLifeStandby" => [
                "sequence" => "{$s}20\\20",
                "name" => "BatteryAverageLifeStandby",
                "dataType" => "Dimension",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_BatteryChargeTime" => [
                "sequence" => "{$s}20\\30",
                "name" => "BatteryChargeTime",
                "dataType" => "Dimension",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_Size" => [
                "sequence" => "{$s}20\\40",
                "name" => "ClassificationData_Size",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_Color" => [
                "sequence" => "{$s}20\\50",
                "name" => "ClassificationData_Color",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_ClothingType" => [
                "sequence" => "{$s}20\\60",
                "name" => "ClothingType",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
                "restriction" => [
                    "optionValues" => [
                        "Shirt",
                        "Sweater",
                        "Pants",
                        "Shorts",
                        "Skirt",
                        "Dress",
                        "Suit",
                        "Blazer",
                        "Outerwear",
                        "SocksHosiery",
                        "Underwear",
                        "Bra",
                        "Shoes",
                        "Hat",
                        "Bag",
                        "Accessory",
                        "Jewelry",
                        "Sleepwear",
                        "Swimwear",
                        "PersonalBodyCare",
                        "HomeAccessory",
                        "NonApparelMisc",
                        "Kimono",
                        "Obi",
                        "Chanchanko",
                        "Jinbei",
                        "Yukata",
                        "EthnicWear",
                        "Costume",
                        "AdultCostume",
                        "BabyCostume",
                        "ChildrensCostume",
                    ],
                ],
            ],
            "{$i}ClassificationData_Department" => [
                "sequence" => "{$s}20\\70",
                "name" => "Department",
                "dataType" => "StringNotNull",
                "minOccurs" => "1",
                "maxOccurs" => "10",
                "restriction" => [
                    "optionValues" => [
                        "baby-boys",
                        "baby-girls",
                        "boys",
                        "girls",
                        "mens",
                        "unisex-baby",
                        "unisex-child",
                        "womens",
                    ],
                ],
            ],
            "{$i}ClassificationData_StyleKeywords" => [
                "sequence" => "{$s}20\\80",
                "name" => "StyleKeywords",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "maxOccurs" => "10",
            ],
            "{$i}ClassificationData_PlatinumKeywords" => [
                "sequence" => "{$s}20\\90",
                "name" => "PlatinumKeywords",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "maxOccurs" => "20",
            ],
            "{$i}ClassificationData_ColorMap" => [
                "sequence" => "{$s}20\\100",
                "name" => "ColorMap",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_SpecialSizeType" => [
                "sequence" => "{$s}20\\110",
                "name" => "SpecialSizeType",
                "dataType" => "String",
                "minOccurs" => "0",
                "maxOccurs" => "10"
            ],
            "{$i}ClassificationData_MaterialAndFabric" => [
                "sequence" => "{$s}20\\120",
                "name" => "MaterialAndFabric",
                "dataType" => "String",
                "minOccurs" => "0",
                "maxOccurs" => "4"
            ],
            "{$i}ClassificationData_MaterialComposition" => [
                "sequence" => "{$s}20\\125",
                "name" => "MaterialComposition",
                "dataType" => "SuperLongStringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_MaterialOpacity" => [
                "sequence" => "{$s}20\\130",
                "name" => "MaterialOpacity",
                "dataType" => "HundredString",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_InnerMaterial" => [
                "sequence" => "{$s}20\\135",
                "name" => "InnerMaterial",
                "dataType" => "LongString",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_OuterMaterial" => [
                "sequence" => "{$s}20\\140",
                "name" => "OuterMaterial",
                "dataType" => "LongString",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_SoleMaterial" => [
                "sequence" => "{$s}20\\145",
                "name" => "SoleMaterial",
                "dataType" => "LongString",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_PerformanceRating" => [
                "sequence" => "{$s}20\\200",
                "name" => "PerformanceRating",
                "dataType" => "String",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        "Sunproof",
                        "Waterproof",
                        "Weatherproof",
                        "Windproof",
                    ],
                ],
            ],
            "{$i}ClassificationData_ProductSpecification" => [
                "sequence" => "{$s}20\\300",
                "name" => "ProductSpecification",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_Warnings" => [
                "sequence" => "{$s}20\\400",
                "name" => "Warnings",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_IsCustomizable" => [
                "sequence" => "{$s}20\\500",
                "name" => "IsCustomizable",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_CustomizableTemplateName" => [
                "sequence" => "{$s}20\\600",
                "name" => "CustomizableTemplateName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_StyleName" => [
                "sequence" => "{$s}20\\700",
                "name" => "StyleName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_CollarType" => [
                "sequence" => "{$s}20\\800",
                "name" => "CollarType",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_SleeveType" => [
                "sequence" => "{$s}20\\900",
                "name" => "SleeveType",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_WaistStyle" => [
                "sequence" => "{$s}20\\1000",
                "name" => "WaistStyle",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_ModelName" => [
                "sequence" => "{$s}20\\2000",
                "name" => "ModelName",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_ModelNumber" => [
                "sequence" => "{$s}20\\2010",
                "name" => "ModelNumber",
                "dataType" => "FortyStringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_ModelYear" => [
                "sequence" => "{$s}20\\2020",
                "name" => "ModelYear",
                "dataType" => "FourDigitYear",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_IsAdultProduct" => [
                "sequence" => "{$s}20\\2030",
                "name" => "IsAdultProduct",
                "dataType" => "boolean",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_SizeMap" => [
                "sequence" => "{$s}20\\2040",
                "name" => "SizeMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_WaistSize" => [
                "sequence" => "{$s}20\\2050",
                "name" => "WaistSize",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}WaistSize_unitOfMeasure_ClothingSizeUnitOfMeasure",
            ],
            "{$i}ClassificationData_InseamLength" => [
                "sequence" => "{$s}20\\2060",
                "name" => "InseamLength",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}InseamLength_unitOfMeasure_ClothingSizeUnitOfMeasure",
            ],
            "{$i}ClassificationData_SleeveLength" => [
                "sequence" => "{$s}20\\2070",
                "name" => "SleeveLength",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}SleeveLength_unitOfMeasure_ClothingSizeUnitOfMeasure",
            ],
            "{$i}ClassificationData_NeckSize" => [
                "sequence" => "{$s}20\\2080",
                "name" => "NeckSize",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}NeckSize_unitOfMeasure_ClothingSizeUnitOfMeasure",
            ],
            "{$i}ClassificationData_ChestSize" => [
                "sequence" => "{$s}20\\2090",
                "name" => "ChestSize",
                "dataType" => "PositiveDimension",
                "minOccurs" => "0",
                "attribute" => "{$i}NeckSize_unitOfMeasure_ClothingSizeUnitOfMeasure",
            ],
            "{$i}ClassificationData_CupSize" => [
                "sequence" => "{$s}20\\2100",
                "name" => "CupSize",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" => [
                    "optionValues" => [
                        "A",
                        "AA",
                        "B",
                        "C",
                        "D",
                        "DD",
                        "DDD",
                        "E",
                        "EE",
                        "F",
                        "FF",
                        "G",
                        "GG",
                        "H",
                        "I",
                        "J",
                        "Free",
                    ],
                ],
            ],
            "{$i}ClassificationData_MaterialType" => [
                "sequence" => "{$s}20\\2200",
                "name" => "MaterialType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ClassificationData_TargetGender" => [
                "sequence" => "{$s}20\\2300",
                "name" => "TargetGender",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues"  => [
                        "male",
                        "female",
                        "unisex",
                    ]
                ]
            ],
            "{$i}ItemLengthDescription" => [
                "sequence" => "{$s}1000",
                "name" => "ItemLengthDescription",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
               "{$i}AgeRangeDescription" => [
                "sequence" => "{$s}1003",
                "name" => "AgeRangeDescription",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ShirtBodyType" => [
                "sequence" => "{$s}1004",
                "name" => "ShirtBodyType",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ShirtHeightType" => [
                "sequence" => "{$s}1005",
                "name" => "ShirtHeightType",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ShirtSize" => [
                "sequence" => "{$s}1006",
                "name" => "ShirtSize",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ShirtSizeClass" => [
                "sequence" => "{$s}1007",
                "name" => "ShirtSizeClass",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
            "{$i}ShirtSizeSystem" => [
                "sequence" => "{$s}1008",
                "name" => "ShirtSizeSystem",
                "dataType" => "String",
                "minOccurs" => "0",
            ],
        ];

        if (!empty($this->subCategory) && $this->subCategory !== 'Clothing') {
            $common["{$i}ClassificationData_ClothingType"]["minOccurs"] = "0";
        }

        $this->attributes = array_merge($this->attributes, $common);

        switch ($this->subCategory) {
            case "Dress":
                $this->attributes = array_merge($this->attributes, $this->getDress());
                break;
            case "Shoes":
                $this->attributes = array_merge($this->attributes, $this->getShoes());
                break;
        }

        if (isset($params) && !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getDress()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Clothing_";

        $this->attributes['DescriptionData_MfrPartNumber']['minOccurs'] = '1';
        $this->attributes[$i . 'ClassificationData_SizeMap']['minOccurs'] = '1';
        $this->attributes[$i . 'ClassificationData_ColorMap']['minOccurs'] = '1';
        $this->attributes[$i . 'ClassificationData_MaterialType']['minOccurs'] = '1';
        $this->attributes[$i . 'ItemLengthDescription']['minOccurs'] = '1';

        return $this->attributes;
    }

    public function getShoes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Clothing_";

        $this->attributes[$i . 'ClassificationData_SizeMap']['minOccurs'] = '1';
        $this->attributes[$i . 'ClassificationData_ColorMap']['minOccurs'] = '1';
        $this->attributes[$i . 'ClassificationData_TargetGender']['minOccurs'] = '1';

        return $this->attributes;
    }

    public function getSubAttributes()
    {
        /**
         * Index prefix
         */
        $i = "ProductData_Clothing_";

        $subAttributes = self::SUB_ATTRIBUTES;
        $subAttributes["{$i}WaistSize_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        $subAttributes["{$i}InseamLength_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        $subAttributes["{$i}SleeveLength_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        $subAttributes["{$i}NeckSize_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        $subAttributes["{$i}ChestSize_unitOfMeasure_ClothingSizeUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                    "optionValues" => [
                            0 => "IN",
                            1 => "CM",
                        ],
                ],
            "default" => "CM"
        ];
        return $subAttributes;
    }
}
