<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;


class CameraPhoto extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_FILM_CAMERA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CAMCORDER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DIGITAL_CAMERA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DIGITAL_FRAME = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BINOCULAR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SURVEILLANCE_SYSTEM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TELESCOPE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MICROSCOPE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DARK_ROOM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LENS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LENSACCESSORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FILTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FILM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BAG_CASE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BLANK_MEDIA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PHOTO_PAPER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CLEANER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_FLASH = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TRIPOD_STAND = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LIGHTING = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PROJECTION = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PHOTO_STUDIO = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_LIGHT_METER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_POWER_SUPPLY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_OTHER_ACCESSORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'CameraPhoto';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "FilmCamera":
                $this->attributes = array_merge($this->attributes, $this->getFilmCamera());
                break;
            case "Camcorder":
                $this->attributes = array_merge($this->attributes, $this->getCamcorder());
                break;
            case "DigitalCamera":
                $this->attributes = array_merge($this->attributes, $this->getDigitalCamera());
                break;
            case "Binocular":
                $this->attributes = array_merge($this->attributes, $this->getBinocular());
                break;
            case "SurveillanceSystem":
                $this->attributes = array_merge($this->attributes, $this->getSurveillanceSystem());
                break;
            case "Telescope":
                $this->attributes = array_merge($this->attributes, $this->getTelescope());
                break;
            case "Microscope":
                $this->attributes = array_merge($this->attributes, $this->getMicroscope());
                break;
            case "Darkroom":
                $this->attributes = array_merge($this->attributes, $this->getDarkroom());
                break;
            case "Lens":
                $this->attributes = array_merge($this->attributes, $this->getLens());
                break;
            case "LensAccessory":
                $this->attributes = array_merge($this->attributes, $this->getLensAccessory());
                break;
            case "Filter":
                $this->attributes = array_merge($this->attributes, $this->getFilter());
                break;
            case "Film":
                $this->attributes = array_merge($this->attributes, $this->getFilm());
                break;
            case "BagCase":
                $this->attributes = array_merge($this->attributes, $this->getBagCase());
                break;
            case "BlankMedia":
                $this->attributes = array_merge($this->attributes, $this->getBlankMedia());
                break;
            case "PhotoPaper":
                $this->attributes = array_merge($this->attributes, $this->getPhotoPaper());
                break;
            case "Cleaner":
                $this->attributes = array_merge($this->attributes, $this->getCleaner());
                break;
            case "Flash":
                $this->attributes = array_merge($this->attributes, $this->getFlash());
                break;
            case "TripodStand":
                $this->attributes = array_merge($this->attributes, $this->getTripodStand());
                break;
            case "Lighting":
                $this->attributes = array_merge($this->attributes, $this->getLighting());
                break;
            case "Projection":
                $this->attributes = array_merge($this->attributes, $this->getProjection());
                break;
            case "PhotoStudio":
                $this->attributes = array_merge($this->attributes, $this->getPhotoStudio());
                break;
            case "LightMeter":
                $this->attributes = array_merge($this->attributes, $this->getLightMeter());
                break;
            case "PowerSupply":
                $this->attributes = array_merge($this->attributes, $this->getPowerSupply());
                break;
            case "OtherAccessory":
                $this->attributes = array_merge($this->attributes, $this->getOtherAccessory());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getFilmCamera()
    {

        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * FilmCamera => 10
         */
        $s = "100\\10\\10\\10\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_FilmCamera_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_FilmCamera" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "FilmCamera",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}CameraType" => [
                "sequence" => "{$s}10",
                "name" => "CameraType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "point-and-shoot",
                        "slr",
                        "instant",
                        "single-use",
                        "large-format",
                        "medium-format",
                        "rangefinder",
                        "field",
                        "monorail",
                        "kids",
                        "3-d",
                        "micro",
                        "panorama",
                        "passport-and-id",
                        "underwater",
                        "other",
                    ],
                ]
            ],
            "{$i}FilmFormat" => [
                "sequence" => "{$s}20",
                "name" => "FilmFormat",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "aps",
                        "16mm",
                        "35mm",
                        "110",
                        "120",
                        "2x3",
                        "4x5",
                        "5x7",
                        "6x8",
                        "8x10",
                        "8x20",
                        "10x12",
                        "11x14",
                        "12x20",
                        "14x17",
                        "16x20",
                    ],
                ]
            ],
            "{$i}FocusType" => [
                "sequence" => "{$s}30",
                "name" => "FocusType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "auto-focus",
                        "manual-focus",
                        "manual-and-auto-focus",
                        "focus-free",
                    ],
                ]
            ],
            "{$i}LensType" => [
                "sequence" => "{$s}40",
                "name" => "LensType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "fixed",
                        "interchangeable",
                    ],
                ]
            ],
            "{$i}LensType" => [
                "sequence" => "{$s}100",
                "name" => "LensType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "fixed",
                        "interchangeable",
                    ],
                ]
            ],
            "{$i}MinShutterSpeed" => [
                "sequence" => "{$s}110",
                "name" => "MinShutterSpeed",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}MaxShutterSpeed" => [
                "sequence" => "{$s}120",
                "name" => "MaxShutterSpeed",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FlashType" => [
                "sequence" => "{$s}150",
                "name" => "FlashType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "automatic",
                        "forced",
                        "fill",
                        "none",
                        "flash-override",
                    ],
                ]
            ],
            "{$i}FlashModes" => [
                "sequence" => "{$s}160",
                "name" => "FlashModes",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}FlashSynchronization" => [
                "sequence" => "{$s}180",
                "name" => "FlashSynchronization",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}MidrollChange" => [
                "sequence" => "{$s}230",
                "name" => "MidrollChange",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}MidrollRewind" => [
                "sequence" => "{$s}240",
                "name" => "MidrollRewind",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}AutoRewind" => [
                "sequence" => "{$s}250",
                "name" => "AutoRewind",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}BatteryType" => [
                "sequence" => "{$s}310",
                "name" => "BatteryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}BatteryIncluded" => [
                "sequence" => "{$s}320",
                "name" => "BatteryIncluded",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
        ];
        return $this->attributes;
    }

    public function getCamcorder()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * Camcorder => 20
         */
        $s = "100\\10\\10\\20\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_Camcorder_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_Camcorder" => [
                "sequence" => "100\\10\\10\\20",
                "name" => "Camcorder",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}AnalogFormats" => [
                "sequence" => "{$s}10",
                "name" => "AnalogFormats",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "general",
                        "8mm",
                        "betacam-sp",
                        "hi-8",
                        "s-vhs",
                        "s-vhs-c",
                        "vhs",
                        "vhs-c",
                        "other",
                    ],
                ]
            ],
            "{$i}DigitalFormats" => [
                "sequence" => "{$s}20",
                "name" => "DigitalFormats",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "general",
                        "digital-betacam",
                        "dv",
                        "dvcam",
                        "dvcpro",
                        "minidv",
                        "micromv",
                        "digital8",
                        "dvd",
                        "minidisc",
                        "other",
                    ],
                ]
            ],
            "{$i}SensorType" => [
                "sequence" => "{$s}30",
                "name" => "SensorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "ccd",
                        "3-chip-ccd",
                        "cmos",
                        "progressive-scan-ccd",
                        "fixed-zoom-lens",
                        "interchangeable-lens",
                        "other-lens",
                    ],
                ]
            ],
            "{$i}FilmFormats" => [
                "sequence" => "{$s}40",
                "name" => "FilmFormats",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "general",
                        "8mm",
                        "16mm",
                        "35mm",
                        "65mm",
                        "70mm",
                        "other",
                    ],
                ]
            ],
            "{$i}LensType" => [
                "sequence" => "{$s}50",
                "name" => "LensType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "fixed-non-zoom",
                        "fixed-zoom",
                        "interchangeable",
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getDigitalCamera()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * DigitalCamera => 30
         */
        $s = "100\\10\\10\\30\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_DigitalCamera_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_DigitalCamera" => [
                "sequence" => "100\\10\\10\\30",
                "name" => "DigitalCamera",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Megapixels" => [
                "sequence" => "{$s}10",
                "name" => "Megapixels",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}Megapixels_unitOfMeasure_PixelUnitOfMeasure"
            ],
            "{$i}CameraType" => [
                "sequence" => "{$s}60",
                "name" => "CameraType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "point-and-shoot",
                        "slr",
                        "3-d",
                        "macro",
                        "passport-and-id",
                        "underwater",
                        "other",
                    ],
                ]
            ],
            "{$i}FocusType" => [
                "sequence" => "{$s}70",
                "name" => "FocusType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "automatic",
                        "manual",
                        "manual-and-auto",
                        "focus-free",
                    ],
                ]
            ],
            "{$i}SensorType" => [
                "sequence" => "{$s}80",
                "name" => "SensorType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "ccd",
                        "super-ccd",
                        "cmos",
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getBinocular()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * Binocular => 40
         */
        $s = "100\\10\\10\\40\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_Binocular_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_Binocular" => [
                "sequence" => "100\\10\\10\\40",
                "name" => "Binocular",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}BinocularType" => [
                "sequence" => "{$s}10",
                "name" => "BinocularType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "binoculars",
                        "monoculars",
                        "laser-rangefinders",
                        "spotting-scopes",
                        "night-vision",
                    ],
                ]
            ],
            "{$i}FocusType" => [
                "sequence" => "{$s}20",
                "name" => "FocusType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PrismType" => [
                "sequence" => "{$s}30",
                "name" => "PrismType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Features" => [
                "sequence" => "{$s}150",
                "name" => "Features",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "compact",
                        "full-size",
                        "image-stabilizing",
                        "waterproof",
                        "fogproof",
                        "zoom",
                        "uv-protection",
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getSurveillanceSystem()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * SurveillanceSystem => 50
         */
        $s = "100\\10\\10\\50\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_SurveillanceSystem_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_SurveillanceSystem" => [
                "sequence" => "100\\10\\10\\50",
                "name" => "SurveillanceSystem",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}SurveillanceSystemType" => [
                "sequence" => "{$s}10",
                "name" => "SurveillanceSystemType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "cameras",
                        "complete-systems",
                        "monitors",
                        "network-systems",
                        "multiplexer",
                    ],
                ]
            ],
            "{$i}CameraType" => [
                "sequence" => "{$s}20",
                "name" => "CameraType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "security-cameras",
                        "dummy-cameras",
                        "bullet-cameras",
                        "web-cameras",
                        "mirror-image-cameras",
                        "dome-cameras",
                        "spy-cameras",
                        "pinhole-cameras",
                        "miniature-cameras",
                        "nanny-cameras",
                        "pen-cameras",
                    ],
                ]
            ],
            "{$i}Features" => [
                "sequence" => "{$s}30",
                "name" => "Features",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "weatherproof",
                        "motion-detection",
                        "real-time",
                        "indoor",
                        "outdoor",
                        "black-and-white",
                        "color",
                        "night-vision",
                        "day-and-night-camera",
                        "adjustable-panning",
                        "submersible",
                        "wireless",
                        "ptz-system",
                        "digital-spy-camera",
                    ],
                ]
            ],
            "{$i}CameraAccessories" => [
                "sequence" => "{$s}40",
                "name" => "CameraAccessories",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "mounting-brackets",
                        "power-adapter",
                        "cable",
                        "sun-shield",
                        "camera-controller",
                        "transmitters",
                        "zoom-lens",
                        "pinhole-lens"
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getTelescope()
    {
        return [];
    }

    public function getMicroscope()
    {
        return [];
    }

    public function getDarkroom()
    {
        return [];
    }

    public function getLens()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * Lens => 90
         */
        $s = "100\\10\\10\\90\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_Lens_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_Lens" => [
                "sequence" => "100\\10\\10\\90",
                "name" => "Lens",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}CameraType" => [
                "sequence" => "{$s}10",
                "name" => "CameraType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "camcorder",
                        "digital-camera",
                        "35mm-rangefinder",
                        "35mm-slr",
                        "aps",
                        "large-format",
                        "medium-format",
                        "underwater",
                    ],
                ]
            ],
            "{$i}MinFocalLength" => [
                "sequence" => "{$s}20",
                "name" => "MinFocalLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}MinFocalLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}MaxFocalLength" => [
                "sequence" => "{$s}30",
                "name" => "MinFocalLength",
                "minOccurs" => "0",
                "dataType" => "PositiveDimension",
                "attribute" => "{$i}MaxFocalLength_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}LensType" => [
                "sequence" => "{$s}40",
                "name" => "LensType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "wide-angle",
                        "telephoto",
                        "zoom",
                        "macro",
                        "tilt-shift",
                        "fisheye",
                        "teleconverter",
                        "normal",
                    ],
                ]
            ],
            "{$i}FocusType" => [
                "sequence" => "{$s}50",
                "name" => "FocusType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "manual-focus",
                        "auto-focus",
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getLensAccessory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * LensAccessory => 100
         */
        $s = "100\\10\\10\\100\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_LensAccessory_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_LensAccessory" => [
                "sequence" => "100\\10\\10\\100",
                "name" => "LensAccessory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}ForUseWith" => [
                "sequence" => "{$s}10",
                "name" => "ForUseWith",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "film-cameras",
                        "digital-cameras",
                        "camcorders",
                        "telescopes",
                        "microscopes",
                    ],
                ]
            ],
            "{$i}AccessoryType" => [
                "sequence" => "{$s}20",
                "name" => "AccessoryType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "c-mounts",
                        "lens-scope-converters",
                        "lens-to-camera-adapters",
                        "remote-lens-controllers",
                        "extenders",
                        "series-vii-adapters",
                        "t-mounts",
                        "tripod-adapters",
                        "lens-boards",
                        "bayonets",
                        "lens-hoods",
                        "lens-supports",
                        "rapid-focusing-levers",
                        "shutters",
                        "diopters",
                        "mirror-scopes",
                        "lens-caps-general",
                        "lens-caps-up-to-48mm",
                        "lens-caps-49mm",
                        "lens-caps-52mm",
                        "lens-caps-55mm",
                        "lens-caps-58mm",
                        "lens-caps-62mm",
                        "lens-caps-67mm",
                        "lens-caps-72mm",
                        "lens-caps-77mm",
                        "lens-caps-82mm",
                        "lens-caps-86mm",
                        "lens-caps-92mm",
                        "lens-caps-other-sizes",

                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getFilter()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * Filter => 110
         */
        $s = "100\\10\\10\\110\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_Filter_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_Filter" => [
                "sequence" => "100\\10\\10\\110",
                "name" => "Filter",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}PackageType" => [
                "sequence" => "{$s}10",
                "name" => "PackageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "single-filter",
                        "filter-sets",
                    ],
                ]
            ],
            "{$i}MountType" => [
                "sequence" => "{$s}20",
                "name" => "MountType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "round",
                        "square",
                        "bayonet",
                        "other",
                    ],
                ]
            ],
            "{$i}SpecialEffect" => [
                "sequence" => "{$s}120",
                "name" => "SpecialEffect",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "center-spot",
                        "cross-screen",
                        "diffraction",
                        "double-exposure",
                        "enhancing",
                        "fog",
                        "hot-mirror",
                        "infrared",
                        "masks",
                        "multi-image",
                        "prism",
                        "sepia",
                        "special-contrast",
                        "speed",
                        "split-field",
                        "star-filters",
                        "other",
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getFilm()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CameraPhoto => 10
         * ProductType => 10
         * Film => 120
         */
        $s = "100\\10\\10\\120\\";
        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_ProductType_Film_";
        $this->attributes = [
            "ProductData_CameraPhoto_ProductType_Film" => [
                "sequence" => "100\\10\\10\\120",
                "name" => "Film",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}FilmColor" => [
                "sequence" => "{$s}10",
                "name" => "FilmColor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "black-and-white",
                        "color",
                    ],
                ]
            ],
            "{$i}FilmType" => [
                "sequence" => "{$s}20",
                "name" => "FilmType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "print",
                        "slide",
                    ],
                ]
            ],
            "{$i}Format" => [
                "sequence" => "{$s}30",
                "name" => "Format",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "35mm",
                        "70mm",
                        "110",
                        "120",
                        "220",
                        "2x3",
                        "4x5",
                        "5x7",
                        "8x10",
                        "11x14",
                        "aps",
                        "micro",
                        "instant",
                        "other",
                    ],
                ]
            ],
            "{$i}ExposureCount" => [
                "sequence" => "{$s}80",
                "name" => "ExposureCount",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "12-exposure",
                        "24-exposure",
                        "other-exposure-count",
                    ],
                ]
            ],
        ];
        return $this->attributes;
    }

    public function getBagCase()
    {

    }

    public function getBlankMedia()
    {
        return [];
    }

    public function getPhotoPaper()
    {
        return [];
    }

    public function getCleaner()
    {
        return [];
    }

    public function getFlash()
    {
        return [];
    }

    public function getTripodStand()
    {
        return [];
    }

    public function getLighting()
    {
        return [];
    }

    public function getProjection()
    {
        return [];
    }

    public function getPhotoStudio()
    {
        return [];
    }

    public function getLightMeter()
    {
        return [];
    }

    public function getPowerSupply()
    {
        return [];
    }

    public function getOtherAccessory()
    {
        return [];
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_CameraPhoto_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }

    public function getSubDigitalCamera()
    {
        $i = "ProductData_CameraPhoto_ProductType_DigitalCamera_";
        $subAttributes = [
            "{$i}Megapixels_unitOfMeasure_PixelUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "pixels",
                                1 => "MP",
                            ],
                    ],
                "default" => "MP"
            ],
        ];
        return $subAttributes;
    }

    public function getSubLens()
    {
        $i = "ProductData_CameraPhoto_ProductType_Lens_";
        $subAttributes = [
            "{$i}MinFocalLength_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
            "{$i}MaxFocalLength_unitOfMeasure_LengthUnitOfMeasure" => [
                "name" => "unitOfMeasure",
                "minOccurs" => "1",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                0 => "MM",
                                1 => "CM",
                                2 => "M",
                            ],
                    ],
                "default" => "CM"
            ],
        ];
        return $subAttributes;
    }
}