<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class CE extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_ANTENNA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_AUDIOVIDEOACCESSORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_AVFURNITURE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_BARCODEREADER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CEBINOCULAR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CECAMCORDER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CAMERABAGSANDCASES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CEBATTERY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CEBLANKMEDIA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CABLEORADAPTER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CECAMERAFLASH = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CAMERALENSES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CAMERAOTHERACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CAMERAPOWERSUPPLY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CARALARM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CARAUDIOORTHEATER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CARELECTRONICS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CONSUMERELECTRONICS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CEDIGITALCAMERA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DIGITALPICTUREFRAME = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DIGITALVIDEORECORDER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_DVDPLAYERORRECORDER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CEFILMCAMERA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GPSORNAVIGATIONACCESSORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_GPSORNAVIGATIONSYSTEM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HANDHELDORPDA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HEADPHONES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_HOMETHEATERSYSTEMORHTIB = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_KINDLEACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_KINDLEEREADERACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_KINDLEFIREACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MEDIAPLAYER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MEDIAPLAYEROREREADERACCESSORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MEDIASTORAGE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_MISCAUDIOCOMPONENTS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PC = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PDA = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PHONE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PHONEACCESSORY = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PHOTOGRAPHICSTUDIOITEMS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PORTABLEAUDIO = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_PORTABLEAVDEVICE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_POWERSUPPLIESORPROTECTION = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RADARDETECTOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RADIOORCLOCKRADIO = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_RECEIVERORAMPLIFIER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_REMOTECONTROL = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_SPEAKERS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_STEREOSHELFSYSTEM = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CETELESCOPE = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TELEVISION = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TUNER = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TVCOMBOS = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_TWOWAYRADIO = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VCR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_CEVIDEOPROJECTOR = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;
    const ALLOWED_MARKETPLACE_VIDEOPROJECTORSANDACCESSORIES = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'CE';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "Antenna":
                $this->attributes = array_merge($this->attributes, $this->getAntenna());
                break;
            case "AudioVideoAccessory":
                $this->attributes = array_merge($this->attributes, $this->getAudioVideoAccessory());
                break;
            case "AVFurniture":
                $this->attributes = array_merge($this->attributes, $this->getAVFurniture());
                break;
            case "BarCodeReader":
                $this->attributes = array_merge($this->attributes, $this->getBarCodeReader());
                break;
            case "CEBinocular":
                $this->attributes = array_merge($this->attributes, $this->getCEBinocular());
                break;
            case "CECamcorder":
                $this->attributes = array_merge($this->attributes, $this->getCECamcorder());
                break;
            case "CameraBagsAndCases":
                $this->attributes = array_merge($this->attributes, $this->getCameraBagsAndCases());
                break;
            case "CEBattery":
                $this->attributes = array_merge($this->attributes, $this->getCEBattery());
                break;
            case "CEBlankMedia":
                $this->attributes = array_merge($this->attributes, $this->getCEBlankMedia());
                break;
            case "CableOrAdapter":
                $this->attributes = array_merge($this->attributes, $this->getCableOrAdapter());
                break;
            case "CECameraFlash":
                $this->attributes = array_merge($this->attributes, $this->getCECameraFlash());
                break;
            case "CameraLenses":
                $this->attributes = array_merge($this->attributes, $this->getCameraLenses());
                break;
            case "CameraOtherAccessories":
                $this->attributes = array_merge($this->attributes, $this->getCameraOtherAccessories());
                break;
            case "CameraPowerSupply":
                $this->attributes = array_merge($this->attributes, $this->getCameraPowerSupply());
                break;
            case "CarAlarm":
                $this->attributes = array_merge($this->attributes, $this->getCarAlarm());
                break;
            case "CarAudioOrTheater":
                $this->attributes = array_merge($this->attributes, $this->getCarAudioOrTheater());
                break;
            case "CarElectronics":
                $this->attributes = array_merge($this->attributes, $this->getCarElectronics());
                break;
            case "ConsumerElectronics":
                $this->attributes = array_merge($this->attributes, $this->getConsumerElectronics());
                break;
            case "CEDigitalCamera":
                $this->attributes = array_merge($this->attributes, $this->getCEDigitalCamera());
                break;
            case "DigitalPictureFrame":
                $this->attributes = array_merge($this->attributes, $this->getDigitalPictureFrame());
                break;
            case "DigitalVideoRecorder":
                $this->attributes = array_merge($this->attributes, $this->getDigitalVideoRecorder());
                break;
            case "DVDPlayerOrRecorder":
                $this->attributes = array_merge($this->attributes, $this->getDVDPlayerOrRecorder());
                break;
            case "CEFilmCamera":
                $this->attributes = array_merge($this->attributes, $this->getCEFilmCamera());
                break;
            case "GPSOrNavigationAccessory":
                $this->attributes = array_merge($this->attributes, $this->getGPSOrNavigationAccessory());
                break;
            case "GPSOrNavigationSystem":
                $this->attributes = array_merge($this->attributes, $this->getGPSOrNavigationSystem());
                break;
            case "HandheldOrPDA":
                $this->attributes = array_merge($this->attributes, $this->getHandheldOrPDA());
                break;
            case "Headphones":
                $this->attributes = array_merge($this->attributes, $this->getHeadphones());
                break;
            case "HomeTheaterSystemOrHTIB":
                $this->attributes = array_merge($this->attributes, $this->getHomeTheaterSystemOrHTIB());
                break;
            case "KindleAccessories":
                $this->attributes = array_merge($this->attributes, $this->getKindleAccessories());
                break;
            case "KindleEReaderAccessories":
                $this->attributes = array_merge($this->attributes, $this->getKindleEReaderAccessories());
                break;
            case "KindleFireAccessories":
                $this->attributes = array_merge($this->attributes, $this->getKindleFireAccessories());
                break;
            case "MediaPlayer":
                $this->attributes = array_merge($this->attributes, $this->getMediaPlayer());
                break;
            case "MediaPlayerOrEReaderAccessory":
                $this->attributes = array_merge($this->attributes, $this->getMediaPlayerOrEReaderAccessory());
                break;
            case "MediaStorage":
                $this->attributes = array_merge($this->attributes, $this->getMediaStorage());
                break;
            case "MiscAudioComponents":
                $this->attributes = array_merge($this->attributes, $this->getMiscAudioComponents());
                break;
            case "PC":
                $this->attributes = array_merge($this->attributes, $this->getPC());
                break;
            case "PDA":
                $this->attributes = array_merge($this->attributes, $this->getPDA());
                break;
            case "Phone":
                $this->attributes = array_merge($this->attributes, $this->getPhone());
                break;
            case "PhoneAccessory":
                $this->attributes = array_merge($this->attributes, $this->getPhoneAccessory());
                break;
            case "PhotographicStudioItems":
                $this->attributes = array_merge($this->attributes, $this->getPhotographicStudioItems());
                break;
            case "PortableAudio":
                $this->attributes = array_merge($this->attributes, $this->getPortableAudio());
                break;
            case "PortableAvDevice":
                $this->attributes = array_merge($this->attributes, $this->getPortableAvDevice());
                break;
            case "PowerSuppliesOrProtection":
                $this->attributes = array_merge($this->attributes, $this->getPowerSuppliesOrProtection());
                break;
            case "RadarDetector":
                $this->attributes = array_merge($this->attributes, $this->getRadarDetector());
                break;
            case "RadioOrClockRadio":
                $this->attributes = array_merge($this->attributes, $this->getRadioOrClockRadio());
                break;
            case "ReceiverOrAmplifier":
                $this->attributes = array_merge($this->attributes, $this->getReceiverOrAmplifier());
                break;
            case "RemoteControl":
                $this->attributes = array_merge($this->attributes, $this->getRemoteControl());
                break;
            case "Speakers":
                $this->attributes = array_merge($this->attributes, $this->getSpeakers());
                break;
            case "StereoShelfSystem":
                $this->attributes = array_merge($this->attributes, $this->getStereoShelfSystem());
                break;
            case "CETelescope":
                $this->attributes = array_merge($this->attributes, $this->getCETelescope());
                break;
            case "Television":
                $this->attributes = array_merge($this->attributes, $this->getTelevision());
                break;
            case "Tuner":
                $this->attributes = array_merge($this->attributes, $this->getTuner());
                break;
            case "TVCombos":
                $this->attributes = array_merge($this->attributes, $this->getTVCombos());
                break;
            case "TwoWayRadio":
                $this->attributes = array_merge($this->attributes, $this->getTwoWayRadio());
                break;
            case "VCR":
                $this->attributes = array_merge($this->attributes, $this->getVCR());
                break;
            case "CEVideoProjector":
                $this->attributes = array_merge($this->attributes, $this->getCEVideoProjector());
                break;
            case "VideoProjectorsAndAccessories":
                $this->attributes = array_merge($this->attributes, $this->getVideoProjectorsAndAccessories());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_";

        $common = [
            "{$i}ProductSubtype" => [
                "sequence" => "{$s}10",
                "name" => "ProductSubtype",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "Antenna",
                                "AVFurniture",
                                "BarCodeReader",
                                "CEBinocular",
                                "CECamcorder",
                                "CameraBagsAndCases",
                                "Battery",
                                "BlankMedia",
                                "CableOrAdapter",
                                "CECameraFlash",
                                "CameraLenses",
                                "CameraOtherAccessories",
                                "CameraPowerSupply",
                                "CarAudioOrTheater",
                                "CarElectronics",
                                "CEDigitalCamera",
                                "DigitalPictureFrame",
                                "CECarryingCaseOrBag",
                                "CombinedAvDevice",
                                "Computer",
                                "ComputerDriveOrStorage",
                                "ComputerProcessor",
                                "ComputerVideoGameController",
                                "DigitalVideoRecorder",
                                "DVDPlayerOrRecorder",
                                "CEFilmCamera",
                                "FlashMemory",
                                "GPSOrNavigationAccessory",
                                "GPSOrNavigationSystem",
                                "HandheldOrPDA",
                                "HomeTheaterSystemOrHTIB",
                                "Keyboards",
                                "MemoryReader",
                                "Microphone",
                                "Monitor",
                                "MP3Player",
                                "MultifunctionOfficeMachine",
                                "NetworkAdapter",
                                "NetworkMediaPlayer",
                                "NetworkStorage",
                                "NetworkTransceiver",
                                "NetworkingDevice",
                                "NetworkingHub",
                                "Phone",
                                "PhoneAccessory",
                                "PhotographicStudioItems",
                                "PointingDevice",
                                "PortableAudio",
                                "PortableAvDevice",
                                "PortableElectronics",
                                "Printer",
                                "PrinterConsumable",
                                "ReceiverOrAmplifier",
                                "RemoteControl",
                                "SatelliteOrDSS",
                                "Scanner",
                                "SoundCard",
                                "Speakers",
                                "CETelescope",
                                "SystemCabinet",
                                "SystemPowerDevice",
                                "Television",
                                "TwoWayRadio",
                                "VCR",
                                "VideoCard",
                                "VideoProjector",
                                "VideoProjectorsAndAccessories",
                                "Webcam",
                            ],
                    ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}200",
                "name" => "Color",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}ColorDepth" => [
                "sequence" => "{$s}300",
                "name" => "ColorDepth",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
                "maxOccurs" => "5",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}400",
                "name" => "ColorMap",
                "dataType" => "StringNotNull",
                "minOccurs" => "0",
            ],
            "{$i}MfgWarrantyDescriptionLabor" => [
                "sequence" => "{$s}500",
                "name" => "MfgWarrantyDescriptionLabor",
                "dataType" => "SuperLongStringNotNull",
                "minOccurs" => "1",
            ],
            "{$i}ItemDisplayWeight" => [
                "sequence" => "{$s}500",
                "name" => "ItemDisplayWeight",
                "dataType" => "Dimension",
                "minOccurs" => "0",
                "attribute" => "{$i}ItemDisplayWeight_unitOfMeasure_LengthUnitOfMeasure"
            ],
            "{$i}Model" => [
                'sequence' => "{$s}600",
                'name' => 'Model',
                'dataType' => "FortyStringNotNull",
                'minOccurs' => '0',
            ],
            "{$i}Size" => [
                'sequence' => "{$s}700",
                'name' => 'Size',
                'dataType' => "StringNotNull",
                'minOccurs' => '0',
            ],
        ];

        $this->attributes = array_merge($this->attributes, $common);

        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }

        return $this->attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getAntenna()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * Antenna => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_Antenna_";

        $attributes = [
            "ProductData_CE_ProductType_Antenna" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Antenna",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getAudioVideoAccessory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * AudioVideoAccessory => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_AudioVideoAccessory_";

        $attributes = [
            "ProductData_CE_ProductType_AudioVideoAccessory" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "AudioVideoAccessory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getAVFurniture()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * AVFurniture => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_AVFurniture_";

        $attributes = [
            "ProductData_CE_ProductType_AVFurniture" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "AVFurniture",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getBarCodeReader()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * BarCodeReader => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_BarCodeReader_";

        $attributes = [
            "ProductData_CE_ProductType_BarCodeReader" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "BarCodeReader",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCEBinocular()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CEBinocular => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CEBinocular_";

        $attributes = [
            "ProductData_CE_ProductType_CEBinocular" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CEBinocular",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCECamcorder()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CECamcorder => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CECamcorder_";

        $attributes = [
            "ProductData_CE_ProductType_CECamcorder" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CECamcorder",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCameraBagsAndCases()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CameraBagsAndCases => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CameraBagsAndCases_";

        $attributes = [
            "ProductData_CE_ProductType_CameraBagsAndCases" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CameraBagsAndCases",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCEBattery()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CEBattery => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CEBattery_";

        $attributes = [
            "ProductData_CE_ProductType_CEBattery" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CEBattery",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCEBlankMedia()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CEBlankMedia => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CEBlankMedia_";

        $attributes = [
            "ProductData_CE_ProductType_CEBlankMedia" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CEBlankMedia",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCableOrAdapter()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CableOrAdapter => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CableOrAdapter_";

        $attributes = [
            "ProductData_CE_ProductType_CableOrAdapter" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CableOrAdapter",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCECameraFlash()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CECameraFlash => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CECameraFlash_";

        $attributes = [
            "ProductData_CE_ProductType_CECameraFlash" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CECameraFlash",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCameraLenses()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CameraLenses => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CameraLenses_";

        $attributes = [
            "ProductData_CE_ProductType_CameraLenses" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CameraLenses",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCameraOtherAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CameraOtherAccessories => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CameraOtherAccessories_";

        $attributes = [
            "ProductData_CE_ProductType_CameraOtherAccessories" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CameraOtherAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCameraPowerSupply()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CameraPowerSupply => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CameraPowerSupply_";

        $attributes = [
            "ProductData_CE_ProductType_CameraPowerSupply" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CameraPowerSupply",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCarAlarm()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CarAlarm => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CarAlarm_";

        $attributes = [
            "ProductData_CE_ProductType_CarAlarm" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CarAlarm",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCarAudioOrTheater()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CarAudioOrTheater => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CarAudioOrTheater_";

        $attributes = [
            "ProductData_CE_ProductType_CarAudioOrTheater" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CarAudioOrTheater",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCarElectronics()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CarElectronics => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CarElectronics_";

        $attributes = [
            "ProductData_CE_ProductType_CarElectronics" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CarElectronics",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getConsumerElectronics()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * ConsumerElectronics => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_ConsumerElectronics_";

        $attributes = [
            "ProductData_CE_ProductType_ConsumerElectronics" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "ConsumerElectronics",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Color",
                        "Size",
                        "Size-Color",
                        "Scent",
                        "Size-Scent",
                        "CustomerPackageType",
                        "ColorName-CustomerPackageType",
                        "SizeName-CustomerPackageType",
                        "SizeName-ColorName-CustomerPackageType",
                        "StyleName-CustomerPackageType",
                        "SizeName-StyleName-CustomerPackageType",
                    ],
                ],
            ],
            "{$i}AudibleNoise" => [
                "sequence" => "{$s}30",
                "name" => "AudibleNoise",
                "minOccurs" => "0",
                "dataType" => "positiveInteger",
            ],
            "{$i}Color" => [
                "sequence" => "{$s}40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}50",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CustomerPackageType" => [
                "sequence" => "{$s}60",
                "name" => "CustomerPackageType",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}CanShipInOriginalContainer" => [
                "sequence" => "{$s}70",
                "name" => "CanShipInOriginalContainer",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}EnclosureFinish" => [
                "sequence" => "{$s}80",
                "name" => "EnclosureFinish",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "a",
                        "a_plus",
                        "a_plus_plus",
                        "a_plus_plus_plus",
                        "b",
                        "c",
                        "d",
                        "e",
                        "f",
                        "g",
                    ]
                ]
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCEDigitalCamera()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CEDigitalCamera => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CEDigitalCamera_";

        $attributes = [
            "ProductData_CE_ProductType_CEDigitalCamera" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CEDigitalCamera",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getDigitalPictureFrame()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * DigitalPictureFrame => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_DigitalPictureFrame_";

        $attributes = [
            "ProductData_CE_ProductType_DigitalPictureFrame" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "DigitalPictureFrame",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getDigitalVideoRecorder()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * DigitalVideoRecorder => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_DigitalVideoRecorder_";

        $attributes = [
            "ProductData_CE_ProductType_DigitalVideoRecorder" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "DigitalVideoRecorder",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getDVDPlayerOrRecorder()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * DVDPlayerOrRecorder => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_DVDPlayerOrRecorder_";

        $attributes = [
            "ProductData_CE_ProductType_DVDPlayerOrRecorder" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "DVDPlayerOrRecorder",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCEFilmCamera()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CEFilmCamera => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CEFilmCamera_";

        $attributes = [
            "ProductData_CE_ProductType_CEFilmCamera" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CEFilmCamera",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getGPSOrNavigationAccessory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * GPSOrNavigationAccessory => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_GPSOrNavigationAccessory_";

        $attributes = [
            "ProductData_CE_ProductType_GPSOrNavigationAccessory" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "GPSOrNavigationAccessory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getGPSOrNavigationSystem()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * GPSOrNavigationSystem => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_GPSOrNavigationSystem_";

        $attributes = [
            "ProductData_CE_ProductType_GPSOrNavigationSystem" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "GPSOrNavigationSystem",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getHandheldOrPDA()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * HandheldOrPDA => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_HandheldOrPDA_";

        $attributes = [
            "ProductData_CE_ProductType_HandheldOrPDA" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "HandheldOrPDA",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getHeadphones()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * Headphones => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_Headphones_";

        $attributes = [
            "ProductData_CE_ProductType_Headphones" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Headphones",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getHomeTheaterSystemOrHTIB()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * HomeTheaterSystemOrHTIB => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_HomeTheaterSystemOrHTIB_";

        $attributes = [
            "ProductData_CE_ProductType_HomeTheaterSystemOrHTIB" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "HomeTheaterSystemOrHTIB",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getKindleAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * KindleAccessories => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_KindleAccessories_";

        $attributes = [
            "ProductData_CE_ProductType_KindleAccessories" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "KindleAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Color",
                        "Size",
                        "Size-Color",
                        "Scent",
                        "Size-Scent",
                    ],
                ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}50",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getKindleEReaderAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * KindleEReaderAccessories => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_KindleEReaderAccessories_";

        $attributes = [
            "ProductData_CE_ProductType_KindleEReaderAccessories" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "KindleEReaderAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Color",
                        "Size",
                        "Size-Color",
                    ],
                ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}50",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getKindleFireAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * KindleFireAccessories => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_KindleFireAccessories_";

        $attributes = [
            "ProductData_CE_ProductType_KindleFireAccessories" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "KindleFireAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}VariationData_Parentage" => [
                "sequence" => "{$s}20\\10",
                "name" => "Parentage",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" =>
                    [
                        "optionValues" =>
                            [
                                "parent",
                                "child",
                            ],
                    ],
            ],
            "{$i}VariationData_VariationTheme" => [
                "sequence" => "{$s}20\\40",
                "name" => "VariationTheme",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Color",
                        "Size",
                        "Size-Color",
                        "Scent",
                        "Size-Scent",
                    ],
                ],
            ],
            "{$i}Color" => [
                "sequence" => "{$s}40",
                "name" => "Color",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}ColorMap" => [
                "sequence" => "{$s}50",
                "name" => "ColorMap",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getMediaPlayer()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * MediaPlayer => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_MediaPlayer_";

        $attributes = [
            "ProductData_CE_ProductType_MediaPlayer" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "MediaPlayer",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getMediaPlayerOrEReaderAccessory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * MediaPlayerOrEReaderAccessory => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_MediaPlayerOrEReaderAccessory_";

        $attributes = [
            "ProductData_CE_ProductType_MediaPlayerOrEReaderAccessory" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "MediaPlayerOrEReaderAccessory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getMediaStorage()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * MediaStorage => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_MediaStorage_";

        $attributes = [
            "ProductData_CE_ProductType_MediaStorage" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "MediaStorage",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getMiscAudioComponents()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * MiscAudioComponents => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_MiscAudioComponents_";

        $attributes = [
            "ProductData_CE_ProductType_MiscAudioComponents" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "MiscAudioComponents",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPC()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PC => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PC_";

        $attributes = [
            "ProductData_CE_ProductType_PC" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PC",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPDA()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PDA => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PDA_";

        $attributes = [
            "ProductData_CE_ProductType_PDA" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PDA",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPhone()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * Phone => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_Phone_";

        $attributes = [
            "ProductData_CE_ProductType_Phone" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Phone",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPhoneAccessory()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PhoneAccessory => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PhoneAccessory_";

        $attributes = [
            "ProductData_CE_ProductType_PhoneAccessory" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PhoneAccessory",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPhotographicStudioItems()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PhotographicStudioItems => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PhotographicStudioItems_";

        $attributes = [
            "ProductData_CE_ProductType_PhotographicStudioItems" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PhotographicStudioItems",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPortableAudio()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PortableAudio => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PortableAudio_";

        $attributes = [
            "ProductData_CE_ProductType_PortableAudio" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PortableAudio",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPortableAvDevice()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PortableAvDevice => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PortableAvDevice_";

        $attributes = [
            "ProductData_CE_ProductType_PortableAvDevice" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PortableAvDevice",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getPowerSuppliesOrProtection()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * PowerSuppliesOrProtection => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_PowerSuppliesOrProtection_";

        $attributes = [
            "ProductData_CE_ProductType_PowerSuppliesOrProtection" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "PowerSuppliesOrProtection",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getRadarDetector()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * RadarDetector => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_RadarDetector_";

        $attributes = [
            "ProductData_CE_ProductType_RadarDetector" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "RadarDetector",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getRadioOrClockRadio()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * RadioOrClockRadio => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_RadioOrClockRadio_";

        $attributes = [
            "ProductData_CE_ProductType_RadioOrClockRadio" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "RadioOrClockRadio",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getReceiverOrAmplifier()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * ReceiverOrAmplifier => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_ReceiverOrAmplifier_";

        $attributes = [
            "ProductData_CE_ProductType_ReceiverOrAmplifier" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "ReceiverOrAmplifier",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getRemoteControl()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * RemoteControl => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_RemoteControl_";

        $attributes = [
            "ProductData_CE_ProductType_RemoteControl" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "RemoteControl",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getSpeakers()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * Speakers => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_Speakers_";

        $attributes = [
            "ProductData_CE_ProductType_Speakers" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Speakers",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getStereoShelfSystem()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * StereoShelfSystem => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_StereoShelfSystem_";

        $attributes = [
            "ProductData_CE_ProductType_StereoShelfSystem" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "StereoShelfSystem",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCETelescope()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CETelescope => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CETelescope_";

        $attributes = [
            "ProductData_CE_ProductType_CETelescope" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CETelescope",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getTelevision()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * Television => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_Television_";

        $attributes = [
            "ProductData_CE_ProductType_Television" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Television",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getTuner()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * Tuner => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_Tuner_";

        $attributes = [
            "ProductData_CE_ProductType_Tuner" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "Tuner",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getTVCombos()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * TVCombos => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_TVCombos_";

        $attributes = [
            "ProductData_CE_ProductType_TVCombos" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "TVCombos",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getTwoWayRadio()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * TwoWayRadio => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_TwoWayRadio_";

        $attributes = [
            "ProductData_CE_ProductType_TwoWayRadio" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "TwoWayRadio",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getVCR()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * VCR => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_VCR_";

        $attributes = [
            "ProductData_CE_ProductType_VCR" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "VCR",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getCEVideoProjector()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * CEVideoProjector => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_CEVideoProjector_";

        $attributes = [
            "ProductData_CE_ProductType_CEVideoProjector" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "CEVideoProjector",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    /**
     * Get attributes array
     * @return array
     */
    public function getVideoProjectorsAndAccessories()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * CE => 10
         * ProductType => 10
         * VideoProjectorsAndAccessories => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_CE_ProductType_VideoProjectorsAndAccessories_";

        $attributes = [
            "ProductData_CE_ProductType_VideoProjectorsAndAccessories" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "VideoProjectorsAndAccessories",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
        ];

        return $attributes;
    }

    public function getSubAttributes()
    {
        $subAttributes = self::SUB_ATTRIBUTES;

        /**
         * Index prefix
         */
        $i = "ProductData_CE_";

        $subAttributes["{$i}ItemDisplayWeight_unitOfMeasure_WeightUnitOfMeasure"] = [
            "name" => "unitOfMeasure",
            "minOccurs" => "1",
            "restriction" => [
                "optionValues" => [
                    "GR",
                    "KG",
                    "OZ",
                    "LB",
                    "MG",
                ],
            ],
            "default" => "KG"
        ];

        return $subAttributes;
    }
}
