<?php
/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2018 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Product\Category;

class Books extends \Amazon\Sdk\Product\Category implements \Amazon\Sdk\Product\CategoryInterface
{
    const ALLOWED_MARKETPLACE_BOOKS_MISC = \Amazon\Sdk\Marketplace::MARKETPLACE_IDS;

    public function __construct($subCategory)
    {
        parent::__construct($subCategory);

        // setting category
        $this->category = 'Books';
        $this->data["ProductData_{$this->category}_ProductType_{$subCategory}"] = '';
    }

    public function getAttributes($params = [])
    {
        $this->params = $params;

        $this->attributes = self::BASE_ATTRIBUTES;

        if ($this->getBarcodeExemption()) {
            $this->attributes['StandardProductID_Value'] = [
                'sequence' => '20\20',
                'name' => 'Barcode',
                'dataType' => "Barcode",
                'minOccurs' => '0',
                "length" => "8:16"
            ];
        }

        switch ($this->subCategory) {
            case "BooksMisc":
                $this->attributes = array_merge($this->attributes, $this->getBooksMisc());
                break;
        }

        /**
         * Sequence prefix
         * ProductData => 100
         * Books => 10
         */
        $s = "100\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Books_";
        if (isset($params) and !empty($params)) {
            $this->attributes = array_filter($this->attributes, [$this, 'filterAttributes']);
        }
        return $this->attributes;
    }

    public function getBooksMisc()
    {
        /**
         * Sequence prefix
         * ProductData => 100
         * Beauty => 10
         * ProductType => 10
         * BooksMisc => 10
         */
        $s = "100\\10\\10\\10\\";

        /**
         * Index prefix
         */
        $i = "ProductData_Books_ProductType_BooksMisc_";

        $this->attributes = [
            "ProductData_Books_ProductType_BooksMisc" => [
                "sequence" => "100\\10\\10\\10",
                "name" => "BooksMisc",
                "dataType" => "string",
                "minOccurs" => "0",
                "visible" => false
            ],
            "{$i}Author" => [
                "sequence" => "{$s}10",
                "name" => "Author",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Binding" => [
                "sequence" => "{$s}20",
                "name" => "Binding",
                "minOccurs" => "1",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        0 => "Accessory",
                        1 => "Album",
                        2 => "Audiocd",
                        3 => "Audiodownload",
                        4 => "Bathbook",
                        5 => "Boardbook",
                        6 => "Bondedleather",
                        7 => "Calendar",
                        8 => "Cardbook",
                        9 => "Cards",
                        10 => "Cassette",
                        11 => "Cdrom",
                        12 => "Comic",
                        13 => "Diary",
                        14 => "Dvdrom",
                        15 => "Flexibound",
                        16 => "Foambook",
                        17 => "Game",
                        18 => "Hardcover",
                        19 => "Hardcovercomic",
                        20 => "Hardcoverspiral",
                        21 => "Imitationleather",
                        22 => "Journal",
                        23 => "Kindleedition",
                        24 => "Leatherbound",
                        25 => "Library",
                        26 => "Looseleaf",
                        27 => "Map",
                        28 => "Massmarket",
                        29 => "Microfiche",
                        30 => "Microfilm",
                        31 => "Miscsupplies",
                        32 => "Mook",
                        33 => "Mp3cd",
                        34 => "Pamphlet",
                        35 => "Paperback",
                        36 => "Paperbackbunko",
                        37 => "Paperbackshinsho",
                        38 => "Plasticcomb",
                        39 => "Popup",
                        40 => "Ragbook",
                        41 => "Ringbound",
                        42 => "Roughcut",
                        43 => "School",
                        44 => "Spiralbound",
                        45 => "Textbook",
                        46 => "Toy",
                        47 => "Vinylbound",
                        48 => "Wallchart",
                        49 => "Workbook"
                    ],
                ]
            ],
            "{$i}Edition" => [
                "sequence" => "{$s}40",
                "name" => "Edition",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Editor" => [
                "sequence" => "{$s}50",
                "name" => "Editor",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Introduction" => [
                "sequence" => "{$s}70",
                "name" => "Introduction",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}IsAdultProduct" => [
                "sequence" => "{$s}80",
                "name" => "IsAdultProduct",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}IsFixedPrice" => [
                "sequence" => "{$s}90",
                "name" => "IsFixedPrice",
                "minOccurs" => "0",
                "dataType" => "boolean",
            ],
            "{$i}Language" => [
                "sequence" => "{$s}100",
                "name" => "Language",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
                "restriction" => [
                    "optionValues" => [
                        "Abkhazian",
                        "Adygei",
                        "Afar",
                        "Afrikaans",
                        "Albanian",
                        "Alsatian",
                        "Amharic",
                        "Arabic",
                        "Aramaic",
                        "Armenian",
                        "Assamese",
                        "Aymara",
                        "Azerbaijani",
                        "Bambara",
                        "Bashkir",
                        "Basque",
                        "Bengali",
                        "Berber",
                        "Bhutani",
                        "Bihari",
                        "Bislama",
                        "Breton",
                        "Bulgarian",
                        "Burmese",
                        "Buryat",
                        "Byelorussian",
                        "CantoneseChinese",
                        "Castillian",
                        "Catalan",
                        "Cayuga",
                        "Cheyenne",
                        "Chinese",
                        "ClassicalNewari",
                        "Cornish",
                        "Corsican",
                        "Creole",
                        "CrimeanTatar",
                        "Croatian",
                        "Czech",
                        "Danish",
                        "Dargwa",
                        "Dutch",
                        "English",
                        "Esperanto",
                        "Estonian",
                        "Faroese",
                        "Farsi",
                        "Fiji",
                        "Filipino",
                        "Finnish",
                        "Flemish",
                        "French",
                        "FrenchCanadian",
                        "Frisian",
                        "Galician",
                        "Georgian",
                        "German",
                        "Gibberish",
                        "Greek",
                        "Greenlandic",
                        "Guarani",
                        "Gujarati",
                        "Gullah",
                        "Hausa",
                        "Hawaiian",
                        "Hebrew",
                        "Hindi",
                        "Hmong",
                        "Hungarian",
                        "Icelandic",
                        "IndoEuropean",
                        "Indonesian",
                        "Ingush",
                        "Interlingua",
                        "Interlingue",
                        "Inuktitun",
                        "Inuktitut",
                        "Inupiak",
                        "Inupiaq",
                        "Irish",
                        "Italian",
                        "Japanese",
                        "Javanese",
                        "Kalaallisut",
                        "Kalmyk",
                        "Kannada",
                        "KarachayBalkar",
                        "Kashmiri",
                        "Kashubian",
                        "Kazakh",
                        "Khmer",
                        "Kinyarwanda",
                        "Kirghiz",
                        "Kirundi",
                        "Klingon",
                        "Korean",
                        "Kurdish",
                        "Ladino",
                        "Lao",
                        "Lapp",
                        "Latin",
                        "Latvian",
                        "Lingala",
                        "Lithuanian",
                        "Lojban",
                        "LowerSorbian",
                        "Macedonian",
                        "Malagasy",
                        "Malay",
                        "Malayalam",
                        "Maltese",
                        "MandarinChinese",
                        "Maori",
                        "Marathi",
                        "Mende",
                        "MiddleEnglish",
                        "Mirandese",
                        "Moksha",
                        "Moldavian",
                        "Mongo",
                        "Mongolian",
                        "Multilingual",
                        "Nauru",
                        "Navaho",
                        "Nepali",
                        "Nogai",
                        "Norwegian",
                        "Occitan",
                        "OldEnglish",
                        "Oriya",
                        "Oromo",
                        "Pashto",
                        "Persian",
                        "PigLatin",
                        "Polish",
                        "Portuguese",
                        "Punjabi",
                        "Quechua",
                        "Romance",
                        "Romanian",
                        "Romany",
                        "Russian",
                        "Samaritan",
                        "Samoan",
                        "Sangho",
                        "Sanskrit",
                        "Serbian",
                        "Serbo-Croatian",
                        "Sesotho",
                        "Setswana",
                        "Shona",
                        "SichuanYi",
                        "Sicilian",
                        "SignLanguage",
                        "Sindhi",
                        "Sinhalese",
                        "Siswati",
                        "Slavic",
                        "Slovak",
                        "Slovakian",
                        "Slovene",
                        "Somali",
                        "Spanish",
                        "Sumerian",
                        "Sundanese",
                        "Swahili",
                        "Swedish",
                        "SwissGerman",
                        "Syriac",
                        "Tagalog",
                        "TaiwaneseChinese",
                        "Tajik",
                        "Tamil",
                        "Tatar",
                        "Telugu",
                        "Thai",
                        "Tibetan",
                        "Tigrinya",
                        "Tonga",
                        "Tsonga",
                        "Turkish",
                        "Turkmen",
                        "Twi",
                        "Udmurt",
                        "Uighur",
                        "Ukrainian",
                        "Ukranian",
                        "Unknown",
                        "Urdu",
                        "Uzbek",
                        "Vietnamese",
                        "Volapuk",
                        "Welsh",
                        "Wolof",
                        "Xhosa",
                        "Yiddish",
                        "Yoruba",
                        "Zhuang",
                        "Zulu"
                    ],
                ]
            ],
            "{$i}Narrator" => [
                "sequence" => "{$s}110",
                "name" => "Narrator",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}PublicationDate" => [
                "sequence" => "{$s}150",
                "name" => "PublicationDate",
                "minOccurs" => "1",
                "dataType" => "dateTime",
            ],
            "{$i}Subject" => [
                "sequence" => "{$s}180",
                "name" => "Subject",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Translator" => [
                "sequence" => "{$s}190",
                "name" => "Translator",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
            "{$i}Volume" => [
                "sequence" => "{$s}200",
                "name" => "Volume",
                "minOccurs" => "0",
                "dataType" => "StringNotNull",
            ],
        ];
        return $this->attributes;
    }

    public function getSubAttributes()
    {

        /**
         * Index prefix
         */
        $i = "ProductData_Books_";

        $subAttributes = self::SUB_ATTRIBUTES;
        return $subAttributes;
    }
}
