<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CedCommerce (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Order\Fulfillment;

class CarrierCode
{
    public static function getCarrierCodes()
    {
        $codes = [
            "USPS",
            "UPS",
            "UPSMI",
            "FedEx",
            "DHL",
            "Fastway",
            "GLS",
            "GO!",
            "Hermes Logistik Gruppe",
            "Royal Mail",
            "Parcelforce",
            "City Link",
            "TNT",
            "Target",
            "SagawaExpress",
            "NipponExpress",
            "YamatoTransport",
            "DHL Global Mail",
            "UPS Mail Innovations",
            "FedEx SmartPost",
            "OSM",
            "OnTrac",
            "Streamlite",
            "Newgistics",
            "Canada Post",
            "Blue Package",
            "Chronopost",
            "Deutsche Post",
            "DPD",
            "La Poste",
            "Parcelnet",
            "Poste Italiane",
            "SDA",
            "Smartmail",
            "FEDEX_JP",
            "JP_EXPRESS",
            "NITTSU",
            "SAGAWA",
            "YAMATO",
            "BlueDart",
            "AFL/Fedex",
            "Aramex",
            "India Post",
            "Professional",
            "DTDC",
            "Overnite Express",
            "First Flight",
            "Delhivery",
            "Lasership",
            "Yodel",
            "Other",
            "Amazon Shipping",
            "Seur",
            "Correos",
            "MRW",
            "Endopack",
            "Chrono Express",
            "Nacex",
            "Otro",
            "Correios",
            "Australia Post-Consignment",
            "Australia Post-ArticleID",
            "China Post",
            "4PX",
            "Asendia",
            "Couriers Please",
            "Sendle",
            "SF express",
            "SFC",
            "Singapore Post",
            "Startrack-Consignment",
            "Startrack-ArticleID",
            "Yanwen",
            "Yun Express",
            "Australia Post"
        ];

        return $codes;
    }

    public static function search($value)
    {
        $result = null;

        // Matching with upper case and no-space, or sub string
        foreach (self::getCarrierCodes() as $code) {
            if (strtoupper($value) == strtoupper($code) ||
                strtoupper(preg_replace('/\s+/', '', $value)) == strtoupper(preg_replace('/\s+/', '', $code)) ||
                strpos(
                    strtoupper(preg_replace('/\s+/', '', $value)),
                    strtoupper(preg_replace('/\s+/', '', $code))
                ) !== false ||
                strpos(
                    strtoupper(preg_replace('/\s+/', '', $code)),
                    strtoupper(preg_replace('/\s+/', '', $value))
                ) !== false
            ) {
                $result = $code;
                break;
            }
        }

        return $result;
    }
}
