<?php

namespace Amazon\Sdk\Order;

/**
 * Class Adjustment
 * @package Amazon\Sdk\Order
 * @refer amazon-sdk/xsd/xsd_in/OrderAdjustment.xsd
 */
class Adjustment extends \Amazon\Sdk\Base
{
    const ACTION_TYPE_CANCEL = 'Cancel';

    const ACTION_TYPE_REFUND = 'Refund';

    const COD_COLLECTION_METHOD_DIRECT_PAYMENT = 'DirectPayment';

    const ADJUSTMENT_REASON_NO_INVENTORY = 'NoInventory';

    const ADJUSTMENT_REASON_CUSTOMER_RETURN = 'CustomerReturn';

    const ADJUSTMENT_REASONS = [
        self::ADJUSTMENT_REASON_NO_INVENTORY,
        self::ADJUSTMENT_REASON_CUSTOMER_RETURN,
    ];

    public static function getAdjustmentReasons()
    {
        return self::ADJUSTMENT_REASONS;
    }

    /**
     * Message Type
     * @return string
     */
    public function getMessageType()
    {
        return \Amazon\Sdk\Base::MESSAGE_TYPE_ORDER_ADJUSTMENT;
    }

    /**
     * @param null $orderId
     * @param array $data
     * @throws \Exception
     */
    public function setData($orderId = null, array $data = [])
    {
        if (isset($orderId) && !empty($orderId)) {
            $this->data[0]['AmazonOrderID'] = (string)$orderId;  // required, choice
        } elseif (isset($data['MerchantOrderID']) && !empty($data['MerchantOrderID'])) {
            $this->data[0]['MerchantOrderID'] = (string)$data['MerchantOrderID']; // required, choice
        } else {
            throw new \Exception("'AmazonOrderID' and 'MerchantOrderID' both are invalid.");
        }

        if (isset($data['ActionType']) &&
            in_array($data['ActionType'], [self::ACTION_TYPE_CANCEL, self::ACTION_TYPE_REFUND])) {
            $this->data[0]['ActionType'] = (string)$data['ActionType']; // optional
        }

        if (isset($data['CODCollectionMethod']) &&
            in_array($data['CODCollectionMethod'], [self::COD_COLLECTION_METHOD_DIRECT_PAYMENT])) {
            $this->data[0]['CODCollectionMethod'] = (string)$data['CODCollectionMethod']; // optional
        }
    }

    /**
     * @param array $items ,
     * [
     *  [AmazonOrderItemCode] => 68828574383266  // required, choice
     *  [MerchantOrderItemID] => 68828574383266  // required, choice
     *  [MerchantAdjustmentItemID] => 68828574383266  // optional
     *  [AdjustmentReason] => 'NoInventory' // required
     * ]
     * @throws \Exception
     */
    public function setItems(array $items = [])
    {
        foreach ($items as $item) {
            if (isset($item['QuantityCancelled']) && $item['QuantityCancelled'] > 0) {
                $value = [];
                if (isset($item['AmazonOrderItemCode']) && !empty($item['AmazonOrderItemCode'])) {
                    $value['AmazonOrderItemCode'] = (string)$item['AmazonOrderItemCode'];  // required, choice
                } elseif (isset($item['MerchantOrderItemID']) && !empty($item['MerchantOrderItemID'])) {
                    $value['MerchantOrderItemID'] = (string)$item['MerchantOrderItemID']; // required, choice
                } else {
                    throw new \Exception("'AmazonOrderItemCode' and 'MerchantOrderItemID' both are invalid.");
                }

                if (isset($item['MerchantAdjustmentItemID']) && !empty($item['MerchantAdjustmentItemID'])) {
                    $value['MerchantAdjustmentItemID'] = (string)$item['MerchantAdjustmentItemID']; // optional
                }

                if (isset($item['AdjustmentReason']) && !empty($item['AdjustmentReason'])) {
                    $value['AdjustmentReason'] = (string)$item['AdjustmentReason']; // required
                } else {
                    throw new \Exception("'AdjustmentReason' is invalid.");
                }

                if (isset($item['ItemPriceAdjustments']) && !empty($item['ItemPriceAdjustments'])) {
                    $value['ItemPriceAdjustments'] = $item['ItemPriceAdjustments']; // required
                } else {
                    throw new \Exception("'ItemPriceAdjustments' is invalid.");
                }

                $value['QuantityCancelled'] = (string)$item['QuantityCancelled'];
                $this->data[]['AdjustedItem'] = $value;
            }
        }
    }
}
