<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Ced
 * @package     Ced_Amazon
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright © 2019 CedCommerce. All rights reserved.
 * @license     EULA http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Api\Data;

class Data implements DataInterface
{
    protected $data = [];

    /**
     * Set Data
     * @param string $key
     * @param mixed $value
     * @return $this
     */
    public function setData($key, $value)
    {
        if (!empty($key)) {
            $this->data[$key] = $value;
        }

        return $this;
    }

    /**
     * Get Data
     * @param string $key
     * @return mixed
     */
    public function getData($key)
    {
        $value = null;
        if (isset($this->data[$key])) {
            $value = $this->data[$key];
        }

        return $value;
    }
}
