<?php

/**
 * CedCommerce
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the End User License Agreement (EULA)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://cedcommerce.com/license-agreement.txt
 *
 * @category    Amazon-Sdk
 * @package     Ced_Amazon_Sdk
 * @author      CedCommerce Core Team <connect@cedcommerce.com>
 * @copyright   Copyright CedCommerce (http://cedcommerce.com/)
 * @license     http://cedcommerce.com/license-agreement.txt
 */

namespace Amazon\Sdk\Api;

interface ConfigInterface
{
    const API_MODE_MERCHANT = "merchant";
    const API_MODE_SELLER = "seller";

    /**
     * ConfigInterface constructor.
     * @param array $params
     */
    public function __construct($params = []);

    /**
     * Set API Mode
     * @param $mode
     * @return void
     */
    public function setMode($mode);

    /**
     * Get API Mode
     * @return string
     */
    public function getMode();

    /**
     * Set Amazon Seller Id
     * @param string $sellerId
     * @return void
     */
    public function setSellerId($sellerId);

    /**
     * Get Amazon Seller Id
     * @return string
     */
    public function getSellerId();

    /**
     * Set Amazon AccessKeyId
     * @param string $accessKeyId
     * @return void
     */
    public function setAccessKeyId($accessKeyId);

    /**
     * Get Amazon AccessKeyId
     * @return string
     */
    public function getAccessKeyId();

    /**
     * Set Amazon MWSAuthToken
     * @param string $token
     * @return void
     */
    public function setAuthToken($token);

    /**
     * Get Amazon MWSAuthToken
     * @return string
     */
    public function getAuthToken();

    /**
     * Set Amazon Marketplace Id
     * @param string $marketplaceId
     * @return void
     */
    public function setMarketplaceId($marketplaceId);

    /**
     * Get Amazon Marketplace Id
     * @return string
     */
    public function getMarketplaceId();

    /**
     * Set Amazon Secret Key
     * @param string $secretKey
     * @return void
     */
    public function setSecretKey($secretKey);

    /**
     * Get Amazon Secret Key
     * @return string
     */
    public function getSecretKey();

    /**
     * Set Amazon Service Url
     * @param string $serviceUrl
     * @return void
     */
    public function setServiceUrl($serviceUrl);

    /**
     * Get Amazon Service Url
     * @return string
     */
    public function getServiceUrl();

    /**
     * Set to enable or disable logging
     * @param bool $muteLog
     * @return void
     */
    public function setMuteLog($muteLog = false);

    /**
     * Get Logging status
     * @return boolean
     */
    public function getMuteLog();

}
