# Amazon Sdk
## Installation
+ ##### Manual Way 
    + Create "cedcoss" directory in vendor directory
    + run below command in cedcoss directory
                        
            git clone https://github.com/cedcoss/amazon-sdk.git
    + now open composer.json present in root directory and add below lines in it
    
            "autoload": {
                 "psr-4": {
                     "Amazon\\Sdk\\": "vendor/cedcoss/amazon-sdk/src/"
                }
            }
    + after that run below command
    
            composer require cedcommerce/validator
            composer dump
    
+ ##### Install through composer 
    + Run Below commands in your root directory (Make sure ssh key setup is done fore this repo)
    
            composer config repositories.ced/amazon-sdk git git@github.com:cedcoss/amazon-sdk.git
            
            composer require ced/amazon-sdk:dev-master


## Api Issues:

+ Product category is required in feed.
```xml
 <ProductData>
        <Home>
          <ProductType>
            <FurnitureAndDecor></FurnitureAndDecor>
          </ProductType>
        </Home>
 </ProductData>
```

+ Product MPN is required. 
    - `A value is required for the &quot;part_number&quot; field`
```xml
  <DescriptionData>
    <MfrPartNumber>Test</MfrPartNumber>
  </DescriptionData>
```

+ Product standard product id is required. 
    - `Missing Attributes standard_product_id.`
```xml
   <Product>
        <StandardProductID>
          <Type>UPC</Type>
          <Value>746775289461</Value>
        </StandardProductID>
   </Product>
```
+ Matching Product Id on amazon must match all product attributes with already present product.
    - `The SKU data provided conflicts with the Amazon catalog. The standard_product_id value(s) provided correspond to the ASIN  B00YGGH1WO, but some information contradicts with the Amazon catalog. The following are the attribute value(s) that are conflicting: distribution_designation (Merchant: &apos;&apos; / Amazon: &apos;jp_parallel_import&apos;). If your product is this ASIN, then modify your data to reflect the Amazon catalog values. Else, check your value(s) for  standard_product_id are correct. The SKU data provided conflicts with the Amazon catalog. The standard_product_id value(s) provided correspond to the ASIN  B00IWOHC98, but some information contradicts with the Amazon catalog. The following are the attribute value(s) that are conflicting: brand (Merchant: &apos;Amazon Brand&apos; / Amazon: &apos;Fisher-Price&apos;). If your product is this ASIN, then modify your data to reflect the Amazon catalog values. Else, check your value(s) for  standard_product_id are correct.`

+ Product Description data must be normalised string. Not chars xml/html allowed. [strip_tags() used]
    - `The Message/Product/DescriptionData/Description field contains an invalid value: &lt;pre xml=&quot;space&quot;&gt;&lt;br /&gt;Unique handmade wooden jewelry box is made of walnut wood.&lt;/pre&gt;&lt;pre xml=&quot;space&quot;&gt; The box is perfect for gift wrapping, as well as for storing jewelry. &lt;/pre&gt;&lt;pre xml=&quot;space&quot;&gt;A box of wooden is charming.&lt;/pre&gt;&lt;pre xml=&quot;space&quot;&gt; This charming and very picturesque thing will decorate and revitalize any interior. &lt;/pre&gt;&lt;pre xml=&quot;space&quot;&gt;Kings and rich men used these jewelry boxes as they were expensive.&lt;span&gt;&lt;br /&gt;&lt;/span&gt;Product of Botirbek.&lt;span&gt;&lt;br /&gt;&lt;/span&gt;Made by one of the best masters in Uzbekistan. Naturally insect resistant. Each box is unique.&lt;/pre&gt;. The product_description field contains an invalid value. Please provide a valid value for the field and try again.`
        
+ Product category cannot be updated once uploaded. Product is needed to be deleted and reuploaded.
    - `You cannot change the &apos;item_classification&apos; for SKU &apos;handmade-wooden-jewelry-box&apos; by submitting a feed with a new value. To change this attribute, do the following: 1) Submit a feed to delete the existing SKU.  2) Submit a feed to recreate the SKU with the updated &apos;item_classification&apos;.`
    
+ USD is not accepted in India.
    - `The Message/Price/StandardPrice/@currency field contains an invalid value: USD. To correct this error, choose from the valid set of values.`

+ ASIN creation blocked due to high product creation.
    - `We have temporarily removed your ability to submit listings (creating new offers or new ASINs) because an unusually high number of listings have been created from your account. Please refer to the ASIN Creation Policy page (https://sellercentral-europe.amazon.com/gp/help/201844590) for more information on how to avoid receiving this error message. If you believe your listing creation privileges have been removed in error, please contact Seller Support by using the following link: https://sellercentral-europe.amazon.com/cu/contact-us.`

+ Multiple similar values for Variation and Classification cannot be assigned.
    - `Values cannot be assigned to both the Message/Product/ProductData/Clothing/VariationData/Color (Blue) field and the Message/Product/ProductData/Clothing/ClassificationData/Color (Blue) field, so the value in the second field was ignored.` 

+ India: Categories are restricted and can be manually applied to allow.

+ Model Number is required on Barcode Exemption

## Guidelines:

+ Feed File and Response File should be saved in file as size can be very large for bulk uploads.
    - Should be deleted on row delete.

## Sdk Issues:

+ Repetitions with multiple attributes not possible with sdk. Only single group is allowed.
```xml
    <!--0 to 3 repetitions:-->
    <BatterySubgroup>
      <BatteryType>battery_type_a76</BatteryType>
      <NumberOfBatteries>201</NumberOfBatteries>
    </BatterySubgroup>
    
    <!--0 to 2 repetitions:-->
    <Rebate>
      <RebateStartDate>2005-04-02T19:23:42+05:30</RebateStartDate>
      <RebateEndDate>2009-03-10T06:47:16+05:30</RebateEndDate>
      <RebateMessage>string</RebateMessage>
    </Rebate> 
```

## Sdk Usage:
+ Check `usage/Product.php`

## TODO:
+ check and update mock files and sdk mock mode.
+ check and update test-cases
+ check and update usage
