<?php

namespace Phalcon\Test\Validation\Validator;


use MongoDB\BSON\ObjectId;
use Phalcon\Test\Test\UnitTestCaseTest as Test;
use Phalcon\Validation;
use Phalcon\Validation\Validator\MongoId;

/**
 * \Phalcon\Test\Validation\Validator\MongoIdTest
 * Tests for Phalcon\Validation\Validator\MongoId component
 *
 * @copyright (c) 2011-2019 Phalcon Team
 * @link      http://www.phalconphp.com
 * @author    Wajdi Jurry <jurrywajdi@yahoo.com>
 * @package   Phalcon\Validation\Validator
 * @group     Validation
 *
 * The contents of this file are subject to the New BSD License that is
 * bundled with this package in the file docs/LICENSE.txt
 *
 * If you did not receive a copy of the license and are unable to obtain it
 * through the world-wide-web, please send an email to license@phalconphp.com
 * so that we can send you a copy immediately.
 */
class MongoIdTest extends Test
{
    private $validator;

    public function setUp()
    {
        $this->validator = new Validation();
        $this->validator->add(
            'id',
            new MongoId([
                'allowEmpty' => true
            ])
        );
        return parent::setUp(); // TODO: Change the autogenerated stub
    }

    public function testValidMongoIds()
    {
        $stringMongoId = "5d4a0496e4895300110e3272";
        $objectId = new ObjectId("5d4a0496e4895300110e3272");
        $emptyId = '';

        $this->assertCount(0, $this->validator->validate(['id' => $stringMongoId]));
        $this->assertCount(0, $this->validator->validate(['id' => $objectId]));
        $this->assertCount(0, $this->validator->validate(['id' => $emptyId]));
    }

    public function testInvalidMongoId()
    {
        $invalidMongoId = "12345";

        $this->assertCount(1, $this->validator->validate(['id' => $invalidMongoId]));
    }
}
